#include "por.h"
#include "it3_common.h"
#include "it3_config.h"

#include "lst.h"

#define	ISVALID_PORID(porid)	((0 < (porid)) && ((porid) < TNUM_POR))
#define	ISVALID_PORATR(poratr)	(TRUE)	/* ̓`FbNȂ */
#define	ISVALID_RDVNO(rdvno)	(TRUE)	/* TODO RNO̔͂ǂ? */

typedef struct S_PORCB
{
	T_LST		call_queue;		/* |[gďo҂L[ */
	ID			porid;			/* |[gID */
	VP			exinf;			/* g */
	ATR			poratr;			/* |[g */
	T_LST		accept_queue;	/* |[gt҂L[ */
	INT			maxcmsz;		/* ďobZ[W̍ő咷 */
	INT			maxrmsz;		/* ԓbZ[W̍ő咷 */
} T_PORCB;

static T_PORCB porcbs[TNUM_POR];

static const T_PORCB porcb_initializer = {0};

ER por_initialize(void)
{
	INT cnt;

	for(cnt = 0;cnt < TNUM_POR;cnt++)
	{
		porcbs[cnt] = porcb_initializer;
	}

	return E_OK;
}

void por_terminate(void)
{

}

/* fup̃|[g */
ER cre_por(ID porid, T_CPOR *pk_cpor)
{
	ER result;

	if(ISVALID_PORID(porid))
	{
		if(ISVALID_PTR(pk_cpor))
		{
			T_PORCB *p_porcb;

			p_porcb = &(porcbs[porid]);

			if(0 == p_porcb->porid)
			{
				*p_porcb = porcb_initializer;

				p_porcb->porid = porid;

				p_porcb->exinf = pk_cpor->exinf;
				p_porcb->poratr = pk_cpor->poratr;
				p_porcb->maxcmsz = pk_cpor->maxcmsz;
				p_porcb->maxrmsz = pk_cpor->maxrmsz;

				lst_init(&(p_porcb->accept_queue));
				lst_init(&(p_porcb->call_queue));

				result = E_OK;
			}
			else
			{
				result = E_OBJ;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* fup̃|[g폜 */
ER del_por(ID porid)
{
	ER result;

	if(ISVALID_PORID(porid))
	{
		T_PORCB *p_porcb;

		p_porcb = &(porcbs[porid]);

		if(0 != p_porcb->porid)
		{
			*p_porcb = porcb_initializer;

			result = E_OK;
		}
		else
		{
			result = E_NOEXS;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* |[gɑ΂郉fǔďo */
ER cal_por(VP msg, INT *p_rmsgsz, ID porid, UINT calptn, INT cmsgsz)
{
	return tcal_por(msg, p_rmsgsz, porid, calptn, cmsgsz, TMO_FEVR);
}

/* |[gɑ΂郉fǔďo(|[O) */
ER pcal_por(VP msg, INT *p_rmsgsz, ID porid, UINT calptn, INT cmsgsz)
{
	return tcal_por(msg, p_rmsgsz, porid, calptn, cmsgsz, TMO_POL);
}

/* |[gɑ΂郉fǔďo(^CAEgL) */
ER tcal_por(VP msg, INT *p_rmsgsz, ID porid, UINT calptn, INT cmsgsz, TMO tmout)
{
	ER result;

	if(ISVALID_PORID(porid))
	{
		if(ISVALID_PTR(msg) && ISVALID_PTR(p_rmsgsz) && (0 != calptn) && (0 < cmsgsz) && ISVALID_TMOUT(tmout))
		{
			T_PORCB *p_porcb;

			p_porcb = &(porcbs[porid]);

			if(0 != p_porcb->porid)
			{
				// TODO ǂȁ[
				result = E_NOSPT;
			}
			else
			{
				result = E_NOEXS;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* |[gɑ΂郉fut */
ER acp_por(RNO *p_rdvno, VP msg, INT *p_cmsgsz, ID porid, UINT acpptn)
{
	return tacp_por(p_rdvno, msg, p_cmsgsz, porid, acpptn, TMO_FEVR);
}

/* |[gɑ΂郉fut(|[O) */
ER pacp_por(RNO *p_rdvno, VP msg, INT *p_cmsgsz, ID porid, UINT acpptn)
{
	return tacp_por(p_rdvno, msg, p_cmsgsz, porid, acpptn, TMO_POL);
}

/* |[gɑ΂郉fut(^CAEgL) */
ER tacp_por(RNO *p_rdvno, VP msg, INT *p_cmsgsz, ID porid, UINT acpptn, TMO tmout)
{
	ER result;

	if(ISVALID_PORID(porid))
	{
		if(ISVALID_PTR(p_rdvno) && ISVALID_PTR(msg) && ISVALID_PTR(p_cmsgsz) && (0 != acpptn) && ISVALID_TMOUT(tmout))
		{
			T_PORCB *p_porcb;

			p_porcb = &(porcbs[porid]);

			if(0 != p_porcb->porid)
			{
				// TODO ǂȁ[
				result = E_NOSPT;
			}
			else
			{
				result = E_NOEXS;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* |[gɑ΂郉fu */
ER fwd_por(ID porid, UINT calptn, RNO rdvno, VP msg, INT cmsgsz)
{
	ER result;

	if(ISVALID_PORID(porid))
	{
		if((0 != calptn) && ISVALID_RDVNO(rdvno) && ISVALID_PTR(msg) && (0 < cmsgsz))
		{
			T_PORCB *p_porcb;

			p_porcb = &(porcbs[porid]);

			if(0 != p_porcb->porid)
			{
				// TODO ǂȁ[
				result = E_NOSPT;
			}
			else
			{
				result = E_NOEXS;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

/* fuԓ */
ER rpl_rdv(RNO rdvno, VP msg, INT rmsgsz)
{
	ER result;

	if(ISVALID_RDVNO(rdvno) && ISVALID_PTR(msg) && (0 < rmsgsz))
	{
		// TODO ǂȁ[
		result = E_NOSPT;
	}
	else
	{
		result = E_PAR;
	}

	return result;
}

/* |[gԎQ */
ER ref_por(T_RPOR *pk_rpor, ID porid)
{
	ER result;

	if(ISVALID_PORID(porid))
	{
		if(ISVALID_PTR(pk_rpor))
		{
			T_PORCB *p_porcb;

			p_porcb = &(porcbs[porid]);

			if(0 != p_porcb->porid)
			{
				pk_rpor->exinf = p_porcb->exinf;
				pk_rpor->wtsk = FALSE;		// TODO ǂȁ[
				pk_rpor->atsk = FALSE;		// TODO ǂȁ[

				result = E_OK;
			}
			else
			{
				result = E_NOEXS;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}
