#ifndef _LST_H_
#define _LST_H_

#include <itron.h>

#define INLINE __inline

typedef struct S_LST {
	struct S_LST	*p_next;
	struct S_LST	*p_prev;
} T_LST;

/**
 * initialize list.
 */
INLINE void lst_init(T_LST *p_lst)
{
	p_lst->p_prev = p_lst->p_next = p_lst;
}

/**
 * list insert item.
 *  p_lst ̒O entry }.
 *  p_lst L[wb_wꍇɂ́CL[̍Ō entry }邱ƂɂȂD
 */
INLINE void lst_insert(T_LST *p_lst, T_LST *p_item)
{
	p_item->p_prev = p_lst->p_prev;
	p_item->p_next = p_lst;
	p_lst->p_prev->p_next = p_item;
	p_lst->p_prev = p_item;
}

/*
 *  L[Gg폜
 *
 *  entry L[폜D
 */
INLINE void lst_delete(T_LST *p_item)
{
	if (p_item->p_next != p_item)
	{
		p_item->p_prev->p_next = p_item->p_next;
		p_item->p_next->p_prev = p_item->p_prev;
	}
}

/*
 *  L[̐擪̃Gg̎o
 *
 *  p_lst ̒̃GgL[폜C폜GgԂD
 *  p_lst L[wb_wꍇɂ́CL[̐擪̃Ggo
 *  ƂɂȂD
 */
INLINE T_LST * lst_delete_next(T_LST *p_lst)
{
	T_LST *p_item;

	if (p_lst->p_next != p_lst)
	{
		p_item = p_lst->p_next;
		p_lst->p_next = p_item->p_next;
		p_item->p_next->p_prev = p_lst;
	}
	else
	{
		p_item = (void *)NADR;
	}

	return (p_item);
}

/*
 *  L[̃Gg̃T[`
 *
 *  p_lst ŎL[Coffset ŎtB[h val 傫
 *  GgT[`C̃GgԂDYGgȂꍇ
 *  ́Cp_lst ԂD
 */
INLINE T_LST * lst_search_gt(T_LST *p_lst, INT val, INT offset)
{
	T_LST *entry;

	for (entry = p_lst->p_next; entry != p_lst; entry = entry->p_next) {
		if (*((INT *)(((VB *) entry) + offset)) > val) {
			break;
		}
	}

	return(entry);
}

/*
 *  L[󂩂ǂ̃`FbN
 */
INLINE BOOL lst_empty(T_LST *p_lst)
{
	return ((p_lst->p_next == p_lst) ? TRUE : FALSE);
}

#endif /* _LST_H_ */
