#ifndef _IT3_DEBUG_H_
#define _IT3_DEBUG_H_

/* fobOVXȅ */
int it3_debug_initialize(void);

/* fobOVXȅI */
void it3_debug_terminate(void);

#ifdef _DEBUG

extern void it3_debug_printf(const char *fmt, ...);

#define	IT3_ASSERT(s)	{if(! (s)){ it3_debug_printf("Assert!:(" #s "), %s:%d\n", __FILE__, __LINE__); }}

#define	IT3_LOG(s)						it3_debug_printf("[IT3] " s "\n")
#define	IT3_LOG1(fmt, p1)				it3_debug_printf("[IT3] " fmt "\n", (p1))
#define	IT3_LOG2(fmt, p1, p2)			it3_debug_printf("[IT3] " fmt "\n", (p1), (p2))
#define	IT3_LOG3(fmt, p1, p2, p3)		it3_debug_printf("[IT3] " fmt "\n", (p1), (p2), (p3))
#define	IT3_LOG4(fmt, p1, p2, p3, p4)	it3_debug_printf("[IT3] " fmt "\n", (p1), (p2), (p3), (p4))

#else /* _DEBUG */

#define	IT3_ASSERT(s)

#define	IT3_LOG(s)
#define	IT3_LOG1(fmt, p1)
#define	IT3_LOG2(fmt, p1, p2)
#define	IT3_LOG3(fmt, p1, p2, p3)
#define	IT3_LOG4(fmt, p1, p2, p3, p4)

#endif /* _DEBUG */

#endif /* _IT3_DEBUG_H_ */
