#define _WIN32_WINNT 0x0500

#include <windows.h>
#include <limits.h>
#include <stdio.h>
#include <stdarg.h>

#include <mmsystem.h>
#pragma comment(lib, "winmm.lib")

#include "depend.h"
#include <it3_debug.h>

#define	ISVALID_TSKID(tskid)	((0 < (tskid)) && ((tskid) < DEPEND_TNUM_TSK))
#define	ISVALID_TIMID(timid)	((0 < (timid)) && ((timid) < DEPEND_TNUM_TIM))

/*
===============================================================================
	ˑ̂߂̓Ǝ̌^`
===============================================================================
*/
/* ˑ Ǝ^XNTCB */
typedef struct S_DEPEND_TCB
{
	int tskid;

	LPVOID p_fiber;							/* t@Co[AhX		*/

	void (*p_func)(void *);						/* z^XN̊JnAhX	*/
	void *p_param;								/* z^XNɊ֘Atꂽf[^
													LŎ擾ł
													Ez^XN̈
													Edepend_get_param()
												*/
} T_DEPEND_TCB;

typedef struct S_DEPEND_TIMCB
{
	int timid;

	void (*p_func)(void *);
	void *p_param;
} T_DEPEND_TIMCB;

static const T_DEPEND_TCB dep_tcb_initializer = {0};

static const T_DEPEND_TIMCB dep_tim_initializer = {0};


/*
===============================================================================
	ˑ̂߂̃O[oϐ
===============================================================================
*/
static DWORD tickcount = 0;

/* z^XN̂߂̏ */
static T_DEPEND_TCB dep_tcbs[DEPEND_TNUM_TSK];

static CRITICAL_SECTION cs;

static HANDLE dep_timer_handle;
static T_DEPEND_TIMCB dep_timcbs[DEPEND_TNUM_TIM];


/*
 ˑ
	z^XN		c t@Co[
	z^XNID	c XbhID

 */

static void ShowErrorMessage(void)
{
	LPVOID lpMsgBuf;

	FormatMessage(	FORMAT_MESSAGE_ALLOCATE_BUFFER |
					FORMAT_MESSAGE_FROM_SYSTEM |
					FORMAT_MESSAGE_IGNORE_INSERTS,
					NULL,
					GetLastError(),
					MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // ̌
					(LPTSTR) &lpMsgBuf,
					0,
					NULL
	);

	// \B
	IT3_LOG1("%s", lpMsgBuf);

	// obt@B
	LocalFree(lpMsgBuf);

}

/* ˑ ^XN@\ */
static int depend_tsk_initialize(void)
{
	int result;
	int cnt;
	T_DEPEND_TCB *p_dep_tcb;
	LPVOID p_fiber;

	/* z^XNTCB */
	for(cnt = 0;cnt < DEPEND_TNUM_TSK;cnt++)
	{
		dep_tcbs[cnt] = dep_tcb_initializer;
	}

	/* ============================
	 * Xbht@Co[ɕϊ
	 * ============================ */
	/* J[l̊ˑTCB擾 */
	p_dep_tcb = &(dep_tcbs[0]);

	/* ̏𓮂XbhuITROÑJ[lpt@CoƂ */
	p_fiber = ConvertThreadToFiber(p_dep_tcb);
	if(p_fiber)
	{
		p_dep_tcb->p_fiber = p_fiber;

		result = 0;
	}
	else
	{
		result = (-1);
	}

	return result;
}

static void depend_tsk_terminate(void)
{
	int cnt;
	T_DEPEND_TCB *p_dep_tcb;
	BOOL ret;

	for(cnt = 1;cnt < DEPEND_TNUM_TSK;cnt++)
	{
		p_dep_tcb = &(dep_tcbs[cnt]);

		if(0 != p_dep_tcb)
		{
			DeleteFiber(p_dep_tcb->p_fiber);
			*p_dep_tcb = dep_tcb_initializer;
		}
	}

	/* J[lpt@CoXbhɖ߂ */
	ret = ConvertFiberToThread();
	if(! ret)
	{
		ShowErrorMessage();
	}
	dep_tcbs[0] = dep_tcb_initializer;
}

static int depend_tim_initialize(void)
{
	int result;
	HANDLE timer_handle;

	timer_handle = CreateTimerQueue();
	if(NULL != timer_handle)
	{
		dep_timer_handle = timer_handle;
		result = 0;
	}
	else
	{
		ShowErrorMessage();
		result = (-1);
	}

	return result;
}

static void depend_tim_terminate(void)
{
	if(NULL != dep_timer_handle)
	{
		DeleteTimerQueueEx(dep_timer_handle, NULL);
		dep_timer_handle = NULL;
	}
}

/* ˑ̏ */
int depend_initialize(void)
{
	int result;
	int ret;

	ret = depend_CreateCriticalSection();
	if(0 == ret)
	{
		/* z^XN@\̏ */
		ret = depend_tsk_initialize();
		if(0 == ret)
		{
			ret = depend_tim_initialize();
			if(0 == ret)
			{
				/* N擾 */
				tickcount = GetTickCount();

				result = 0;
			}
			else
			{
				depend_tsk_terminate();
				depend_DestoryCriticalSection();
				result = (-3);
			}
		}
		else
		{
			depend_DestoryCriticalSection();
			result = (-2);
		}
	}
	else
	{
		result = (-1);
	}

	return result;
}

/* ˑ̏I */
void depend_terminate(void)
{
	depend_tim_terminate();
	depend_tsk_terminate();
	depend_DestoryCriticalSection();
}

/* ďoĂ鐧Ɋ֘Atꂽf[^Ԃ */
void * depend_GetParam(void)
{
	void *p_param = NULL;

	__try
	{
		T_DEPEND_TCB *p_dep_tcb;

		/*
		 * ̊֐𓮂Ăt@Co[Ɋ֘Atꂽf[^擾
		 * ̒ĺAdepend_cre_tskT_DEP_CRE_TSKp_dataCreateFiber,ConvertThreadToFiber
		 * ^ꂽlł
		 */
		p_dep_tcb = (T_DEPEND_TCB *)GetFiberData();
		if(p_dep_tcb)
		{
			p_param = p_dep_tcb->p_param;
		}
	}
	__finally
	{
		/* ̊֐𓮂Ă̂́At@Co[Ȃ */
	}

	return p_param;
}

VOID CALLBACK FiberProc(PVOID lpParameter)   // t@Cof[^
{
	T_DEPEND_TCB *p_dep_tcb = lpParameter;

	(p_dep_tcb->p_func)(p_dep_tcb->p_param);
}

/* z^XN𐶐 */
int depend_CreateTask(int tskid, const T_DEPEND_CTSK *p_dep_ctsk)
{
	int result;
	T_DEPEND_TCB *p_dep_tcb;

	if(ISVALID_TSKID(tskid))
	{
		p_dep_tcb = &(dep_tcbs[tskid]);

		if(0 != p_dep_tcb->tskid)
		{
			p_dep_tcb->tskid = tskid;
			p_dep_tcb->p_func	= p_dep_ctsk->p_func;
			p_dep_tcb->p_param	= p_dep_ctsk->p_param;

			p_dep_tcb->p_fiber = CreateFiber(p_dep_ctsk->stksz, FiberProc, p_dep_tcb);
			if(NULL != p_dep_tcb->p_fiber)
			{
				result = 0;
			}
			else
			{
				*p_dep_tcb = dep_tcb_initializer;
				result = (-3);
			}
		}
		else
		{
			result = (-2);
		}
	}
	else
	{
		result = (-1);
	}

	return result;
}

int depend_DestoryTask(int tskid)
{
	int result;

	if(ISVALID_TSKID(tskid))
	{
		T_DEPEND_TCB *p_dep_tcb;

		p_dep_tcb = &(dep_tcbs[tskid]);

		if(0 != p_dep_tcb->tskid)
		{
			DeleteFiber(p_dep_tcb->p_fiber);

			*p_dep_tcb = dep_tcb_initializer;

			/* J[lɐڂ */
	//		depend_wakeup_tsk(0);

			result = 0;
		}
		else
		{
			result = (-2);
		}
	}
	else
	{
		result = (-1);
	}

	return result;
}

int depend_SetTimer(int timid, T_DEPEND_CTIM *p_ctim)
{
	int result;

	if(ISVALID_TIMID(timid))
	{
		T_DEPEND_TIMCB *p_timcb;

		p_timcb = &(dep_timcbs[timid]);
		if(0 != p_timcb->timid)
		{
			HANDLE tim_handle;
			BOOL ret;

			p_timcb->timid = timid;
#if 0 // TODO
			ret = CreateTimerQueueTimer(&tim_handle, dep_timer_handle, )
			if()
#endif

			result = 0;
		}
		else
		{
			result = (-2);
		}
	}
	else
	{
		result = (-1);
	}

	return result;
}

int depend_KillTimer(int timid)
{
	int result;

	// TODO
	result = 0;

	return result;
}

/* Cxg̐ */
void* depend_cre_evt(const char *p_name)
{
	void * hEventToKernel;
	hEventToKernel = CreateEvent(NULL, FALSE, FALSE, p_name);

	return hEventToKernel;
}

/* Cxg̔j */
int depend_des_evt(void *p_handle_evt)
{
	CloseHandle((HANDLE)p_handle_evt);

	return 0;
}

/* Cxg҂ */
int depend_wai_evt(void *p_handle_evt, int time)
{
	DWORD d;

	if(-1 == time)								/* w? */
	{
		time = INFINITE;
	}

	d = WaitForSingleObject((HANDLE)p_handle_evt, time);

	return 0;
}

/* Cxgݒ */
int depend_set_evt(void *p_handle_evt)
{
	SetEvent((HANDLE)p_handle_evt);

	return 0;
}

/* w莞Ԃ~߂i~bj */
void depend_sleep(int time)
{
	Sleep(time);
}

/* ݎ擾 */
int depend_get_time(void)
{
	int time;
	DWORD new_tickcount;

	new_tickcount = GetTickCount();

	if(tickcount <= new_tickcount)
	{
		time = new_tickcount - tickcount;
	}
	else
	{
		time = (ULONG_MAX - tickcount) + new_tickcount;
	}

	return time;
}

/* w肳ꂽz^XNɐ؂ւ */
int depend_SwitchTask(int tskid)
{
	IT3_ASSERT(ISVALID_TSKID(tskid));

	SwitchToFiber(dep_tcbs[tskid].p_fiber);

	return 0;
}

/* bZ[W\ */
void depend_message_show(const char *p_fmt, ...)
{
	char buff[256];
	va_list arg;

	va_start(arg, p_fmt);				/* Initialize variable arguments.	*/

	vsprintf(buff, p_fmt, arg);

	va_end(arg);						/* Reset variable arguments.		*/

	MessageBox(NULL, buff, "ASSERT", MB_OK | MB_ICONINFORMATION);
}

void * depend_malloc(int size)
{
	return malloc(size);
}

void depend_free(void *p_mem)
{
	free(p_mem);
}

int depend_CreateCriticalSection(void)
{
	int result;

	__try
	{
		InitializeCriticalSection(&cs);
		result = 0;
	}
	__except(STATUS_NO_MEMORY)
	{
		IT3_LOG("CriticalSection not enough memory.");
		result = (-1);
	}

	return result;
}

void depend_DestoryCriticalSection(void)
{
	DeleteCriticalSection(&cs);
}

void depend_EnterCriticalSection(void)
{
	EnterCriticalSection(&cs);
}

void depend_LeaveCriticalSection(void)
{
	LeaveCriticalSection(&cs);
}
