/**
 * @file	cyc.c
 * @brief	ԊǗ@\iNj
 *
 * @author  nikarana
 * @date    2012/11/23
 *
 */

#include "cyc.h"
#include "it3_common.h"
#include "it3_config.h"
#include <depend.h>

#define	ISVALID_CYCNO(cycno)	((0 < (cycno)) && ((cycno) < TNUM_CYC))
#define	ISVALID_CYCACT(cycact)	(0 == ((cycact) & ~(TCY_INI | TCY_ON)))

typedef struct S_CYCCB
{
	HNO			cycno;							/**< Nnhԍ				*/

	VP			exinf;							/**< g						*/
	ATR			cycatr;							/**< Nnh				*/
	FP			cychdr;							/**< NnhAhX			*/
	UINT		cycact;							/**< Nnh			*/
	CYCTIME		cyctim;							/**< NԊԊu					*/

	UINT		lftime;							/**< ̃nhN܂ł̎c莞 */
	UINT		cytime;							/**< NԊԊu */
} T_CYCCB;

static const T_CYCCB cyccb_initializer = {0};

static T_CYCCB cyccbs[TNUM_CYC];

/**
 * @brief	ԊǗ@\iNj
 *
 * @return	G[R[h
 * @retval	E_OK	I
 * @retval	E_OKȊO	ُI
 */
ER cyc_initialize(void)
{
	INT cnt;

	for(cnt = 0;cnt < TNUM_CYC;cnt++)
	{
		cyccbs[cnt] = cyccb_initializer;
	}

	return E_OK;
}

/**
 * @brief	ԊǗ@\iNjI
 */
void cyc_terminate(void)
{
}

/**
 * @brief	N^C}Cxg
 *
 * @param	steptime	oߎ(ms)
 */
void cyc_timeevent(UINT steptime)
{
	INT cnt;
	T_CYCCB *p_cyccb;

	for(cnt = 0;cnt < TNUM_CYC;cnt++)
	{
		p_cyccb = &(cyccbs[cnt]);

		depend_EnterCriticalSection();

		if(0 != p_cyccb->cycno)
		{
			if(steptime < p_cyccb->lftime)
			{
				p_cyccb->lftime -= steptime;
			}
			else
			{
				p_cyccb->lftime = p_cyccb->cytime;		/* c莞ԃZbg			*/

				if(TCY_OFF != p_cyccb->cycact)
				{
					(p_cyccb->cychdr)();
				}
			}
		}

		depend_LeaveCriticalSection();
	}
}

/**
 * @brief	Nnh`
 *
 * @param	cycno	Nnhwԍ
 * @param	pk_dcyc	Nnh`
 * @return	G[R[h
 * @retval	E_OK	I
 * @retval	E_NOMEM	s(ǗubNp̗̈悪mۂłȂ)
 * @retval	E_RSATR	\񑮐(cycatrs邢͗płȂ)
 * @retval	E_PAR	p[^G[(cycno, pk_dcyc, cychdr, cycact, cyctims邢͗płȂ)
 */
ER def_cyc(HNO cycno, T_DCYC *pk_dcyc)
{
	ER result;

	if(ISVALID_CYCNO(cycno))
	{
		T_CYCCB *p_cyccb;

		p_cyccb = &(cyccbs[cycno]);

		depend_EnterCriticalSection();

		if(ISVALID_PTR(pk_dcyc))
		{
			*p_cyccb = cyccb_initializer;

			p_cyccb->cycno = cycno;

			p_cyccb->exinf = pk_dcyc->exinf;
			p_cyccb->cycatr = pk_dcyc->cycatr;
			p_cyccb->cychdr = pk_dcyc->cychdr;
			p_cyccb->cycact = pk_dcyc->cycact;
			p_cyccb->cyctim = pk_dcyc->cyctim;

			p_cyccb->lftime		= pk_dcyc->cyctim.ltime;
			p_cyccb->cytime		= pk_dcyc->cyctim.ltime;

			result = E_OK;

		}
		else
		{
			*p_cyccb = cyccb_initializer;

			result = E_OK;
		}

		depend_LeaveCriticalSection();
	}
	else
	{
		result = E_PAR;
	}

	return result;
}

/**
 * @brief	Nnh
 *
 * @param	cycno	Nnhwԍ
 * @param	cyhact	Nnh
 * @return	G[R[h
 * @retval	E_OK	I
 * @retval	E_NOEXS	IuWFNg݂ĂȂ(cycno̎Nnh`ĂȂ)
 * @retval	E_PAR	p[^G[(cycnopłȂ, cycacts)
 */
ER act_cyc(HNO cycno, UINT cyhact)
{
	ER result;

	if(ISVALID_CYCNO(cycno))
	{
		if(ISVALID_CYCACT(cyhact))
		{
			T_CYCCB *p_cyccb;

			p_cyccb = &(cyccbs[cycno]);

			depend_EnterCriticalSection();

			if(0 != p_cyccb->cycno)
			{
				p_cyccb->cycact = cyhact;

				if(cyhact & TCY_INI)					/* w肠?			*/
				{
					p_cyccb->lftime = p_cyccb->cytime;
				}

				result = E_OK;
			}
			else
			{
				result = E_NOEXS;
			}

			depend_LeaveCriticalSection();
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_PAR;
	}

	return result;
}

/**
 * @brief	NnhԎQ
 *
 * @param	pk_rcyc	Nnh̏ԂԂpPbg̐擪AhX
 * @param	cycno	Nnhwԍ
 * @return	G[R[h
 * @retval	E_OK	I
 * @retval	E_NOEXS	IuWFNg݂ĂȂ(cycno̎Nnh`ĂȂ)
 * @retval	E_PAR	p[^G[(cycnopłȂ, ^[p[^p̃pPbgAhXgpłȂl)
 */
ER ref_cyc(T_RCYC *pk_rcyc, HNO cycno)
{
	ER result;

	if(ISVALID_CYCNO(cycno) && ISVALID_PTR(pk_rcyc))
	{
		T_CYCCB *p_cyccb;

		p_cyccb = &(cyccbs[cycno]);

		depend_EnterCriticalSection();

		if(0 != p_cyccb->cycno)
		{
			pk_rcyc->exinf = p_cyccb->exinf;
			pk_rcyc->lfttim.ltime = p_cyccb->lftime;
			pk_rcyc->cycact = p_cyccb->cycact;

			result = E_OK;
		}
		else
		{
			result = E_NOEXS;
		}

		depend_LeaveCriticalSection();
	}
	else
	{
		result = E_PAR;
	}

	return result;
}
