-- gm.lua
require("DxLib")
return {
	WindowWidth = 640,
	WindowHeight= 480,
	WindowColor =  32,
	WindowMode  = true,
	FontHandle  = nil,

	stage = {
		child = {},

		add  = function(self, _obj)
			table.insert(self.child, _obj);
		end;
		calc = function(self)
			local i,v;
			for i,v in ipairs(self.child) do
				v[i]:calc();
			end;
		end;
		draw = function(self)
			local i,v;
 			for i,v in ipairs(self.child) do
 				v[i]:draw();
 			end;
		end;
	},

	KeyDown={},
	KeyUp  ={},
	KeyHeld={},

	drawText = function(self, x, y, s )
		for i = 1, #s do
			local c = string.byte(s, i);
			DrawGraph( x + i*16, y , self.FontHandle[c] ) ;
		end;
	end;

	MainInit = nil;
	MainLoop = function(self)
	end;

	init = function(self)
		SetUseFPUPreserveFlag(1);										-- FPU̐x𗎂ƂȂ
		local w;
		if self.WindowMode == true then
			w = 1;
		else
			w = 0;
		end;
		ChangeWindowMode(w);											-- window mode
		SetDrawScreen(0xfffffffe);										-- `:

		print( self.WindowWidth , self.WindowHeight , self.WindowColor );
		SetGraphMode( self.WindowWidth , self.WindowHeight , self.WindowColor ) ;		-- GraphMode

		if ( DxLib_Init() == -1 ) then  									-- G[N璼ɏI
			return -1;
		end;
		ClearDrawScreen() ;
		self.FontHandle = LoadDivGraph( "font.bmp"  ,128,16, 8,16,16 );
	end;

	run = function(self)
		while( (ProcessMessage() == 0) and (CheckHitKey(1) == 0)  ) do
			ClearDrawScreen() ;
			self.KeyDown, self.KeyHeld, self.KeyUp = GetJoypadInputStateEX( 0x1001 ) ;
			if self.MainInit ~= nil then
				self:MainInit();
				self.MainInit = nil;
			end;
			self:MainLoop();
			self.stage:calc();
			self.stage:draw();
			ScreenFlip();
		end;
	end;

	exit = function(self)
		DxLib_End();
	end;

	SetMainLoop = function(self, f)
		self.MainInit = f.init;
		self.MainLoop = f.loop;
	end;

}
