
io = require("io")
os = require("os")
string = require("string")
debug = require("debug")

local source_list = {}
local debug_mode = 0 -- 0:stepinto, 1:stepover, 2:stepreturn
local stack_level = 0 -- stepover, stepreturnŎg܂
local breakpoints = {}

function init_source_list(filename)
	local list = {}
	local n = 1
	for line in io.lines(filename) do
		list[n] = line
		n = n + 1
	end
	source_list = list
end

function show_source(line)
	local begin_line
	if line - 3 > 0 then
		begin_line = line - 3
	else
		begin_line = 1
	end

	for i = begin_line, line + 3 do
		if source_list[i] then
			local bp = " "
			if breakpoints[i] then bp = "*" end

			if i == line then
				print(string.format("=> %s %d: %s", bp, i, source_list[i]))
			else
				print(string.format("   %s %d: %s", bp, i, source_list[i]))
			end
		end
	end
end

function show_backtrace()
	-- level=1  ̊֐
	-- level=2  ̊֐̌Ăяo(wait_loop)
	-- level=3  tbN֐
	-- ̊֐̕\Ă܂B
	local level = 4

	print("backtrace:")
	while true do
		local stacktrace = debug.getinfo(level, "nlS")
		if stacktrace == nil then break end
		print("    function: ", stacktrace.name, stacktrace.what)
		level = level + 1
	end
end

function show_locals()
	print("local variables:")

	local i = 1
	while true do
		local name, value = debug.getlocal(4, i)
		if name == nil then break end
		if name ~= "(*temporary)" then
			print("    " .. name, value)
		end
		i = i + 1
	end
end

function toggle_breakpoint(line)
	breakpoints[line] = not breakpoints[line]
	print("set breakpoint: " .. line)
end

function show_usage()
	print("usage:")
	print("    n, next:                do stepinto")
	print("    o, stepover:            do stepover")
	print("    r, stepreturn:          do stepreturn")
	print("    h, help:                show usage")
	print("    bt, backtrace:          show backtrace")
	print("    l, locals:              show local variables")
	print("    s, source:              show source")
	print("    b, break [linenumber]:  toggle breakpoint")
	print("    q, quit):               quit")
end

function hook_wait_loop()
	while true do
		io.write("> ")
		local str = io.read()

		if str == "" or str == "n" or str == "next" then
			debug_mode = 0
			return
		elseif str == "o" or str == "stepover" then
			debug_mode = 1
			stack_level = 0
			return
		elseif str == "r" or str == "stepreturn" then
			debug_mode = 2
			stack_level = 1
			return
		elseif str == "h" or str == "help" then
			show_usage()
		elseif str == "bt" or str == "backtrace" then
			show_backtrace()
		elseif str == "l" or str == "locals" then
			show_locals()
		elseif str == "s" or str == "source" then
			show_source()
		elseif string.match(str, "^b") then
			local line = string.match(str, "^b%s+(%d+)")
			if line then
				toggle_breakpoint(tonumber(line))
			else
				print("Usage: break(b) line-number")
			end
		elseif str == "q" or str == "quit" then
			os.exit(-1)
		else
			print("unknown command: " .. str)
		end
	end
end

function hook(event, line)
	local stacktrace = debug.getinfo(3, "nlS")
	if event == "call" then
		stack_level = stack_level + 1
		return
	elseif event == "return" then
		stack_level = stack_level - 1
		return
	elseif event == "line" then
		if breakpoints[line] or stack_level <= 0 then
			debug_mode = 0
		end
		if debug_mode ~= 0 then
			return
		end
	end

	show_source(line)
	hook_wait_loop()
end

if not arg[1] then
	print("Usage: lua debugger.lua input.lua")
	exit(-1)
end

print("Debug " .. arg[1])
init_source_list(arg[1])
chunk = loadfile(arg[1])

debug.sethook(hook, "crl", 0)
pcall(chunk)
