
Player = {
	life  = 1,
	x     = 0,
	y     = 0,
	dx    = 0,
	dy    = 0,
	state = 0,
	count = 0,
	dir   = 0,
	pat   = 0,
	slipcount = 0,
	speed     = 0,
	
	STATE_STOP      = 0,
	STATE_WALK      = 1,
	STATE_RUN       = 2,
	STATE_SLIP      = 3,
	STATE_JUMP_UP   = 4,
	STATE_JUMP_DOWN = 5,
	STATE_OUT       = 6,
	STATE_FALLDOWN  = 7,
	
	DIR_RIGHT    = 1,
	DIR_LEFT     = 0,

	ACCEL        = 1,
	WALKMAXSPEED = 3,
	RUNMAXSPEED  = 6,
	JUMPPOWER    = 8,
	GRAVITY      = 2,



	walk = function(self, key)
		local k,max,pdx;
		-- max = (kh&KEYS.B)?player.RUNMAXSPEED:player.WALKMAXSPEED;	// Dash?
		if self.dir == self.DIR_RIGHT then
			k = key.RIGHT;
			pdx = 1;
		else
			k = key.LEFT;
			pdx = -1;
		end;
		if k then	--walking
			self.dx = self.dx + self.speed;
			if (self.dx * pdx) > self.WALKMAXSPEED then self.dx = self.WALKMAXSPEED * pdx; end;
		else 				--stop?
			if not( (self.state == self.STATE_JUMP_UP) or (self.state == self.STATE_JUMP_DOWN) ) then
				self.dx = self.dx - self.speed;
				if( (self.dx * pdx) < 0 ) then
					self.dx = 0;
					self.state = self.STATE_STOP;
				end
			end
		end;
	end,
	
	move = function(self)
        local key, KDown, KUp = GetJoypadInputStateEX( 0x1001 ) ;
		if self.state == self.STATE_STOP then 	-- stop
			
			if key.RIGHT then 
				self.state = self.STATE_WALK;
				self.dir   = self.DIR_RIGHT;
				self.slipcount = 0;
				self.count = 0;
				self.speed = self.ACCEL;
			elseif key.LEFT then
				self.state = self.STATE_WALK;
				self.dir   = self.DIR_LEFT;
				self.slipcount = 0;
				self.count = 0;
				self.speed = -self.ACCEL;
			end
			if key.A then
				self.state = self.STATE_JUMP_UP;
				self.count = 0;
				self.dy    = -self.JUMPPOWER;
			end
		elseif self.state == self.STATE_WALK then
			if self.dir == self.DIR_RIGHT then
				if key.LEFT then
					if self.dx > 0 then self.state = self.STATE_SLIP; end;
					self.dir = self.DIR_LEFT;
					self.speed = - self.ACCEL;
					self.slipcount = 0;
					self.count     = 0;
 				end;
			else
				if key.RIGHT then
					if self.dx < 0 then self.state = self.STATE_SLIP; end;
					self.dir = self.DIR_RIGHT;
					self.speed = self.ACCEL;
					self.slipcount = 0;
					self.count     = 0;
				end;
			end;
			if key.A then   --jump?
				self.state = self.JUMP_UP;
				self.count = 0;
				self.dy    = -self.JUMPPOWER;
--				print( "jump" );
			end;
			self.walk( self,key );
		elseif self.state == self.STATE_SLIP then --slip
			-- sound(slip);
			if self.dir == self.DIR_RIGHT then
				k = key.RIGHT;
				pdx = 1;
			else
				k = key.LEFT;
				pdx = -1;
			end;
			if (not k) or ( (self.dx*pdx) > 0 ) then  self.state = self.STATE_WALK end;
			self.walk(self,key);
		-- jump up
		elseif self.state == self.STATE_JUMP_UP then
			print( "jump up" );
			if (self.count > 10) or (KDown.A == false) then
				self.state = self.STATE_JUMP_DOWN;
				self.count = 0;
			else
				--sound( JUMP, player.count );
			end;
			self.walk(self,key);

		-- jump down
		elseif self.state == self.STATE_JUMP_DOWN then
			print( "jump down" );
			self.dy = self.dy + self.GRAVITY;
			if self.dy > self.JUMPPOWER then
				self.dy = self.JUMPPOWER;
			end;
			self.walk(self,key);
		end;

		-- move check
		if ( self.state == self.STATE_STOP ) then
			-- chk
			
		elseif ( self.state == self.STATE_WALK ) or 
			   ( self.state == self.STATE_SLIP ) then

			--[[ Ȃ
			if( self.y1 > 11 ){
				player.state = player.STATE_JUMP_DOWN;
				player.dy += player.GRAVITY;
			}else if( tx1 < 0 ){ 

			}else if( mapdata.data[ty2+1][tx1]==0 && mapdata.data[ty2+1][tx2]==0 ){
				player.state = player.STATE_JUMP_DOWN;
				player.dy += player.GRAVITY;
			}
			]]--

		elseif self.state == self.STATE_JUMP_DOWN then
			if self.y > 300 then
				if self.dx ~= 0 then
					self.state = self.STATE_WALK;
				else
					self.state = self.STATE_STOP;
				end;
				self.dy = 0;
			end;
			--[[
			if( tx1 < 0 )tx1 = 0;
			if( tx2 < 0 )tx2 = 0;
			if( ty2 < 0 )ty2 = 0;
			if( ty2 > 11 ){
				if( player.dy > 0 ) player.y += player.dy;
			}else if( mapdata.data[ty2][tx1]==0 && mapdata.data[ty2][tx2]==0 ){
				if( player.dy > 0 ) player.y += player.dy;
			}else{
				player.y = player.y + player.dy - (player.y + player.dy)%256;
				player.dy = 0;
				if( player.state == player.STATE_JUMP_DOWN ){
					if( player.dx != 0 ){
						player.state = player.STATE_WALK;
					}else{
						player.state = player.STATE_STOP;
					}
				}
			}
			break;
			]]--
		end;
		self.count = self.count + 1;
	end,
	
	disp = function(self)
		self.x = self.x + self.dx;
		self.y = self.y + self.dy;
		local pat=0;
		if self.state == self.STATE_STOP then
			pat = 0;
		elseif self.state == self.STATE_WALK then
			if self.count > 10 then pat = 0 else pat = 1 end;
			if self.count > 20 then self.count = 0 end;
		elseif self.state == self.STATE_SLIP then
			pat = 7;
		elseif self.state == self.STATE_JUMP_UP then
			pat = 5;
		elseif self.state == self.STATE_JUMP_DOWN then
			pat = 5;
		end;

		if self.dir == self.DIR_RIGHT then 
			DrawTurnGraph( self.x , self.y , charGraph[pat], 1 ) ;
		else
			DrawGraph( self.x , self.y , charGraph[pat], 1 ) ;
		end;

	end;
}	



--[[


enum STATE {
	STOP      = 0
	WALK      = 1
	RUN       = 2
	SLIP      = 3
	JUMP_UP   = 4
	JUMP_DOWN = 5
	OUT       = 6
	FALLDOWN  = 7
}

player <- {
	life  = 3,
	x     = 4*256,
	y     = 100*16,
	dx    = 0,
	dy    = 0,
	state = 0,
	count = 0,
	dir   = 0,
	slipcount = 0,
	speed     = 0,
	pat   = 0,
	
	STATE_STOP      = 0,
	STATE_WALK      = 1,
	STATE_RUN       = 2,
	STATE_SLIP      = 3,
	STATE_JUMP_UP   = 4,
	STATE_JUMP_DOWN = 5,
	STATE_OUT       = 6,
	STATE_FALLDOWN  = 7,
	
	DIR_RIGHT    = 1,
	DIR_LEFT     = 0,

	ACCEL        = 5,
	WALKMAXSPEED = 30,
	RUNMAXSPEED  = 60,
	JUMPPOWER    = 80,
	GRAVITY      = 20,
};

function player_walk(kd, kh){
	local k,max,pdx;
	max = (kh&KEYS.B)?player.RUNMAXSPEED:player.WALKMAXSPEED;	// Dash?
	if( player.dir == player.DIR_RIGHT ){
		k = KEYS.RIGHT;
		pdx = 1;
	}else{
		k = KEYS.LEFT;
		pdx = -1;
	}
	if( kh & k ){	//walking
		player.dx += player.speed;
		if( (player.dx * pdx) > max ) player.dx = max * pdx;
	}else{ 			//stop?
		if( !(player.state == player.STATE_JUMP_UP || player.state == player.STATE_JUMP_DOWN) ){
			player.dx -= player.speed;
			if( (player.dx * pdx) < 0 ){
				player.dx = 0;
				player.state = player.STATE_STOP;
			}
		}
	}
}

function player_move()
{
	local kd = keysDown();
	local kh = keysHeld();
	local k,d,spd,pdx;

	switch( player.state ){
	case STATE.STOP: // stop
		if( kh & KEYS.RIGHT ){ 
			player.state = STATE.WALK;
			player.dir = player.DIR_RIGHT;
			player.slipcount = 0;		//ground check?
			player.count = 0;
			player.speed = player.ACCEL;
		}
		else if( kh & KEYS.LEFT  )
		{
			player.state = STATE.WALK;
			player.dir = player.DIR_LEFT;
			player.slipcount = 0;		//ground check?
			player.count = 0;
			player.speed = -player.ACCEL;
		}
		if( kd & KEYS.A     ){
			player.state = STATE.JUMP_UP;
			player.count = 0;
			player.dy = -player.JUMPPOWER;
		}
		break;
	case STATE.SLIP: // slip
		// sound(slip);
		if( player.dir == player.DIR_RIGHT ){
			k = KEYS.RIGHT;
			pdx = 1;
		}else{
			k = KEYS.LEFT;
			pdx = -1;
		}
		if( !(kh & k) || ( (player.dx*pdx) > 0 ) ) player.state = STATE.WALK;
		player_walk(kd,kh);
		break;
	case STATE.WALK: // walk
		if( player.dir == player.DIR_RIGHT ){ 
			k   = KEYS.LEFT;
			pdx = 1;
			d   = player.DIR_LEFT;
			spd = -1;
		}else{
			k   = KEYS.RIGHT;
			pdx = -1;
			d   = player.DIR_RIGHT;
			spd =  1;
		}
		if( kh & k ){	//slip?
			if( (player.dx * pdx) > 0 ) player.state = STATE.SLIP;
			player.dir       = d;
			player.slipcount = 0;
			player.count     = 0;
			player.speed     = player.ACCEL * spd;
		}
		if( kd & KEYS.A     ){ //jump?
			player.state = STATE.JUMP_UP;
			player.count = 0;
			player.dy = -player.JUMPPOWER;
		}
		player_walk(kd,kh);
		break;
	case STATE.JUMP_UP:   // jump
		if( (player.count > 10) || !(kh & KEYS.A) ){
			player.state = STATE.JUMP_DOWN;
			player.count = 0;
		}else{
			//sound( JUMP, player.count );
		}
		player_walk(kd,kh);
		break;
	case STATE.JUMP_DOWN:   // jump
		player.dy += player.GRAVITY;
		if( player.dy > player.JUMPPOWER ){
			player.dy = player.JUMPPOWER;
		}
		player_walk(kd,kh);
		break;

	case STATE.OUT:
		if(count<20 ){
			player.dy = -20;
		}else if( count < 60 ){
			player.dy =  20;
		}else{ 
			player.state = STATE.FALLDOWN;
		}
		break;
	case STATE.FALLDOWN:
		break;
	}

	// map check
	local tx1 = (player.x + player.dx    )>>8;
	local tx2 = (player.x + player.dx+240)>>8;
	local ty1 = (player.y + player.dy    )>>8;
	local ty2 = (player.y + player.dy+240)>>8;
	// 
	if( player.dx < 0 ){
		if( tx1 < 0 ){
			player.dx = 0;
		} else if( ty1 < 0 ){	// nocheck
			 player.x += player.dx;
		}else if( mapdata.data[ty1][tx1]==0 && mapdata.data[ty2][tx1]==0 ){
			 player.x += player.dx;
		}
	}
	// E
	if( player.dx > 0 ){
		if( tx2 > (mapdata.WIDTH>>4)-8 ){
			// GOAL
			LOG("GOAL" );
		} else if( ty1 < 0 ){	// nocheck
			 player.x += player.dx;
		} else if( mapdata.data[ty1][tx2]==0 && mapdata.data[ty2][tx2]==0 ){
			 player.x += player.dx;
		}
	}
/*
	local tx1 = (player.x + player.dx)>>8;
	local tx2 = (player.x + player.dx+120)>>8;
	local ty1 = (player.y + player.dy)>>8;
	local ty2 = (player.y + player.dy+120)>>8;
*/
	// 
	if( player.dy < 0 ){
		if( ty1 < 0 || tx1< 0 ){
			 player.y += player.dy;
		}else if( mapdata.data[ty1][tx1]==0 && mapdata.data[ty1][tx2]==0 ){
			 player.y += player.dy;
		}else{
			if( player.state == player.STATE_JUMP_UP ){
				//block atack check
				player.state = player.STATE_JUMP_DOWN;
			}
		}
	}
	// 
	switch( player.state ){
	case player.STATE_STOP :
	case player.STATE_WALK :
	case player.STATE_SLIP :
		if( ty2+1 > 11 ){
			player.state = player.STATE_JUMP_DOWN;
			player.dy += player.GRAVITY;
		}else if( tx1 < 0 ){ 

		}else if( mapdata.data[ty2+1][tx1]==0 && mapdata.data[ty2+1][tx2]==0 ){
			player.state = player.STATE_JUMP_DOWN;
			player.dy += player.GRAVITY;
		}
		break;
	case player.STATE_JUMP_DOWN:
		if( tx1 < 0 )tx1 = 0;
		if( tx2 < 0 )tx2 = 0;
		if( ty2 < 0 )ty2 = 0;
		if( ty2 > 11 ){
			if( player.dy > 0 ) player.y += player.dy;
		}else if( mapdata.data[ty2][tx1]==0 && mapdata.data[ty2][tx2]==0 ){
			if( player.dy > 0 ) player.y += player.dy;
		}else{
			player.y = player.y + player.dy - (player.y + player.dy)%256;
			player.dy = 0;
			if( player.state == player.STATE_JUMP_DOWN ){
				if( player.dx != 0 ){
					player.state = player.STATE_WALK;
				}else{
					player.state = player.STATE_STOP;
				}
			}
		}
		break;
	}
//	LOG( "tx1:"+tx1+" tx2:"+tx2+" ty1:"+ty1+" ty2:"+ty2+ "        " );
	drawText16( 0x6200000,0,10,"tx1:"+tx1+" tx2:"+tx2+"ty1:"+ty1+" ty2:"+ty2+"          ", 0xFFFF, 0x8000 );
	drawText16( 0x6200000,0,20,"state:"+player.state+" dx:"+player.dx+" dy:"+player.dy+" cnt"+player.count+"           ", 0xFFFF, 0x8000 );
	
//	if( player.x < 0      ) player.x = 256<<4;
//		if( player.x > 256<<4 ) player.x = 0;
	local p;
	switch( player.state ){
	case player.STATE_STOP:
		player.pat = 0;
		break;
	case player.STATE_WALK:
		player.pat = (player.count > 10)?0:4;
		if( player.count > 20 ) player.count = 0;
		break;
	case player.STATE_SLIP:
		player.pat = 32;
		break;
	case player.STATE_JUMP_UP:
		player.pat = 24;
		break;
	case player.STATE_JUMP_DOWN:
		player.pat = 24;
		break;
	}
	player.count ++;
}

enemy <- [
	{ 
		live = true,
		type = 1,
		x    = 128,
		y    = 128,
		dx   = 10,
		dy   = 0,
	}, 
	{live = false},{live = false},{live = false},
	{live = false},{live = false},{live = false},
	{live = false},{live = false},{live = false}
];

function enemy_move()
{
	local i;
	foreach( en in  enemy ){
		if( en.live ){
			switch( type ){
			case 0:	// nomove
				break;
			case 1: // walk
				// check x
				if( bg[ en.x + en.dx] == 1  ){
					en.dx = -en.dx;
				}
				// check y
				if( bg[ en.x + en.dx] == 1  ){
					en.dy = 0;
				}else{
					en.dy = 20;
				}
				// move
				en.x += en.dx;
				en.y += en.dy;
				break;
			case 2:
				break;
			case 3:
				break;
			}
		}
	}
}
bg <- {
	x    = 0,
	y    = 0,
	oldChipX = 0,
	drawX = 18,
};

spawn <- [
	{ x=150,y=150,type=0 },
	{ x=200,y=200,type=1 },
];

function bg_scroll(){

	bg.x = (player.x >> 4) - 120;
	if( bg.x < 0 ) bg.x = 0;
	if( bg.x > mapdata.WIDTH - 256 ) bg.x = mapdata.WIDTH -256;

	// chip change
	local x = bg.x>>4;
	local mx = 0;
	if( x != bg.oldChipX ){
		local bx = bg.drawX;
		if( x > bg.oldChipX ){
			mx = x + 17;
			bg.drawX += 1;
			if( bg.drawX > 31 ) bg.drawX = 0;
		}else {
			mx = x - 15;
			bg.drawX -= 1;
			if( bg.drawX < 0 ) bg.drawX = 31;
		}
		for( local i = 0;i<12;i++ ){
			if( mx > 0 ){
				SetTileChip(bx,i, bg_chip[mapdata.data[i][mx] ] );
			}
			
		}
		bg.oldChipX = x;
		drawText16( 0x6200000,0,30,"mx:"+mx+"  oldChipX:"+bg.oldChipX+"  x:"+x+"          ", 0xFFFF, 0x8000 );
	}
	// enemy spawn
	foreach( i, spw in spawn ){
		if( spw.live == false ){
			// map̈ʒugKɂĐ܂i\O)
			// [fixme]  worldWƉʍW܂lĂȂ
			if( spw.x - map.x+256 < 128  ){
				foreach( en in enemy ){
					if( en.live == false ){
						en.live = true;
						en.type = spw.type;
						en.dx   = 20;		// <- 
						en.dy   = 0;		// <- 
						en.x    = spw.x;
						en.y    = spw.y;
						break;
					}
				}
			}
		}
	}
}

function disp(){

	// player
	local x = player.x>>4;
	local y = player.y>>4;
	if( x > 120 ){
		if( x > mapdata.WIDTH - 136 ){
			x = 120+ x - (mapdata.WIDTH - 136);
		}else{
			x = 120;
		}
	}
	PutSprite(11,  x, y,  player.pat,   1,   0, player.dir,  1,    0,    0,   1 );
	
	// enemy
	foreach( i, en in enemy ){
		if( en.live ){
			PutSprite(20+i,  en.x, en.y,  en.pat,   1,   0, en.dir,  1,    0,    0,   1 );
		}
	}
	// bg scroll
	poke16( 0x4000014, (bg.x & 0x1FF)  );
}

// main
//function main(){

	screen_set();
//	bitmap_set();
	char_set();
//	disp2();
	local flg = true;
	//main loop
	while(flg){
		waitForVBlank(1);
		scanKeys();
		player_move();
		enemy_move();
		bg_scroll();
		disp();
	}

]]--
