gm = require("gm")
-- gm.WindowWidth = 640;
-- gm.WindowHeight= 480;
gm:init();

back = gm.Actor(0,0,0,0,0);
back.img = LoadDivGraph( "ball.bmp"  ,16,8, 2,32,32 );
back.dat = {
	[ 0]={[0]=0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	[ 1]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[ 2]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[ 3]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[ 4]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[ 5]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[ 6]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[ 7]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[ 8]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[ 9]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[10]={[0]=0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	[11]={[0]=0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	[12]={[0]=0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	[13]={[0]=0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	[14]={[0]=0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
}
back.draw = function(self)
	local x, y;
	for x=0,19,1 do
		for y=0,14,1 do
			DrawGraph( x*32, y*32 , back.img[back.dat[y][x]] );
		end;
	end;
	local ret,x,y;
	local l,m,r,s;
	local mx,my;
	ret,x,y = GetMousePoint();
	l,r,m   = GetMouseInput();
	mx = math.floor( (x - 32) / 32 );
	my = math.floor( (y - 32) / 32 );

	gm:drawText(400,10,"x     ="..x.." "..mx);
	gm:drawText(400,30,"y     ="..y.." "..my);
	if l then s = "true" else s="false" end;
	gm:drawText(400,50,"Left  ="..s);
	if m then s = "true" else s="false" end;
	gm:drawText(400,70,"Middle="..s);
	if r then s = "true" else s="false" end;
	gm:drawText(400,90,"Right ="..s);
end;

tamaimg = LoadGraph( "tama.bmp" );

tama = function(_x,_y,_dx,_dy,_c)
	a = gm.Actor(_x,_y,_dx,_dy,_c);
	a.img = tamaimg;
	a.calc = function(self)
		self.x = self.x - self.dx;
		self.y = self.y - self.dy;
		if (self.x < 0) or (self.x > gm.WindowWidth)  then self.state = 0; end;
		if (self.y < 0) or (self.y > gm.WindowHeight) then self.state = 0; end;
--		if self.x < 0      then self.dx = - self.dx; end;
--		if self.x > 640-32 then self.dx = - self.dx; end;
--		if self.y < 0      then self.dy = - self.dy; end;
--		if self.y > 480-32 then self.dy = - self.dy; end;
	end;
	return a;
end;

balls = function( _x, _y, _s )
	a = gm.Actor(_x,_y,0,0,0);
	a.col = 0;
	a.img = {[0]=back.img[1],back.img[2],back.img[3],back.img[4],back.img[5],back.img[6],back.img[7] };
	a.ami = false;
	a.chk = false;

	a.draw = function(self)
		if self.state > 0 then 
			DrawGraph( self.x * 32  , self.y * 32 , self.img[self.col], 1 ) ;
			if self.ami then
				DrawGraph( self.x * 32  , self.y * 32 , back.img[8], 1 ) ;
			end
		end;
	end;
	return a;
end;

STATE = {
	SELECT_BALL  = 10;
	CHECK_MOVE   = 20;
	SELECT_DIST  = 30;
	MOVE_BALL    = 40;
	BREAK_BALL   = 50;
	ADD_BALL     = 60;
	GAME_OVER    = 70;
	MENU         = 80;
}

main = {
	nextBall = {};
	ban = {};
	sx = 0;
	sy = 0;

	oldl = false;
	oldr = false;
	oldm = false;
	
	getMouse = function(self)
		local l,r,m  = GetMouseInput();
		local a,b,c;
		if self.oldl and ( not l ) then a = true; end;
		if self.oldr and ( not r ) then b = true; end;
		if self.oldm and ( not m ) then c = true; end;
		self.oldl = l;
		self.oldr = r;
		self.oldm = m;
		return a,b,c;
	end;

	init = function(self)
		local i;
		local x,y;
		gm:add( back );
		for y=0,8,1 do 
			main.ban[y] = {}
			for x=0,8,1 do 
				main.ban[y][x] = balls(x+1,y+1, 0);
				gm:add(main.ban[y][x]);
			end;
		end;
		for i=0,2,1 do
			main.nextBall[i] = balls(10+i,10, 1);
			main.nextBall[i].state = 1;
			gm:add(main.nextBall[i]);
		end;
		main:createNextBall();
		main:dropBall();
		main:createNextBall();
		main.state = STATE.SELECT_BALL;
	end;

	createNextBall= function(self)
		for i=0,2,1 do
			self.nextBall[i].col = math.random(1,6);
		end;
	end;

	dropBall = function(self)
		local x,y;
		for i=0,2,1 do
			repeat 
				x = math.random(0,8);
				y = math.random(0,8);
			until self.ban[y][x].col == 0;
			self.ban[y][x].col = self.nextBall[i].col;
		end;
	end;

	chkMove = function(self, _x, _y )
		if main.ban[_y][_x].chk then return end;
		main.ban[_y][_x].chk = true;
		if main.ban[_y][_x].col == 0 then
			main.ban[_y][_x].ami = false;	--ԏ
			if _x > 0 then main:chkMove( _x-1, _y  ); end;
			if _x < 8 then main:chkMove( _x+1, _y  ); end;
			if _y > 0 then main:chkMove( _x  , _y-1); end;
			if _y < 8 then main:chkMove( _x  , _y+1); end;
		end;
	end;

	amikake = function(self,  b )
		local x,y;
		for y=0,8,1 do 
			for x=0,8,1 do 
				main.ban[y][x].chk = false;
				main.ban[y][x].ami = b;
			end;
		end;
	end;
	
	loop = function(self)
		local ret,x,y;
		local l,m,r,s = 0;
		local mx,my;
		local mouse = {}
		ret,mouse.x,mouse.y      = GetMousePoint();
		mouse.l,mouse.r,mouse.m  = main:getMouse();
		bx = math.floor( (mouse.x - 32) / 32 );
		by = math.floor( (mouse.y - 32) / 32 );
		if mouse.l and (bx >= 0) and (bx < 9) and (by >= 0) and (by < 9) then
			s = 1;
		end;
		print( main.state );
		if main.state == STATE.SELECT_BALL then
			if s == 1 then
				if main.ban[by][bx].state == 1 then
					main.state = STATE.CHECK_MOVE
					main.count = 0;
					main.sx = bx;
					main.sy = by;
				end;
			end;
		elseif main.state == STATE.CHECK_MOVE  then
			main:amikake(true);					--Ԋ|
			local c = main.ban[main.sy][main.sx].col;
			main.ban[main.sy][main.sx].col = 0;
			main:chkMove(main.sx,main.sy);				--ړ\`FbN
			main.ban[main.sy][main.sx].col = c;
			main.ban[main.sy][main.sx].ami = true;
			main.state = STATE.SELECT_DIST
			main.count = 0;
		elseif main.state == STATE.SELECT_DIST then
			if mouse.r then
				main:amikake(false);				--Ԋ|
				main.state = STATE.SELECT_BALL
				main.count = 0;
			else 
				if s == 1 then
					if main.ban[by][bx].ami == false then
--						main:setloute()
						main.dx = bx;
						main.dy = by;
						main:amikake(false);				--Ԋ|
						main.state = STATE.MOVE_BALL;
						main.count = 0;
					end;
				end;
			end;
		elseif main.state == STATE.MOVE_BALL   then
--			if main.count == 0 then
				-- idou
--			end;
--			main.count = main.count + 1;
--			if main.count == 100 then main.count = 0; end;
--			if tama == dist then
				main.ban[main.dy][main.dx].col = main.ban[main.sy][main.sx].col;
				main.ban[main.sy][main.sx].col = 0;
				main.state = STATE.BREAK_BALL;
				main.count = 0;
--			end;
		elseif main.state == STATE.BREAK_BALL  then
			if main.count == 0 then
--				if main:checkbreak() then
				
--				end;
			end;
			main.state = STATE.CHECK_MOVE
		elseif main.state == STATE.ADD_BALL    then
		elseif main.state == STATE.GAME_OVER   then
		elseif main.state == STATE.MENU        then
		end;
	end;
}
gm:SetMainLoop(main);
gm:run();
