// tssLib.cpp : DLL AvP[VpɃGNX|[g֐`܂B
//

#include "stdafx.h"


extern "C" {
//

static int Lua_TSGL_Init(lua_State *L){
    int h = luaL_checkint(L, 1);
    TSGL_Init((HWND)h);
    return 0;
}

static int Lua_TSGL_Trash(lua_State *L){
    TSGL_Trash();
    return 0;
}

static int Lua_TSGL_PlayMusicBuffer(lua_State *L){
    const char * d = luaL_checkstring(L, 1);
    int l = luaL_optint(L, 2, strlen( d ));
    TSGL_PlayMusicBuffer((char *)d, l);
    return 0;
}

static int Lua_TSGL_PlayMusic(lua_State *L){
    const char * f = luaL_checkstring(L, 1);
    TSGL_PlayMusic((char *)f);
    return 0;
}

static int Lua_TSGL_StopMusic(lua_State *L){
    TSGL_StopMusic();
    return 0;
}

static int Lua_TSGL_PlaySound(lua_State *L){
    int ch = luaL_checkint(L, 1);
    const char * dat = luaL_checkstring(L, 2);
    int siz = luaL_checklong(L, 3);
    int bps = luaL_checklong(L, 4);
    int cnt = luaL_checklong(L, 5);
    int srt = luaL_checklong(L, 6);
    TSGL_PlaySound(ch, (char *)dat, siz, bps, cnt, srt);
    return 0;
}

static int Lua_TSGL_StopSound(lua_State *L){
    int ch = luaL_checkint(L, 1);
    TSGL_StopSound(ch);
    return 0;
}

/* auto channel select */
static int Lua_TSGL_PlaySoundAuto(lua_State *L){
    const char * dat = luaL_checkstring(L, 1);
    int siz = luaL_checklong(L, 2);
    int bps = luaL_checklong(L, 3);
    int cnt = luaL_checklong(L, 4);
    int srt = luaL_checklong(L, 5);
    TSGL_PlaySoundAuto((char *)dat, siz, bps, cnt, srt);
    return 0;
}
static int Lua_TSGL_StopSoundAll(lua_State *L){
    TSGL_StopSoundAll();
    return 0;
}

/* now playing ? */
static int Lua_TSGL_Check(lua_State *L){
    int ch = luaL_checkint(L, 1);
    lua_pushnumber( L, TSGL_Check(ch) );
    return 1;
}

/* copy data to local memory and play */
static int Lua_TSGL_PlaySoundLocal(lua_State *L){
    const char * dat = luaL_checkstring(L, 1);
    int siz = luaL_checklong(L, 2);
    int bps = luaL_checklong(L, 3);
    int cnt = luaL_checklong(L, 4);
    int srt = luaL_checklong(L, 5);
    TSGL_PlaySoundLocal((char *)dat, siz, bps, cnt, srt);
    return 0;
}
static int Lua_TSGL_StopSoundLocal(lua_State *L){
    TSGL_StopSoundLocal();
    return 0;
}

static const luaL_Reg Lua_tssLib[] = {
    { "TSGL_Init", Lua_TSGL_Init },
    { "TSGL_Trash", Lua_TSGL_Trash },

    { "TSGL_PlayMusicBuffer", Lua_TSGL_PlayMusicBuffer },
    { "TSGL_PlayMusic", Lua_TSGL_PlayMusic },
    { "TSGL_StopMusic", Lua_TSGL_StopMusic },

    { "TSGL_PlaySound", Lua_TSGL_PlaySound },
    { "TSGL_StopSound", Lua_TSGL_StopSound },

    /* auto channel select */
    { "TSGL_PlaySoundAuto", Lua_TSGL_PlaySoundAuto },
    { "TSGL_StopSoundAll", Lua_TSGL_StopSoundAll },

    /* now playing ? */
    { "TSGL_Check", Lua_TSGL_Check },

    /* copy data to local memory and play */
    { "TSGL_PlaySoundLocal", Lua_TSGL_PlaySoundLocal },
    { "TSGL_StopSoundLocal", Lua_TSGL_StopSoundLocal },
    {NULL, NULL}
};

LUALIB_API int luaopen_tssLib (lua_State *L) {
    luaL_register(L, "_G", Lua_tssLib );
    return 1;
}

} // extern "C"

