// MXDRV.DLL test program "mxp" V1.50a
// Copyright (C) 2000 GORRY.

// mxp.cpp : AvP[Vp̃Gg |Cg̒`
//


#define MAX_LOADSTRING 256
#define MXPFILENAME "mxpfilename"

#define DEFPDXPATH "c:\\"
#define DEFSAMPLERATE 22050
#define DEFBETWEEN 5
#define DEFPCMBUF 5
#define DEFLATE 500
#define DEFMDXBUF 64
#define DEFPDXBUF 1024
#define DEFPCM8 1
#define DEFROMEO 0

#define N_LOOP 2

typedef struct {
	BYTE * mdxbuf;
	BYTE * pdxbuf;
	DWORD mdxsize;
	DWORD pdxsize;
	DWORD PlayTime;
	TCHAR MDXTitle[MAX_LOADSTRING];
} MDX_DATA;

int (*MXDRV_Start)( int, int, int, int, int, int, int );
void (*MXDRV_End)( void );
int (*MXDRV_GetPCM)( void *, int );
void (*MXDRV_Play)( void *mdx, DWORD mdxsize, void *pdx, DWORD pdxsize );
void (*MXDRV)( X68REG *reg );
void volatile *(*MXDRV_GetWork)( int i );
DWORD (*MXDRV_MeasurePlayTime)( void *mdx, DWORD mdxsize, void *pdx, DWORD pdxsize, int loop, int fadeout );
void (*MXDRV_PlayAt)( DWORD playat, int loop, int fadeout );


// O[oϐ:
HINSTANCE hinstMXDRV;
MDX_DATA mdxdata[16];
int gSamplerate;
int gPcmbuflen;
int gMdxbuflen;

// mxdrvN
static int StartMXDRV(
	int samprate,
	int betw,
	int pcmbuf,
	int late,
	int mdxbuf,
	int pdxbuf,
	int romeo
) {
	int ret;

	ret = MXDRV_Start( samprate, betw, pcmbuf, late, mdxbuf, pdxbuf, romeo );
	if ( ret ) {
		switch ( ret ) {
		  case MXDRV_ERR_MEMORY:
//			MessageBox( GetDesktopWindow(), "mxdrv.dllKvȃmۂł܂B", "mxp", MB_ICONSTOP|MB_OK );
			return (!0);
		  case 10000+X68SNDERR_DLL:
//			MessageBox( GetDesktopWindow(), "X68Sound.dll̃[hɎs܂B", "mxp", MB_ICONSTOP|MB_OK );
			return (!0);
		  case 10000+X68SNDERR_FUNC:
//			MessageBox( GetDesktopWindow(), "X68Sound.dllɕKvAPI܂܂Ă܂BX68Sound.dll̃o[WmFĂB", "mxp", MB_ICONSTOP|MB_OK );
			return (!0);
		  case 10100+X68SNDERR_PCMOUT:
//			MessageBox( GetDesktopWindow(), "X68Sound.dllPCMo͂gpł܂B", "mxp", MB_ICONSTOP|MB_OK );
			return (!0);
		  case 10100+X68SNDERR_TIMER:
//			MessageBox( GetDesktopWindow(), "X68Sound.dll^C}gpł܂B", "mxp", MB_ICONSTOP|MB_OK );
			return (!0);
		  case 10100+X68SNDERR_MEMORY:
//			MessageBox( GetDesktopWindow(), "X68Sound.dllKvȃmۂł܂B", "mxp", MB_ICONSTOP|MB_OK );
			return (!0);
		}
	}

	PlayTime = 0;

	return (0);
}

// mxdrv
int initMDX(
	int samprate;
	int betw;
	int pcmbuf;
	int late;
	int mdxbuf;
	int pdxbuf;
	int wavehandle;
	int romeo;
	int pcm8;
) {

	gSamplerate = samprate;
	gMdxbuflen  = mdxbuf;
	gPcmbuflen  = pdxbuf;
	gWavhandle  = 1;			// Ƃ肠waveX68SoundC
	
	// [hς݂Ȃx
	if ( hinstMXDRV ) {
		FreeLibrary( hinstMXDRV );
	}

	// [h
	hinstMXDRV = LoadLibrary( "mxdrv.dll" );
	if ( hinstMXDRV == NULL ) {
/*		MessageBox( GetDesktopWindow(), "mxdrv.dll̓ǂݍ݂Ɏs܂B", "mxp", MB_ICONSTOP|MB_OK ); */
		return (!0);
	}

	// ֐o^
	MXDRV         = (void (*)(X68REG *))GetProcAddress( hinstMXDRV, "MXDRV" );
	MXDRV_Start   = (int (*)(int, int, int, int, int, int, int))GetProcAddress( hinstMXDRV, "MXDRV_Start" );
	MXDRV_End     = (void (*)(void))GetProcAddress( hinstMXDRV, "MXDRV_End" );
	MXDRV_GetPCM  = (int (*)(void *, int))GetProcAddress( hinstMXDRV, "MXDRV_GetPCM" );
	MXDRV_Play    = (void (*)(void *, DWORD, void *, DWORD))GetProcAddress( hinstMXDRV, "MXDRV_Play" );
	MXDRV_PlayAt  = (void(*)(DWORD, int, int))GetProcAddress( hinstMXDRV, "MXDRV_PlayAt" );
	MXDRV_GetWork = (void volatile *(*)(int))GetProcAddress( hinstMXDRV, "MXDRV_GetWork" );
	MXDRV_MeasurePlayTime = (DWORD(*)(void *, DWORD, void *, DWORD, int, int))GetProcAddress( hinstMXDRV, "MXDRV_MeasurePlayTime" );

	if ( wavehandle == 0 ) {
		betw = 0;
	}
	// MXDRVN
	ret = MXDRV_Start( samprate, betw, pcmbuf, late, mdxbuf, pdxbuf, romeo );
	if ( ret ) {
		switch ( ret ) {
		  case MXDRV_ERR_MEMORY:		//			MessageBox( GetDesktopWindow(), "mxdrv.dllKvȃmۂł܂B", "mxp", MB_ICONSTOP|MB_OK );
			return (!0);
		  case 10000+X68SNDERR_DLL:		//			MessageBox( GetDesktopWindow(), "X68Sound.dll̃[hɎs܂B", "mxp", MB_ICONSTOP|MB_OK );
			return (!0);
		  case 10000+X68SNDERR_FUNC:	//			MessageBox( GetDesktopWindow(), "X68Sound.dllɕKvAPI܂܂Ă܂BX68Sound.dll̃o[WmFĂB", "mxp", MB_ICONSTOP|MB_OK );
			return (!0);
		  case 10100+X68SNDERR_PCMOUT:	//			MessageBox( GetDesktopWindow(), "X68Sound.dllPCMo͂gpł܂B", "mxp", MB_ICONSTOP|MB_OK );
			return (!0);
		  case 10100+X68SNDERR_TIMER:	//			MessageBox( GetDesktopWindow(), "X68Sound.dll^C}gpł܂B", "mxp", MB_ICONSTOP|MB_OK );
			return (!0);
		  case 10100+X68SNDERR_MEMORY:	//			MessageBox( GetDesktopWindow(), "X68Sound.dllKvȃmۂł܂B", "mxp", MB_ICONSTOP|MB_OK );
			return (!0);
		}
	}
	
	// Waveo͋N
//	if ( wavehandle == 0 ) {
//		StartWaveout();
//		EndWaveout();
//	}

	// PCM8̎gp
	pcm8ptr = (UBYTE *)MXDRV_GetWork(MXDRV_WORK_PCM8);
	*(pcm8ptr) = ( pcm8 ? 1 : 0 );

	return (0);
}

// mxdrvj
int TrashMDX(void){
	MXDRV_Stop();
	EndWaveout();
	MXDRV_End();
	return (0);
}

//
DWORD NegateChannelPlayFlagMDX(	int ch )
{
	MXWORK_GLOBAL *g;

	g = (MXWORK_GLOBAL *)MXDRV_GetWork(MXDRV_WORK_GLOBAL);
	g->L001e1c ^= (1<<ch);
	return ( (DWORD)g->L001e1c );
}

//
DWORD GetChannelPlayFlagMDX( void )
{
	MXWORK_GLOBAL *g;

	g = (MXWORK_GLOBAL *)MXDRV_GetWork(MXDRV_WORK_GLOBAL);
	return ( (DWORD)g->L001e1c );
}

//
void SetChannelPlayFlagMDX( DWORD status )
{
	MXWORK_GLOBAL *g;

	g = (MXWORK_GLOBAL *)MXDRV_GetWork(MXDRV_WORK_GLOBAL);
	g->L001e1c = (UWORD)status;
}

//
void FastPlayMDX( int md )
{
	MXWORK_KEY *k;

	k = (MXWORK_KEY *)MXDRV_GetWork(MXDRV_WORK_KEY);
	if ( md ) {
		k->SHIFT = 1;
		k->OPT2 = 1;
	} else {
		k->SHIFT = 0;
		k->OPT2 = 0;
	}
}

//
/*
static int FindMDX(
	HWND hwnd,
	TCHAR *mdxfilename
) {
	static OPENFILENAME ofn;

	ofn.lStructSize = sizeof( ofn );
	ofn.hwndOwner = hwnd;
	ofn.hInstance = hInst;
	ofn.lpstrFilter = "MDX file\0*.MDX\0";
	ofn.lpstrFile = mdxfilename;
	ofn.nMaxFile = FILENAME_MAX;
	ofn.Flags = OFN_FILEMUSTEXIST;
	return ( GetOpenFileName( &ofn ) );
}

//

static int FindPDX(
	HWND hwnd,
	TCHAR *pdxfilename
) {
	static OPENFILENAME ofn;

	ofn.lStructSize = sizeof( ofn );
	ofn.hwndOwner = hwnd;
	ofn.hInstance = hInst;
	ofn.lpstrFilter = "PDX file\0*.PDX\0";
	ofn.lpstrFile = pdxfilename;
	ofn.nMaxFile = FILENAME_MAX;
	ofn.Flags = OFN_FILEMUSTEXIST;
	return ( GetOpenFileName( &ofn ) );
}

//

static void AddDirMark(
	TCHAR *p
) {
	int len;

	len = lstrlen( p );
	if ( _ismbslead( (const unsigned char *)p, (const unsigned char *)(p+len) ) ) {
		if ( p[len] == '\\' ) return;
	}
	p[len] = '\\';
	p[len+1] = '\0';
}

//
*/

// tpXt@CpX擾
static void ExtractPath(
	TCHAR *p
) {
	TCHAR c;
	TCHAR *p2;

	do {
		c = *(p);
		if ( c == '\0' ) break;
		if ( _ismbblead(c) ) {
			p = (TCHAR *)_mbsinc( (const unsigned char *)p );
		} else {
			if ( c == '\\' ) {
				p2 = p;
			}
			p++;
		}
	} while (!0);
	p2[1] = '\0';
}
//

int LoadMDX( TCHAR *mdxname )
{

	// PDXpX𐶐
	lstrcpy( mdxpath, mdxfilename );

	// MDXpX𐶐
	GetFullPathName( mdxname, sizeof(mdxfilename), mdxfilename, &dummy );
	lstrcpy( mdxpath, mdxfilename );
	ExtractPath( mdxpath );

	// m
	mdxbuf = (BYTE *)malloc( mdxbufsize );
	pdxbuf = (BYTE *)malloc( pdxbufsize );
	if ( (mdxbuf == NULL) || (pdxbuf == NULL) ) goto err_malloc;

	// MDXt@Cǂݍ
	fin = fopen( mdxfilename, "rb" );
	if ( fin == NULL ) goto err_readmdx;
	fseek( fin, 0, SEEK_END );
	fsize = ftell( fin );
	fseek( fin, 0, SEEK_SET);
	fptr = (BYTE *)malloc( fsize+8 );
	if ( fptr == NULL ) {
		goto err_readmdx;
	}
	mdxloadsize = fread( fptr+8, 1, fsize, fin );
	fclose( fin );

	if ( mdxloadsize > mdxbufsize-8 ) {
		goto err_mdxbuf;
	}
	mdxsize = mdxloadsize;
	memcpy( mdxbuf+8, mdxloadptr, mdxsize );
	free( mdxloadptr );

	// ^CgXLbv
	p = mdxbuf+8;
	while ( mdxsize-- ) {
		c = *(p++);
		if ( c == 0x0d ) break;
		if ( c == 0x0a ) break;
		if ( c < 0x20 ) {
			if ( c != 0x1b ) goto err_brokenmdx;
		}
	}
	if ( mdxsize <= 0 ) goto err_brokenmdx;
	p--;
	*(p++) = 0x00;
	if ( ((DWORD)(p))&0x01 ) {
		*(p++) = 0x00;
		mdxsize--;
		if ( mdxsize <= 0 ) goto err_brokenmdx;
	}
	p2 = p;
	if ( c != 0x0d ) {
		while ( mdxsize--, *(p2++) != 0x0d ) {
			if ( mdxsize <= 0 ) goto err_brokenmdx;
		}
	}
	while ( mdxsize--, *(p2++) != 0x1a ) {			// pcmt@C܂ňړ
		if ( mdxsize <= 0 ) goto err_brokenmdx;
	}
	havepdx = 0;
	// PDXǂݍ
	if ( *(p2) != 0x00 ) {
		havepdx = 1;
		wsprintf( pdxfilename, "%s%s", mdxpath, p2 );
		wsprintf( pdxfilename2, "%s%s", mdxpath, p2 );
		fin = fopen( pdxfilename, "rb" );
		if ( fin == NULL ) {
			wsprintf( errmsg, "PDXt@C(%s)܂B", p2 );
			MessageBox( hwnd, errmsg, "mxp", MB_ICONINFORMATION|MB_OK );
			havepdx = 0;
		}

		if ( havepdx ) {
			fseek( fin, 0, SEEK_END );
			if ( ftell( fin ) > pdxbufsize ) goto err_pdxbuf;
			fseek( fin, 0, SEEK_SET );
			pdxnamelen = lstrlen( pdxfilename2 )+1;
			pdxbodyptr = (8+pdxnamelen+1)&(-2);
			lstrcpy( (TCHAR *)(pdxbuf+8), (TCHAR *)(pdxfilename2) );
			pdxsize = fread( pdxbuf+pdxbodyptr, 1, pdxbufsize-pdxbodyptr, fin );
			fclose( fin );
			if ( !memcmp( pdxbuf+pdxbodyptr+5, "LZX ", 4 ) ) {
				goto err_brokenmdx;
			}
			pdxbuf[0] = 0x00;
			pdxbuf[1] = 0x00;
			pdxbuf[2] = 0x00;
			pdxbuf[3] = 0x00;
			pdxbuf[4] = pdxbodyptr>>8;
			pdxbuf[5] = pdxbodyptr;
			pdxbuf[6] = pdxnamelen>>8;
			pdxbuf[7] = pdxnamelen;
			pdxsize += pdxbodyptr;
		}
	}

	// MDXMXDRV֓n悤H
	while ( mdxsize--, *(p2++) ) {		// PCMt@C̎
		if ( mdxsize <= 0 ) goto err_brokenmdx;
	}
	mdxbodyptr = p - &mdxbuf[0];
	while ( mdxsize-- ) {
		*(p++) = *(p2++);
	}
	mdxsize = p - &mdxbuf[0];
	mdxbuf[0] = 0x00;
	mdxbuf[1] = 0x00;
	mdxbuf[2] = (havepdx ? 0 : 0xff);
	mdxbuf[3] = (havepdx ? 0 : 0xff);
	mdxbuf[4] = mdxbodyptr>>8;
	mdxbuf[5] = mdxbodyptr;
	mdxbuf[6] = 0x00;
	mdxbuf[7] = 0x08;
	lstrcpy( MDXTitle, (TCHAR *)&mdxbuf[8] );

	return (0);

  err:;
	if ( mdxbuf ) free( mdxbuf );
	if ( pdxbuf ) free( pdxbuf );
	return (!0);

  err_malloc:;
	MessageBox( hwnd, "mۂɎs܂B", "mxp", MB_ICONSTOP|MB_OK );
	goto err;

  err_readmdx:;
	wsprintf( errmsg, "MDXt@C(%s)̓ǂݍ݂Ɏs܂B", mdxfilename );
	MessageBox( hwnd, errmsg, "mxp", MB_ICONSTOP|MB_OK );
	goto err;

  err_brokenmdx:;
	wsprintf( errmsg, "t@C(%s)MDXłȂAĂ܂B", mdxfilename );
	MessageBox( hwnd, errmsg, "mxp", MB_ICONSTOP|MB_OK );
	goto err;

  err_mdxbuf:;
	wsprintf( errmsg, "t@C(%s)ǂMDXobt@܂B", mdxfilename );
	MessageBox( hwnd, errmsg, "mxp", MB_ICONSTOP|MB_OK );
	goto err;

  err_pdxbuf:;
	fclose( fin );
	wsprintf( errmsg, "t@C(%s)ǂPDXobt@܂B", pdxfilename );
	MessageBox( hwnd, errmsg, "mxp", MB_ICONSTOP|MB_OK );
	goto err;
}
	
int PlayMDX( int cnt ) {

	// WaveoutN
//	wavehandle = GetPrivateProfileInt( "Switch", "WAVEHandleByX68Sound", 0, INIFileName );
//	if ( wavehandle == 0 ) {
//		StartWaveout();
//	}

	// tO~
	MXDRV_Stop();

	// tԌv
	if ( havepdx ) {
		PlayTime = MXDRV_MeasurePlayTime( mdxbuf, mdxsize, pdxbuf, pdxsize, N_LOOP, TRUE );
	} else {
		PlayTime = MXDRV_MeasurePlayTime( mdxbuf, mdxsize, NULL  , 0      , N_LOOP, TRUE );
	}

	// MXDRVĂяo
	if ( havepdx ) {
		MXDRV_Play( mdxbuf, mdxsize, pdxbuf, pdxsize );
	} else {
		MXDRV_Play( mdxbuf, mdxsize, NULL, 0 );
	}

	// :Q񃋁[vŃtF[hAEgݒŁAtJn60bĐ
//	MXDRV_PlayAt( 1000*60, 2, TRUE );

	// 
//	free( mdxbuf );
//	free( pdxbuf );

	return (0);
}

// WaveHandleByX68Sound == 0 ̂ƂmxpPCMfoCXփ|vB

DWORD WaveBufSize = 1024;
#define WaveBufBlk 4
BYTE *WaveBuf;
HANDLE WaveoutThreadHandle;
DWORD WaveoutThreadID;
HANDLE FillWavebufThreadHandle;
DWORD FillWavebufThreadID;
volatile int WaveoutWriteBlk;
volatile int WaveoutPlayBlk;
HWAVEOUT WaveoutHandle;
int WaveoutSamprate = 44100;
WAVEHDR WaveoutHeader[WaveBufBlk];
enum {
	IDTH_DONE = WM_USER+1000,
	IDTH_KILL,
};
int FillingWaveBuf;
int WaitPlayEnd = 0;

static DWORD WINAPI FillWaveBuf(
	LPVOID p
) {
	int i;

	if ( p ) {
		for ( i=0; i<WaveBufBlk; i++ ) {
			MXDRV_GetPCM( WaveoutHeader[i].lpData, WaveBufSize );
		}
	} else {
		while (!0) {
			if ( WaveoutPlayBlk == WaveoutWriteBlk ) {
				Sleep(10);
			} else {
				while ( WaveoutPlayBlk != WaveoutWriteBlk ) {
					MXDRV_GetPCM( WaveoutHeader[WaveoutWriteBlk].lpData, WaveBufSize );
					WaveoutWriteBlk++;
					if ( WaveoutWriteBlk >= WaveBufBlk ) {
						WaveoutWriteBlk = 0;
					}
				}
			}
		}
	}
	return (0);
}

static DWORD WINAPI WaveoutThreadFunc(
	LPVOID p
) {
	MSG msg;

	while ( GetMessage( &msg, NULL, 0, 0 ) ) {
		switch ( msg.message ) {
		  case IDTH_DONE:
			waveOutWrite( WaveoutHandle, &WaveoutHeader[WaveoutPlayBlk], sizeof(WAVEHDR) );
			WaveoutPlayBlk++;
			if ( WaveoutPlayBlk >= WaveBufBlk ) {
				WaveoutPlayBlk = 0;
			}
			break;
		  case IDTH_KILL:
			waveOutReset( WaveoutHandle );
			ExitThread( 0 );
			break;
		}
	}
	return (0);
}

static void CALLBACK WaveoutCallbackFunc(
	HWAVEOUT hwo,
	UINT uMsg,
	DWORD dwInstance,
	DWORD dwParam1,
	DWORD dwParam2
) {
	if ( uMsg == MM_WOM_DONE ) {
		PostThreadMessage( WaveoutThreadID, IDTH_DONE, 0, 0 );
	}
}

static int StartWaveout(
	void
) {
	int ret;
	WAVEFORMATEX w;
	int i;
	DWORD late;

	if ( WaveBuf ) {
		return (TRUE);
	}

	// p[^ݒ
	WaveoutSamprate = GetPrivateProfileInt( "Switch", "SampleRate", DEFSAMPLERATE, INIFileName );
	late = GetPrivateProfileInt( "Switch", "Late", DEFLATE, INIFileName );
	WaveBufSize = WaveoutSamprate*late/1000;

	// y[Wm
	WaveBuf = (BYTE *)VirtualAlloc( NULL, 4*WaveBufSize*WaveBufBlk, MEM_COMMIT, PAGE_READWRITE|PAGE_NOCACHE );
	if ( WaveBuf == NULL ) goto err_alloc;

	// 
	w.wFormatTag = WAVE_FORMAT_PCM;
	w.nChannels = 2;
	w.nSamplesPerSec = WaveoutSamprate;
	w.wBitsPerSample = 16;
	w.nBlockAlign = w.nChannels*(w.wBitsPerSample/8);
	w.nAvgBytesPerSec = w.nSamplesPerSec*w.nBlockAlign;
	w.cbSize = 0;

	// wavefoCXJ
	ret = waveOutOpen( &WaveoutHandle, WAVE_MAPPER, &w, (DWORD)WaveoutCallbackFunc, NULL, CALLBACK_FUNCTION );
	if ( ret != MMSYSERR_NOERROR ) goto err_open;

	// wavewb_
	for ( i=0; i<WaveBufBlk; i++ ) {
		ZeroMemory( &WaveoutHeader[i], sizeof(WAVEHDR) );
		WaveoutHeader[i].lpData = (char *)&WaveBuf[4*WaveBufSize*i];
		WaveoutHeader[i].dwBufferLength = 4*WaveBufSize;
		ret = waveOutPrepareHeader( WaveoutHandle, &WaveoutHeader[i], sizeof(WAVEHDR) );
		if ( ret != MMSYSERR_NOERROR ) goto err_prepareheader;
	}

	// ĐXbhJ
	WaveoutThreadHandle = CreateThread( NULL, 0, WaveoutThreadFunc, NULL, 0, &WaveoutThreadID );
	if ( WaveoutThreadHandle == NULL ) goto err_createwaveoutthread;
	SetThreadPriority( WaveoutThreadHandle, THREAD_PRIORITY_TIME_CRITICAL );

	// g`s
	FillWaveBuf( (LPVOID)1 );
	WaveoutWriteBlk = 0;
	WaveoutPlayBlk = 0;

	// Ȍ͔g`XbhɔC
	FillWavebufThreadHandle = CreateThread( NULL, 0, FillWaveBuf, NULL, 0, &FillWavebufThreadID );
	if ( FillWavebufThreadHandle == NULL ) goto err_createfillwavebufthread;
	SetThreadPriority( WaveoutThreadHandle, THREAD_PRIORITY_HIGHEST );

	// ĐJn
	for ( i=0; i<WaveBufBlk; i++ ) {
		waveOutWrite( WaveoutHandle, &WaveoutHeader[i], sizeof(WAVEHDR) );
	}

	Sleep( 100 );

	WaitPlayEnd = 0;

	return (TRUE);

  err_open:;
  err_prepareheader:;
	PostThreadMessage( WaveoutThreadID, IDTH_KILL, 0, 0 );
	WaitForSingleObject( WaveoutThreadHandle, INFINITE );
	CloseHandle( WaveoutThreadHandle );
	WaveoutHandle = NULL;
  err_createfillwavebufthread:;
	TerminateThread( FillWavebufThreadHandle, 0 );
	WaitForSingleObject( FillWavebufThreadHandle, INFINITE );
	CloseHandle( FillWavebufThreadHandle );
	FillWavebufThreadHandle = NULL;
  err_createwaveoutthread:;
	VirtualFree( WaveBuf, 0, MEM_RELEASE );
  err_alloc:;
	return (FALSE);

}

static int EndWaveout(
	void
) {
	int i;

	if ( WaveBuf ) {
		PostThreadMessage( WaveoutThreadID, IDTH_KILL, 0, 0 );
		WaitForSingleObject( WaveoutThreadHandle, INFINITE );
		CloseHandle( WaveoutThreadHandle );
		WaveoutThreadHandle = NULL;
		TerminateThread( FillWavebufThreadHandle, 0 );
		WaitForSingleObject( FillWavebufThreadHandle, INFINITE );
		CloseHandle( FillWavebufThreadHandle );
		FillWavebufThreadHandle = NULL;
		waveOutReset( WaveoutHandle );
		for ( i=0; i<WaveBufBlk; i++ ) {
			waveOutUnprepareHeader( WaveoutHandle, &WaveoutHeader[i], sizeof(WAVEHDR) );
		}
		waveOutClose( WaveoutHandle );
		Sleep( 100 );
		VirtualFree( WaveBuf, 0, MEM_RELEASE );
		WaveBuf = NULL;
	}

	return (TRUE);
}

static int AskPlayEnd(
	void
) {
	MXWORK_GLOBAL *g;

	g = (MXWORK_GLOBAL *)MXDRV_GetWork(MXDRV_WORK_GLOBAL);
	return ( g->L001e06 == 0 );
}

//
/*
#define MAXARGC 16
LPWSTR *MyCommandLineToArgvW(
	WCHAR *cmd,
	int *pargc
) {
	WCHAR *q = cmd;
	WCHAR *p;
	WCHAR c;
	static LPWSTR Argv[MAXARGC+1];
	static WCHAR Argvbody[MAXARGC+1][FILENAME_MAX+1];
	int argc;
	int restargc;

	argc = 0;
	restargc = MAXARGC;
	while ( restargc-- ) {
		p = &Argvbody[argc][0];
		Argv[argc] = p;
		argc++;
		c = *(cmd++);
	  quote:;
		if ( c == '"' ) {
			do {
				c = *(cmd++);
				if ( c == '\0' ) break;
				if ( c == '"' ) break;
				*(p++) = c;
			} while (!0);
			if ( c == '\0' ) break;
			c = *(cmd++);
			goto quote;
		} else {
			while ( c != ' ' ) {
				if ( c == '\0' ) break;
				if ( c == '"' ) break;
				*(p++) = c;
				c = *(cmd++);
			}
			if ( c == '\0' ) break;
			if ( c == '"' ) goto quote;
			*(p++) = 0;
			while ( c == ' ' ) {
				c = *(cmd++);
			}
			if ( c == '\0' ) break;
			cmd--;
		}
	}
	*(pargc) = argc;
	return (Argv);
}
int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
 	// TODO: ̈ʒuɃR[hLqĂB
	MSG msg;
	HACCEL hAccelTable;
	TCHAR *p;
	TCHAR *p2;
	HWND hwnd;
	TCHAR exefilename[FILENAME_MAX];
	TCHAR *dummy;

	// init@C
	argv = MyCommandLineToArgvW( GetCommandLineW(), &argc );
	WideCharToMultiByte( CP_ACP, 0, argv[0], -1, exefilename, sizeof(EXEFileName), NULL, NULL );
	SearchPath( NULL, exefilename, ".exe", sizeof(EXEFileName), EXEFileName, &dummy );
//	MessageBox( NULL, EXEFileName, "mxp", MB_OK );

	lstrcpy( INIFileName, EXEFileName );
	p = &INIFileName[0];
	p2 = NULL;
	while ( *(p) ) {
		if ( *(p) == '.' ) {
			p2 = p;
		}
		p++;
	}
	if ( p2 == NULL ) {
		p2 = p;
	}
	lstrcpy( p2, ".ini" );
//	MessageBox( NULL, INIFileName, "mxp", MB_OK );

	// O[o XgO܂
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_MXP, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass( hInstance );
	LoadString(hInst, IDS_HELLO, szHello, MAX_LOADSTRING);
	lstrcpy( MDXTitle, szHello );

	// dN`FbN
	hwnd = FindWindow( szWindowClass, NULL );
	if ( hwnd ) {
		HANDLE hargv;
		if ( argc >= 2 ) {
			hargv = CreateFileMapping( (HANDLE)0xffffffff, NULL, PAGE_READWRITE, 0, 1024, MXPFILENAME );
			if ( hargv ) {
				void *p = MapViewOfFile( hargv, FILE_MAP_READ|FILE_MAP_WRITE, 0, 0, 0 );
				if ( p ) {
					WideCharToMultiByte( CP_ACP, 0, argv[1], -1, (LPSTR)p, 1024, NULL, NULL );
					SendMessage( hwnd, WM_USER_START, (WPARAM)1, 0 );
					UnmapViewOfFile( p );
				}
				CloseHandle( hargv );
			}
		} else {
			SendMessage( hwnd, WM_USER_START, 0, 0 );
		}
		return (NULL);
	}

	// MXDRVN
	if ( LoadMXDRV() ) {
		return 0;
	}

	// AvP[V̏s܂:
	if( !InitInstance( hInstance, nCmdShow ) ) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_MXP);

	// C bZ[W [v:
	while( GetMessage(&msg, NULL, 0, 0) ) 
	{
		if( !TranslateAccelerator (msg.hwnd, hAccelTable, &msg) ) 
		{
			TranslateMessage( &msg );
			DispatchMessage( &msg );
		}
	}

	MXDRV_Stop();
	EndWaveout();
	MXDRV_End();

	return msg.wParam;
}



//
//  ֐: MyRegisterClass()
//
//  pr: EBhE NX̓o^
//
//  Rg:
//
//    ̊֐т̎gp͂̃R[h Windows 95 Őɒǉꂽ
//    'RegisterClassEx' ֐ Win32 VXě݊ێꍇ
//    ̂ݕKvƂȂ܂BAvP[VAAvP[VɊ֘At
//    ꂽX[ ACR擾ł悤Å֐ĂяoƂ
//    dvłB
//
ATOM MyRegisterClass( HINSTANCE hInstance )
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style		= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon		= LoadIcon(hInstance, (LPCTSTR)IDI_MXP);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= (LPCSTR)IDC_MXP;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	return RegisterClassEx( &wcex );
}

//
//   ֐: InitInstance(HANDLE, int)
//
//   pr: CX^X nh̕ۑƃC EBhE̍쐬
//
//   Rg:
//
//        ̊֐ł́ACX^X nhO[oϐɕۑAvO
//        C EBhE쐬\܂B
//
BOOL InitInstance( HINSTANCE hInstance, int nCmdShow )
{
   HWND hWnd;
	int x, y, w, h;
	int iconic;

   hInst = hInstance; // O[oϐɃCX^X nhۑ܂

	x = GetPrivateProfileInt( "Position", "X", CW_USEDEFAULT, INIFileName );
	y = GetPrivateProfileInt( "Position", "Y", CW_USEDEFAULT, INIFileName );
	w = GetPrivateProfileInt( "Position", "W", CW_USEDEFAULT, INIFileName );
	h = GetPrivateProfileInt( "Position", "H", CW_USEDEFAULT, INIFileName );
	if ( (x+w > GetSystemMetrics( SM_CXSCREEN )) || (y+h > GetSystemMetrics( SM_CYSCREEN )) ) {
		x = CW_USEDEFAULT;
		y = CW_USEDEFAULT;
		w = CW_USEDEFAULT;
		h = CW_USEDEFAULT;
	}
	iconic = GetPrivateProfileInt( "Position", "Iconic", 0, INIFileName );
	if ( iconic ) {
		nCmdShow = SW_SHOWMINIMIZED;
	}

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      x, y, w, h, NULL, NULL, hInstance, NULL);

   if( !hWnd ) 
   {
      return FALSE;
   }

   ShowWindow( hWnd, nCmdShow );
   UpdateWindow( hWnd );

   return TRUE;
}

//

LRESULT CALLBACK WndProc_MXPPROP(
	HWND hwnd,
	UINT message,
	WPARAM wParam,
	LPARAM lParam
) {
	static int Samprate;
	static int Between;
	static int PCMBuf;
	static int Late;
	static int MDXBuf;
	static int PDXBuf;
	static int PCM8;
	static int ROMEO;
	static int WaveHandle;
	static TCHAR PDXPath[FILENAME_MAX+1];
	TCHAR str[512];
	int state;
	int betw;

	switch( message ) {
	  case WM_INITDIALOG:
		Samprate = GetPrivateProfileInt( "Switch", "SampleRate", DEFSAMPLERATE, INIFileName );
		state = IDC_RADIO_MXPPROP_22K;
		if ( Samprate == 44100 ) state = IDC_RADIO_MXPPROP_44K;
		if ( Samprate == 48000 ) state = IDC_RADIO_MXPPROP_48K;
		CheckRadioButton( hwnd, IDC_RADIO_MXPPROP_22K, IDC_RADIO_MXPPROP_44K, state );
		Between = GetPrivateProfileInt( "Switch", "Between", DEFBETWEEN, INIFileName );
		wsprintf( str, "%d", Between );
		Edit_SetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_BETWEEN ), str );
		PCMBuf = GetPrivateProfileInt( "Switch", "PCMBuf", DEFPCMBUF, INIFileName );
		wsprintf( str, "%d", PCMBuf );
		Edit_SetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_PCMBUF ), str );
		Late = GetPrivateProfileInt( "Switch", "Late", DEFLATE, INIFileName );
		wsprintf( str, "%d", Late );
		Edit_SetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_LATE ), str );
		MDXBuf = GetPrivateProfileInt( "Switch", "MDXBuf", DEFMDXBUF, INIFileName );
		wsprintf( str, "%d", MDXBuf );
		Edit_SetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_MDXBUF ), str );
		PDXBuf = GetPrivateProfileInt( "Switch", "PDXBuf", DEFPDXBUF, INIFileName );
		wsprintf( str, "%d", PDXBuf );
		Edit_SetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_PDXBUF ), str );
		PCM8 = GetPrivateProfileInt( "Switch", "PCM8", DEFPCM8, INIFileName );
		Button_SetCheck( GetDlgItem( hwnd, IDC_CHECK_MXPPROP_PCM8 ), ( PCM8 ? 1 : 0 ) );
		WaveHandle = GetPrivateProfileInt( "Switch", "WAVEHandleByX68Sound", 0, INIFileName );
		Button_SetCheck( GetDlgItem( hwnd, IDC_CHECK_MXPPROP_WAVEHANDLE ), ( WaveHandle ? 1 : 0 ) );
		ROMEO = GetPrivateProfileInt( "Switch", "ROMEO", DEFROMEO, INIFileName );
		if ( WaveHandle == 0 ) ROMEO = 0;
		Button_SetCheck( GetDlgItem( hwnd, IDC_CHECK_MXPPROP_ROMEO ), ( ROMEO ? 1 : 0 ) );
		SendMessage( hwnd, WM_COMMAND, IDC_CHECK_MXPPROP_WAVEHANDLE, 0 );
		GetPrivateProfileString( "Path", "PDX", DEFPDXPATH, PDXPath, sizeof( PDXPath ), INIFileName );
		Edit_SetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_PDXPATH ), PDXPath );
		SetFocus( GetDlgItem( hwnd, IDOK ) );
		break;
	  case WM_COMMAND:
		switch (GET_WM_COMMAND_ID(wParam, lParam)) {
		  case IDC_CHECK_MXPPROP_WAVEHANDLE:
			state = Button_GetCheck( GetDlgItem( hwnd, IDC_CHECK_MXPPROP_WAVEHANDLE ) );
			if ( !state ) {
				Button_SetCheck( GetDlgItem( hwnd, IDC_CHECK_MXPPROP_ROMEO ), 0 );
				EnableWindow( GetDlgItem( hwnd, IDC_CHECK_MXPPROP_ROMEO ), 0 );
			} else {
				EnableWindow( GetDlgItem( hwnd, IDC_CHECK_MXPPROP_ROMEO ), 1 );
			}
			break;
		  case IDOK:
			Samprate = 22050;
			state = Button_GetCheck( GetDlgItem( hwnd, IDC_RADIO_MXPPROP_44K ) );
			if ( state ) Samprate = 44100;
			state = Button_GetCheck( GetDlgItem( hwnd, IDC_RADIO_MXPPROP_48K ) );
			if ( state ) Samprate = 48000;
			Edit_GetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_BETWEEN ), str, sizeof(str) );
			Between = atoi(str);
			if ( (Between<1) || (Between>1000) ) {
				MessageBox( hwnd, "荞݊Ԋu1`1000łB", "mxp", MB_ICONSTOP|MB_OK );
				SetFocus( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_BETWEEN ) );
				return (0);
			}
			Edit_GetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_PCMBUF ), str, sizeof(str) );
			PCMBuf = atoi(str);
			if ( (PCMBuf<1) || (PCMBuf>5000) ) {
				MessageBox( hwnd, "PCMϊobt@TCY1`5000łB", "mxp", MB_ICONSTOP|MB_OK );
				SetFocus( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_PCMBUF ) );
				return (0);
			}
			Edit_GetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_LATE ), str, sizeof(str) );
			Late = atoi(str);
			if ( (Late<1) || (Late>5000) ) {
				MessageBox( hwnd, "obt@TCY1`5000łB", "mxp", MB_ICONSTOP|MB_OK );
				SetFocus( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_LATE ) );
				return (0);
			}
			Edit_GetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_MDXBUF ), str, sizeof(str) );
			MDXBuf = atoi(str);
			if ( (MDXBuf<1) || (MDXBuf>256) ) {
				MessageBox( hwnd, "MDXobt@TCY1`256łB", "mxp", MB_ICONSTOP|MB_OK );
				SetFocus( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_MDXBUF ) );
				return (0);
			}
			Edit_GetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_PDXBUF ), str, sizeof(str) );
			PDXBuf = atoi(str);
			if ( (PDXBuf<1) || (PDXBuf>16384) ) {
				MessageBox( hwnd, "PDXobt@TCY1`16384łB", "mxp", MB_ICONSTOP|MB_OK );
				SetFocus( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_PDXBUF ) );
				return (0);
			}
			state = Button_GetCheck( GetDlgItem( hwnd, IDC_CHECK_MXPPROP_PCM8 ) );
			PCM8 = ( state ? 1 : 0 );
			state = Button_GetCheck( GetDlgItem( hwnd, IDC_CHECK_MXPPROP_ROMEO ) );
			ROMEO = ( state ? 1 : 0 );
			state = Button_GetCheck( GetDlgItem( hwnd, IDC_CHECK_MXPPROP_WAVEHANDLE ) );
			WaveHandle = ( state ? 1 : 0 );
			if ( WaveHandle == 0 ) ROMEO = 0;
			Edit_GetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_PDXPATH ), PDXPath, sizeof(PDXPath) );
			wsprintf( str, "%d", Samprate );
			WritePrivateProfileString( "Switch", "SampleRate", str, INIFileName );
			wsprintf( str, "%d", Between );
			WritePrivateProfileString( "Switch", "Between", str, INIFileName );
			wsprintf( str, "%d", PCMBuf );
			WritePrivateProfileString( "Switch", "PCMBuf", str, INIFileName );
			wsprintf( str, "%d", Late );
			WritePrivateProfileString( "Switch", "Late", str, INIFileName );
			wsprintf( str, "%d", MDXBuf );
			WritePrivateProfileString( "Switch", "MDXBuf", str, INIFileName );
			wsprintf( str, "%d", PDXBuf );
			WritePrivateProfileString( "Switch", "PDXBuf", str, INIFileName );
			wsprintf( str, "%d", PCM8 );
			WritePrivateProfileString( "Switch", "PCM8", str, INIFileName );
			wsprintf( str, "%d", ROMEO );
			WritePrivateProfileString( "Switch", "ROMEO", str, INIFileName );
			wsprintf( str, "%d", WaveHandle );
			WritePrivateProfileString( "Switch", "WAVEHandleByX68Sound", str, INIFileName );
			WritePrivateProfileString( "Path", "PDX", PDXPath, INIFileName );
			EndDialog( hwnd, TRUE );

			MXDRV_Stop();
			EndWaveout();
			MXDRV_End();
			betw = ( WaveHandle ? Between : 0 );
			if ( StartMXDRV( Samprate, betw, PCMBuf, Late, MDXBuf*1024, PDXBuf*1024, ROMEO ) ) {
				return (FALSE);
			}
			return (TRUE);

		  case IDCANCEL:
			EndDialog( hwnd, FALSE );
			return (TRUE);

		  case IDC_BUTTON_MXPPROP_DEFAULT:
			Samprate = 22050;
			CheckRadioButton( hwnd, IDC_RADIO_MXPPROP_22K, IDC_RADIO_MXPPROP_44K, ( Samprate==44100 ? IDC_RADIO_MXPPROP_44K : IDC_RADIO_MXPPROP_22K ) );
			Between = 5;
			wsprintf( str, "%d", Between );
			Edit_SetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_BETWEEN ), str );
			PCMBuf = 5;
			wsprintf( str, "%d", PCMBuf );
			Edit_SetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_PCMBUF ), str );
			Late = 100;
			wsprintf( str, "%d", Late );
			Edit_SetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_LATE ), str );
			WaveHandle = 1;
			Button_SetCheck( GetDlgItem( hwnd, IDC_CHECK_MXPPROP_WAVEHANDLE ), ( WaveHandle ? 1 : 0 ) );
			break;

		  case IDC_BUTTON_MXPPROP_PDXPATH:
			Edit_GetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_PDXPATH ), PDXPath, sizeof(PDXPath) );
			if ( PDXPath[lstrlen(PDXPath)-1] == '\\' ) {
				wsprintf( str, "%s*.pdx", PDXPath );
			} else {
				wsprintf( str, "%s\\*.pdx", PDXPath );
			}
			if ( FindPDX( hwnd, str ) ) {
				TCHAR *p;
				lstrcpy( PDXPath, str );
				p = &PDXPath[lstrlen(PDXPath)];
				while ( *(p) != '\\' ) {
					p--;
					if ( p == &PDXPath[0] ) break;
				}
				*(p) = '\0';
				Edit_SetText( GetDlgItem( hwnd, IDC_EDIT_MXPPROP_PDXPATH ), PDXPath );
			}
			break;
		}
		break;
	}

	return (FALSE);
}

//

int MXPPROP(
	HWND hwnd
) {
	int ret;
	
	ret = DialogBox( hInst, MAKEINTRESOURCE(IDD_MXPPROP), hwnd, (DLGPROC)WndProc_MXPPROP );
	if ( ret < 0 ) {
		ret = 0;
	}
	return (ret);
}

//

void SetChannelMenuFlag(
	HWND hwnd
) {
	MENUITEMINFO m;
	HMENU hmenu;
	int i;
	DWORD state;

	ZeroMemory( &m, sizeof(MENUITEMINFO) );
	m.cbSize = sizeof(MENUITEMINFO);

	hmenu = GetSubMenu( GetMenu( hwnd ), 2 );
	state = GetChannelPlayFlagMDX();

	for ( i=0; i<16; i++ ) {
		GetMenuItemInfo( hmenu, IDM_KEY0+i, FALSE, &m );
		m.fMask = MIIM_STATE;
		m.fState = ( (state & (1<<i)) ? MFS_CHECKED : MFS_UNCHECKED );
		SetMenuItemInfo( hmenu, IDM_KEY0+i, FALSE, &m );
	}
}

//

void SetWindowInformation(
	HWND hwnd,
	TCHAR *mdxfilename
) {
	TCHAR str[FILENAME_MAX+256];

	if ( lstrlen( mdxfilename ) ) {
		wsprintf( str, "%s - mxp", mdxfilename );
	} else {
		wsprintf( str, "mxp" );
	}
	SetWindowText( hwnd, str );
	InvalidateRect( hwnd, NULL, FALSE );
	SetChannelMenuFlag( hwnd );
}
//
//  ֐: WndProc(HWND, unsigned, WORD, LONG)
//
//  pr: C EBhẼbZ[W܂B
//
//  WM_COMMAND	- AvP[V j[̏
//  WM_PAINT	- C EBhE̕`
//  WM_DESTROY	- IbZ[W̒ʒmƃ^[
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;
	static TCHAR mdxfilename[FILENAME_MAX+1];
	TCHAR str[256];
	static RECT WindowRect;
	RECT rt;
	COLORREF col;
	static int DisablePlay = 0;
	HFONT hfont, hfontold;
	DWORD lastplayflag;
	int wavehandle;
	int late;

	switch( message ) 
	{
		case WM_CREATE:
			DragAcceptFiles( hWnd, TRUE );
			if ( !DisablePlay ) {
				if ( argc >= 2 ) {
					WideCharToMultiByte( CP_ACP, 0, argv[1], -1, mdxfilename, sizeof(mdxfilename), NULL, NULL );
					lastplayflag = GetChannelPlayFlagMDX();
					PlayMDX( hWnd, mdxfilename );
					SetChannelPlayFlagMDX( lastplayflag );
					SetWindowInformation( hWnd, mdxfilename );
				}
			}
			GetWindowRect( hWnd, &WindowRect );
			SetTimer( hWnd, IDT_ASKPLAYEND, 1000, NULL );
			break;
		case WM_USER_START:
			if ( !DisablePlay ) {
				if ( wParam ) {
					HANDLE hargv = OpenFileMapping( FILE_MAP_READ|FILE_MAP_WRITE, FALSE, MXPFILENAME );
					if ( hargv ) {
						void *p = MapViewOfFile( hargv, FILE_MAP_READ|FILE_MAP_WRITE, 0, 0, 0 );
						if ( p ) {
							lstrcpy( mdxfilename, (LPSTR)p );
							lastplayflag = GetChannelPlayFlagMDX();
							PlayMDX( hWnd, mdxfilename );
							SetChannelPlayFlagMDX( lastplayflag );
							SetWindowInformation( hWnd, mdxfilename );
						}
					}
					CloseHandle( hargv );
				}
			}
			break;
		case WM_DROPFILES:
			if ( !DisablePlay ) {
				if ( DragQueryFile( (HDROP)wParam, 0, mdxfilename, sizeof(mdxfilename) ) ) {
					lastplayflag = GetChannelPlayFlagMDX();
					PlayMDX( hWnd, mdxfilename );
					SetChannelPlayFlagMDX( lastplayflag );
					SetWindowInformation( hWnd, mdxfilename );
				}
			}
			break;
		case WM_TIMER:
			switch ( wParam ) {
				case IDT_ASKPLAYEND:
					if ( AskPlayEnd() && (!WaitPlayEnd) ) {
						WaitPlayEnd = 1;
						late = GetPrivateProfileInt( "Switch", "Late", DEFLATE, INIFileName );
						SetTimer( hWnd, IDT_PLAYEND, 1000*1+late*WaveBufBlk, NULL );
					}
					break;
				case IDT_PLAYEND:
					KillTimer( hWnd, IDT_PLAYEND );
					if ( AskPlayEnd() ) {
						EndWaveout();
					}
					break;
			}
			break;
		case WM_MOVE:
			if ( !IsIconic( hWnd ) ) {
				GetWindowRect( hWnd, &WindowRect );
			}
			break;
		case WM_SIZE:
			if ( wParam == SIZE_RESTORED ) {
				GetWindowRect( hWnd, &WindowRect );
			}
			break;
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// j[Ỉ:
			switch( wmId ) 
			{
				case IDM_OPEN:
					if ( !DisablePlay ) {
						DisablePlay++;
						if ( FindMDX( hWnd, mdxfilename ) ) {
							lastplayflag = GetChannelPlayFlagMDX();
							PlayMDX( hWnd, mdxfilename );
							SetChannelPlayFlagMDX( lastplayflag );
							SetWindowInformation( hWnd, mdxfilename );
						}
						DisablePlay--;
					}
					break;
				case IDM_MXPPROP:
					if ( MXPPROP( hWnd ) ) {
						lastplayflag = GetChannelPlayFlagMDX();
						SetChannelPlayFlagMDX( lastplayflag );
						lstrcpy( mdxfilename, "" );
						SetWindowInformation( hWnd, "" );
						lstrcpy( MDXTitle, szHello );
					}
					break;
				case IDM_STOP:
					MXDRV_Stop();
					EndWaveout();
					break;
				case IDM_REPLAY:
					lastplayflag = GetChannelPlayFlagMDX();
					wavehandle = GetPrivateProfileInt( "Switch", "WAVEHandleByX68Sound", 0, INIFileName );
					if ( wavehandle == 0 ) {
						StartWaveout();
					}
					MXDRV_Replay();
					SetChannelPlayFlagMDX( lastplayflag );
					SetWindowInformation( hWnd, mdxfilename );
					break;
				case IDM_PAUSE:
					MXDRV_Pause();
					break;
				case IDM_CONT:
					MXDRV_Cont();
					break;
				case IDM_FADEOUT:
					MXDRV_Fadeout();
					break;
				case IDM_ABOUT:
					DisablePlay++;
					DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
					DisablePlay--;
					break;
				case IDM_EXIT:
					DestroyWindow( hWnd );
					break;
				case IDM_FFSTART:
					FastPlayMDX( 1 );
					break;
				case IDM_FFEND:
					FastPlayMDX( 0 );
					break;
				case IDM_KEY0:
					NegateChannelPlayFlagMDX( 0 );
					SetChannelMenuFlag( hWnd );
					break;
				case IDM_KEY1:
					NegateChannelPlayFlagMDX( 1 );
					SetChannelMenuFlag( hWnd );
					break;
				case IDM_KEY2:
					NegateChannelPlayFlagMDX( 2 );
					SetChannelMenuFlag( hWnd );
					break;
				case IDM_KEY3:
					NegateChannelPlayFlagMDX( 3 );
					SetChannelMenuFlag( hWnd );
					break;
				case IDM_KEY4:
					NegateChannelPlayFlagMDX( 4 );
					SetChannelMenuFlag( hWnd );
					break;
				case IDM_KEY5:
					NegateChannelPlayFlagMDX( 5 );
					SetChannelMenuFlag( hWnd );
					break;
				case IDM_KEY6:
					NegateChannelPlayFlagMDX( 6 );
					SetChannelMenuFlag( hWnd );
					break;
				case IDM_KEY7:
					NegateChannelPlayFlagMDX( 7 );
					SetChannelMenuFlag( hWnd );
					break;
				case IDM_KEY8:
					NegateChannelPlayFlagMDX( 8 );
					SetChannelMenuFlag( hWnd );
					break;
				case IDM_KEY9:
					NegateChannelPlayFlagMDX( 9 );
					SetChannelMenuFlag( hWnd );
					break;
				case IDM_KEYA:
					NegateChannelPlayFlagMDX( 10 );
					SetChannelMenuFlag( hWnd );
					break;
				case IDM_KEYB:
					NegateChannelPlayFlagMDX( 11 );
					SetChannelMenuFlag( hWnd );
					break;
				case IDM_KEYC:
					NegateChannelPlayFlagMDX( 12 );
					SetChannelMenuFlag( hWnd );
					break;
				case IDM_KEYD:
					NegateChannelPlayFlagMDX( 13 );
					SetChannelMenuFlag( hWnd );
					break;
				case IDM_KEYE:
					NegateChannelPlayFlagMDX( 14 );
					SetChannelMenuFlag( hWnd );
					break;
				case IDM_KEYF:
					NegateChannelPlayFlagMDX( 15 );
					SetChannelMenuFlag( hWnd );
					break;
				case IDM_MASKCLEAR:
					SetChannelPlayFlagMDX( 0 );
					SetChannelMenuFlag( hWnd );
					break;
				default:
					return DefWindowProc( hWnd, message, wParam, lParam );
			}
			break;
		case WM_PAINT:
			hdc = BeginPaint (hWnd, &ps);
			// TODO: ̈ʒuɕ`p̃R[hǉĂ...
			GetClientRect( hWnd, &rt );
			col = GetTextColor( hdc );
			hfont = CreateFont( GetSystemMetrics( SM_CYSIZE ), 0, 0, 0, FW_DONTCARE, FALSE, FALSE, FALSE, DEFAULT_CHARSET, 0, 0, 0, FIXED_PITCH, "lr SVbN" );
			hfontold = (HFONT)SelectObject( hdc, hfont );
			SetTextColor( hdc, GetSysColor(COLOR_WINDOW) );
			DrawText( hdc, szDispMDXTitle, lstrlen(szDispMDXTitle), &rt, DT_CENTER|DT_NOPREFIX );
			SetTextColor( hdc, col );
			if ( PlayTime ) {
				wsprintf( szDispMDXTitle, "(%d:%02d) %s", PlayTime/1000/60, PlayTime/1000%60, MDXTitle );
			} else {
				wsprintf( szDispMDXTitle, "%s", MDXTitle );
			}
			DrawText( hdc, szDispMDXTitle, lstrlen(szDispMDXTitle), &rt, DT_CENTER|DT_NOPREFIX );
			SelectObject( hdc, hfontold );
			DeleteObject( hfont );
			EndPaint( hWnd, &ps );
			break;
		case WM_DESTROY:
			wsprintf( str, "%d", WindowRect.left );
			WritePrivateProfileString( "Position", "X", str, INIFileName );
			wsprintf( str, "%d", WindowRect.top );
			WritePrivateProfileString( "Position", "Y", str, INIFileName );
			wsprintf( str, "%d", WindowRect.right-WindowRect.left );
			WritePrivateProfileString( "Position", "W", str, INIFileName );
			wsprintf( str, "%d", WindowRect.bottom-WindowRect.top );
			WritePrivateProfileString( "Position", "H", str, INIFileName );
			wsprintf( str, "%d", IsIconic( hWnd ) );
			WritePrivateProfileString( "Position", "Iconic", str, INIFileName );
			PostQuitMessage( 0 );
			break;
		default:
			return DefWindowProc( hWnd, message, wParam, lParam );
	}
	return 0;
}

// o[W{bNXpbZ[W nh
LRESULT CALLBACK About( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	switch( message )
	{
		case WM_INITDIALOG:
				SetWindowText( GetDlgItem( hDlg, IDC_STATIC_ABOUTBOX_CREDIT ), (TCHAR *)MXDRV_GetWork(MXDRV_WORK_CREDIT) );
				return TRUE;

		case WM_COMMAND:
			if( LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL ) 
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}
*/