gm = require("gm")

menu = {
	img,
	ttl,
	init = function( self )
		self.img = LoadGraph( "title.bmp" );
		ttl = gm.Actor(100,100,0,0,self.img)
		gm:add( ttl );
	end;
	
	loop = function( self )
		if gm.mouse.left.down then
			gm:clear();
			gm:SetMainLoop(main);
		end;
	end;
}

STATE = {
	NAGI_PLAY = "PLAY",
	NAGI_LINE = "LINE",
	NAGI_EXEC = "EXEC",
}

BOMB = function (x,y, img )
	local b = gm.Actor( x,y, 0,0, img );
	b.count = 1;
	b.draw = function( self )
		DrawGraph( self.x  , self.y , self.img[self.count], 1 ) ;
		self.count = self.count + 1;
		if self.count == 16 then 
			self.state = 0;
		end;
	end;
	
	return b;
end;

main = {
	level = 1;

	nagiCount;

	nagiLine = {
		data = {};

		calc = function(self)
		end;

		add = function(self, dt)
			table.insert( self.data, dt );
		end;
		clear = function(self)
			self.data = {};
		end;

		draw = function(self)
			for i,v in ipairs( self.data ) do 
				DrawPixel( v.x  , v.y , GetColor(   0 , 255 , 0 ) ) ;
			end;
		end;

		isDead = function( self )
		end;
	};

	init = function(self)
		self.bombimg = LoadDivGraph( "bomb.png", 16,4, 4,64,64 );
		self.img = LoadGraph( "tama.bmp" );
--		local ttl = gm.Actor(100,100,0,0,self.img)
--		gm:add( ttl );
		gm:add( self.nagiLine );
		self.state = STATE.NAGI_PLAY;
	end;

	loop = function(self)

		if self.state == STATE.NAGI_PLAY then
			if gm.mouse.right.down then
				self.nagiCount = 100;
				self.state = STATE.NAGI_LINE
				self.nagiLine:clear();
			end;
		elseif self.state == STATE.NAGI_LINE then
			self.nagiLine:add({x=gm.mouse.x, y=gm.mouse.y});
			self.nagiCount = self.nagiCount - 1;
			if gm.mouse.right.up or (self.nagiCount < 1 ) then
				self.state = STATE.NAGI_EXEC
			end;
		elseif self.state == STATE.NAGI_EXEC then
			local b = BOMB( self.nagiLine.data[1].x-32,self.nagiLine.data[1].y-32, self.bombimg); 
			gm:add( b );
			table.remove( self.nagiLine.data, 1 );
			if #self.nagiLine.data == 0 then 
				self.state = STATE.NAGI_PLAY
			end;
		end;
		print( self.state );
	end;
}

gm:init();
gm:SetMainLoop(menu);
gm:run();
