require "DxLib"

dofile "3DMap.lua"

ChangeWindowMode(1);
if( DxLib_Init() == -1 ) then os.exit() end; -- G[N璼ɏI

SetGraphMode( 800 , 600 , 32 ) ;

-- `ʂ𗠉ʂɃZbg
SetDrawScreen(0xfffffffe);

Model = {
	Count = 3;
	Name = {"ishiKabe2.mqo","kaidan2.mqo", "camera.mqo"};
	Handle = {0,0,0};
	[  1] = { 1, 0, 0,   0 };
	[  2] = { 2, 0, 0,   0 };
	[  3] = { 2, 0, 0,  90 };
	[  4] = { 2, 0, 0, 180 };
	[  5] = { 2, 0, 0, 270 };
	[100] = {100,0, 0,   0 };

	init = function( self )
		for i = 1, self.Count do
			if self.Handle[i] == 0 then
				MV1DeleteModel( self.Handle[i] );
			end;
			self.Handle[i] = MV1LoadModel( self.Name[i] ) ;
		end;
	end;
	
	Draw = function(self, x, y, z, n )
		if self[ n ] ~= nil then 
			local v = { x=(x-1) * 200, y=(y-1) * 200, z=(z-1) * 200 };
			MV1SetPosition( self.Handle[self[n][1]], v ); 
			MV1SetRotationXYZ( self.Handle[self[n][1]] , {x=0,y=math.rad(self[n][4]),z=0} );
			MV1DrawModel( self.Handle[self[n][1]] );
		end;
		
	end;
}

Model:init();

Player = {
	x = 2;
	y = 2;
	z = 2;
	cur = 0;
}

MOVEDIST  = 200;
MOVECOUNT = 10;
TURNCOUNT = 10;

TURNSTEP  = math.rad( 90 / TURNCOUNT );
MOVESTEP  = MOVEDIST / MOVECOUNT;

state = 0;
count = 0;

local OutCamPos  = { x = 1800, y = 3000, z = 2000 };

local CamPos  = { x = Player.x * MOVEDIST, y = Player.y * MOVEDIST, z = Player.z * MOVEDIST };
local CamTurn = { x =  0, y =  0, z =  0 };

local CamMode = false;

local curs = {
		[0] = { x = -1, z = 0, y = 0 },
		[1] = { x =  0, z = 1, y = 0 },
		[2] = { x =  1, z = 0, y = 0 },
		[3] = { x =  0, z =-1, y = 0 }
	}


function vadd( a, b )
end;

moveVect = {x=0,y=0,z=0}

while( ProcessMessage() == 0 ) do
    if CheckHitKey(1) == 1 then break end;
    ClearDrawScreen() ;			-- ʂ

    key,dkey,ukey = GetJoypadInputStateEX( 0x1001 ) ;

	if state == 0 then
		-- ړ
		if dkey.UP    then
			moveVect.x = curs[Player.cur].x * MOVESTEP;
			moveVect.y = curs[Player.cur].y * MOVESTEP;
			moveVect.z = curs[Player.cur].z * MOVESTEP;
			Player.x = Player.x + curs[Player.cur].x
			Player.y = Player.y + curs[Player.cur].y
			Player.z = Player.z + curs[Player.cur].z
			state = 1;
		end;
		if dkey.DOWN  then 
			moveVect.x = curs[Player.cur].x * -MOVESTEP;
			moveVect.y = curs[Player.cur].y * -MOVESTEP;
			moveVect.z = curs[Player.cur].z * -MOVESTEP;
			Player.x = Player.x - curs[Player.cur].x
			Player.y = Player.y - curs[Player.cur].y
			Player.z = Player.z - curs[Player.cur].z
			state = 1;
		end;
		if dkey.RIGHT then 
			ts = TURNSTEP;
			CamTurn.y = math.rad( ((Player.cur-1)%4) * 90 );
			Player.cur = (Player.cur + 1) % 4;
			state = 2;
		end;
		if dkey.LEFT  then
			ts = -TURNSTEP;
			CamTurn.y = math.rad( ((Player.cur-1)%4) * 90 );
			Player.cur = (Player.cur - 1) % 4;
			state = 2;
		end;

		if dkey.A then 
			moveVect.x = 0;
			moveVect.z = 0;
			moveVect.y = - MOVESTEP;
			Player.y = Player.y - 1;
			state = 1;
		end;
		if dkey.X then 
			moveVect.x = 0;
			moveVect.z = 0;
			moveVect.y = MOVESTEP;
			Player.y = Player.y + 1;
			state = 1;
		end;
		if dkey.C then
			Model:init();
		end;
		if dkey.Y then
			dofile "3DMap.lua"
		end;
		if dkey.Z then
			CamMode = not CamMode;
		end;

	elseif state == 1 then
		count = count + 1;
		CamPos.x = CamPos.x + moveVect.x;
		CamPos.y = CamPos.y + moveVect.y;
		CamPos.z = CamPos.z + moveVect.z;
		if count >= MOVECOUNT then 
			state = 0;
			count = 0;
		end;
	elseif state == 2 then
		count = count + 1;
		CamTurn.y = CamTurn.y + ts;
		if count >= TURNCOUNT then 
			state = 0;
			count = 0;
		end;

	end;

if CamMode then 
	SetCameraPositionAndAngle( CamPos, CamTurn.x, CamTurn.y, CamTurn.z );
else
	SetCameraPositionAndTarget_UpVecY( OutCamPos, {x=1000,y=0,z=1000} );

	MV1SetPosition( Model.Handle[3], CamPos ); 
	MV1SetRotationXYZ( Model.Handle[3], CamTurn );
	MV1DrawModel( Model.Handle[3] );
end;

	local v = { x = 0, y = 0, z = 0 };
	for y = 1, 4, 1 do
		for z = 1, 16, 1 do
			for x = 1, 16, 1 do
				Model:Draw( x,y,z, map[y][x][z] );
			end;
		end;
	end;

	DrawString( 10,10, "Player X:".. Player.x .." Y:".. Player.y .." Z:"..Player.z .." CUR:"..Player.cur, 0xFFFF );
	DrawString( 10,30, "Camera :".. CamPos.x .." ".. CamPos.y .." "..CamPos.z, 0xFFFF );
    -- ʂ̓e\ʂɔf
    ScreenFlip() ;

end;

-- cwCugp̏I
DxLib_End();








