-- gm.lua
require("DxLib")
return {
	WindowWidth = 640,
	WindowHeight= 480,
	WindowColor =  32,
	WindowMode  = true,
	FontHandle  = nil,
	KeyDown={},
	KeyUp  ={},
	KeyHeld={},
	child = {},
	MainProc = Nil,

	oldl = false;
	oldr = false;
	oldm = false;

	GetMouseInputEx = function(self)
		local ret,mx,my = GetMousePoint();
		local l,r,m     = GetMouseInput();
		local a,b,c;
		if self.oldl and ( not l ) then a = true; end;
		if self.oldr and ( not r ) then b = true; end;
		if self.oldm and ( not m ) then c = true; end;
		self.oldl = l;
		self.oldr = r;
		self.oldm = m;
		return { x=mx, y=my, l=a ,r=b, m=c };
	end;
	
	Actor = function (_x,_y,_dx,_dy,_img)
		return {
			x     = _x,
			y     = _y,
			dx    = _dx,
			dy    = _dy,
			img   = _img,
			state = 1;

			calc = function(self)
				self.x = self.x + self.dx;
				self.y = self.y + self.dy;
			end;
			draw = function(self)
				DrawGraph( self.x  , self.y , self.img, 1 ) ;
			end;
			isDead = function(self)
				return (self.state == 0);
			end;
		}
	end;

	Background = function (_x, _y, _dx, _dy, _siz, _dat, _img)
		return {
			x     = _x,
			y     = _y,
			dx    = _dx,
			dy    = _dy,
			dat   = _dat,
			img   = _img,
			siz   = 32,
			state = 1,

			calc = function(self)
				self.x = self.x + self.dx;
				self.y = self.y + self.dy;
			end;

			draw = function(self)
				if state == 0 then return end;
				local bx, by;
				local ax = math.floor(self.x / self.siz);
				local ay = math.floor(self.y / self.siz);
				local mx = self.x % self.siz;
				local my = self.y % self.siz;
				for by=0,15,1 do
					if self.dat[by+ay] == nil then break; end;
					for bx=0,20,1 do
						if self.dat[by+ay][bx+ax] == nil then break; end;
						DrawGraph( bx*32-mx, by*32-my, self.img[self.dat[by+ay][bx+ay]] );
					end;
				end;
			end;
			isDead = function(self)
				return (self.state == 0);
			end;
		}
	end;

	add  = function(self, _obj)
		table.insert(self.child, _obj);
	end;

	calc = function(self)
		local i,v;
		for i,v in ipairs(self.child) do
			if v:isDead() then
				table.remove(self.child,i);
			else
				v:calc();
			end;
		end;
	end;

	draw = function(self)
		local i,v;
			for i,v in ipairs(self.child) do
				v:draw();
			end;
	end;

	clear = function(self)
		self.child = {};
	end;

	drawText = function(self, x, y, s )
		for i = 1, #s do
			local c = string.byte(s, i);
			DrawGraph( x + i*16, y , self.FontHandle[c],1 ) ;
		end;
	end;

	init = function(self)
		math.randomseed(os.time());
		SetUseFPUPreserveFlag(1);										-- FPU̐x𗎂ƂȂ
		local w;
		if self.WindowMode == true then
			w = 1;
		else
			w = 0;
		end;
		ChangeWindowMode(w);											-- window mode
		SetDrawScreen(0xfffffffe);										-- `:

		SetGraphMode( self.WindowWidth , self.WindowHeight , self.WindowColor ) ;		-- GraphMode

		if ( DxLib_Init() == -1 ) then  									-- G[N璼ɏI
			return -1;
		end;
		ClearDrawScreen() ;
		self.FontHandle = LoadDivGraph( "font.bmp"  ,128,16, 8,16,16 );
	end;

	run = function(self)
		while( (ProcessMessage() == 0) and (CheckHitKey(1) == 0)  ) do
			ClearDrawScreen() ;
			self.KeyDown, self.KeyHeld, self.KeyUp = GetJoypadInputStateEX( 0x1001 ) ;
			if self.MainProc ~= nil then
				if self.MainProc.init ~= nil then
					self.MainProc:init();
					self.MainProc.init = nil;
				end;
				self.MainProc:loop();
			end;
			self:calc();
			self:draw();
			ScreenFlip();
		end;
	end;

	exit = function(self)
		DxLib_End();
	end;

	SetMainLoop = function(self, f)
		self.MainProc = f;
	end;

}
