require "DxLib"
require "tssLib"

local d = os.date("*t");
math.randomseed(d.sec);

--dofile "stagedata.lua"

SetGraphMode( 1024 , 768 , 32 ) ;

BG_WIDTH  = 64;
BG_HEIGHT = 48;

BG_NO_NON =  0  -- ʘH  BG
BG_NO_DOT =  1  -- dot   BG
BG_NO_POW =  2  -- power BG
BG_NO_SLW =  3  -- slow  BG
BG_NO_WRP =  4  -- warp  BG

ChangeWindowMode(1);

-- `ʂ𗠉ʂɃZbg
SetDrawScreen(0xfffffffe);

if( DxLib_Init() == -1 ) then os.exit() end; -- 

ret, charGraph = LoadDivGraph( "char.bmp", 64, 8, 8,32,32 );
ret, bgGraph   = LoadDivGraph( "bged.bmp"  ,256,16,16,16,16 );
ret, bgFont    = LoadDivGraph( "font.bmp",128,16, 8,16,16 );

function drawText( x, y, s )
	for i = 1, #s do
		local c = string.byte(s, i);
		DrawGraph( x + i*16, y , bgFont[c] ) ;
	end;
end;


function drawBG( x, y )
	DrawBox( x-1 , y-1 , x+1 + 16*16 , y+1 + 16*16 ,0xFFFFFF , 0 );
	for i= 0,15 do
		for j=0,15 do
			DrawGraph( x + i*16, y + j*16, bgGraph[j*16+i]  );
		end;
	end;
end;

Back = {
    stage = {};

    stageinit = function(self)
--[[
        for i=0,BG_HEIGHT-1 do
            self.stage[i] = {};
            for j=0,BG_WIDTH-1 do
            	if stagedata[i] == nil then 
	            	self.stage[i][j] = 0;
	            else
	            	if stagedata[i][j] == nil then 
		            	self.stage[i][j] = 0;
		            else
		                self.stage[i][j] = stagedata[i][j];
					end;
				end;
		    end;
        end;
     ]]--
    end;

    draw = function(self)
        local i,j;
        for j=0,BG_HEIGHT-1 do
        	if self.stage[j] == nil then self.stage[j] = {}; end;
            for i=0,BG_WIDTH-1 do
            	if self.stage[j][i] == nil then self.stage[j][i] = 0; end;
                DrawGraph( 16*i , 16*j , bgGraph[self.stage[j][i]] ) ;
--[[
                if self.stage[j][i] == 0 or self.stage[j][i] == 16 or self.stage[j][i] ==17 then
                       DrawBox( 16*i ,16*j, 16*i+16,16*j+16, 0x555555 ,0 );
                end;
]]--
            end;
        end;
--[[
		for i,j in pairs(medamadata) do

            local z = { {x=0,y=-1},{x=1,y=0},{x=0,y=1},{x=-1,y=0} };
			local x = i%32;
			local y = math.floor(i/32);

			for k = 1 , 4 do
	            if j[k] == 1 then  DrawBox( 16*(x+z[k].x),16*(y+z[k].y), 16*(x+z[k].x)+16,16*(y+z[k].y)+16, 0x555555 ,0 ); end;
			end;
		end;
]]--
    end;

	chkstage = function(self, x, y)
		local b = self.stage[y][x];
		print( y );
		local cnt = 0;
		local dt={[0]={x=0,y=-1},{x=1,y=0},{x=0,y=1},{x=-1,y=0}};
		local buf={[0]=0,0,0,0};
		if b == BG_NO_NON or b == BG_NO_POW or b == BG_NO_SLW or b == BG_NO_DOT then
			for i=0,3 do
				b = self.stage[y+dt[i].y][x+dt[i].x];
				if b == BG_NO_NON or b == BG_NO_POW or b == BG_NO_SLW or b == BG_NO_DOT then 
					cnt = cnt + 1;
					buf[i] = 1;
				end;
			end;
			if cnt==1 then buf = nil; -- s~܂ȂȂ
			elseif cnt == 2 then -- ȂpȂ΂Ȃ
				if     buf[0]==1 and buf[2]==1 then buf = nil;
				elseif buf[1]==1 and buf[3]==1 then buf = nil; end;
			end;
		end;
		if cnt==0 then buf = nil; end; -- s~܂ȂȂ
		return buf;
	end;

    savestage = function(self)
		local cnt = 0;
		local i,j ;
		local buf = {};
		fp = io.open ( "sdata.lua" , "w")
		fp:write( "Back.stage = {\n" )
		for i=0,BG_HEIGHT-1 do
			if i==0 then fp:write( "[0]=") else fp:write( "    ") end;
			fp:write( "{")
			for j=0,BG_WIDTH-1 do
				if j==0 then fp:write( "[0]=")  end;
				if self.stage[i]==nil or self.stage[i][j] == nil then num = 0 else num = self.stage[i][j] end;
				if num == BG_NO_POW or num == BG_NO_DOT then cnt = cnt + 1; end;
				fp:write( string.format("%3d", num), "," );
			end;
			fp:write( "},\n")
		end;
		fp:write( "};\n");
		fp:write( "stagedotcount = "..tostring( cnt ).."\n" );
		fp:write( "kosadata = {};\n" );

		for i=1,BG_HEIGHT-2 do
			if self.stage[i]==nil then break; end;
			for j=1,BG_WIDTH-1 do
				if self.stage[i][j]~=nil then
					buf = self:chkstage( j,i );
					if buf ~= nil then
						fp:write( "kosadata[",string.format("%2d", i*BG_WIDTH+j),"]={",
						          string.format("%d", buf[0]),",",
						          string.format("%d", buf[1]),",",
						          string.format("%d", buf[2]),",",
						          string.format("%d", buf[3]),
						          "};\n" );
					end;
 				end;
			end;
		end;
		fp:flush();
		fp:close();
    end;

	loadstage = function(self)
		dofile "sdata.lua"
		self:stageinit();
	end;

}

Back:stageinit();

function sb( b )
	if b then slb="T" else slb="F" end;
	return slb;
end;



function GetMouseInput2()
	local lb,rb,mb = GetMouseInput();
	if lb then 
		if olb then lb = false else olb = true end
	else 
		olb = false
	end;
	if rb then 
		if orb then rb = false else orb = true end
	else 
		orb = false
	end;
	if mb then 
		if omb then mb = false else omb = true end
	else 
		omb = false
	end;
	return lb,rb,mb;
end;

BGSelecter=false;

function getBGsel( x, y )
	if x < 30*16 or x > (30+16)*16 then return -1 end;
	if y < 30*16 or y > (30+16)*16 then return -1 end;
	
	dx = math.floor( (x - 30*16) / 16 );
	dy = math.floor( (y - 30*16) / 16 );
	return dy*16 + dx;
end;

bgnum = 0;
cnt = 0;
tenmetu = true;
drawGrid = true;

KEY_INPUT_F1 = 0x3B
KEY_INPUT_F2 = 0x3C

while( ProcessMessage() == 0 ) do
    if CheckHitKey(1) == 1 then break end;

	if CheckHitKey(KEY_INPUT_F1) == 1 then
		Back:savestage();
	end;

	if CheckHitKey(KEY_INPUT_F2) == 1 then
		Back:loadstage();
	end;

    -- ʂ
    ClearDrawScreen() ;

	ret,x,y = GetMousePoint();

	local l,r,m    = GetMouseInput();
	local lb,rb,mb = GetMouseInput2();

	if BGSelecter then
		if lb then
			ret = getBGsel( x, y );
			if ret ~= -1 then 
				bgnum = ret;
--				BGSelecter = false;
			end;
		end;
		if mb then
			BGSelecter = not BGSelecter
		end;
	else 
		if l then
			dx = math.floor( x  / 16 );
			dy = math.floor( y  / 16 );
			if Back.stage[dy] == nil then Back.stage[dy] = {}; end;
			Back.stage[dy][dx] = bgnum;
		end;
		if rb then
			dx = math.floor( x  / 16 );
			dy = math.floor( y  / 16 );
			bgnum = Back.stage[dy][dx];
		end;
		if mb then
			BGSelecter = not BGSelecter
		end;
	end;

	Back:draw();

	if drawGrid then
		for i=0,BG_WIDTH  do DrawLine( i*16 , 0    , i*16       ,16*BG_HEIGHT ,0x555555 ,0 ) end;
		for i=0,BG_HEIGHT do DrawLine( 0    , i*16 , 16*BG_WIDTH,i*16         ,0x555555 ,0 ) end;
	end;
	
--	drawText( 28*16,36*16, ""..bgnum )
	if BGSelecter  then
		drawBG( 30*16, 30*16 );
		drawText( 30*16,29*16, ""..bgnum )
	end;
    -- ʂ̓e\ʂɔf
    ScreenFlip() ;

end;

-- cwCugp̏I
DxLib_End();

