require "DxLib"
require "tssLib"

local d = os.date("*t");
math.randomseed(d.sec);

dofile "stagedata.lua"
dofile "sdata.lua"

SetGraphMode( 800 , 600 , 32 ) ;

ChangeWindowMode(1);
--SetGraphMode( 640 , 496 , 32 ) ;

-- `ʂ𗠉ʂɃZbg
SetDrawScreen(0xfffffffe);

if( DxLib_Init() == -1 ) then os.exit() end; -- G[N璼ɏI

charGraph = LoadDivGraph( "char.bmp", 64, 8, 8,32,32 );
bgGraph   = LoadDivGraph( "bg.bmp"  ,128,16, 8,16,16 );


function drawText( x, y, s )
	for i = 1, #s do
		local c = string.byte(s, i);
		DrawGraph( x + i*16, y , bgGraph[c] ) ;
	end;
end;


function drawBG( x, y )
	DrawBox( x-1 , y-1 , x+1 + 16*16 , y+1 + 8*16 ,0xFFFFFF , 0 );
	for i= 0,15 do
		for j=0,7 do
			DrawGraph( x + i*16, y + j*16, bgGraph[j*16+i]  );
		end;
	end;
end;

Back = {
    stage = {};

    stageinit = function(self)
        for i=0,34 do
            self.stage[i] = {};
            for j=0,49 do
            	if stagedata[i] == nil then 
	            	self.stage[i][j] = 0;
	            else
	            	if stagedata[i][j] == nil then 
		            	self.stage[i][j] = 0;
		            else
		                self.stage[i][j] = stagedata[i][j];
					end;
				end;
		    end;
        end;
    end;

    draw = function(self)
        local i,j;
        for j=0,34 do
            for i=0,49 do
                DrawGraph( 16*i , 16*j , bgGraph[self.stage[j][i]] ) ;
--[[
                if self.stage[j][i] == 0 or self.stage[j][i] == 16 or self.stage[j][i] ==17 then
                       DrawBox( 16*i ,16*j, 16*i+16,16*j+16, 0x555555 ,0 );
                end;
]]--
            end;
        end;
--[[
		for i,j in pairs(medamadata) do

            local z = { {x=0,y=-1},{x=1,y=0},{x=0,y=1},{x=-1,y=0} };
			local x = i%32;
			local y = math.floor(i/32);

			for k = 1 , 4 do
	            if j[k] == 1 then  DrawBox( 16*(x+z[k].x),16*(y+z[k].y), 16*(x+z[k].x)+16,16*(y+z[k].y)+16, 0x555555 ,0 ); end;
			end;
		end;
]]--
    end;
    
    savestage = function(self)
    	cnt = 0;
		fp = io.open ( "sdata.lua" , "w")
		fp:write( "stagedata = {\n" )
		for i=0,34 do
			if i==0 then fp:write( "[0]=") else fp:write( "    ") end;
			fp:write( "{")
			for j=0,49 do
				if j==0 then fp:write( "[0]=")  end;
				if self.stage[i]==nil or self.stage[i][j] == nil then num = 0 else num = self.stage[i][j] end;
				if num == 46 or num == 47 then cnt = cnt + 1; end;
				fp:write( string.format("%2d", num), "," );
			end;
			fp:write( "},\n")
		end;
		fp:write( "};\n");
		fp:write( "stagedotcount = "..tostring( cnt ).."\n" );
		fp:flush();
		fp:close();
    end;

}

Back:stageinit();

function sb( b )
	if b then slb="T" else slb="F" end;
	return slb;
end;



function GetMouseInput2()
	local lb,rb,mb = GetMouseInput();
	if lb then 
		if olb then lb = false else olb = true end
	else 
		olb = false
	end;
	if rb then 
		if orb then rb = false else orb = true end
	else 
		orb = false
	end;
	if mb then 
		if omb then mb = false else omb = true end
	else 
		omb = false
	end;
	return lb,rb,mb;
end;

BGSelecter=false;

function getBGsel( x, y )
	if x < 30*16 or x > (30+16)*16 then return -1 end;
	if y < 30*16 or y > (30+ 8)*16 then return -1 end;
	
	dx = math.floor( (x - 30*16) / 16 );
	dy = math.floor( (y - 30*16) / 16 );
	return dy*16 + dx;
end;

bgnum = 0;
cnt = 0;
tenmetu = true;
drawGrid = true;

KEY_INPUT_F1 = 0x3B

while( ProcessMessage() == 0 ) do
    if CheckHitKey(1) == 1 then break end;

	if CheckHitKey(KEY_INPUT_F1) == 1 then
		Back:savestage();
	end;

    -- ʂ
    ClearDrawScreen() ;

	ret,x,y = GetMousePoint();

	local lb,rb,mb = GetMouseInput2();
	if rb then
		BGSelecter = not BGSelecter
	end;
	if lb then
		if BGSelecter then
			ret = getBGsel( x, y );
			if ret ~= -1 then 
				bgnum = ret;
				BGSelecter = false;
			end;
		else
			dx = math.floor( x  / 16 );
			dy = math.floor( y  / 16 );
			Back.stage[dy][dx] = bgnum;
		end;
	end;

	Back:draw();

	if drawGrid then
		for i=0,50 do DrawLine( i*16 , 0 , i*16, 16*34 ,0x555555 ,0 ) end;
		for i=0,34 do DrawLine( 0 , i*16 , 16*50,i*16  ,0x555555 ,0 ) end;
	end;
	
	drawText( 28*16, 5*16, ""..bgnum )
	if BGSelecter  then
		drawBG( 30*16, 30*16 );
	end;
    -- ʂ̓e\ʂɔf
    ScreenFlip() ;

end;

-- cwCugp̏I
DxLib_End();

