map <- {
	mapdata_num = 0
	mapdata_name = "maze_map_data"

	mazeUpdate = true,

	party = {}
	event = {}

	bx = [ -1, 0, 1,  -1, 0, 1,  -1, 0, 1,  0, 0, 0,   1, 1, 1,   2, 2, 2,  1, 0,-1,   1, 0,-1,   1, 0,-1,  0, 0, 0,  -1,-1,-1,  -2,-2,-2  ]
	by = [  0, 0, 0,  -1,-1,-1,  -2,-2,-2, -1, 0, 1,  -1, 0, 1,  -1, 0, 1,  0, 0, 0,   1, 1, 1,   2, 2, 2,  1, 0,-1,   1, 0,-1,   1, 0,-1  ]
	dirmap = [
		[ [0xFF,0xFF,0xFF] ,[0xFF,0xFF,0xFF] ,[0xFF,0xFF,0xFF] ],
		[ [0xFF,0xFF,0xFF] ,[0xFF,0xFF,0xFF] ,[0xFF,0xFF,0xFF] ],
		[ [0xFF,0xFF,0xFF] ,[0xFF,0xFF,0xFF] ,[0xFF,0xFF,0xFF] ]
	]
	MazeLineData = [
		{ flg=false, vis=false, x=  0,y=  0,w= 10,h= 10,
			[ [ [1,0,0],
			
		},	// 0
		{ flg=false, vis=false, x=  0,y=100,w= 10,h=-10 },	// 1
		{ flg=false, vis=false, x=100,y=  0,w=-10,h= 10 },	// 2
		{ flg=false, vis=false, x=100,y=100,w=-10,h=-10 },	// 3

		{ flg=false, vis=false, x= 10,y= 10,w= 80,h=  0 },	// 4
		{ flg=false, vis=false, x= 10,y= 10,w=  0,h= 80 },	// 5
		{ flg=false, vis=false, x= 10,y= 90,w= 80,h= 00 },	// 6
		{ flg=false, vis=false, x= 90,y= 10,w=  0,h= 80 },	// 7

		{ flg=false, vis=false, x=  0,y= 10,w= 10,h=  0 },	// 8
		{ flg=false, vis=false, x=  0,y= 90,w= 10,h=  0 },	// 9
		{ flg=false, vis=false, x= 90,y= 10,w= 10,h=  0 },	//10
		{ flg=false, vis=false, x= 90,y= 90,w= 10,h=  0 },	//11

		{ flg=false, vis=false, x= 30,y= 30,w= 40,h=  0 },	//12
		{ flg=false, vis=false, x= 30,y= 30,w=  0,h= 40 },	//13
		{ flg=false, vis=false, x= 30,y= 70,w= 40,h=  0 },	//14
		{ flg=false, vis=false, x= 70,y= 30,w=  0,h= 40 },	//15

		{ flg=false, vis=false, x= 10,y= 10,w= 20,h= 20 },	//16
		{ flg=false, vis=false, x= 10,y= 90,w= 20,h=-20 },	//17
		{ flg=false, vis=false, x= 90,y= 10,w=-20,h= 20 },	//18
		{ flg=false, vis=false, x= 90,y= 90,w=-20,h=-20 },	//19

		{ flg=false, vis=false, x= 10,y= 30,w= 20,h=  0 },	//20
		{ flg=false, vis=false, x= 10,y= 70,w= 20,h=  0 },	//21
		{ flg=false, vis=false, x= 70,y= 30,w= 20,h=  0 },	//22
		{ flg=false, vis=false, x= 70,y= 70,w= 20,h=  0 },	//23

		{ flg=false, vis=false, x= 30,y= 30,w= 20,h= 20 },	//24
		{ flg=false, vis=false, x= 30,y= 70,w= 20,h=-20 },	//25
		{ flg=false, vis=false, x= 70,y= 30,w=-20,h= 20 },	//26
		{ flg=false, vis=false, x= 70,y= 70,w=-20,h=-20 },	//27
	]

	function init(e, p)
	{
		party = p
		event = e
		dofile( "nds.nut" );
		change_mapdata(0);
	}

	function proc()
	{
		drawMaze();
	}

	function change_mapdata(num)
	{
		mapdata_num = num;
		dofile( mapdata_name + mapdata_num + ".nut" );
	}

	function moveCheck(d){
		local cx, cy;
		local dx = [ 0, 1, 0, -1 ];
		local dy = [-1, 0, 1,  0 ];
		cx = dx[party.dir] * d;
		cy = dy[party.dir] * d;
		if( party.z < 0 || party.x < 0 || party.y < 0 )      return [ false, 0,0 ];
		if( party.z >= mazedata.len() )          return [ false, 0,0 ];
		if( party.y >= mazedata[party.z].len() )       return [ false, 0,0 ];
		if( party.x >= mazedata[party.z][party.y+cy].len() ) return [ false, 0,0 ];
		if( 128     <  mazedata[party.z][party.y+cy][party.x+cx] ) return [ false, 0,0 ];
		return [ true, cx, cy ];
	}

	function drawMaze(){

		if( !mazeUpdate ) return;

		local h,i,j;
		local cx,cy,cz;
		for( h=0;h<3;h++){
			for( i=0;i<3;i++){
				for( j=0;j<3;j++){
					cz = party.z+(h-1);
					cy = party.y+by[party.dir*9+i*3+j];
					cx = party.x+bx[party.dir*9+i*3+j];
					if( (cz < 0) || (cz >= mazedata.len()        ) ){ dirmap[h][i][j] = 0xff; continue; }
					if( (cy < 0) || (cy >= mazedata[cz].len()    ) ){ dirmap[h][i][j] = 0xff; continue; }
					if( (cx < 0) || (cx >= mazedata[cz][cy].len()) ){ dirmap[h][i][j] = 0xff; continue; }
					dirmap[h][i][j] = mazedata[cz][cy][cx];
				}
			}
		}

		drawTextExt16( BG_MAIN, 10 ,110, "Z:" + party.z + " X:" + party.x +"  Y:"+ party.y +"  dir:"+ party.dir +"     ", RGB(31,31,5), RGB(0,10,10) );
		for( i=0;i<3;i++){
			for( j=0;j<3;j++){
				local m;
				if( dirmap[1][i][j] > 128 ) m = "" else m= "E" ;
				if( (i == 0) && (j == 1) ) m = "";
				drawTextExt16( BG_MAIN, 50+j*12 ,170-(i*12), m, 0xFFFF, 0x8000 );
			}
		}

		// flg clear
		foreach( i in MazeLineData ) i.flg = false;

		//set mazeflg
		//0 left
		if( dirmap[1][0][0]>128 ){
			MazeLineData[4].flg = true; 
			MazeLineData[5].flg = true;
		}else{
			if( dirmap[1][1][0]>128 ){
				MazeLineData[8].flg = true; 
				MazeLineData[9].flg = true;
			}
		}
		//0 right
		if( dirmap[1][0][2]>128 ){
			MazeLineData[6].flg = true; 
			MazeLineData[7].flg = true;
		}else{
			if( dirmap[1][1][2]>128 ){
				MazeLineData[10].flg = true; 
				MazeLineData[11].flg = true;
			}
		}
		//1 front
		if( dirmap[1][1][1]>128 ){
			MazeLineData[0].flg = true; 
			MazeLineData[1].flg = true;
			MazeLineData[2].flg = true; 
			MazeLineData[3].flg = true;
		}else{
			//1 left
			if( dirmap[1][1][0]>128 ){
				MazeLineData[16].flg = true; 
				MazeLineData[17].flg = true;
			}else{
				if( dirmap[1][2][0]>128 ){
					MazeLineData[20].flg = true; 
					MazeLineData[21].flg = true;
				}
			}
			//1 right
			if( dirmap[1][1][2]>128 ){
				MazeLineData[18].flg = true; 
				MazeLineData[19].flg = true;
			}else{
				if( dirmap[1][2][2]>128 ){
					MazeLineData[22].flg = true; 
					MazeLineData[23].flg = true;
				}
			}
			//2 front
			if( dirmap[1][2][1]>128 ){
				MazeLineData[12].flg = true; 
				MazeLineData[13].flg = true;
				MazeLineData[14].flg = true; 
				MazeLineData[15].flg = true;
			}else{
				//2 left
				if( dirmap[1][2][0]>128 ){
					MazeLineData[24].flg = true; 
					MazeLineData[25].flg = true;
				}else{
					if( dirmap[1][1][0]<=128 ){
						MazeLineData[13].flg = true;
					}
				}
				//2 right
				if( dirmap[1][2][2]>128 ){
					MazeLineData[26].flg = true; 
					MazeLineData[27].flg = true;
				}else{
					if( dirmap[1][1][2]<=128 ){
						MazeLineData[15].flg = true;
					}
				}
			}
		}

		// maze clear
		foreach(i in MazeLineData ){
			line16(BG_MAIN, i.x, i.y, i.w, i.h, 0x8000 );
		};
		// maze draw
		box16( BG_MAIN, 0,0, 100,100, 0xFFFF );
		foreach(i in MazeLineData ){
			if( i.flg ) line16(BG_MAIN, i.x, i.y, i.w, i.h, 0xFFFF );
		};
		mazeUpdate = false;
	}

	function updateMaze(){
		mazeUpdate = true;
	}

	function getEvent()
	{
		LOG( "Z:" + party.z + " X:" + party.x +"  Y:"+ party.y + " EV:" + mazedata[party.z][party.y][party.x]);
		return mazedata[party.z][party.y][party.x];
	}
}
//map.init();
