require "DxLib"
require "tssLib"

local d = os.date("*t");
math.randomseed(d.sec);

-- dofile "JmpAct_map.lua"

SetGraphMode( 640 , 480 , 32 ) ;

ChangeWindowMode(1);

-- `ʂ𗠉ʂɃZbg
SetDrawScreen(0xfffffffe);

SetEmulation320x240( 1 ) ;

SetUseFPUPreserveFlag(1);

if( DxLib_Init() == -1 ) then os.exit() end; -- G[N璼ɏI
SetTransColor( 255, 0, 255 );

SetBackgroundColor( 0,250,250 );

charGraph = LoadDivGraph( "JmpAct_char.bmp", 128,16, 8,16,16 );
--ret,bgGraph   = LoadDivGraph( "bg.bmp"  ,128,16, 8,16,16 );

Player = {
	life  = 3,
	x     = 100,
	y     = 100,
	dx    = 0,
	dy    = 0,
	state = 0,
	count = 0,
	dir   = 0,
	pat   = 0,
	slipcount = 0,
	speed     = 0,
	
	STATE_STOP      = 0,
	STATE_WALK      = 1,
	STATE_RUN       = 2,
	STATE_SLIP      = 3,
	STATE_JUMP_UP   = 4,
	STATE_JUMP_DOWN = 5,
	STATE_OUT       = 6,
	STATE_FALLDOWN  = 7,
	
	DIR_RIGHT    = 1,
	DIR_LEFT     = 0,

	ACCEL        = 1,
	WALKMAXSPEED = 3,
	RUNMAXSPEED  = 6,
	JUMPPOWER    = 8,
	GRAVITY      = 2,



	walk = function(self, key)
		local k,max,pdx;
		-- max = (kh&KEYS.B)?player.RUNMAXSPEED:player.WALKMAXSPEED;	// Dash?
		if self.dir == self.DIR_RIGHT then
			k = key.RIGHT;
			pdx = 1;
		else
			k = key.LEFT;
			pdx = -1;
		end;
		if k then	--walking
			self.dx = self.dx + self.speed;
			if (self.dx * pdx) > self.WALKMAXSPEED then self.dx = self.WALKMAXSPEED * pdx; end;
		else 				--stop?
			if not( (self.state == self.STATE_JUMP_UP) or (self.state == self.STATE_JUMP_DOWN) ) then
				self.dx = self.dx - self.speed;
				if( (self.dx * pdx) < 0 ) then
					self.dx = 0;
					self.state = self.STATE_STOP;
				end
			end
		end;
	end,
	
	move = function(self)
        local key, KDown, KUp = GetJoypadInputStateEX( 0x1001 ) ;
		if self.state == self.STATE_STOP then 	-- stop
			
			if key.RIGHT then 
				self.state = self.STATE_WALK;
				self.dir   = self.DIR_RIGHT;
				self.slipcount = 0;
				self.count = 0;
				self.speed = self.ACCEL;
			elseif key.LEFT then
				self.state = self.STATE_WALK;
				self.dir   = self.DIR_LEFT;
				self.slipcount = 0;
				self.count = 0;
				self.speed = -self.ACCEL;
			end
			if key.A then
				self.state = self.STATE_JUMP_UP;
				self.count = 0;
				self.dy    = -self.JUMPPOWER;
			end
		elseif self.state == self.STATE_WALK then
			if self.dir == self.DIR_RIGHT then
				if key.LEFT then
					if self.dx > 0 then self.state = self.STATE_SLIP; end;
					self.dir = self.DIR_LEFT;
					self.speed = - self.ACCEL;
					self.slipcount = 0;
					self.count     = 0;
 				end;
			else
				if key.RIGHT then
					if self.dx < 0 then self.state = self.STATE_SLIP; end;
					self.dir = self.DIR_RIGHT;
					self.speed = self.ACCEL;
					self.slipcount = 0;
					self.count     = 0;
				end;
			end;
			if key.A then   --jump?
				self.state = self.JUMP_UP;
				self.count = 0;
				self.dy    = -self.JUMPPOWER;
			end;
			self.walk( self,key );
		end;
		if self.state == self.STATE_SLIP then --slip
			-- sound(slip);
			if self.dir == self.DIR_RIGHT then
				k = key.RIGHT;
				pdx = 1;
			else
				k = key.LEFT;
				pdx = -1;
			end;
			if (not k) or ( (self.dx*pdx) > 0 ) then  self.state = self.STATE_WALK end;
			self.walk(self,key);
		end;
		self.count = self.count + 1;
	end,
	
	disp = function(self)
		self.x = self.x + self.dx;
		self.y = self.y + self.dy;
		local pat=0;
		if self.state == self.STATE_STOP then
			pat = 0;
		elseif self.state == self.STATE_WALK then
			if self.count > 10 then pat = 0 else pat = 1 end;
			if self.count > 20 then self.count = 0 end;
		elseif self.state == self.STATE_SLIP then
			pat = 7;
		elseif self.state == self.STATE_JUMP_UP then
			pat = 5;
		elseif self.state == self.STATE_JUMP_DOWN then
			pat = 5;
		end;

		if self.dir == self.DIR_RIGHT then 
			DrawTurnGraph( self.x , self.y , charGraph[pat], 1 ) ;
		else
			DrawGraph( self.x , self.y , charGraph[pat],1 ) ;
		end;

	end;
}	


function disp()
	Player:disp();
--	enemey:disp();
--	bg:disp();
--	statsu:disp();
end;


x=0;
mx = 0;
while( ProcessMessage() == 0 ) do
    if CheckHitKey(1) == 1 then break end;
    -- ʂ
    ClearDrawScreen() ;

	Player:move();
--	enemy_move();
--	bg_scroll();
	disp();

    -- ʂ̓e\ʂɔf
    ScreenFlip() ;

end;

-- cwCugp̏I
DxLib_End();

