#include "stdafx.h"

#define NOTIMPL( A ) \
	static int Lua_##A(lua_State *L){			\
	printf("not implemented! [" #A "]\n");	\
		return 0;							\
	}

#define LUAFUNC_NONE( name ) 				\
static int Lua_##name(lua_State *L){		\
	lua_pushnumber( L, (int)##name() );		\
	return 1;								\
}

#define LUAFUNC_INT1( name ) 				\
static int Lua_##name(lua_State *L){		\
    int a = luaL_checkint(L, 1);			\
	lua_pushnumber( L, (int)##name(a) );	\
	return 1;								\
}

#define LUAFUNC_INT2( name ) 				\
static int Lua_##name(lua_State *L){		\
    int a = luaL_checkint(L, 1);			\
    int b = luaL_checkint(L, 2);			\
	lua_pushnumber( L, (int)##name(a,b) );	\
	return 1;								\
}

#define LUAFUNC_INT3( name ) 				\
static int Lua_##name(lua_State *L){		\
    int a = luaL_checkint(L, 1);			\
    int b = luaL_checkint(L, 2);			\
    int c = luaL_checkint(L, 3);			\
	lua_pushnumber( L, (int)##name(a,b,c) ); \
	return 1;								\
}

#define LUAFUNC_INT4( name ) 				\
static int Lua_##name(lua_State *L){		\
	int a = luaL_checkint(L, 1);			\
	int b = luaL_checkint(L, 2);			\
	int c = luaL_checkint(L, 3);			\
	int d = luaL_checkint(L, 4);			\
	lua_pushnumber( L, (int)##name(a,b,c,d) );	\
	return 1;								\
}

#define LUAFUNC_INT5( name ) 				\
static int Lua_##name(lua_State *L){		\
	int a = luaL_checkint(L, 1);			\
	int b = luaL_checkint(L, 2);			\
	int c = luaL_checkint(L, 3);			\
	int d = luaL_checkint(L, 4);			\
	int e = luaL_checkint(L, 5);			\
	lua_pushnumber( L, (int)##name(a,b,c,d,e) );	\
	return 1;								\
}

#define LUAFUNC_INT6( name ) 				\
static int Lua_##name(lua_State *L){		\
	int a = luaL_checkint(L, 1);			\
	int b = luaL_checkint(L, 2);			\
	int c = luaL_checkint(L, 3);			\
	int d = luaL_checkint(L, 4);			\
	int e = luaL_checkint(L, 5);			\
	int f = luaL_checkint(L, 6);			\
	lua_pushnumber( L, (int)##name(a,b,c,d,e,f) );	\
	return 1;								\
}

#define LUAFUNC_INT7( name ) 				\
static int Lua_##name(lua_State *L){		\
	int a = luaL_checkint(L, 1);			\
	int b = luaL_checkint(L, 2);			\
	int c = luaL_checkint(L, 3);			\
	int d = luaL_checkint(L, 4);			\
	int e = luaL_checkint(L, 5);			\
	int f = luaL_checkint(L, 6);			\
	int g = luaL_checkint(L, 7);			\
	lua_pushnumber( L, (int)##name(a,b,c,d,e,f,g) );	\
	return 1;								\
}

#define LUAFUNC_INT8( name ) 				\
static int Lua_##name(lua_State *L){		\
	int a = luaL_checkint(L, 1);			\
	int b = luaL_checkint(L, 2);			\
	int c = luaL_checkint(L, 3);			\
	int d = luaL_checkint(L, 4);			\
	int e = luaL_checkint(L, 5);			\
	int f = luaL_checkint(L, 6);			\
	int g = luaL_checkint(L, 7);			\
	int h = luaL_checkint(L, 8);			\
	lua_pushnumber( L, (int)##name(a,b,c,d,e,f,g,h) );	\
	return 1;								\
}

#define LUAFUNC_INT9( name ) 				\
static int Lua_##name(lua_State *L){		\
	int a = luaL_checkint(L, 1);			\
	int b = luaL_checkint(L, 2);			\
	int c = luaL_checkint(L, 3);			\
	int d = luaL_checkint(L, 4);			\
	int e = luaL_checkint(L, 5);			\
	int f = luaL_checkint(L, 6);			\
	int g = luaL_checkint(L, 7);			\
	int h = luaL_checkint(L, 8);			\
	int i = luaL_checkint(L, 9);			\
	lua_pushnumber( L, (int)##name(a,b,c,d,e,f,g,h,i) );	\
	return 1;								\
}

#define LUAFUNC_INT10( name ) 				\
static int Lua_##name(lua_State *L){		\
	int a = luaL_checkint(L, 1);			\
	int b = luaL_checkint(L, 2);			\
	int c = luaL_checkint(L, 3);			\
	int d = luaL_checkint(L, 4);			\
	int e = luaL_checkint(L, 5);			\
	int f = luaL_checkint(L, 6);			\
	int g = luaL_checkint(L, 7);			\
	int h = luaL_checkint(L, 8);			\
	int i = luaL_checkint(L, 9);			\
	int j = luaL_checkint(L,10);			\
	lua_pushnumber( L, (int)##name(a,b,c,d,e,f,g,h,i,j) );	\
	return 1;								\
}

#define LUAFUNC_STR1( name ) 					\
static int Lua_##name(lua_State *L){			\
	const char * fn   = luaL_checkstring(L, 1);	\
	lua_pushnumber( L, (int)##name(fn) );		\
	return 1;									\
}

#define LUAFUNC_OPT1( name ) 					\
static int Lua_##name(lua_State *L){			\
	int r  = (int)luaL_optnumber( L, 1, 1);		\
	lua_pushnumber( L, (int)##name(r) );		\
	return 1;									\
}

#define LUAFUNC_S1I1( name ) \
static int Lua_##name(lua_State *L){         \
	char * s =(char *)luaL_checkstring(L, 1);           \
	int h = (int)luaL_checknumber( L,2 );               \
	lua_pushnumber( L, (int)##name(s,h) );   			\
	return 1;                                           \
}

#define LUAFUNC_FLT1( name )                            \
static	int	Lua_##name( lua_State *L ){                 \
	float  a = (float)luaL_checknumber(L, 1);           \
	lua_pushnumber( L,(int)##name( a ) );               \
	return 1;                                           \
}

#define LUAFUNC_FLT2( name )                            \
static	int	Lua_##name( lua_State *L ){                 \
	float  a = (float)luaL_checknumber(L, 1);           \
	float  b = (float)luaL_checknumber(L, 2);           \
	lua_pushnumber( L,(int)##name( a, b ) );            \
	return 1;                                           \
}

#define LUAFUNC_NONE_FLT( name )                        \
static	int	Lua_##name( lua_State *L ){                 \
	lua_pushnumber( L,(float)##name() );                \
	return 1;                                           \
}

#define LUAFUNC_NONE_VCT( name )             \
static	int	Lua_##name( lua_State *L ){      \
	pushVECTOR( L,##name() );                \
	return 1;                                \
}

#define LUAFUNC_NONE_MTX( name )             \
static	int	Lua_##name( lua_State *L ){      \
	pushMATRIX( L,##name() );                \
	return 1;                                \
}

#define LUAFUNC_MTX_INT( name )              \
static	int	Lua_##name( lua_State *L ){      \
	MATRIX a = getMATRIX(L, 1);              \
	lua_pushnumber( L,(int)##name( a ) );    \
	return 1;                                \
}

#define LUAFUNC_VCT2_INT( name )              \
static	int	Lua_##name( lua_State *L ){       \
	VECTOR a = getVECTOR(L, 1);               \
	VECTOR b = getVECTOR(L, 1);               \
	lua_pushnumber( L,(int)##name( a, b ) );  \
	return 1;                                 \
}

#define LUAFUNC_VCT3_INT( name )              \
static	int	Lua_##name( lua_State *L ){       \
	VECTOR a = getVECTOR(L, 1);               \
	VECTOR b = getVECTOR(L, 1);               \
	VECTOR c = getVECTOR(L, 1);               \
	lua_pushnumber( L,(int)##name( a, b, c ) );  \
	return 1;                                 \
}

extern "C" {

// X^bNgbvVECTORzς
static void pushVECTOR(lua_State *L, VECTOR vec ){
	lua_createtable(L, 0, 3 );
	int num = lua_gettop(L);
	lua_pushstring(L,"x"); lua_pushnumber(L,vec.x); lua_settable(L,num);
	lua_pushstring(L,"y"); lua_pushnumber(L,vec.y); lua_settable(L,num);
	lua_pushstring(L,"z"); lua_pushnumber(L,vec.z); lua_settable(L,num);
}

// X^bNVECTOR𓾂
static VECTOR getVECTOR(lua_State *L, int num ){
	float x,y,z;
	lua_pushstring(L,"x");lua_gettable(L,num);x = (float)luaL_checknumber(L,lua_gettop(L));
	lua_pushstring(L,"y");lua_gettable(L,num);y = (float)luaL_checknumber(L,lua_gettop(L));
	lua_pushstring(L,"z");lua_gettable(L,num);z = (float)luaL_checknumber(L,lua_gettop(L));
	lua_pop(L,3);
	return VGet(x,y,z);
}

// X^bNgbvMATRIXς
static void pushMATRIX(lua_State *L, MATRIX mat ){
	lua_createtable(L, 0, 1);  //{
	int z = lua_gettop(L);     // {̂̈ʒu
	lua_pushstring(L,"m");     // m(2z)
	lua_createtable(L, 4, 0);  // me[u
	int m = lua_gettop(L);     // m̈ʒu
	int i,j;
	for(i=0;i<4;i++){
		lua_pushinteger(L,i);
		lua_createtable(L, 4, 0);
		int num = lua_gettop(L);
		for(j=0;j<4;j++){
			lua_pushinteger(L,j); lua_pushnumber(L,mat.m[i][j]); lua_settable(L,num);
		}
		lua_settable(L,m);     // mɒǉ
	}
	lua_settable(L,z);     // m{̂ɒǉ
}
// X^bNMATRIX𓾂
static MATRIX getMATRIX(lua_State *L, int num ){
	MATRIX mat;
	float x;
	int i,j;
	lua_pushstring(L,"m");
	lua_gettable(L,num);
	for(i=0;i<4;i++){
		lua_pushinteger(L,i);
		lua_gettable(L,num);
		int m = lua_gettop(L);
		for(j=0;j<4;j++){
			lua_pushinteger(L,j);
			lua_gettable(L,m);
			x = (float)luaL_checknumber(L,lua_gettop(L));
			mat.m[i][j] = x;
		}
		lua_pop(L,5);
	}
	lua_pop(L, 1);
	return mat;
}




//

LUAFUNC_NONE( DxLib_Init )				//DxLib_Init	@Cȕ
LUAFUNC_NONE( DxLib_End )				//DxLib_End	@Cugp̏I֐
LUAFUNC_NONE( ProcessMessage )			//ProcessMessage	@EChEỸbZ[W
LUAFUNC_INT1( SetUseFPUPreserveFlag )	// FPU̐x𗎂ƂȂݒgp邩ǂݒ肷ADxLib_Init ĂяoÔݗL( TRUE:gp(xȂ)  FALSE:gpȂ(x𗎂Ƃ(ftHg) )

//}``֐
LUAFUNC_INT6( DrawLine     )			//@`
LUAFUNC_INT6( DrawBox      )			//@lp`
LUAFUNC_INT5( DrawCircle   )			//@~̕`
LUAFUNC_INT6( DrawOval     )			//@ȉ~̕`
LUAFUNC_INT8( DrawTriangle )			//@Op`̕`
LUAFUNC_INT3( DrawPixel    )			//@_`悷
LUAFUNC_INT2( GetPixel     )			//@w_̐F擾

//OtBbNf[^֐
//LoadGraphScreen	@摜t@Cǂ݂ŉʂɕ\
static int Lua_LoadGraphScreen(lua_State *L){
	int x = (int)luaL_checknumber(L, 1);
	int y = (int)luaL_checknumber(L, 2);
	const char * fn = luaL_checkstring(L, 3);
	int f = (int)luaL_checknumber(L, 4);
	lua_pushnumber( L, (int)LoadGraphScreen( x, y,  fn, f ) );
	return 1;
}
//LoadGraph	@摜t@C̃ւ̓ǂ݂݁Ayѓt@C̃[h
static int Lua_LoadGraph(lua_State *L){
	const char * fn = luaL_checkstring(L, 1);
	int f = (int)luaL_optnumber(L, 2, 0);
	lua_pushnumber(L, (int)LoadGraph( fn, f ) );
	return 1;
}

//LoadDivGraph    @摜t@C̃ւ̕ǂ݂
static int Lua_LoadDivGraph(lua_State *L){
    int i;
    const char * fn = luaL_checkstring(L, 1);
    int a  = (int)luaL_checknumber(L, 2);
    int b  = (int)luaL_checknumber(L, 3);
    int c  = (int)luaL_checknumber(L, 4);
    int d  = (int)luaL_checknumber(L, 5);
    int e  = (int)luaL_checknumber(L, 6);
    int f  = (int)luaL_optnumber  (L, 7, 0);
    int *buf = (int*)malloc( sizeof(int) * a );
	int ret = LoadDivGraph( fn, a, b, c,d, e, buf, f );
	if ( ret < 0 ){
		lua_pushnil(L);	// G[
	}else{
		lua_createtable(L, a, 0);           // e[u쐬
		int t = lua_gettop(L);
		for( i=0;i<a;i++ ){
			lua_pushnumber( L, i);			// zԍ(0`)
			lua_pushnumber( L, buf[i] );	// OtBbNnh
			lua_settable (L,t);				// e[uɏ
		}
	}
	free(buf);
    return 1;
}

//MakeGraph	@̃OtBbN쐬
static int Lua_MakeGraph(lua_State *L){
	int x = (int)luaL_checknumber(L, 1);
	int y = (int)luaL_checknumber(L, 2);
	int f = (int)luaL_optnumber(L, 3, 0);
	lua_pushnumber( L, (int)MakeGraph( x, y, f ) );
	return 1;
}

//DrawGraph	@ɓǂ݂񂾃OtBbN̕`
static int Lua_DrawGraph(lua_State *L){
	int x = (int)luaL_checknumber(L, 1);
	int y = (int)luaL_checknumber(L, 2);
	int h = (int)luaL_checknumber(L, 3);
	int f = (int)luaL_optnumber(L, 4, 0);
	lua_pushnumber( L, (int)DrawGraph( x, y, h, f ) );
	return 1;
}
//@ɓǂ݂񂾃OtBbN̂kq]`
static int Lua_DrawTurnGraph(lua_State *L){
	int x = (int)luaL_checknumber(L, 1);
	int y = (int)luaL_checknumber(L, 2);
	int h = (int)luaL_checknumber(L, 3);
	int f = (int)luaL_optnumber(L, 4, 0);
	lua_pushnumber( L, (int)DrawTurnGraph(x,y,h,f) );
	return 1;
}

//@ɓǂ݂񂾃OtBbN̊gk`
static int Lua_DrawExtendGraph(lua_State *L){
	int x1 = (int)luaL_checknumber(L, 1);
	int y1 = (int)luaL_checknumber(L, 2);
	int x2 = (int)luaL_checknumber(L, 3);
	int y2 = (int)luaL_checknumber(L, 4);
	int h  = (int)luaL_checknumber(L, 5);
	int f  = (int)luaL_optnumber(L, 6, 0);
	lua_pushnumber( L, (int)DrawExtendGraph(x1,y1,x2,y2,h,f ) );
	return 1;
}

//@ɓǂ݂񂾃OtBbN̉]`
static int Lua_DrawRotaGraph(lua_State *L){
	int x = (int)luaL_checknumber(L, 1);
	int y = (int)luaL_checknumber(L, 2);
	double r = luaL_checknumber(L, 3);
	double a = luaL_checknumber(L, 4);
	int h  = (int)luaL_checknumber(L, 5);
	int f  = (int)luaL_checknumber(L, 6);
	int t  = (int)luaL_optnumber(L, 7, 0);
	lua_pushnumber( L, (int)DrawRotaGraph(x,y,r,a,h,f,t) );
	return 1;
}

//@ɓǂ݂񂾃OtBbN̉]`(]Sw肠)
static int Lua_DrawRotaGraph2(lua_State *L){
	int x  = (int)luaL_checknumber(L, 1);
	int y  = (int)luaL_checknumber(L, 2);
	int cx = (int)luaL_checknumber(L, 3);
	int cy = (int)luaL_checknumber(L, 4);
	double r = luaL_checknumber(L, 5);
	double a = luaL_checknumber(L, 6);
	int h  = (int)luaL_checknumber(L, 7);
	int f  = (int)luaL_checknumber(L, 8);
	int t  = (int)luaL_optnumber(L, 9, 0);
	lua_pushnumber( L, (int)DrawRotaGraph2(x,y,cx,cy,r,a,h,f,t) );
	return 1;
}

//@ɓǂ݂񂾃OtBbN̎Rό``
static int Lua_DrawModiGraph(lua_State *L){
	int x1  = (int)luaL_checknumber(L, 1);
	int y1  = (int)luaL_checknumber(L, 2);
	int x2  = (int)luaL_checknumber(L, 3);
	int y2  = (int)luaL_checknumber(L, 4);
	int x3  = (int)luaL_checknumber(L, 5);
	int y3  = (int)luaL_checknumber(L, 6);
	int x4  = (int)luaL_checknumber(L, 7);
	int y4  = (int)luaL_checknumber(L, 8);
	int h   = (int)luaL_checknumber(L, 9);
	int f   = (int)luaL_optnumber(L, 10, 0);
	lua_pushnumber( L, (int)DrawModiGraph(x1,y1,x2,y2,x3,y3,x4,y4,h,f) );
	return 1;
}

//@OtBbN̎w`݂̂`
static int Lua_DrawRectGraph(lua_State *L){
	int dx  = (int)luaL_checknumber(L, 1);
	int dy  = (int)luaL_checknumber(L, 2);
	int sx  = (int)luaL_checknumber(L, 3);
	int sy  = (int)luaL_checknumber(L, 4);
	int w   = (int)luaL_checknumber(L, 5);
	int h   = (int)luaL_checknumber(L, 6);
	int g   = (int)luaL_checknumber(L, 7);
	int f   = (int)luaL_checknumber(L, 8);
	int t   = (int)luaL_optnumber(L, 9, 0);
	lua_pushnumber( L, (int)DrawRectGraph(dx,dy,sx,sy,w,h,g,f,t) );
	return 1;
}

LUAFUNC_INT5( DerivationGraph )			//@w̃OtBbN̎w蕔𔲂oĐVȃOtBbN쐬

//@`ɐݒ肳ĂOtBbN̈悩ẅ̃OtBbNǂ݂
static int Lua_GetDrawScreenGraph(lua_State *L){
	int x1  = (int)luaL_checknumber(L, 1);
	int y1  = (int)luaL_checknumber(L, 2);
	int x2  = (int)luaL_checknumber(L, 3);
	int y2  = (int)luaL_checknumber(L, 4);
	int h   = (int)luaL_checknumber(L, 5);
	int f   = (int)luaL_optnumber(L, 9, 1);
	lua_pushnumber( L, (int)GetDrawScreenGraph(x1,y1,x2,y2,h,f) );
	return 1;
}

//@OtBbÑTCY𓾂
static int Lua_GetGraphSize(lua_State *L){
	int x,y;
	int h   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)GetGraphSize(h,&x,&y) );
	lua_pushnumber( L, x );
	lua_pushnumber( L, y );
	return 3;
}

LUAFUNC_INT1( InitGraph )				//@ǂ݂񂾃OtBbNf[^ׂč폜

//@w̃OtBbNォ폜
static int Lua_DeleteGraph(lua_State *L){
	int h   = (int)luaL_checknumber(L, 1);
	int f   = (int)luaL_optnumber(L, 2, 0);
	lua_pushnumber( L, (int)DeleteGraph(h,f) );
	return 1;
}

LUAFUNC_INT1( SetDrawMode )				//@`惂[hZbg
LUAFUNC_INT2( SetDrawBlendMode )		//@`̍ۂ̃uh[hZbg
LUAFUNC_INT3( SetDrawBright )			//@`PxZbg
LUAFUNC_INT3( SetTransColor )			//@OtBbNɐݒ肷铧ߐFZbg
LUAFUNC_STR1( LoadBlendGraph )			//@摜t@Cuh摜ǂݍ
LUAFUNC_INT7( DrawBlendGraph )			//@uh摜ƒʏ摜ĕ`悷

//`֌W֐

//@`悷
static int Lua_DrawString(lua_State *L){
	int x   = (int)luaL_checknumber(L, 1);
	int y   = (int)luaL_checknumber(L, 2);
	const char * s   = luaL_checkstring(L, 3);
	int c   = (int)luaL_checknumber(L, 4);
	int e   = (int)luaL_optnumber(L, 5, 0);
	lua_pushnumber( L, (int)DrawString(x,y,s,c,e) );
	return 1;
}

//@DrawString ŕ`悳镶̕(hbgP)𓾂
static int Lua_GetDrawStringWidth(lua_State *L){
	const char * s = luaL_checkstring(L, 1);
	int l   = (int)luaL_checknumber(L, 2);
	int f   = (int)luaL_optnumber(L, 3, 0);
	lua_pushnumber( L, (int)GetDrawStringWidth( s,l,f ) );
	return 1;
}

NOTIMPL( GetDrawFormatStringWidth )				//@DrawFormatString ֐t̕`敝(hbgP)𓾂
LUAFUNC_INT1( SetFontSize )						//@`悷镶̃TCYZbg
LUAFUNC_INT1( SetFontThickness )				//@`悷镶̑̕Zbg

//@`悷tHgύX
static int Lua_ChangeFont(lua_State *L){
	const char * fn = luaL_checkstring(L, 1);
	int c   = (int)luaL_optnumber(L, 2, -1);
	lua_pushnumber( L, 	(int)ChangeFont( fn, c ) );
	return 1;
}

LUAFUNC_INT1( ChangeFontType )					//@`ɎgptHg̃^CvύX

//@VtHgf[^쐬
static int Lua_CreateFontToHandle(lua_State *L){
	const char * fn = luaL_checkstring(L, 1);
	int s   = (int)luaL_checknumber(L, 2);
	int t   = (int)luaL_checknumber(L, 3);
	int ft  = (int)luaL_optnumber(L, 4, -1);
	int cs  = (int)luaL_optnumber(L, 5, -1);
	int es  = (int)luaL_optnumber(L, 6, -1);
	int i   = (int)luaL_optnumber(L, 7,  0);
	int di  = (int)luaL_optnumber(L, 8, -1);
	lua_pushnumber( L, (int)CreateFontToHandle(fn,s,t,ft,cs,es,i,di) );
	return 1;
}
LUAFUNC_INT1( DeleteFontToHandle )				//@tHgf[^폜

//@w̃tHgf[^ŕ`悷
static int Lua_DrawStringToHandle(lua_State *L){
	int x   = (int)luaL_checknumber(L, 1);
	int y   = (int)luaL_checknumber(L, 2);
	const char * s = luaL_checkstring(L, 3);
	int c   = (int)luaL_checknumber(L, 4);
	int h   = (int)luaL_checknumber(L, 5);
	int ec  = (int)luaL_optnumber(L, 6, 0);
	int f   = (int)luaL_optnumber(L, 7, 0);
	lua_pushnumber( L, (int)DrawStringToHandle(x,y,s,c,h,ec,f) );
	return 1;
}

//@w̃tHgf[^ŏt`悷
NOTIMPL( DrawFormatStringToHandle );

//@w̃tHgf[^ŕ`悷镶̕𓾂
static int Lua_GetDrawStringWidthToHandle(lua_State *L){
	const char * s = luaL_checkstring(L, 1);
	int l  = (int)luaL_checknumber(L, 2);
	int h  = (int)luaL_checknumber(L, 3);
	int f  = (int)luaL_optnumber(L, 4, 0);
	lua_pushnumber( L, (int)GetDrawStringWidthToHandle(s,l,h,f) );
	return 1;
}

//@w̃tHgf[^ŏt̕`敝𓾂
NOTIMPL( GetDrawFormatStringWidthToHandle )

//@w̃tHgf[^̏𓾂
static int Lua_GetFontStateToHandle(lua_State *L){
	char * fn =(char *)luaL_checkstring(L, 1);
	int h  = (int)luaL_optnumber(L, 2, 0);
	int s,t;
	lua_pushnumber( L, (int)GetFontStateToHandle(fn,&s,&t,h) );
	lua_pushnumber( L, s );
	lua_pushnumber( L, t );
	return 3;
}

LUAFUNC_NONE( InitFontToHandle )				//@tHgf[^Sď
LUAFUNC_STR1( printfDx         )				//ȈՉʏo͊֐
LUAFUNC_NONE( clsDx            )				//@ȈՉʏo͗NA

//̑ʑn֐

//@ʃ[h̕ύX
static int Lua_SetGraphMode(lua_State *L){
	int x = (int)luaL_checknumber(L, 1);
	int y = (int)luaL_checknumber(L, 2);
	int c = (int)luaL_checknumber(L, 3);
	int r = (int)luaL_optnumber(L, 4, 60);
	lua_pushnumber( L, (int)SetGraphMode( x, y, c, r ) );
	return 1;
}

//@݂̉ʂ̑傫ƃJ[rbg𓾂
static int Lua_GetScreenState(lua_State *L){
	int x,y,d;
	lua_pushnumber( L, (int)GetScreenState(&x,&y,&d) );
	lua_pushnumber( L, x );
	lua_pushnumber( L, y );
	lua_pushnumber( L, d );
	return 4;
}

LUAFUNC_INT4( SetDrawArea )				//@`\̈̃Zbg
LUAFUNC_NONE( ClearDrawScreen )			//@ʂɕ`ꂽ̂
LUAFUNC_INT3( GetColor )				//@FR[h擾
LUAFUNC_INT1( SetDrawScreen )			//@`OtBbN̈̎w
LUAFUNC_NONE( ScreenFlip )				//@tbv֐Aʂ̗y[W(i͕\ĂȂ)̓e\y[W(i\Ă)ɔf
LUAFUNC_INT3( SetBackgroundColor )		// obNOEhJ[ݒ

//֌W֐

//@t@C̍Đ
static int Lua_PlayMovie(lua_State *L){
	const char * fn = luaL_checkstring(L, 1);
	int r  = (int)luaL_checknumber(L, 2);
	int t  = (int)luaL_checknumber(L, 3);
	lua_pushnumber( L, (int)PlayMovie(fn,r,t) );
	return 1;
}

//@[r[OtBbN̓̍ĐJn
static int Lua_PlayMovieToGraph(lua_State *L){
	int h  = (int)luaL_checknumber(L, 1);
	int pt = (int)luaL_optnumber(L, 2, 1);
	int sp = (int)luaL_optnumber(L, 3, 0);
	lua_pushnumber( L, (int)PlayMovieToGraph(h,pt,sp) );
	return 1;
}

//@[r[OtBbN̓Đꎞ~
static int Lua_PauseMovieToGraph(lua_State *L){
	int g = (int)luaL_checknumber(L, 1);
	int p = (int)luaL_optnumber(L, 2, 0);
	lua_pushnumber( L, (int)PauseMovieToGraph(g,p) );
	return 1;
}

LUAFUNC_INT2( SeekMovieToGraph )			//@[r[OtBbN̓̍ĐʒuύX
LUAFUNC_INT1( TellMovieToGraph )			//@[r[OtBbN̓̍Đʒu𓾂
LUAFUNC_INT1( GetMovieStateToGraph )		//@[r[OtBbN̓̍ĐԂ𓾂
//}XN֌W֐

LUAFUNC_NONE( CreateMaskScreen )			//@}XNʂ쐬
LUAFUNC_NONE( DeleteMaskScreen )			//@}XNʂ폜
LUAFUNC_STR1( LoadMask         )			//@}XNf[^摜t@C(BMP.JPEG.PNG)\z

//@}XNf[^摜t@C(BMP.JPEG.PNG)番\z
static int Lua_LoadDivMask(lua_State *L){
	const char * fn = luaL_checkstring(L, 1);
	int an  = (int)luaL_checknumber(L, 2);
	int xn  = (int)luaL_checknumber(L, 3);
	int yn  = (int)luaL_checknumber(L, 4);
	int xs  = (int)luaL_checknumber(L, 5);
	int ys  = (int)luaL_checknumber(L, 6);
	int *buf = (int*)malloc( sizeof(int) * an );
	int i;
	lua_pushnumber( L, (int)LoadDivMask(fn,an,xn,yn,xs,ys,buf) );

	// zԂ
    lua_createtable(L, an, 0);
    for( i=0;i<an;i++ ){
        lua_pushinteger(L, i); lua_pushinteger( L, buf[i] ); lua_settable (L,8);
    }
	free(buf);
	return 2;
}

LUAFUNC_INT4( DrawMask )				//@}XNf[^}XNʂɕ`悷
LUAFUNC_INT5( DrawFillMask )			//@w̃}XNʗ̈w̃}XNf[^^CɕׂĖ߂
LUAFUNC_INT1( DeleteMask )				//@}XNf[^폜
LUAFUNC_NONE( InitMask )				//@}XNf[^
LUAFUNC_INT1( FillMaskScreen )			//@}XNʂw̐FœhԂ
LUAFUNC_INT1( SetUseMaskScreenFlag )	//@}XNʂ̗L̗LύX
LUAFUNC_INT2( MakeMask )				//@̃}XNf[^̍쐬

//@}XNf[^̑傫𓾂
static int Lua_GetMaskSize(lua_State *L){
	int mh   = (int)luaL_checknumber(L, 1);
	int w,h;
	lua_pushnumber( L, (int)GetMaskSize(&w,&h,mh) );
	lua_pushnumber( L, w );
	lua_pushnumber( L, h );
	return 3;
}

//@}XÑf[^}XNf[^̈ɓ]
static int Lua_SetDataToMask(lua_State *L){
	int w   = (int)luaL_checknumber(L, 1);
	int h   = (int)luaL_checknumber(L, 2);
	int mh  = (int)luaL_checknumber(L, 4);
	int * md = (int*)malloc(sizeof(int)*w*h);
	int i;
	for(i=0;i<w*h;i++){
		lua_gettable (L, 3);
		md[i] = lua_tointeger (L, 5);
		lua_pop(L,1);
	}
	lua_pushnumber( L, (int)SetDataToMask(w,h,md,mh) );
	free(md);
	return 1;
}

//@}XÑf[^}XNʂɒڕ`悷
static int Lua_DrawMaskToDirectData(lua_State *L){
	int x   = (int)luaL_checknumber(L, 1);
	int y   = (int)luaL_checknumber(L, 2);
	int w   = (int)luaL_checknumber(L, 3);
	int h   = (int)luaL_checknumber(L, 4);
	int * md = (int*)malloc(sizeof(int)*w*h);
	int i;
	for(i=0;i<w*h;i++){
		lua_gettable (L, 5);
		md[i] = lua_tointeger (L, 7);
		lua_pop(L,1);
	}
	int m   = (int)luaL_checknumber(L, 6);
	lua_pushnumber( L, (int)DrawMaskToDirectData(x,y,w,h,md,m) );
	free(md);
	return 1;
}

//@}XÑf[^^Cɕׂ`Œڃ}XNʑŜɕ`悷
static int Lua_DrawFillMaskToDirectData(lua_State *L){
	int x1   = (int)luaL_checknumber(L, 1);
	int y1   = (int)luaL_checknumber(L, 2);
	int x2   = (int)luaL_checknumber(L, 3);
	int y2   = (int)luaL_checknumber(L, 4);
	int w    = (int)luaL_checknumber(L, 5);
	int h    = (int)luaL_checknumber(L, 6);
	int * md = (int*)malloc(sizeof(int)*w*h);
	int i;
	for(i=0;i<w*h;i++){
		lua_gettable (L, 7);
		md[i] = (int)lua_tonumber (L, 9);
		lua_pop(L,1);
	}
	int m   = (int)luaL_checknumber(L, 8);
	lua_pushnumber( L, (int)DrawFillMaskToDirectData(x1,y1,x2,y2,w,h,md) );
	free(md);
	return 1;
}

LUAFUNC_INT1( SetMaskTransColor )			//@}XNɎgߐF̃Zbg


//͊֌W̊֐
//@@WCpbh͊֘A֐
//@WCpbhڑĂ鐔擾
static int Lua_GetJoypadNum(lua_State *L){
	lua_pushnumber( L, (int)GetJoypadNum() );
	return 1;
}

static void pushkeydata(lua_State *L, int k ){
	lua_createtable(L, 0, 32);
	int tbl = lua_gettop(L);
	lua_pushstring(L, "DOWN"  ); lua_pushboolean( L, k&PAD_INPUT_DOWN	 ); lua_settable (L,tbl);
	lua_pushstring(L, "LEFT"  ); lua_pushboolean( L, k&PAD_INPUT_LEFT	 ); lua_settable (L,tbl);
	lua_pushstring(L, "RIGHT" ); lua_pushboolean( L, k&PAD_INPUT_RIGHT	 ); lua_settable (L,tbl);
	lua_pushstring(L, "UP"    ); lua_pushboolean( L, k&PAD_INPUT_UP		 ); lua_settable (L,tbl);
	lua_pushstring(L, "A"     ); lua_pushboolean( L, k&PAD_INPUT_A		 ); lua_settable (L,tbl);
	lua_pushstring(L, "B"     ); lua_pushboolean( L, k&PAD_INPUT_B		 ); lua_settable (L,tbl);
	lua_pushstring(L, "C"     ); lua_pushboolean( L, k&PAD_INPUT_C		 ); lua_settable (L,tbl);
	lua_pushstring(L, "X"     ); lua_pushboolean( L, k&PAD_INPUT_X		 ); lua_settable (L,tbl);
	lua_pushstring(L, "Y"     ); lua_pushboolean( L, k&PAD_INPUT_Y		 ); lua_settable (L,tbl);
	lua_pushstring(L, "Z"     ); lua_pushboolean( L, k&PAD_INPUT_Z		 ); lua_settable (L,tbl);
	lua_pushstring(L, "L"     ); lua_pushboolean( L, k&PAD_INPUT_L		 ); lua_settable (L,tbl);
	lua_pushstring(L, "R"     ); lua_pushboolean( L, k&PAD_INPUT_R		 ); lua_settable (L,tbl);
	lua_pushstring(L, "START" ); lua_pushboolean( L, k&PAD_INPUT_START	 ); lua_settable (L,tbl);
	lua_pushstring(L, "M"     ); lua_pushboolean( L, k&PAD_INPUT_M		 ); lua_settable (L,tbl);
	lua_pushstring(L, "D"     ); lua_pushboolean( L, k&PAD_INPUT_D		 ); lua_settable (L,tbl);
	lua_pushstring(L, "F"     ); lua_pushboolean( L, k&PAD_INPUT_F		 ); lua_settable (L,tbl);
	lua_pushstring(L, "G"     ); lua_pushboolean( L, k&PAD_INPUT_G		 ); lua_settable (L,tbl);
	lua_pushstring(L, "H"     ); lua_pushboolean( L, k&PAD_INPUT_H		 ); lua_settable (L,tbl);
	lua_pushstring(L, "I"     ); lua_pushboolean( L, k&PAD_INPUT_I		 ); lua_settable (L,tbl);
	lua_pushstring(L, "J"     ); lua_pushboolean( L, k&PAD_INPUT_J		 ); lua_settable (L,tbl);
	lua_pushstring(L, "K"     ); lua_pushboolean( L, k&PAD_INPUT_K		 ); lua_settable (L,tbl);
	lua_pushstring(L, "LL"    ); lua_pushboolean( L, k&PAD_INPUT_LL		 ); lua_settable (L,tbl);
	lua_pushstring(L, "N"     ); lua_pushboolean( L, k&PAD_INPUT_N		 ); lua_settable (L,tbl);
	lua_pushstring(L, "O"     ); lua_pushboolean( L, k&PAD_INPUT_O		 ); lua_settable (L,tbl);
	lua_pushstring(L, "P"     ); lua_pushboolean( L, k&PAD_INPUT_P		 ); lua_settable (L,tbl);
	lua_pushstring(L, "RR"    ); lua_pushboolean( L, k&PAD_INPUT_RR		 ); lua_settable (L,tbl);
	lua_pushstring(L, "S"     ); lua_pushboolean( L, k&PAD_INPUT_S		 ); lua_settable (L,tbl);
	lua_pushstring(L, "T"     ); lua_pushboolean( L, k&PAD_INPUT_T		 ); lua_settable (L,tbl);
	lua_pushstring(L, "U"     ); lua_pushboolean( L, k&PAD_INPUT_U		 ); lua_settable (L,tbl);
	lua_pushstring(L, "V"     ); lua_pushboolean( L, k&PAD_INPUT_V		 ); lua_settable (L,tbl);
	lua_pushstring(L, "W"     ); lua_pushboolean( L, k&PAD_INPUT_W		 ); lua_settable (L,tbl);
	lua_pushstring(L, "XX"    ); lua_pushboolean( L, k&PAD_INPUT_XX		 ); lua_settable (L,tbl);
}

//@WCpbh̓͏Ԃ𓾂
static int Lua_GetJoypadInputState(lua_State *L){
	int n = (int)luaL_checknumber( L, 1 );
	int k = GetJoypadInputState(n);
	pushkeydata( L, k );
	return 1;
}

//@WCpbh̓͏Ԃ𓾂 A
static int Lua_GetJoypadInputStateEX(lua_State *L){
	static int oldk[17] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
	int n = (int)luaL_checknumber( L, 1 );
	int i = n&(~DX_INPUT_KEY);   // L[{[htΏ
	int k = GetJoypadInputState(n);
	int d = (~oldk[i]) & k;
	int u = oldk[i] & (~k);
	pushkeydata( L, k );
	pushkeydata( L, d );
	pushkeydata( L, u );
	oldk[i] = k;
	return 3;
}

//@WCpbh̃AiOIȃo[͏𓾂
static int Lua_GetJoypadAnalogInput(lua_State *L){
	int t = (int)luaL_checknumber( L, 1 );
	int x,y;
	lua_pushnumber( L, (int)GetJoypadAnalogInput(&x,&y,t) );
	lua_pushnumber( L, x );
	lua_pushnumber( L, y );
	return 3;
}

//@WCpbh̃AiOIȃo[͏𓾂(orpbhEXeBbNp)
static int Lua_GetJoypadAnalogInputRight(lua_State *L){
	int t = (int)luaL_checknumber( L, 1 );
	int x,y;
	lua_pushnumber( L, (int)GetJoypadAnalogInputRight(&x,&y,t) );
	lua_pushnumber( L, x );
	lua_pushnumber( L, y );
	return 3;
}

//@WCpbh̓͂ɑΉL[{[h̓͂ݒ肷
static int Lua_SetJoypadInputToKeyInput(lua_State *L){
	int t  = (int)luaL_checknumber( L, 1 );
	int p  = (int)luaL_checknumber( L, 2 );
	int k1 = (int)luaL_checknumber( L, 3 );
	int k2 = (int)luaL_optnumber( L, 4, -1 );
	int k3 = (int)luaL_optnumber( L, 5, -1 );
	int k4 = (int)luaL_optnumber( L, 6, -1 );
	lua_pushnumber( L, (int)SetJoypadInputToKeyInput(t,p,k1,k2,k3,k4) );
	return 1;
}

LUAFUNC_INT3( StartJoypadVibration )			//@WCpbh̐UJn
LUAFUNC_INT1( StopJoypadVibration  )			//@WCpbh̐U~

//@@}EX͊֘A֐
LUAFUNC_INT1( SetMouseDispFlag )				//@}EXJ[\̕\ݒtÕZbg

//@}EXJ[\̈ʒu擾
static int Lua_GetMousePoint(lua_State *L){
	int x,y ;
	lua_pushnumber( L, (int)GetMousePoint(&x,&y) );
	lua_pushnumber( L, x );
	lua_pushnumber( L, y );
	return 3;
}
LUAFUNC_INT2( SetMousePoint )					//@}EXJ[\̈ʒuZbg

//@}EXJ[\̃{^̏Ԃ𓾂
static int Lua_GetMouseInput(lua_State *L){
	int b = GetMouseInput();
	lua_pushboolean( L, b&1 );
	lua_pushboolean( L, b&2 );
	lua_pushboolean( L, b&4 );
	return 3;
}
LUAFUNC_OPT1( GetMouseWheelRotVol )				//@}EXzC[̉]ʂ𓾂

//@@L[{[h͊֘A֐
//@ׂẴL[̉Ԃ擾
static int Lua_CheckHitKeyAll(lua_State *L){
	int t  = (int)luaL_optnumber( L, 1, 7 );
	lua_pushnumber( L, (int)CheckHitKeyAll(t) );
	return 1;
}
LUAFUNC_INT1( CheckHitKey )						//@L[̓͏Ԃ𓾂

//@L[{[ĥׂẴL[̉Ԃ擾
static int Lua_GetHitKeyStateAll(lua_State *L){
	char buf[256];
	int i,top;
	lua_pushnumber( L, (int)GetHitKeyStateAll(buf) );
	lua_createtable(L, 256, 0);
	top = lua_gettop(L);
	for(i=0;i<256;i++){
		lua_pushinteger(L, i); lua_pushinteger( L, buf[i] ); lua_settable(L,top);
	}
	return 1;
}

//@@p͊֘A֐
LUAFUNC_INT1( GetInputChar )					//@̓obt@ɗ܂f[^P擾
LUAFUNC_INT1( GetInputCharWait )				//@̓obt@ɗ܂f[^P擾Aobt@ɂȂɂR[hȂꍇ̓L[܂ő҂
LUAFUNC_NONE( ClearInputCharBuf )				//@̓obt@NA

//@@{͊֘A֐
//@L[{[hɂ镶̓
static int Lua_KeyInputString(lua_State *L){
	int x = (int)luaL_checknumber( L, 1 );
	int y = (int)luaL_checknumber( L, 2 );
	int l = (int)luaL_checknumber( L, 3 );
	int f = (int)luaL_checknumber( L, 4 );
	char * buf = (char*)malloc(l+1);
	lua_pushnumber( L, (int)KeyInputString(x,y,l,buf,f) );
	lua_pushstring( L, buf );
	free(buf);
	return 1;
}

//@L[{[hɂ锼p݂̂̓
static int Lua_KeyInputSingleCharString(lua_State *L){
	int x = (int)luaL_checknumber( L, 1 );
	int y = (int)luaL_checknumber( L, 2 );
	int l = (int)luaL_checknumber( L, 3 );
	int f = (int)luaL_checknumber( L, 4 );
	char * buf = (char*)malloc(l+1);
	lua_pushnumber( L, (int)KeyInputSingleCharString(x,y,l,buf,f) );
	lua_pushstring( L, buf );
	free(buf);
	return 1;
}

//@L[{[hɂ鐔l̓
static int Lua_KeyInputNumber(lua_State *L){
	int x = (int)luaL_checknumber( L, 1 );
	int y = (int)luaL_checknumber( L, 2 );
	int maxnum = (int)luaL_checknumber( L, 3 );
	int minnum = (int)luaL_checknumber( L, 4 );
	int f = (int)luaL_checknumber( L, 5 );
	lua_pushnumber( L, (int)KeyInputNumber(x,y,maxnum,minnum,f) );
	return 1;
}

//@KeyInputStringn ֐gp̊̕eFύX
static int Lua_SetKeyInputStringColor(lua_State *L){
	int NmlStr        = (int)luaL_checknumber( L,1 );
	int NmlCur        = (int)luaL_checknumber( L,2 );
	int IMEStr        = (int)luaL_checknumber( L,3 );
	int IMECur        = (int)luaL_checknumber( L,4 );
	int IMELine		  = (int)luaL_checknumber( L,5 );
	int IMESelectStr  = (int)luaL_checknumber( L,6 );
	int IMEModeStr	  = (int)luaL_checknumber( L,7 );
	int NmlStrE       = (int)luaL_optnumber  ( L,8,0 ); 
	int IMESelectStrE = (int)luaL_optnumber  ( L,9,0 );
	int IMEModeStrE   = (int)luaL_optnumber  ( L,10,0 );
	int IMESelectWinE = (int)luaL_optnumber  ( L,11,-1 );
	int IMESelectWinF = (int)luaL_optnumber  ( L,12,-1 );
	int SelectStrBackColor = (int)luaL_optnumber( L,13,-1 );
	int SelectStrColor     = (int)luaL_optnumber( L,14,-1 );
	int SelectStrEdgeColor = (int)luaL_optnumber( L,15,-1 );
	lua_pushnumber( L,	(int)SetKeyInputStringColor( NmlStr, NmlCur, IMEStr, IMECur, IMELine, IMESelectStr, IMEModeStr , NmlStrE, 
		                    IMESelectStrE,IMEModeStrE,IMESelectWinE, IMESelectWinF,
							SelectStrBackColor,SelectStrColor,SelectStrEdgeColor) );
	return 1;
}

LUAFUNC_INT4( MakeKeyInput )			//@VL[̓f[^̍쐬
LUAFUNC_INT1( DeleteKeyInput )			//@L[̓f[^̍폜
LUAFUNC_NONE( InitKeyInput )			//@ׂẴL[̓f[^̍폜
LUAFUNC_INT1( SetActiveKeyInput )		//@w̃L[͂ANeBuɂ
LUAFUNC_INT1( CheckKeyInput )			//@͂IĂ邩擾
LUAFUNC_INT3( DrawKeyInputString )		//@L[͒f[^̕`
LUAFUNC_INT2( DrawKeyInputModeString )	//@̓[h`悷
LUAFUNC_S1I1( SetKeyInputString )		//@L[̓f[^Ɏw̕Zbg
LUAFUNC_INT2( SetKeyInputNumber )		//@L[̓f[^Ɏw̐l𕶎ɒuăZbg
LUAFUNC_S1I1( GetKeyInputString )		//@̓f[^̕擾
LUAFUNC_INT1( GetKeyInputNumber )		//@̓f[^̕𐔒lƂĎ擾

//p֐
LUAFUNC_S1I1( PlaySoundFile )			//@t@C(WAV.MP3.Ogg)Đ
LUAFUNC_NONE( CheckSoundFile )			//@t@CĐׂ
LUAFUNC_NONE( StopSoundFile )			//@t@C̍Đ~߂
LUAFUNC_STR1( LoadSoundMem )			//@t@C(WAV.MP3.Ogg)ɓǂ݂
LUAFUNC_INT3( PlaySoundMem )			//@ɓǂ݂񂾉f[^Đ
LUAFUNC_INT1( CheckSoundMem )			//@ɓǂ݂񂾉f[^Đׂ
LUAFUNC_INT1( StopSoundMem )			//@ɓǂݍ񂾉f[^̍Đ~߂
LUAFUNC_INT1( DeleteSoundMem )			//@ɓǂ݂񂾃TEhf[^폜
LUAFUNC_NONE( InitSoundMem )			//@ɓǂ݂񂾉f[^ׂď
LUAFUNC_INT2( SetPanSoundMem )			//@ɓǂ݂񂾉f[^̍ĐɃpݒ肷
LUAFUNC_INT2( ChangeVolumeSoundMem )	//@ɓǂ݂񂾉f[^̍ĐɃ{[ݒ肷
LUAFUNC_INT2( SetFrequencySoundMem )	//@ɓǂݍ񂾉f[^̍Đgݒ肷
LUAFUNC_INT2( SetLoopPosSoundMem )		//@ɓǂݍ񂾉f[^̃[vʒuݒ肷
LUAFUNC_INT2( SetLoopSamplePosSoundMem )//@ɓǂݍ񂾉f[^̃[vʒuݒ肷(Tvʒuw)
LUAFUNC_INT2( SetCurrentPositionSoundMem )	//@ɓǂݍ񂾉f[^̍ĐʒuTvPʂŕύX
LUAFUNC_INT1( DuplicateSoundMem )		//@Ƀɓǂݍł鉹f[^gpTEhnhVɍ쐬( Xg[TEĥ )

//yĐ֐
LUAFUNC_S1I1( PlayMusic )				//@lhch͂loRt@Ct(Đ)
LUAFUNC_NONE( CheckMusic )				//@lhch͂loRt@Ct(Đ)̏擾
LUAFUNC_NONE( StopMusic )				//@lhch͂loRt@C̉t(Đ)~
LUAFUNC_INT1( SetVolumeMusic )			//@lhch͂loRt@C̉t(Đ)̉ʂݒ肷

//EGCg֌W̊֐
LUAFUNC_INT1( WaitTimer )				//@w̎ԂƂ߂
LUAFUNC_INT1( WaitVSync )				//@bqs̐Mw񐔑҂
LUAFUNC_NONE( WaitKey )					//@L[̓͑҂

//Ԋ֌W̊֐
LUAFUNC_NONE( GetNowCount )				//@~bPʂ̐xJE^̌ݒl𓾂
NOTIMPL( GetNowHiPerformanceCount )		//@GetNowCount̍xo[W

//@ݎ擾
static int Lua_GetDateTime(lua_State *L){
	DATEDATA buf;
	lua_pushnumber( L, (int)GetDateTime(&buf) );
	lua_createtable(L, 0, 6);
	lua_pushstring(L, "Year" ); lua_pushinteger( L, buf.Year ); lua_settable (L,2);
	lua_pushstring(L, "Mon"  ); lua_pushinteger( L, buf.Mon	 ); lua_settable (L,2);
	lua_pushstring(L, "Day"  ); lua_pushinteger( L, buf.Day	 ); lua_settable (L,2);
	lua_pushstring(L, "Hour" ); lua_pushinteger( L, buf.Hour ); lua_settable (L,2);
	lua_pushstring(L, "min"  ); lua_pushinteger( L, buf.Min  ); lua_settable (L,2);
	lua_pushstring(L, "sec"  ); lua_pushinteger( L, buf.Sec  ); lua_settable (L,2);
	return 1;
}

//擾֐
LUAFUNC_INT1( GetRand )					//@擾
LUAFUNC_INT1( SRand )					//@̏lݒ肷

//EChE[h֌W
LUAFUNC_INT1( ChangeWindowMode )		//@EChE[hEtXN[[h̕ύXs
LUAFUNC_STR1( SetMainWindowText )		//@EChẼ^CgύX
NOTIMPL( SetWindowIconID )				//@EChẼACRύX
LUAFUNC_INT1( SetWindowSizeChangeEnableFlag )	//@EChE[h̎ɃEChẼTCYRɕύXo悤ɂ邩ǂݒ肷
LUAFUNC_INT1( SetWindowSizeExtendRate )	//@EChE[h̎̃EChȆ傫ƕ`ʂ̑傫̔䗦ݒ肷

//ʐM֌W
//@̃}Vɐڑ
static int Lua_ConnectNetWork(lua_State *L){
	IPDATA d;
	d.d1 = (int)luaL_checknumber( L, 1 );
	d.d2 = (int)luaL_checknumber( L, 2 );
	d.d3 = (int)luaL_checknumber( L, 3 );
	d.d4 = (int)luaL_checknumber( L, 4 );
	int p = (int)luaL_optnumber( L, 5, -1 );
	lua_pushnumber( L, (int)ConnectNetWork(d,p) );
	return 1;
}
LUAFUNC_INT1( CloseNetWork )			//@ڑI

//@ڑ󂯕tԂɂ
static int Lua_PreparationListenNetWork(lua_State *L){
	int p = (int)luaL_optnumber( L, 1, -1 );
	lua_pushnumber( L, (int)PreparationListenNetWork(p) );
	return 1;
}
LUAFUNC_NONE( StopListenNetWork )		//@ڑ󂯕tĂԂ

//@f[^𑗐M
static int Lua_NetWorkSend(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	int l = (int)luaL_checknumber( L, 3 );
	char * buf = (char*)malloc(l);
	int i;
	for(i=0;i<l;i++){
		lua_gettable (L, 2);
		buf[l] = lua_tointeger(L, 4);
		lua_pop(L,1);
	}
	lua_pushnumber( L, (int)NetWorkSend(h,buf,l) );
	free(buf);
	return 1;
}

LUAFUNC_INT1( GetNetWorkDataLength )	//@Mf[^ꎞLobt@ɗ܂Ăf[^̗ʂ𓾂
LUAFUNC_INT1( GetNetWorkSendDataLength )	//@M̃f[^̗ʂ𓾂

//@Mf[^ꎞLobt@ɗ܂Ăf[^擾
static int Lua_NetWorkRecv(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	int l = (int)luaL_checknumber( L, 2 );
	char * buf = (char*)malloc( l );
	int i;
	lua_pushnumber( L,(int)NetWorkRecv(h,buf,l) );
	lua_createtable(L, l, 0);
	for(i=0;i<l;i++ ){
        lua_pushinteger(L, i); lua_pushinteger( L, buf[i] ); lua_settable(L,3);
	}
	free(buf);	
	return 2;
}

//@Mf[^ǂݍށAǂݍ񂾃f[^̓obt@폜Ȃ
static int Lua_NetWorkRecvToPeek(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	int l = (int)luaL_checknumber( L, 2 );
	char * buf = (char*)malloc( l );
	int i;
	lua_pushnumber( L,(int)NetWorkRecvToPeek(h,buf,l) );
	lua_createtable(L, l, 0);
	for(i=0;i<l;i++ ){
        lua_pushinteger(L, i); lua_pushinteger( L, buf[i] ); lua_settable(L,3);
	}
	free(buf);	
	return 2;
}
LUAFUNC_NONE( GetNewAcceptNetWork )		//@VɊmڑlbg[Nnh𓾂
LUAFUNC_NONE( GetLostNetWork      )		//@Vɔjꂽڑlbg[Nnh𓾂
LUAFUNC_INT1( GetNetWorkAcceptState )	//@ڑԂ擾

//@ڑ̂hoAhX𓾂
static int Lua_GetNetWorkIP(lua_State *L){
	IPDATA buf;
	int h = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)GetNetWorkIP(h,&buf) );
	lua_pushnumber( L, buf.d1 );
	lua_pushnumber( L, buf.d2 );
	lua_pushnumber( L, buf.d3 );
	lua_pushnumber( L, buf.d4 );
	return 5;
}

//@tcogpĒʐM邽߂̃\Pbg쐬
static int Lua_MakeUDPSocket(lua_State *L){
	int p = (int)luaL_optnumber( L, 1, -1 );
	lua_pushnumber( L, (int)MakeUDPSocket(p) );
	return 1;
}

LUAFUNC_INT1( DeleteUDPSocket )			//@tcogpĒʐM邽߂̃\Pbg폜

//
//@tcogpđ̃}VɃf[^𑗐M
static int Lua_NetWorkSendUDP(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	IPDATA ip;
	ip.d1 = (int)luaL_checknumber( L, 2 );
	ip.d2 = (int)luaL_checknumber( L, 3 );
	ip.d3 = (int)luaL_checknumber( L, 4 );
	ip.d4 = (int)luaL_checknumber( L, 5 );
	int port = (int)luaL_checknumber( L, 6 );
	int l = (int)luaL_checknumber( L, 8 );

	char * buf = (char*)malloc(l);
	int i;
	for(i=0;i<l;i++){
		lua_gettable (L, 7);
		buf[i] = lua_tointeger (L, 9);
		lua_pop(L,1);
	}
	lua_pushnumber( L, (int)NetWorkSendUDP(h,ip,port,buf,l) );
	free(buf);
	return 1;
}

//
//@tcogpđ̃}Ṽf[^M
static int Lua_NetWorkRecvUDP(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	IPDATA ip;
	int port;
	int l = (int)luaL_checknumber( L, 2 );
	int p = (int)luaL_checknumber( L, 3 );
	char * buf = (char*)malloc(l);
	int i;
	lua_pushnumber( L, (int)NetWorkRecvUDP(h,&ip,&port,buf,l,p ) );
	lua_pushnumber( L, ip.d1 );
	lua_pushnumber( L, ip.d2 );
	lua_pushnumber( L, ip.d3 );
	lua_pushnumber( L, ip.d4 );
	lua_pushnumber( L, port );
	lua_createtable(L, l, 0);
	int t = lua_gettop(L);
	for(i=0;i<l;i++ ){
        lua_pushinteger(L, i); lua_pushinteger( L, buf[i] ); lua_settable(L,t);
	}
	free(buf);	
	return 7;
}

LUAFUNC_INT1( CheckNetWorkRecvUDP )				//@tcogp̃}VMf[^邩ǂ擾

//t@Cǂݍ݊֌W
//@t@CJ
static int Lua_FileRead_open(lua_State *L){
	const char * p = luaL_checkstring( L, 1 );
	int s = (int)luaL_optnumber( L, 2, 0 );
	lua_pushnumber( L, (int)FileRead_open(p,s) );
	return 1;
}
LUAFUNC_STR1( FileRead_size )					//@t@C̃TCY𓾂
LUAFUNC_INT1( FileRead_close )					//@t@C
LUAFUNC_INT1( FileRead_tell )					//@t@C|C^̈ʒu𓾂
LUAFUNC_INT3( FileRead_seek )					//@t@C|C^̈ʒuύX

static int Lua_FileRead_read(lua_State *L){
	int siz = (int)luaL_checknumber( L, 1 );
	int h   = (int)luaL_checknumber( L, 2 );
	char * buf = (char*)malloc( siz );
	int i;
	lua_pushnumber( L,(int)FileRead_read(buf,siz,h) );
	lua_createtable(L, siz, 0);
	for(i=0;i<siz;i++ ){
        lua_pushinteger(L, i); lua_pushinteger( L, buf[i] ); lua_settable(L,4);
	}
	free(buf);	
	return 2;
}
LUAFUNC_INT1( FileRead_eof )					//@t@C̏I[ǂ𒲂ׂ

//@t@Csǂݏo
static int Lua_FileRead_gets(lua_State *L){
	int siz  = (int)luaL_checknumber( L, 1 );
	int h    = (int)luaL_checknumber( L, 2 );
	char * buf = (char*)malloc( siz );
	lua_pushnumber( L,(int)FileRead_gets(buf,siz, h) );
	lua_pushstring( L, buf );
	return 2;
}

//@t@Cꕶǂݏo
static int Lua_FileRead_getc(lua_State *L){
	int h    = (int)luaL_checknumber( L, 1 );
	TCHAR c = FileRead_getc(h);
	lua_pushnumber( L, c );
	return 1;
}

NOTIMPL( FileRead_scanf ) //@t@C珑tf[^ǂݏo

//hbgPʂŉ摜ɃANZX֌W
NOTIMPL( LoadSoftImage           )  //@botňC[W̓ǂݍ
NOTIMPL( LoadSoftImageToMem      )  //@botňC[W̃̓ǂݍ
NOTIMPL( MakeARGB8ColorSoftImage )  //@botňC[W̍쐬( RGBA8 J[ )
NOTIMPL( MakeXRGB8ColorSoftImage )  //@botňC[W̍쐬( XRGB8 J[ )

//@botňC[W̍쐬( pbgQTUF J[ )
NOTIMPL( MakePAL8ColorSoftImage )
//@botňC[W̉
NOTIMPL( DeleteSoftImage )
//@botňC[WSĉ
NOTIMPL( InitSoftImage )
//@botňC[W̃TCY擾
NOTIMPL( GetSoftImageSize )
//@botňC[WwFœhԂ(eFvf͂O`QTT)
NOTIMPL( FillSoftImage )

//@botňC[W̃pbgZbg(eFvf͂O`QTT)
NOTIMPL( SetPaletteSoftImage )
	//@botňC[W̃pbg擾(eFvf͂O`QTT)
NOTIMPL( GetPaletteSoftImage )
//@botňC[W̎wWɃhbg`悷(pbg摜pALl͂O`QTT)
NOTIMPL( DrawPixelPalCodeSoftImage )
//@botňC[W̎wW̐FR[h擾(pbg摜pA߂l͂O`QTT)
NOTIMPL( GetPixelPalCodeSoftImage )
//@botňC[W̎wWɃhbg`悷(eFvf͂O`QTT)
NOTIMPL( DrawPixelSoftImage )
//@botňC[W̎wW̐F擾(eFvf͂O`QTT)
NOTIMPL( GetPixelSoftImage )
//@botňC[Wʂ̃C[Wɓ]
NOTIMPL( BltSoftImage )
//@botňC[Wʂɕ`悷
NOTIMPL( DrawSoftImage )
//@botňC[WOtBbNnh쐬
NOTIMPL( CreateGraphFromSoftImage )
//@botňC[W番OtBbNnh쐬
NOTIMPL( CreateDivGraphFromSoftImage )

	
//}Ci[֐
LUAFUNC_INT1( SetUse3DFlag )			//@Rc@\gÃtOZbg
LUAFUNC_NONE( GetUse3DFlag )			//@ʂ̕`ɂRcANZ[^gĂ邩Ȁ𓾂
LUAFUNC_INT1( SetWaitVSyncFlag )		//@ScreenFlip֐sɂbqs̐M҂邩̃tOZbg
LUAFUNC_NONE( GetColorBitDepth )		//@ʂ̐Frbg𓾂

//@cɕ`悷
static int Lua_DrawVString(lua_State *L){
	int x    = (int)luaL_checknumber( L, 1 );
	int y    = (int)luaL_checknumber( L, 2 );
	const char * s = luaL_checkstring( L, 3 );
	int c    = (int)luaL_checknumber( L, 4 );
	int e    = (int)luaL_optnumber( L, 5, 0 );
	lua_pushnumber( L, (int)DrawVString(x,y,s,c,e) );
	return 1;
}

//@tHgnhgpĕcɕ`悷
static int Lua_DrawVStringToHandle(lua_State *L){
	int x    = (int)luaL_checknumber( L, 1 );
	int y    = (int)luaL_checknumber( L, 2 );
	const char * s = luaL_checkstring( L, 3 );
	int c    = (int)luaL_checknumber( L, 4 );
	int h    = (int)luaL_checknumber( L, 5 );
	int e    = (int)luaL_optnumber( L, 6, 0 );
	lua_pushnumber( L, (int)DrawVStringToHandle(x,y,s,c,h,e) );
	return 1;
}
LUAFUNC_INT1( SetGraphDataShavedMode )			//@OtBbNF̉摜򉻊ɘa[h̕ύX

//@ݕ`ΏۂɂȂĂʂalo`ŕۑ
static int Lua_SaveDrawScreen(lua_State *L){
	int x1    = (int)luaL_checknumber( L, 1 );
	int y1    = (int)luaL_checknumber( L, 2 );
	int x2    = (int)luaL_checknumber( L, 3 );
	int y2    = (int)luaL_checknumber( L, 4 );
	const char * fn = luaL_checkstring(L, 5);
	int typ   = (int)luaL_optnumber(L, 6,  0);
	int jq    = (int)luaL_optnumber(L, 7, 80);
	int js    = (int)luaL_optnumber(L, 8,  1);
	int pcmp  = (int)luaL_optnumber(L, 9, -1);
	lua_pushnumber( L,	(int)SaveDrawScreen(x1,y1,x2,y2,fn,typ,jq,js,pcmp) );
	return 1;
}
LUAFUNC_STR1( LoadPauseGraph )					//@tH[JX̃\tgɈڂĂƂɃobNOEhɕ\OtBbÑ[hAo^(NULL ŉ)
LUAFUNC_INT1( SetOutApplicationLogValidFlag )	//@Oo͂sۂ̃Zbg
LUAFUNC_INT1( SetBasicBlendFlag )				//@RcANZ[^gȂ`揈Ȋȗꂽgp邩ۂύX
LUAFUNC_INT1( SetScreenMemToVramFlag )			//@ʂ̉摜f[^uq`lɔzu邩ǂύX
LUAFUNC_NONE( ScreenCopy )						//@ʃRs[֐Aʂ̗y[Wii͕\ĂȂj\y[Wii\ĂjɃRs[

//@gp\ȃtHg̖O񋓂
static int Lua_EnumFontName(lua_State *L){
	int flg = (int)luaL_checknumber(L, 1);
	int cnt = EnumFontName(NULL,0,flg );
	int i;
	char * buf =(char*) malloc( 64 * cnt );
	lua_pushnumber( L,(int)EnumFontName( buf,cnt,flg ) );
    lua_createtable(L, cnt, 0);
    for( i=0;i<cnt;i++ ){
        lua_pushinteger(L, i); lua_pushstring( L, buf+i*64 ); lua_settable (L,3);
    }
	free(buf);
	return 2;
}	

LUAFUNC_INT1( SelectMidiMode )					//@lhch̉t`ԂZbg
LUAFUNC_INT1( SetAlwaysRunFlag )				//@EChEANeBuł͂ȂԂł𑱍s邩AtOZbg

//@rfI̗eʂ𓾂
static int Lua_GetVideoMemorySize(lua_State *L){
	int a, f;
	lua_pushnumber( L,(int)GetVideoMemorySize(&a,&f) );
	lua_pushnumber( L, a );
	lua_pushnumber( L, f );
	return 3;
}
LUAFUNC_INT1( SetUseDivGraphFlag )				//@KvȂOtBbN̕sۂݒ肷
LUAFUNC_INT1( SetCreateSoundDataType )			//@쐬鉹f[^̍Đ`ݒ肷
NOTIMPL( CreateGraphFromMem )					//@̉摜t@CC[WOtBbNnh쐬
NOTIMPL( ReCreateGraphFromMem )					//@̉摜t@CC[W̃OtBbNnhɃf[^]
NOTIMPL( ReloadFileGraphAll )					//@摜t@C쐬OtBbNnhɍēx摜t@C摜ǂݍ
NOTIMPL( SetRestoreGraphCallback )				//@OtBbNnh֐o^
NOTIMPL( LoadSoundMemByMemImage )				//@̉t@CC[WTEhnh쐬
LUAFUNC_INT1( SetMaskReverseEffectFlag )		//@}XN̐lɑ΂ʂt]邩ǂݒ肷
LUAFUNC_INT1( SetUseDXArchiveFlag )				//@cwA[JCut@C̓ǂݍ݋@\gǂݒ肷
LUAFUNC_STR1( SetDXArchiveExtension )			//@cwA[JCut@C̊gqύX
LUAFUNC_STR1( SetDXArchiveKeyString )			//@cwA[JCut@Čݒ肷
LUAFUNC_INT1( SetEmulation320x240 )				//@USOSWỎʂłRQOQSỎʉ𑜓xɂ邩ǂ̃tOZbgAUSOSWOȊỎ𑜓xł͖


// 3D֘A
LUAFUNC_STR1( MV1LoadModel )					// f̓ǂݍ( -1:G[  0ȏ:fnh )
NOTIMPL( MV1LoadModelFromMem )					// ̃ft@CC[WƓƎ̓ǂݍ݃[`gpăfǂݍ	// extern int MV1LoadModelFromMem( void *FileImage, int FileSize, int (* FileReadFunc )( const TCHAR *FilePath, void **FileImageAddr, int *FileSize, void *FileReadFuncData ), int (* FileReleaseFunc )( void *MemoryAddr, void *FileReadFuncData ), void *FileReadFuncData = NULL ) ;	
LUAFUNC_INT1( MV1DuplicateModel )				// w̃fƓf{f[^gpăf쐬( -1:G[  0ȏ:fnh )
LUAFUNC_INT1( MV1CreateCloneModel )				// w̃ff{f[^܂ߕ( MV1DuplicateModel ̓f{f[^͋L܂Ã͕fƂ͈؋Lf[^̖fnh쐬܂ )( -1:G[  0ȏ:fnh )
LUAFUNC_INT1( MV1DeleteModel )					// f폜
LUAFUNC_NONE( MV1InitModel )					// ׂẴf폜
LUAFUNC_INT1( MV1SetLoadModelReMakeNormal )		// fǂݍލۂɖ@̍ČvZsǂݒ肷( TRUE:s  FALSE:sȂ )

// fǂݍލۂɍs@̍ČvZŎgpX[WOpxݒ肷( Pʂ̓WA )
static	int	Lua_MV1SetLoadModelReMakeNormalSmoothingAngle( lua_State *L ) {
	float f = (float)luaL_optnumber(L, 1, 1.562069f);
	lua_pushnumber( L,(int)MV1SetLoadModelReMakeNormalSmoothingAngle( f ) );
	return 1;
}

LUAFUNC_INT1( MV1SetLoadModelPositionOptimize )		// fǂݍލۂɍWf[^̍œKsǂݒ肷( TRUE:s  FALSE:sȂ )
LUAFUNC_INT1( MV1SetLoadModelUsePhysicsMode )		// ǂݍރf̕Z[hݒ肷
LUAFUNC_FLT1( MV1SetLoadModelPhysicsWorldGravity )	// ǂݍރf̕ZɓKpd̓p[^ݒ肷

// ǂݍރf̕Z[hOvZ( DX_LOADMODEL_PHYSICS_LOADCALC )ꍇɓKpd͂̐ݒ
static	int	Lua_MV1SetLoadCalcPhysicsWorldGravity( lua_State *L ) {
	int a = (int)luaL_checknumber(L, 1);
	VECTOR b = getVECTOR(L, 2);
    lua_pushnumber( L,(int)MV1SetLoadCalcPhysicsWorldGravity( a, b ) );
	return 1;
}

// f`֌W
LUAFUNC_INT2( MV1DrawFrame )						// f̎w̃t[`悷
LUAFUNC_INT1( MV1DrawModel )						// f`悷
LUAFUNC_INT2( MV1DrawMesh  )						// f̎w̃bV`悷

// f̃fobO`
static	int	Lua_MV1DrawModelDebug( lua_State *L ){
	int h  = (int)luaL_checknumber(L, 1);
	int c  = (int)luaL_checknumber(L, 2);
	int n  = (int)luaL_checknumber(L, 3);
	float l  = (float)luaL_checknumber(L, 4);
	int p  = (int)luaL_checknumber(L, 5);
	int s  = (int)luaL_checknumber(L, 6);
	lua_pushnumber( L,(int)MV1DrawModelDebug( h, c, n, l, p, s ) );
	return 1;
}

// f̃[JW烏[hWɕϊs𓾂
static	int	Lua_MV1GetLocalWorldMatrix( lua_State *L ){
	int h  = (int)luaL_checknumber(L, 1);
	MATRIX mat = MV1GetLocalWorldMatrix( h ) ;
	pushMATRIX(L, mat);
	return 1;
}

// f̍WZbg
static	int	Lua_MV1SetPosition( lua_State *L ){
	int h  = (int)luaL_checknumber(L, 1);
	VECTOR p = getVECTOR(L, 2);
	lua_pushnumber( L,(int)MV1SetPosition( h, p ) );
	return 1;
}

// f̍W擾
static	int	Lua_MV1GetPosition( lua_State *L ){
	int h  = (int)luaL_checknumber(L, 1);
	VECTOR p = MV1GetPosition( h );
	pushVECTOR(L, p);
	return 1;
}

// f̊glZbg
static	int	Lua_MV1SetScale( lua_State *L ){
	int h  = (int)luaL_checknumber(L, 1);
	VECTOR s = getVECTOR(L, 2);
	lua_pushnumber( L,(int)MV1SetScale( h, s ) );
	return 1;
}

// f̊gl擾
static	int	Lua_MV1GetScale( lua_State *L ){
	int h  = (int)luaL_checknumber(L, 1);
	VECTOR p = MV1GetScale( h );
	pushVECTOR(L, p);
	return 1;
}

// f̉]lZbg( X]Y]Z] )
static	int	Lua_MV1SetRotationXYZ( lua_State *L ){
	int    h = (int)luaL_checknumber(L, 1);
	VECTOR v = getVECTOR(L, 2);
	lua_pushnumber( L,(int)MV1SetRotationXYZ( h, v ) );
	return 1;
}

// f̉]l擾( X]Y]Z] )
static	int	Lua_MV1GetRotationXYZ( lua_State *L ){
	int h  = (int)luaL_checknumber(L, 1);
	VECTOR p = MV1GetRotationXYZ( h );
	pushVECTOR(L, p);
	return 1;
}

// f̂yƂx̌Zbg
static	int	Lua_MV1SetRotationZYAxis( lua_State *L ){
	int    h = (int)luaL_checknumber(L, 1);
	VECTOR a = getVECTOR(L, 2);
	VECTOR b = getVECTOR(L, 3);
	float  c = (float)luaL_checknumber(L, 4);
	lua_pushnumber( L,(int)MV1SetRotationZYAxis( h, a, b, c ) );
	return 1;
}

// f̉]psZbg
static	int	Lua_MV1SetRotationMatrix( lua_State *L ){
	int    h = (int)luaL_checknumber(L, 1);
	MATRIX a = getMATRIX(L, 2);
	lua_pushnumber( L,(int)MV1SetRotationMatrix( h, a ) );
	return 1;
}

// f̉]ps擾
static	int	Lua_MV1GetRotationMatrix( lua_State *L ){
	int h  = (int)luaL_checknumber(L, 1);
	MATRIX mat = MV1GetRotationMatrix( h ) ;
	pushMATRIX(L, mat);
	return 1;
}

// f̕ό`psZbg
static	int	Lua_MV1SetMatrix( lua_State *L ){
	int    h = (int)luaL_checknumber(L, 1);
	MATRIX a = getMATRIX(L, 2);
	lua_pushnumber( L,(int)MV1SetMatrix( h, a ) );
	return 1;
}

// f̕ό`ps擾
static	int	Lua_MV1GetMatrix( lua_State *L ){
	int h  = (int)luaL_checknumber(L, 1);
	pushMATRIX(L, MV1GetMatrix( h ) );
	return 1;
}
LUAFUNC_INT2( MV1SetVisible )		// f̕\A\ԂύX( TRUE:\  FALSE:\ )
LUAFUNC_INT1( MV1GetVisible )		// f̕\A\Ԃ擾( TRUE:\  FALSE:\ )

// X^bNCOLOR_Fς
static void pushCOLOR_F(lua_State *L, COLOR_F col ){
	lua_createtable(L, 0, 4 );
	int num = lua_gettop(L);
	lua_pushstring(L,"r"); lua_pushnumber(L,col.r); lua_settable(L,num);
	lua_pushstring(L,"g"); lua_pushnumber(L,col.g); lua_settable(L,num);
	lua_pushstring(L,"b"); lua_pushnumber(L,col.b); lua_settable(L,num);
	lua_pushstring(L,"a"); lua_pushnumber(L,col.a); lua_settable(L,num);
}

// X^bNCOLORLF o
static COLOR_F getCOLOR_F(lua_State *L, int num){
	COLOR_F col;
	lua_pushstring(L,"r");lua_gettable(L,num);col.r = (float)luaL_checknumber(L,lua_gettop(L));
	lua_pushstring(L,"g");lua_gettable(L,num);col.g = (float)luaL_checknumber(L,lua_gettop(L));
	lua_pushstring(L,"b");lua_gettable(L,num);col.b = (float)luaL_checknumber(L,lua_gettop(L));
	lua_pushstring(L,"a");lua_gettable(L,num);col.a = (float)luaL_checknumber(L,lua_gettop(L));
	lua_pop(L, 4);
	return col;
}

// f̃fBt[YJ[̃XP[lݒ肷( ftHgl 1.0f )
static	int	Lua_MV1SetDifColorScale( lua_State *L ){
	int     h = (int)luaL_checknumber(L, 1);
	COLOR_F a = getCOLOR_F(L, 2);
	lua_pushnumber( L,(int)MV1SetDifColorScale( h, a ) );
	return 1;
}

// f̃fBt[YJ[̃XP[l擾( ftHgl 1.0f )
static	int	Lua_MV1GetDifColorScale( lua_State *L ){
	int     h = (int)luaL_checknumber(L, 1);
	pushCOLOR_F( L, MV1GetDifColorScale( h ) );
	return 1;
}

// f̃XyLJ[̃XP[lݒ肷( ftHgl 1.0f )
static	int	Lua_MV1SetSpcColorScale( lua_State *L ){
	int     h = (int)luaL_checknumber(L, 1);
	COLOR_F a = getCOLOR_F(L, 2);
	lua_pushnumber( L,(int)MV1SetSpcColorScale( h, a ) );
	return 1;
}

// f̃XyLJ[̃XP[l擾( ftHgl 1.0f )
static	int	Lua_MV1GetSpcColorScale( lua_State *L ){
	int     h = (int)luaL_checknumber(L, 1);
	pushCOLOR_F( L, MV1GetSpcColorScale( h ) );
	return 1;
}

// f̃G~bVuJ[̃XP[lݒ肷( ftHgl 1.0f )
static	int	Lua_MV1SetEmiColorScale( lua_State *L ){
	int     h = (int)luaL_checknumber(L, 1);
	COLOR_F a = getCOLOR_F(L, 2);
	lua_pushnumber( L,(int)MV1SetEmiColorScale( h, a ) );
	return 1;
}

// f̃G~bVuJ[̃XP[l擾( ftHgl 1.0f )
static	int	Lua_MV1GetEmiColorScale( lua_State *L ){
	int     h = (int)luaL_checknumber(L, 1);
	pushCOLOR_F( L, MV1GetEmiColorScale( h ) );
	return 1;
}

// f̃ArGgJ[̃XP[lݒ肷( ftHgl 1.0f )
static	int	Lua_MV1SetAmbColorScale( lua_State *L ){
	int     h = (int)luaL_checknumber(L, 1);
	COLOR_F a = getCOLOR_F(L, 2);
	lua_pushnumber( L,(int)MV1SetAmbColorScale( h, a ) );
	return 1;
}

// f̃ArGgJ[̃XP[l擾( ftHgl 1.0f )
static	int	Lua_MV1GetAmbColorScale( lua_State *L ){
	int     h = (int)luaL_checknumber(L, 1);
	pushCOLOR_F( L, MV1GetAmbColorScale( h ) );
	return 1;
}

LUAFUNC_INT1( MV1GetSemiTransState )	// fɔvf邩ǂ擾( ߂l TRUE:  FALSE:Ȃ )

// f̕sxݒ肷( s 1.0f `  0.0f )
static	int	Lua_MV1SetOpacityRate( lua_State *L ){
	int     h = (int)luaL_checknumber(L, 1);
	float   a = (float)luaL_checknumber(L, 2);
	lua_pushnumber( L,(int)MV1SetOpacityRate( h, a ) );
	return 1;
}
LUAFUNC_INT1( MV1GetOpacityRate )		// f̕sx擾( s 1.0f `  0.0f )
LUAFUNC_INT2( MV1SetUseZBuffer )		// f`悷ۂɂyobt@gp邩ǂݒ肷
LUAFUNC_INT2( MV1SetWriteZBuffer )		// f`悷ۂɂyobt@ɏ݂sǂݒ肷
LUAFUNC_INT2( MV1SetZBufferCmpType )	// f̕`掞̂yl̔r[hݒ肷
LUAFUNC_INT2( MV1SetZBias )				// f̕`掞̏ނyl̃oCAXݒ肷
LUAFUNC_INT2( MV1SetUseVertDifColor )	// f̊܂܂郁bV̒_fBt[YJ[}eÃfBt[YJ[̑Ɏgp邩ǂݒ肷( TRUE:}eAJ[̑Ɏgp  FALSE:}eAJ[gp )
LUAFUNC_INT2( MV1SetUseVertSpcColor )	// fɊ܂܂郁bV̒_XyLJ[}eÃXyLJ[̑Ɏgp邩ǂݒ肷( TRUE:}eAJ[̑Ɏgp  FALSE:}eAJ[gp )
LUAFUNC_INT2( MV1SetSampleFilterMode )	// f̃eNX`̃TvtB^[[hύX( FilterMode  DX_DRAWMODE_NEAREST  )
LUAFUNC_INT2( MV1SetMaxAnisotropy )		// fٕ̈tB^O̍ő原ݒ肷
LUAFUNC_INT2( MV1SetWireFrameDrawFlag )	// fC[t[ŕ`悷邩ǂݒ肷
LUAFUNC_INT1( MV1RefreshVertColorFromMaterial )	// f̒_J[ݐݒ肳Ă}eÃJ[ɂ

// f̕Zw莞ԕo߂Ɖ肵ČvZ( MillisecondTime Ŏw肷鎞Ԃ̒Pʂ̓~b )
static	int	Lua_MV1PhysicsCalculation( lua_State *L ){
	int   h = (int)luaL_checknumber(L, 1);
	float a = (float)luaL_checknumber(L, 2);
	lua_pushnumber( L,(int)MV1PhysicsCalculation( h, a ) );
	return 1;
}

LUAFUNC_INT1( MV1PhysicsResetState )	// f̕Z̏ԂZbg( ʒu[vƂp )

// J֌W֐
LUAFUNC_FLT2( SetCameraNearFar )		// J NearNbvʂ FarNbvʂ̋ݒ肷
LUAFUNC_VCT2_INT( SetCameraPositionAndTarget_UpVecY )		// J̐ݒA_A_AAbvxNg͂x
LUAFUNC_VCT3_INT( SetCameraPositionAndTargetAndUpVec )		// J̐ݒA_A_AAbvxNgw

// J̐ݒA]pxA]pxAP]pxA_w	 
static	int	Lua_SetCameraPositionAndAngle( lua_State *L ){ 
	VECTOR a = getVECTOR(L, 1);
	float  b = (float)luaL_checknumber(L, 2);
	float  c = (float)luaL_checknumber(L, 3);
	float  d = (float)luaL_checknumber(L, 4);
	lua_pushnumber( L,(int)SetCameraPositionAndAngle( a, b, c, d ) );
	return 1;
}
LUAFUNC_MTX_INT( SetCameraViewMatrix )			// r[s𒼐ڐݒ肷	
LUAFUNC_FLT2( SetCameraScreenCenter )			// ʏɂJĂf̒S̍Wݒ肷	
LUAFUNC_FLT1( SetupCamera_Perspective )			// ߖ@JZbgAbv	
LUAFUNC_FLT1( SetupCamera_Ortho )				// ˉeJZbgAbv	
LUAFUNC_MTX_INT( SetupCamera_ProjectionMatrix )	// ˉesݒ肷	
LUAFUNC_FLT1( SetCameraDotAspect )				// J̃hbgAXyNgݒ肷	
LUAFUNC_NONE_FLT( GetCameraNear )				// J Near Nbvʂ̋擾	
LUAFUNC_NONE_FLT( GetCameraFar )				// J Far Nbvʂ̋擾	
LUAFUNC_NONE_VCT( GetCameraPosition )			// J̈ʒu擾	
LUAFUNC_NONE_VCT( GetCameraTarget )				// J̒_擾	
LUAFUNC_NONE_VCT( GetCameraUpVector )			// J̎ɐȏ̃xNg𓾂	
LUAFUNC_NONE_FLT( GetCameraAngleHRotate )		// J̐̌擾	
LUAFUNC_NONE_FLT( GetCameraAngleVRotate )		// J̐̌擾	
LUAFUNC_NONE_FLT( GetCameraAngleTRotate )		// J̌̔Ppx擾	
LUAFUNC_NONE_MTX( GetCameraViewMatrix )			// r[s擾	
LUAFUNC_NONE_MTX( GetCameraBillboardMatrix )	// r{[hs擾	
LUAFUNC_NONE_FLT( GetCameraFov )				// J̎p擾	
LUAFUNC_NONE_FLT( GetCameraSize )				// J̎TCY擾	
LUAFUNC_NONE_MTX( GetCameraProjectionMatrix )	// ˉes擾	
LUAFUNC_NONE_FLT( GetCameraDotAspect )			// J̃hbgAXyNg𓾂	
LUAFUNC_NONE_MTX( GetCameraViewportMatrix )		// r[|[gs擾
LUAFUNC_NONE_MTX( GetCameraAPIViewportMatrix )	// Direct3DŎKpr[|[gs擾

#define LUAREG( name )	{ "##name", Lua_##name },

static const luaL_Reg Lua_DxLib[] = {
	//
	LUAREG( DxLib_Init            )
	LUAREG( DxLib_End             )
	LUAREG( ProcessMessage        )
	LUAREG( SetUseFPUPreserveFlag )
	//}``֐
	LUAREG( DrawLine			)
	LUAREG( DrawBox				)
	LUAREG( DrawCircle			)
	LUAREG( DrawOval			)
	LUAREG( DrawTriangle		)
	LUAREG( DrawPixel			)
	LUAREG( GetPixel			)
	//OtBbNf[^֐
	LUAREG( LoadGraphScreen     )
	LUAREG( LoadGraph           )
	LUAREG( LoadDivGraph        )
	LUAREG( MakeGraph           )
	LUAREG( DrawGraph           )
	LUAREG( DrawTurnGraph		)
	LUAREG( DrawExtendGraph		)
	LUAREG( DrawRotaGraph		)
	LUAREG( DrawRotaGraph2		)
	LUAREG( DrawModiGraph		)
	LUAREG( DrawRectGraph		)
	LUAREG( DerivationGraph		)
	LUAREG( GetDrawScreenGraph	)
	LUAREG( GetGraphSize		)
	LUAREG( InitGraph			)
	LUAREG( DeleteGraph			)
	LUAREG( SetDrawMode			)
	LUAREG( SetDrawBlendMode	)
	LUAREG( SetDrawBright		)
	LUAREG( SetTransColor		)
	LUAREG( LoadBlendGraph		)
	LUAREG( DrawBlendGraph		)
	//`֌W֐
	LUAREG( DrawString				   )
//	LUAREG( DrawFormatString		   )
	LUAREG( GetDrawStringWidth		   )
	LUAREG( GetDrawFormatStringWidth   )
	LUAREG( SetFontSize				   )
	LUAREG( SetFontThickness		   )
	LUAREG( ChangeFont				   )
	LUAREG( ChangeFontType			   )
	LUAREG( CreateFontToHandle		   )
	LUAREG( DeleteFontToHandle		   )
	LUAREG( DrawStringToHandle		   )
	LUAREG( DrawFormatStringToHandle   )
	LUAREG( GetDrawStringWidthToHandle )
	LUAREG( GetDrawFormatStringWidthToHandle )
	LUAREG( GetFontStateToHandle             )
	LUAREG( InitFontToHandle                 )
	//ȈՉʏo͊֐
	LUAREG( printfDx             )
	LUAREG( clsDx                )
	//̑ʑn֐
	LUAREG( SetGraphMode		)
	LUAREG( GetScreenState		)
	LUAREG( SetDrawArea		    )
	LUAREG( ClearDrawScreen     )
	LUAREG( GetColor            )
	LUAREG( SetDrawScreen       )
	LUAREG( ScreenFlip          )
	LUAREG( SetBackgroundColor  )
	//֌W֐
	LUAREG( PlayMovie	          )
	LUAREG( PlayMovieToGraph	  )
	LUAREG( PauseMovieToGraph	  )
	LUAREG( SeekMovieToGraph	  )
	LUAREG( TellMovieToGraph	  )
	LUAREG( GetMovieStateToGraph  )
	//}XN֌W֐
	LUAREG( CreateMaskScreen		)
	LUAREG( DeleteMaskScreen		)
	LUAREG( LoadMask				)
	LUAREG( LoadDivMask				)
	LUAREG( DrawMask				)
	LUAREG( DrawFillMask			)
	LUAREG( DeleteMask				)
	LUAREG( InitMask				)
	LUAREG( FillMaskScreen			)
	LUAREG( SetUseMaskScreenFlag	)
	LUAREG( MakeMask				)
	LUAREG( GetMaskSize				)
	LUAREG( SetDataToMask			)
	LUAREG( DrawMaskToDirectData	)
	LUAREG( DrawFillMaskToDirectData	)
	LUAREG( SetMaskTransColor		)
	//͊֌W̊֐
	LUAREG( GetJoypadNum	)
	LUAREG( GetJoypadInputState	)
	LUAREG( GetJoypadInputStateEX	)
	LUAREG( GetJoypadAnalogInput	)
	LUAREG( GetJoypadAnalogInputRight	)
	LUAREG( SetJoypadInputToKeyInput	)
	LUAREG( StartJoypadVibration	)
	LUAREG( StopJoypadVibration	)
	//}EX͊֘A֐
	{ "SetMouseDispFlag"		, Lua_SetMouseDispFlag	},
	{ "GetMousePoint"			, Lua_GetMousePoint	},
	{ "SetMousePoint"			, Lua_SetMousePoint	},
	{ "GetMouseInput"			, Lua_GetMouseInput	},
	{ "GetMouseWheelRotVol"		, Lua_GetMouseWheelRotVol	},
	//L[{[h͊֘A֐
	{ "CheckHitKeyAll"			, Lua_CheckHitKeyAll	},
	{ "CheckHitKey"				, Lua_CheckHitKey          },
	{ "GetHitKeyStateAll"		, Lua_GetHitKeyStateAll	},
	//p͊֘A֐
	{ "GetInputChar"			, Lua_GetInputChar	},
	{ "GetInputCharWait"		, Lua_GetInputCharWait	},
	{ "ClearInputCharBuf"		, Lua_ClearInputCharBuf	},
	//{͊֘A֐
	{ "KeyInputString"			, Lua_KeyInputString	},
	{ "KeyInputSingleCharString", Lua_KeyInputSingleCharString	},
	{ "KeyInputNumber"			, Lua_KeyInputNumber	},
	{ "SetKeyInputStringColor"	, Lua_SetKeyInputStringColor	},
	{ "MakeKeyInput"			, Lua_MakeKeyInput	},
	{ "DeleteKeyInput"			, Lua_DeleteKeyInput	},
	{ "InitKeyInput"			, Lua_InitKeyInput	},
	{ "SetActiveKeyInput"		, Lua_SetActiveKeyInput	},
	{ "CheckKeyInput"			, Lua_CheckKeyInput	},
	{ "DrawKeyInputString"		, Lua_DrawKeyInputString	},
	{ "DrawKeyInputModeString"	, Lua_DrawKeyInputModeString	},
	{ "SetKeyInputString"		, Lua_SetKeyInputString	},
	{ "SetKeyInputNumber"		, Lua_SetKeyInputNumber	},
	{ "GetKeyInputString"		, Lua_GetKeyInputString	},
	{ "GetKeyInputNumber"		, Lua_GetKeyInputNumber	},
	//p֐
	{ "PlaySoundFile"			, Lua_PlaySoundFile	},
	{ "CheckSoundFile"			, Lua_CheckSoundFile	},
	{ "StopSoundFile"			, Lua_StopSoundFile	},
	{ "LoadSoundMem"			, Lua_LoadSoundMem	},
	{ "PlaySoundMem"			, Lua_PlaySoundMem	},
	{ "CheckSoundMem"			, Lua_CheckSoundMem	},
	{ "StopSoundMem"			, Lua_StopSoundMem	},
	{ "DeleteSoundMem"			, Lua_DeleteSoundMem	},
	{ "InitSoundMem"			, Lua_InitSoundMem	},
	{ "SetPanSoundMem"			, Lua_SetPanSoundMem	},
	{ "ChangeVolumeSoundMem"	, Lua_ChangeVolumeSoundMem	},
	{ "SetFrequencySoundMem"	, Lua_SetFrequencySoundMem	},
	{ "SetLoopPosSoundMem"		, Lua_SetLoopPosSoundMem	},
	{ "SetLoopSamplePosSoundMem", Lua_SetLoopSamplePosSoundMem	},
	{ "SetCurrentPositionSoundMem", Lua_SetCurrentPositionSoundMem	},
	{ "DuplicateSoundMem"		, Lua_DuplicateSoundMem	},
	//yĐ֐
	{ "PlayMusic"				, Lua_PlayMusic	},
	{ "CheckMusic"				, Lua_CheckMusic	},
	{ "StopMusic"				, Lua_StopMusic	},
	{ "SetVolumeMusic"			, Lua_SetVolumeMusic	},
	//EGCg֌W̊֐
	{ "WaitTimer"				, Lua_WaitTimer	},
	{ "WaitVSync"				, Lua_WaitVSync	},
	{ "WaitKey"					, Lua_WaitKey	},
	//Ԋ֌W̊֐
	{ "GetNowCount"				, Lua_GetNowCount	},
	{ "GetNowHiPerformanceCount", Lua_GetNowHiPerformanceCount	},
	{ "GetDateTime"				, Lua_GetDateTime	},
	//擾֐
	{ "GetRand"		, Lua_GetRand	},
	{ "SRand"		, Lua_SRand	},
	//EChE[h֌W
	{ "ChangeWindowMode"       , Lua_ChangeWindowMode     },
	{ "SetMainWindowText"		, Lua_SetMainWindowText	},
	{ "SetWindowIconID"		, Lua_SetWindowIconID	},
	{ "SetWindowSizeChangeEnableFlag"		, Lua_SetWindowSizeChangeEnableFlag	},
	{ "SetWindowSizeExtendRate"		, Lua_SetWindowSizeExtendRate	},
	//ʐM֌W
	{ "ConnectNetWork"		, Lua_ConnectNetWork	},
	{ "CloseNetWork"		, Lua_CloseNetWork	},
	{ "PreparationListenNetWork"		, Lua_PreparationListenNetWork	},
	{ "StopListenNetWork"		, Lua_StopListenNetWork	},
	{ "NetWorkSend"		, Lua_NetWorkSend	},
	{ "GetNetWorkDataLength"		, Lua_GetNetWorkDataLength	},
	{ "GetNetWorkSendDataLength"		, Lua_GetNetWorkSendDataLength	},
	{ "NetWorkRecv"		, Lua_NetWorkRecv	},
	{ "NetWorkRecvToPeek"		, Lua_NetWorkRecvToPeek	},
	{ "GetNewAcceptNetWork"		, Lua_GetNewAcceptNetWork	},
	{ "GetLostNetWork"		, Lua_GetLostNetWork	},
	{ "GetNetWorkAcceptState"		, Lua_GetNetWorkAcceptState	},
	{ "GetNetWorkIP"		, Lua_GetNetWorkIP	},
	{ "MakeUDPSocket"		, Lua_MakeUDPSocket	},
	{ "DeleteUDPSocket"		, Lua_DeleteUDPSocket	},
	{ "NetWorkSendUDP"		, Lua_NetWorkSendUDP	},
	{ "NetWorkRecvUDP"		, Lua_NetWorkRecvUDP	},
	{ "CheckNetWorkRecvUDP"		, Lua_CheckNetWorkRecvUDP	},
	//t@Cǂݍ݊֌W
	{ "FileRead_open"		, Lua_FileRead_open	},
	{ "FileRead_size"		, Lua_FileRead_size	},
	{ "FileRead_close"		, Lua_FileRead_close	},
	{ "FileRead_tell"		, Lua_FileRead_tell	},
	{ "FileRead_seek"		, Lua_FileRead_seek	},
	{ "FileRead_read"		, Lua_FileRead_read	},
	{ "FileRead_eof"		, Lua_FileRead_eof	},
	{ "FileRead_gets"		, Lua_FileRead_gets	},
	{ "FileRead_getc"		, Lua_FileRead_getc	},
	{ "FileRead_scanf"		, Lua_FileRead_scanf	},
	//hbgPʂŉ摜ɃANZX֌W
	{ "LoadSoftImage"		, Lua_LoadSoftImage	},
	{ "LoadSoftImageToMem"		, Lua_LoadSoftImageToMem	},
	{ "MakeARGB8ColorSoftImage"		, Lua_MakeARGB8ColorSoftImage	},
	{ "MakeXRGB8ColorSoftImage"		, Lua_MakeXRGB8ColorSoftImage	},
	{ "MakePAL8ColorSoftImage"		, Lua_MakePAL8ColorSoftImage	},
	{ "DeleteSoftImage"		, Lua_DeleteSoftImage	},
	{ "InitSoftImage"		, Lua_InitSoftImage	},
	{ "GetSoftImageSize"		, Lua_GetSoftImageSize	},
	{ "FillSoftImage"		, Lua_FillSoftImage	},
	{ "SetPaletteSoftImage"		, Lua_SetPaletteSoftImage	},
	{ "GetPaletteSoftImage"		, Lua_GetPaletteSoftImage	},
	{ "DrawPixelPalCodeSoftImage"		, Lua_DrawPixelPalCodeSoftImage	},
	{ "GetPixelPalCodeSoftImage"		, Lua_GetPixelPalCodeSoftImage	},
	{ "DrawPixelSoftImage"		, Lua_DrawPixelSoftImage	},
	{ "GetPixelSoftImage"		, Lua_GetPixelSoftImage	},
	{ "BltSoftImage"		, Lua_BltSoftImage	},
	{ "DrawSoftImage"		, Lua_DrawSoftImage	},
	{ "CreateGraphFromSoftImage"		, Lua_CreateGraphFromSoftImage	},
	{ "CreateDivGraphFromSoftImage"		, Lua_CreateDivGraphFromSoftImage	},
	//}Ci[֐
	{ "SetUse3DFlag"		, Lua_SetUse3DFlag	},
	{ "GetUse3DFlag"		, Lua_GetUse3DFlag	},
	{ "SetWaitVSyncFlag"		, Lua_SetWaitVSyncFlag	},
	{ "GetColorBitDepth"		, Lua_GetColorBitDepth	},
	{ "DrawVString"		, Lua_DrawVString	},
	{ "DrawVStringToHandle"		, Lua_DrawVStringToHandle	},
	{ "SetGraphDataShavedMode"		, Lua_SetGraphDataShavedMode	},
	{ "SaveDrawScreen"		, Lua_SaveDrawScreen	},
	{ "LoadPauseGraph"		, Lua_LoadPauseGraph	},
	{ "SetOutApplicationLogValidFlag"		, Lua_SetOutApplicationLogValidFlag	},
	{ "SetBasicBlendFlag"		, Lua_SetBasicBlendFlag	},
	{ "SetScreenMemToVramFlag"		, Lua_SetScreenMemToVramFlag	},
	{ "ScreenCopy"		, Lua_ScreenCopy	},
	{ "EnumFontName"		, Lua_EnumFontName	},
	{ "SelectMidiMode"		, Lua_SelectMidiMode	},
	{ "SetAlwaysRunFlag"		, Lua_SetAlwaysRunFlag	},
	{ "GetVideoMemorySize"		, Lua_GetVideoMemorySize	},
	{ "SetUseDivGraphFlag"		, Lua_SetUseDivGraphFlag	},
	{ "SetCreateSoundDataType"		, Lua_SetCreateSoundDataType	},
	{ "CreateGraphFromMem"		, Lua_CreateGraphFromMem	},
	{ "ReCreateGraphFromMem"		, Lua_ReCreateGraphFromMem	},
	{ "ReloadFileGraphAll"		, Lua_ReloadFileGraphAll	},
	{ "SetRestoreGraphCallback"		, Lua_SetRestoreGraphCallback	},
	{ "LoadSoundMemByMemImage"		, Lua_LoadSoundMemByMemImage	},
	{ "SetMaskReverseEffectFlag"		, Lua_SetMaskReverseEffectFlag	},
	{ "SetUseDXArchiveFlag"		, Lua_SetUseDXArchiveFlag	},
	{ "SetDXArchiveExtension"		, Lua_SetDXArchiveExtension	},
	{ "SetDXArchiveKeyString"		, Lua_SetDXArchiveKeyString	},
	{ "SetEmulation320x240"		, Lua_SetEmulation320x240	},

	//**** 3D֘A ****
    // fǂݍ
	{ "MV1LoadModel" ,								Lua_MV1LoadModel								},
	{ "MV1LoadModelFromMem", 						Lua_MV1LoadModelFromMem							},
	{ "MV1DuplicateModel",                          Lua_MV1DuplicateModel							},
	{ "MV1CreateCloneModel",                        Lua_MV1CreateCloneModel							},
	{ "MV1DeleteModel",                             Lua_MV1DeleteModel								},
	{ "MV1InitModel",                               Lua_MV1InitModel								},
	{ "MV1SetLoadModelReMakeNormal",                Lua_MV1SetLoadModelReMakeNormal					},
	{ "MV1SetLoadModelReMakeNormalSmoothingAngle",  Lua_MV1SetLoadModelReMakeNormalSmoothingAngle	},
	{ "MV1SetLoadModelPositionOptimize",            Lua_MV1SetLoadModelPositionOptimize				},
	{ "MV1SetLoadModelUsePhysicsMode",              Lua_MV1SetLoadModelUsePhysicsMode				},
	{ "MV1SetLoadModelPhysicsWorldGravity",         Lua_MV1SetLoadModelPhysicsWorldGravity			},
	{ "MV1SetLoadCalcPhysicsWorldGravity",          Lua_MV1SetLoadCalcPhysicsWorldGravity			},

	// f`֘A
	{ "MV1DrawModel"      , Lua_MV1DrawModel       },
	{ "MV1DrawMesh"       , Lua_MV1DrawMesh        },
	{ "MV1DrawModelDebug" , Lua_MV1DrawModelDebug  },
	{ "MV1DrawFrame"      , Lua_MV1DrawFrame       },

	// f֘A
	{ "MV1GetLocalWorldMatrix"            , Lua_MV1GetLocalWorldMatrix           },
	{ "MV1SetPosition"                    , Lua_MV1SetPosition                   },
	{ "MV1GetPosition"                    , Lua_MV1GetPosition                   },
	{ "MV1SetScale"                       , Lua_MV1SetScale                      },
	{ "MV1GetScale"                       , Lua_MV1GetScale                      },
	{ "MV1SetRotationXYZ"                 , Lua_MV1SetRotationXYZ                },
	{ "MV1GetRotationXYZ"                 , Lua_MV1GetRotationXYZ                },
	{ "MV1SetRotationZYAxis"              , Lua_MV1SetRotationZYAxis             },
	{ "MV1SetRotationMatrix"              , Lua_MV1SetRotationMatrix             },
	{ "MV1GetRotationMatrix"              , Lua_MV1GetRotationMatrix             },
	{ "MV1SetMatrix"                      , Lua_MV1SetMatrix                     },
	{ "MV1GetMatrix"                      , Lua_MV1GetMatrix                     },
	{ "MV1SetVisible"                     , Lua_MV1SetVisible                    },
	{ "MV1GetVisible"                     , Lua_MV1GetVisible                    },
	{ "MV1SetDifColorScale"               , Lua_MV1SetDifColorScale              },
	{ "MV1GetDifColorScale"               , Lua_MV1GetDifColorScale              },
	{ "MV1SetSpcColorScale"               , Lua_MV1SetSpcColorScale              },
	{ "MV1GetSpcColorScale"               , Lua_MV1GetSpcColorScale              },
	{ "MV1SetEmiColorScale"               , Lua_MV1SetEmiColorScale              },
	{ "MV1GetEmiColorScale"               , Lua_MV1GetEmiColorScale              },
	{ "MV1SetAmbColorScale"               , Lua_MV1SetAmbColorScale              },
	{ "MV1GetAmbColorScale"               , Lua_MV1GetAmbColorScale              },
	{ "MV1GetSemiTransState"              , Lua_MV1GetSemiTransState             },
	{ "MV1SetOpacityRate"                 , Lua_MV1SetOpacityRate                },
	{ "MV1GetOpacityRate"                 , Lua_MV1GetOpacityRate                },
	{ "MV1SetUseZBuffer"                  , Lua_MV1SetUseZBuffer                 },
	{ "MV1SetWriteZBuffer"                , Lua_MV1SetWriteZBuffer               },
	{ "MV1SetZBufferCmpType"              , Lua_MV1SetZBufferCmpType             },
	{ "MV1SetZBias"                       , Lua_MV1SetZBias                      },
	{ "MV1SetUseVertDifColor"             , Lua_MV1SetUseVertDifColor            },
	{ "MV1SetUseVertSpcColor"             , Lua_MV1SetUseVertSpcColor            },
	{ "MV1SetSampleFilterMode"            , Lua_MV1SetSampleFilterMode           },
	{ "MV1SetMaxAnisotropy"               , Lua_MV1SetMaxAnisotropy              },
	{ "MV1SetWireFrameDrawFlag"           , Lua_MV1SetWireFrameDrawFlag          },
	{ "MV1RefreshVertColorFromMaterial"   , Lua_MV1RefreshVertColorFromMaterial  },
	{ "MV1PhysicsCalculation"             , Lua_MV1PhysicsCalculation            },
	{ "MV1PhysicsResetState"              , Lua_MV1PhysicsResetState             },
	// J֘A
	{ "SetCameraNearFar"                  , Lua_SetCameraNearFar                   },
	{ "SetCameraPositionAndTarget_UpVecY" , Lua_SetCameraPositionAndTarget_UpVecY  },
	{ "SetCameraPositionAndTargetAndUpVec", Lua_SetCameraPositionAndTargetAndUpVec },
	{ "SetCameraPositionAndAngle",          Lua_SetCameraPositionAndAngle          },
	{ "SetCameraViewMatrix",                Lua_SetCameraViewMatrix                },
	{ "SetCameraScreenCenter",              Lua_SetCameraScreenCenter              },
	{ "SetupCamera_Perspective",            Lua_SetupCamera_Perspective            },
	{ "SetupCamera_Ortho",                  Lua_SetupCamera_Ortho                  },
	{ "SetupCamera_ProjectionMatrix",       Lua_SetupCamera_ProjectionMatrix       },
	{ "SetCameraDotAspect",                 Lua_SetCameraDotAspect                 },
	{ "GetCameraNear",                      Lua_GetCameraNear                      },
	{ "GetCameraFar",                       Lua_GetCameraFar                       },
	{ "GetCameraPosition",                  Lua_GetCameraPosition                  },
	{ "GetCameraTarget",                    Lua_GetCameraTarget                    },
	{ "GetCameraUpVector",                  Lua_GetCameraUpVector                  },
	{ "GetCameraAngleHRotate",              Lua_GetCameraAngleHRotate              },
	{ "GetCameraAngleVRotate",              Lua_GetCameraAngleVRotate              },
	{ "GetCameraAngleTRotate",              Lua_GetCameraAngleTRotate              },
	{ "GetCameraViewMatrix",                Lua_GetCameraViewMatrix                },
	{ "GetCameraBillboardMatrix",           Lua_GetCameraBillboardMatrix           },
	{ "GetCameraFov",                       Lua_GetCameraFov                       },
	{ "GetCameraSize",                      Lua_GetCameraSize                      },
	{ "GetCameraProjectionMatrix",          Lua_GetCameraProjectionMatrix          },
	{ "GetCameraDotAspect",                 Lua_GetCameraDotAspect                 },
	{ "GetCameraViewportMatrix",            Lua_GetCameraViewportMatrix            },
	{ "GetCameraAPIViewportMatrix",         Lua_GetCameraAPIViewportMatrix         },

	{NULL, NULL}
};

LUALIB_API int luaopen_DxLib (lua_State *L) {
	luaL_register(L, "_G", Lua_DxLib );
	return 1;
}


} // extern "C"
