gm = require("gm")
gm:init();

back = gm.Actor(0,0,0,0,0);
back.img = LoadDivGraph( "ball.bmp"  ,16,8, 2,32,32 );
back.dat = {
	[ 0]={[0]=0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	[ 1]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[ 2]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[ 3]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[ 4]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[ 5]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[ 6]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[ 7]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[ 8]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[ 9]={[0]=0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
	[10]={[0]=0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	[11]={[0]=0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	[12]={[0]=0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	[13]={[0]=0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	[14]={[0]=0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
}
back.draw = function(self)
	local x, y;
	for x=0,19,1 do
		for y=0,14,1 do
			DrawGraph( x*32, y*32 , back.img[back.dat[y][x]] );
		end;
	end;
	local ret,x,y;
	local l,m,r,s;
	local mx,my;
	ret,x,y = GetMousePoint();
	l,r,m   = gm:GetMouseInputEx();
	mx = math.floor( (x - 32) / 32 );
	my = math.floor( (y - 32) / 32 );

	gm:drawText(400,10,"x     ="..x.." "..mx);
	gm:drawText(400,30,"y     ="..y.." "..my);
	if l then s = "true" else s="false" end;
	gm:drawText(400,50,"Left  ="..s);
	if m then s = "true" else s="false" end;
	gm:drawText(400,70,"Middle="..s);
	if r then s = "true" else s="false" end;
	gm:drawText(400,90,"Right ="..s);
end;

balls = function( _x, _y, _s )
	a = gm.Actor(_x,_y,0,0,0);
	a.col = 0;
	a.img = {[0]=back.img[1],back.img[2],back.img[3],back.img[4],back.img[5],back.img[6],back.img[7] };
	a.ami = false;
	a.chk = false;
	a.route = 0;
	a.draw = function(self)
		if self.col > 0 then 
			DrawGraph( self.x * 32  , self.y * 32 , self.img[self.col], 1 ) ;
		end;
		if self.ami then
			DrawGraph( self.x * 32  , self.y * 32 , back.img[8], 1 ) ;
		end;
		gm:drawText( self.x * 32, self.y * 32, string.format("%d", self.col) );
	end;
	return a;
end;

STATE = {
	SELECT_BALL  = "SELECT_BALL";
	CHECK_MOVE   = "CHECK_MOVE ";
	SELECT_DIST  = "SELECT_DIST";
	MOVE_BALL    = "MOVE_BALL  ";
	BREAK_BALL   = "BREAK_BALL ";
	ADD_BALL     = "ADD_BALL   ";
	GAME_OVER    = "GAME_OVER  ";
	MENU         = "MENU       ";
}

main = {
	nextBall = {};
	ban = {};
	lineCheckStack = {};
	routeStack = {};

	sx = 0;
	sy = 0;
	dx = 0;
	dy = 0;

	init = function(self)
		local i;
		local x,y;
		gm:add( back );
		for y=0,8,1 do 
			main.ban[y] = {}
			for x=0,8,1 do 
				main.ban[y][x] = balls(x+1,y+1, 0);
				gm:add(main.ban[y][x]);
			end;
		end;
		for i=0,2,1 do
			main.nextBall[i] = balls(10+i,10, 1);
			gm:add(main.nextBall[i]);
		end;
		main:createNextBall();
		main.state = STATE.ADD_BALL;
	end;

	createNextBall= function(self)
		for i=0,2,1 do
			self.nextBall[i].col = math.random(1,6);
		end;
	end;

	dropBall = function(self)
		local x,y;
		for i=0,2,1 do
			repeat 
				x = math.random(0,8);
				y = math.random(0,8);
			until self.ban[y][x].col == 0;
			self.ban[y][x].col = self.nextBall[i].col;
			main:breakball(x,y);
		end;
	end;

	chkMove = function(self, x, y, r )
		r = r + 1;
		local b = main.ban[y][x];
		if b.chk then return end;
		b.chk = true;
		if b.col == 0 then
			b.ami = false;	--ԏ
			b.route = r;
			if x > 0 then main:chkMove( x - 1, y    , r); end;
			if x < 8 then main:chkMove( x + 1, y    , r); end;
			if y > 0 then main:chkMove( x    , y - 1, r); end;
			if y < 8 then main:chkMove( x    , y + 1, r); end;
		end;
	end;

	amikake = function(self,  b )
		local x,y;
		for y=0,8,1 do 
			for x=0,8,1 do 
				main.ban[y][x].chk = false;
				main.ban[y][x].ami = b;
			end;
		end;
	end;

	linechk = function(self, x,y,cx,cy,col,cnt)
		local mx = x + cx;
		local my = y + cy;
		if (mx < 0) or (mx > 8) or (my < 0) or (my > 8) then return cnt end;
		if self.ban[my][mx].col ~= col then return cnt end;
		table.insert(self.lineCheckStack, self.ban[my][mx]);
		return self:linechk(mx,my,cx,cy,col,cnt) + 1;
	end;

	breakball= function(self,x,y)
		local cnt1 = 0;
		local cnt2 = 0;
		local brk = false;
		local cur = { [0]={[0]=-1, 0, 1,0},
		              [1]={[0]= 0,-1, 0,1},
		              [2]={[0]=-1,-1, 1,1},
		              [3]={[0]= 1,-1,-1,1}  };
		for i=0,3,1 do
			self.lineCheckStack = {}
			cnt1 = self:linechk(x,y, cur[i][0],cur[i][1], self.ban[y][x].col, 0 );
			cnt2 = self:linechk(x,y, cur[i][2],cur[i][3], self.ban[y][x].col, 0 );
			if cnt1+cnt2+1 >=5 then
				for i,v in ipairs(self.lineCheckStack) do
--					v.brk =true;
					v.col = 0;
				end;
				brk = true;
			end;
		end;
		if brk then
--			self.ban[y][x].brk = true;
			self.ban[y][x].col = 0;
			return true;
		end;
		return false;
	end;

	clearloute = function(self)
		local x,y;
		for y=0,8,1 do 
			for x=0,8,1 do 
				main.ban[y][x].route = 1000;
			end;
		end;
		routeStack = {};
	end;
	
	setloute = function( self, dx,dy )
		local cur = { [0]={[0]=-1,0},[1]={[0]=1,0},[2]={[0]= 0,-1},[3]={[0]=0,1} };
		local i,x,y;
		local flg = false;
		local b=self.ban[dy][dx];
		print( "routeStack insert" );
		table.insert( main.routeStack,1, b );
		for i=0,3,1 do
			x = dx + cur[i][0];
			y = dy + cur[i][1];
			if (x >= 0) and (x <= 8) and (y >= 0) and (y <= 8) then
				if b.route > self.ban[y][x].route then
					b = self.ban[y][x];
					flg = true;
				end;
			end;
		end;
		if not flg then return; end;
		self:setloute(x,y);
	end;

	isOver = function(self)
		for y=0,8,1 do 
			for x=0,8,1 do 
				if main.ban[y][x].col == 0 then
					return false;
				end;
			end;
		end;
		return true;
	end;
	
	loop = function(self)
		local clicked = false;
		local mouse = gm:GetMouseInputEx();
		bx = math.floor( mouse.x / 32 ) - 1;
		by = math.floor( mouse.y / 32 ) - 1;
		if mouse.l and (bx >= 0) and (bx < 9) and (by >= 0) and (by < 9) then
			clicked = true;
		end;
print( main.state );
		if main.state == STATE.SELECT_BALL then
			if clicked then
				if main.ban[by][bx].col ~= 0 then
					main.state = STATE.CHECK_MOVE
					main.count = 0;
					main.sx = bx;
					main.sy = by;
				end;
			end;
		elseif main.state == STATE.CHECK_MOVE  then
			main:amikake(true);					--Ԋ|
			local c = main.ban[main.sy][main.sx].col;
			main.ban[main.sy][main.sx].col = 0;
			main:chkMove(main.sx,main.sy, 0);				--ړ\`FbN
			main.ban[main.sy][main.sx].col = c;
			main.ban[main.sy][main.sx].ami = true;
			main.state = STATE.SELECT_DIST
			main.count = 0;
		elseif main.state == STATE.SELECT_DIST then
			if mouse.r then
				main:amikake(false);				--Ԋ|
				main.state = STATE.SELECT_BALL
				main.count = 0;
			else 
				if clicked then
					if main.ban[by][bx].ami == false then
						main:clearloute();
						main:setloute(bx,by);
						main.dx = bx;
						main.dy = by;
						main:amikake(false);				--Ԋ|
						main.state = STATE.MOVE_BALL;
						main.count = 0;
					end;
				end;
			end;
		elseif main.state == STATE.MOVE_BALL   then
--			if main.count == 10 then main.count = 0; end;
--			if main.count == 0 then
--				main.routeStack[2].col = main.routeStack[1].col;
--				table.remove(routeStack, 1 );
--			end;
--			if #routeStack == 1 then
				main.ban[main.dy][main.dx].col = main.ban[main.sy][main.sx].col;
				main.ban[main.sy][main.sx].col = 0;
				main.state = STATE.BREAK_BALL;
				main.count = 0;
--			end;
		elseif main.state == STATE.BREAK_BALL  then
			main:breakball(main.dx,main.dy)
			main.state = STATE.ADD_BALL
			main.count = 0;
		elseif main.state == STATE.ADD_BALL    then
			main:dropBall();
			main:createNextBall();
			if main:isOver() then
				main.state = STATE.GAME_OVER
				main.count = 0;
			else
				main.state = STATE.SELECT_BALL
				main.count = 0;
			end;
		elseif main.state == STATE.GAME_OVER   then
			main.state = STATE.MENU
			main.count = 0;
		elseif main.state == STATE.MENU        then
			local x,y;
			for y=0,8,1 do 
				for x=0,8,1 do 
					main.ban[y][x].col = 0;
					main.ban[y][x].chk = false;
					main.ban[y][x].ami = false;
				end;
			end;

		end;
		main.count = main.count + 1;
	end;
}
gm:SetMainLoop(main);
gm:run();
