#include "stdafx.h"


extern "C" {
//

//DxLib_Init	@Cȕ
static int Lua_DxLib_Init(lua_State *L){
	lua_pushnumber( L, (int)DxLib_Init() );
	return 1;
}
//DxLib_End	@Cugp̏I֐
static int Lua_DxLib_End(lua_State *L){
	lua_pushnumber( L, (int)DxLib_End() );
	return 1;
}
//ProcessMessage	@EChEỸbZ[W
static int Lua_ProcessMessage(lua_State *L){
	lua_pushnumber( L, (int)ProcessMessage() );
	return 1;
}

// FPU̐x𗎂ƂȂݒgp邩ǂݒ肷ADxLib_Init ĂяoÔݗL( TRUE:gp(xȂ)  FALSE:gpȂ(x𗎂Ƃ(ftHg) )
static int Lua_SetUseFPUPreserveFlag(lua_State *L){
    int flg = luaL_checkint(L, 1);
	lua_pushnumber( L, (int)SetUseFPUPreserveFlag( flg ) );
	return 1;
}


//}``֐
//
//@`
static int Lua_DrawLine(lua_State *L){
    int x1 = (int)luaL_checknumber(L, 1);
    int y1 = (int)luaL_checknumber(L, 2);
    int x2 = (int)luaL_checknumber(L, 3);
    int y2 = (int)luaL_checknumber(L, 4);
    int c  = (int)luaL_checknumber(L, 5);
    int t  = (int)luaL_checknumber(L, 6);
    lua_pushnumber( L, (int)DrawLine( x1, y1,x2,y2,c,t ) );
    return 1;
}

//@lp`
static int Lua_DrawBox(lua_State *L){
    int x1 = (int)luaL_checknumber(L, 1);
    int y1 = (int)luaL_checknumber(L, 2);
    int x2 = (int)luaL_checknumber(L, 3);
    int y2 = (int)luaL_checknumber(L, 4);
    int c  = (int)luaL_checknumber(L, 5);
    int f  = (int)luaL_checknumber(L, 6);
    lua_pushnumber( L, (int)DrawBox( x1, y1,x2,y2,c,f ) );
    return 1;
}

//@~̕`
static int Lua_DrawCircle(lua_State *L){
    int x  = (int)luaL_checknumber(L, 1);
    int y  = (int)luaL_checknumber(L, 2);
    int r  = (int)luaL_checknumber(L, 3);
    int c  = (int)luaL_checknumber(L, 4);
    int f  = (int)luaL_checknumber(L, 5);
    lua_pushnumber( L, (int)DrawCircle( x, y,r,c,f ) );
    return 1;
}

//@ȉ~̕`
static int Lua_DrawOval(lua_State *L){
    int x1 = (int)luaL_checknumber(L, 1);
    int y1 = (int)luaL_checknumber(L, 2);
    int rx = (int)luaL_checknumber(L, 3);
    int ry = (int)luaL_checknumber(L, 4);
    int c  = (int)luaL_checknumber(L, 5);
    int f  = (int)luaL_checknumber(L, 6);
    lua_pushnumber( L, (int)DrawOval( x1, y1,rx,ry,c,f ) );
    return 1;
}

//@Op`̕`
static int Lua_DrawTriangle(lua_State *L){
    int x1 = (int)luaL_checknumber(L, 1);
    int y1 = (int)luaL_checknumber(L, 2);
    int x2 = (int)luaL_checknumber(L, 3);
    int y2 = (int)luaL_checknumber(L, 4);
    int x3 = (int)luaL_checknumber(L, 5);
    int y3 = (int)luaL_checknumber(L, 6);
    int c  = (int)luaL_checknumber(L, 7);
    int f  = (int)luaL_checknumber(L, 8);
    lua_pushnumber( L, (int)DrawTriangle( x1, y1,x2,y2,x3,y3,c,f ) );
    return 1;
}

//@_`悷
static int Lua_DrawPixel(lua_State *L){
    int x = (int)luaL_checknumber(L, 1);
    int y = (int)luaL_checknumber(L, 2);
    int c = (int)luaL_checknumber(L, 3);
    lua_pushnumber( L, (int)DrawPixel(x, y,c ) );
    return 1;
}

//@w_̐F擾
static int Lua_GetPixel(lua_State *L){
    int x = (int)luaL_checknumber(L, 1);
    int y = (int)luaL_checknumber(L, 2);
    lua_pushnumber( L, (int)GetPixel(x, y) );
    return 1;
}



//
//OtBbNf[^֐

//LoadGraphScreen	@摜t@Cǂ݂ŉʂɕ\
static int Lua_LoadGraphScreen(lua_State *L){
	int x = (int)luaL_checknumber(L, 1);
	int y = (int)luaL_checknumber(L, 2);
	const char * fn = luaL_checkstring(L, 3);
	int f = (int)luaL_checknumber(L, 4);
	lua_pushnumber( L, (int)LoadGraphScreen( x, y,  fn, f ) );
	return 1;
}
//LoadGraph	@摜t@C̃ւ̓ǂ݂݁Ayѓt@C̃[h
static int Lua_LoadGraph(lua_State *L){
	const char * fn = luaL_checkstring(L, 1);
	int f = (int)luaL_optnumber(L, 2, 0);
	lua_pushnumber(L, (int)LoadGraph( fn, f ) );
	return 1;
}

//LoadDivGraph    @摜t@C̃ւ̕ǂ݂
static int Lua_LoadDivGraph(lua_State *L){
    int i;
    const char * fn = luaL_checkstring(L, 1);
    int a  = (int)luaL_checknumber(L, 2);
    int b  = (int)luaL_checknumber(L, 3);
    int c  = (int)luaL_checknumber(L, 4);
    int d  = (int)luaL_checknumber(L, 5);
    int e  = (int)luaL_checknumber(L, 6);
    int f  = (int)luaL_optnumber  (L, 7, 0);
    int *buf = (int*)malloc( sizeof(int) * a );
	int ret = LoadDivGraph( fn, a, b, c,d, e, buf, f );
	if ( ret < 0 ){
		lua_pushnil(L);	// G[
	}else{
		lua_createtable(L, a, 0);           // e[u쐬
		int t = lua_gettop(L);
		for( i=0;i<a;i++ ){
			lua_pushnumber( L, i);			// zԍ(0`)
			lua_pushnumber( L, buf[i] );	// OtBbNnh
			lua_settable (L,t);			// e[uɏ
		}
	}
	free(buf);
    return 1;
}
//MakeGraph	@̃OtBbN쐬
static int Lua_MakeGraph(lua_State *L){
	int x = (int)luaL_checknumber(L, 1);
	int y = (int)luaL_checknumber(L, 2);
	int f = (int)luaL_optnumber(L, 3, 0);
	lua_pushnumber( L, (int)MakeGraph( x, y, f ) );
	return 1;
}

//DrawGraph	@ɓǂ݂񂾃OtBbN̕`
static int Lua_DrawGraph(lua_State *L){
	int x = (int)luaL_checknumber(L, 1);
	int y = (int)luaL_checknumber(L, 2);
	int h = (int)luaL_checknumber(L, 3);
	int f = (int)luaL_optnumber(L, 4, 0);
	lua_pushnumber( L, (int)DrawGraph( x, y, h, f ) );
	return 1;
}
//@ɓǂ݂񂾃OtBbN̂kq]`
static int Lua_DrawTurnGraph(lua_State *L){
	int x = (int)luaL_checknumber(L, 1);
	int y = (int)luaL_checknumber(L, 2);
	int h = (int)luaL_checknumber(L, 3);
	int f = (int)luaL_optnumber(L, 4, 0);
	lua_pushnumber( L, (int)DrawTurnGraph(x,y,h,f) );
	return 1;
}

//@ɓǂ݂񂾃OtBbN̊gk`
static int Lua_DrawExtendGraph(lua_State *L){
	int x1 = (int)luaL_checknumber(L, 1);
	int y1 = (int)luaL_checknumber(L, 2);
	int x2 = (int)luaL_checknumber(L, 3);
	int y2 = (int)luaL_checknumber(L, 4);
	int h  = (int)luaL_checknumber(L, 5);
	int f  = (int)luaL_optnumber(L, 6, 0);
	lua_pushnumber( L, (int)DrawExtendGraph(x1,y1,x2,y2,h,f ) );
	return 1;
}

//@ɓǂ݂񂾃OtBbN̉]`
static int Lua_DrawRotaGraph(lua_State *L){
	int x = (int)luaL_checknumber(L, 1);
	int y = (int)luaL_checknumber(L, 2);
	double r = luaL_checknumber(L, 3);
	double a = luaL_checknumber(L, 4);
	int h  = (int)luaL_checknumber(L, 5);
	int f  = (int)luaL_checknumber(L, 6);
	int t  = (int)luaL_optnumber(L, 7, 0);
	lua_pushnumber( L, (int)DrawRotaGraph(x,y,r,a,h,f,t) );
	return 1;
}

//@ɓǂ݂񂾃OtBbN̉]`(]Sw肠)
static int Lua_DrawRotaGraph2(lua_State *L){
	int x  = (int)luaL_checknumber(L, 1);
	int y  = (int)luaL_checknumber(L, 2);
	int cx = (int)luaL_checknumber(L, 3);
	int cy = (int)luaL_checknumber(L, 4);
	double r = luaL_checknumber(L, 5);
	double a = luaL_checknumber(L, 6);
	int h  = (int)luaL_checknumber(L, 7);
	int f  = (int)luaL_checknumber(L, 8);
	int t  = (int)luaL_optnumber(L, 9, 0);
	lua_pushnumber( L, (int)DrawRotaGraph2(x,y,cx,cy,r,a,h,f,t) );
	return 1;
}

//@ɓǂ݂񂾃OtBbN̎Rό``
static int Lua_DrawModiGraph(lua_State *L){
	int x1  = (int)luaL_checknumber(L, 1);
	int y1  = (int)luaL_checknumber(L, 2);
	int x2  = (int)luaL_checknumber(L, 3);
	int y2  = (int)luaL_checknumber(L, 4);
	int x3  = (int)luaL_checknumber(L, 5);
	int y3  = (int)luaL_checknumber(L, 6);
	int x4  = (int)luaL_checknumber(L, 7);
	int y4  = (int)luaL_checknumber(L, 8);
	int h   = (int)luaL_checknumber(L, 9);
	int f   = (int)luaL_optnumber(L, 10, 0);
	lua_pushnumber( L, (int)DrawModiGraph(x1,y1,x2,y2,x3,y3,x4,y4,h,f) );
	return 1;
}

//@OtBbN̎w`݂̂`
static int Lua_DrawRectGraph(lua_State *L){
	int dx  = (int)luaL_checknumber(L, 1);
	int dy  = (int)luaL_checknumber(L, 2);
	int sx  = (int)luaL_checknumber(L, 3);
	int sy  = (int)luaL_checknumber(L, 4);
	int w   = (int)luaL_checknumber(L, 5);
	int h   = (int)luaL_checknumber(L, 6);
	int g   = (int)luaL_checknumber(L, 7);
	int f   = (int)luaL_checknumber(L, 8);
	int t   = (int)luaL_optnumber(L, 9, 0);
	lua_pushnumber( L, (int)DrawRectGraph(dx,dy,sx,sy,w,h,g,f,t) );
	return 1;
}

//@w̃OtBbN̎w蕔𔲂oĐVȃOtBbN쐬
static int Lua_DerivationGraph(lua_State *L){
	int x  = (int)luaL_checknumber(L, 1);
	int y  = (int)luaL_checknumber(L, 2);
	int w  = (int)luaL_checknumber(L, 3);
	int h  = (int)luaL_checknumber(L, 4);
	int g  = (int)luaL_checknumber(L, 5);
	lua_pushnumber( L, (int)DerivationGraph(x,y,w,h,g) );
	return 1;
}

//@`ɐݒ肳ĂOtBbN̈悩ẅ̃OtBbNǂ݂
static int Lua_GetDrawScreenGraph(lua_State *L){
	int x1  = (int)luaL_checknumber(L, 1);
	int y1  = (int)luaL_checknumber(L, 2);
	int x2  = (int)luaL_checknumber(L, 3);
	int y2  = (int)luaL_checknumber(L, 4);
	int h   = (int)luaL_checknumber(L, 5);
	int f   = (int)luaL_optnumber(L, 9, 1);
	lua_pushnumber( L, (int)GetDrawScreenGraph(x1,y1,x2,y2,h,f) );
	return 1;
}

//@OtBbÑTCY𓾂
static int Lua_GetGraphSize(lua_State *L){
	int x,y;
	int h   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)GetGraphSize(h,&x,&y) );
	lua_pushnumber( L, x );
	lua_pushnumber( L, y );
	return 3;
}

//@ǂ݂񂾃OtBbNf[^ׂč폜
static int Lua_InitGraph(lua_State *L){
	int f   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)InitGraph(f) );
	return 1;
}

//@w̃OtBbNォ폜
static int Lua_DeleteGraph(lua_State *L){
	int h   = (int)luaL_checknumber(L, 1);
	int f   = (int)luaL_optnumber(L, 2, 0);
	lua_pushnumber( L, (int)DeleteGraph(h,f) );
	return 1;
}

//@`惂[hZbg
static int Lua_SetDrawMode(lua_State *L){
	int m   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)SetDrawMode(m) );
	return 1;
}

//@`̍ۂ̃uh[hZbg
static int Lua_SetDrawBlendMode(lua_State *L){
	int m   = (int)luaL_checknumber(L, 1);
	int p   = (int)luaL_checknumber(L, 2);
	lua_pushnumber( L, (int)SetDrawBlendMode(m,p) );
	return 1;
}

//@`PxZbg
static int Lua_SetDrawBright(lua_State *L){
	int r   = (int)luaL_checknumber(L, 1);
	int g   = (int)luaL_checknumber(L, 2);
	int b   = (int)luaL_checknumber(L, 3);
	lua_pushnumber( L, (int)SetDrawBright(r,g,b) );
	return 1;
}

//@OtBbNɐݒ肷铧ߐFZbg
static int Lua_SetTransColor(lua_State *L){
	int r   = (int)luaL_checknumber(L, 1);
	int g   = (int)luaL_checknumber(L, 2);
	int b   = (int)luaL_checknumber(L, 3);
	lua_pushnumber( L, (int)SetTransColor(r,g,b) );
	return 1;
}

//@摜t@Cuh摜ǂݍ
static int Lua_LoadBlendGraph(lua_State *L){
	const char * fn   = luaL_checkstring(L, 1);
//	MultiByteToWideChar(CP_UTF8
	lua_pushnumber( L, (int)LoadBlendGraph(fn) );
	return 1;
}

//@uh摜ƒʏ摜ĕ`悷
static int Lua_DrawBlendGraph(lua_State *L){
	int x   = (int)luaL_checknumber(L, 1);
	int y   = (int)luaL_checknumber(L, 2);
	int h   = (int)luaL_checknumber(L, 3);
	int t   = (int)luaL_checknumber(L, 4);
	int g   = (int)luaL_checknumber(L, 5);
	int p   = (int)luaL_checknumber(L, 6);
	int r   = (int)luaL_checknumber(L, 7);
	lua_pushnumber( L, (int)DrawBlendGraph(x,y,h,t,g,p,r) );
	return 1;
}

//`֌W֐

//@`悷
static int Lua_DrawString(lua_State *L){
	int x   = (int)luaL_checknumber(L, 1);
	int y   = (int)luaL_checknumber(L, 2);
	const char * s   = luaL_checkstring(L, 3);
	int c   = (int)luaL_checknumber(L, 4);
	int e   = (int)luaL_optnumber(L, 5, 0);
	lua_pushnumber( L, (int)DrawString(x,y,s,c,e) );
	return 1;
}

//@t`悷
static int Lua_DrawFormatString(lua_State *L){
	printf("not implemented! [DrawFormatString]\n");
	return 0;
}

//@DrawString ŕ`悳镶̕(hbgP)𓾂
static int Lua_GetDrawStringWidth(lua_State *L){
	const char * s = luaL_checkstring(L, 1);
	int l   = (int)luaL_checknumber(L, 2);
	int f   = (int)luaL_optnumber(L, 3, 0);
	lua_pushnumber( L, (int)GetDrawStringWidth( s,l,f ) );
	return 1;
}

//@DrawFormatString ֐t̕`敝(hbgP)𓾂
static int Lua_GetDrawFormatStringWidth(lua_State *L){
	printf("not implemented! [GetDrawFormatStringWidth]\n");
	return 0;
}

//@`悷镶̃TCYZbg
static int Lua_SetFontSize(lua_State *L){
	int s   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, 	(int)SetFontSize(s) );
	return 1;
}

//@`悷镶̑̕Zbg
static int Lua_SetFontThickness(lua_State *L){
	int p   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, 	(int)SetFontThickness(p) );
	return 1;
}

//@`悷tHgύX
static int Lua_ChangeFont(lua_State *L){
	const char * fn = luaL_checkstring(L, 1);
	int c   = (int)luaL_optnumber(L, 2, -1);
	lua_pushnumber( L, 	(int)ChangeFont( fn, c ) );
	return 1;
}

//@`ɎgptHg̃^CvύX
static int Lua_ChangeFontType(lua_State *L){
	int t   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, 	(int)ChangeFontType(t) );
	return 1;
}

//@VtHgf[^쐬
static int Lua_CreateFontToHandle(lua_State *L){
	const char * fn = luaL_checkstring(L, 1);
	int s   = (int)luaL_checknumber(L, 2);
	int t   = (int)luaL_checknumber(L, 3);
	int ft  = (int)luaL_optnumber(L, 4, -1);
	int cs  = (int)luaL_optnumber(L, 5, -1);
	int es  = (int)luaL_optnumber(L, 6, -1);
	int i   = (int)luaL_optnumber(L, 7,  0);
	int di  = (int)luaL_optnumber(L, 8, -1);
	lua_pushnumber( L, (int)CreateFontToHandle(fn,s,t,ft,cs,es,i,di) );
	return 1;
}

//@tHgf[^폜
static int Lua_DeleteFontToHandle(lua_State *L){
	int h   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)DeleteFontToHandle(h) );
	return 1;
}

//@w̃tHgf[^ŕ`悷
static int Lua_DrawStringToHandle(lua_State *L){
	int x   = (int)luaL_checknumber(L, 1);
	int y   = (int)luaL_checknumber(L, 2);
	const char * s = luaL_checkstring(L, 3);
	int c   = (int)luaL_checknumber(L, 4);
	int h   = (int)luaL_checknumber(L, 5);
	int ec  = (int)luaL_optnumber(L, 6, 0);
	int f   = (int)luaL_optnumber(L, 7, 0);
	lua_pushnumber( L, (int)DrawStringToHandle(x,y,s,c,h,ec,f) );
	return 1;
}

//@w̃tHgf[^ŏt`悷
static int Lua_DrawFormatStringToHandle(lua_State *L){
	printf("not implemented! [DrawFormatStringToHandle]\n");
	return 0;
}

//@w̃tHgf[^ŕ`悷镶̕𓾂
static int Lua_GetDrawStringWidthToHandle(lua_State *L){
	const char * s = luaL_checkstring(L, 1);
	int l  = (int)luaL_checknumber(L, 2);
	int h  = (int)luaL_checknumber(L, 3);
	int f  = (int)luaL_optnumber(L, 4, 0);
	lua_pushnumber( L, (int)GetDrawStringWidthToHandle(s,l,h,f) );
	return 1;
}

//@w̃tHgf[^ŏt̕`敝𓾂
static int Lua_GetDrawFormatStringWidthToHandle(lua_State *L){
	printf("not implemented! [GetDrawFormatStringWidthToHandle]\n");
	return 0;
}

//@w̃tHgf[^̏𓾂
static int Lua_GetFontStateToHandle(lua_State *L){
	char * fn =(char *)luaL_checkstring(L, 1);
	int h  = (int)luaL_optnumber(L, 2, 0);
	int s,t;
	lua_pushnumber( L, (int)GetFontStateToHandle(fn,&s,&t,h) );
	lua_pushnumber( L, s );
	lua_pushnumber( L, t );
	return 3;
}

//@tHgf[^Sď
static int Lua_InitFontToHandle(lua_State *L){
	lua_pushnumber( L, (int)InitFontToHandle() );
	return 1;
}

//ȈՉʏo͊֐
//printfDx	@ȈՕ`
static int Lua_printfDx(lua_State *L){
	const char * fmt = luaL_checkstring(L, 1);
	lua_pushnumber( L, (int)printfDx(fmt) );
	return 1;
}

//@ȈՉʏo͗NA
static int Lua_clsDx(lua_State *L){
	lua_pushnumber( L, (int)clsDx() );
	return 1;
}

//̑ʑn֐

//@ʃ[h̕ύX
static int Lua_SetGraphMode(lua_State *L){
	int x = (int)luaL_checknumber(L, 1);
	int y = (int)luaL_checknumber(L, 2);
	int c = (int)luaL_checknumber(L, 3);
	int r = (int)luaL_optnumber(L, 4, 60);
	lua_pushnumber( L, (int)SetGraphMode( x, y, c, r ) );
	return 1;
}

//@݂̉ʂ̑傫ƃJ[rbg𓾂
static int Lua_GetScreenState(lua_State *L){
	int x,y,d;
	lua_pushnumber( L, (int)GetScreenState(&x,&y,&d) );
	lua_pushnumber( L, x );
	lua_pushnumber( L, y );
	lua_pushnumber( L, d );
	return 4;
}

//@`\̈̃Zbg
static int Lua_SetDrawArea(lua_State *L){
	int x1 = (int)luaL_checknumber(L, 1);
	int y1 = (int)luaL_checknumber(L, 2);
	int x2 = (int)luaL_checknumber(L, 3);
	int y2 = (int)luaL_checknumber(L, 4);
	lua_pushnumber( L, (int)SetDrawArea( x1,y1,x2,y2 ) );
	return 1;
}

//@ʂɕ`ꂽ̂
static int Lua_ClearDrawScreen(lua_State *L){
	lua_pushnumber( L, (int)ClearDrawScreen() );
	return 1;
}

//@FR[h擾
static int Lua_GetColor(lua_State *L){
	int r = (int)luaL_checknumber(L, 1);
	int g = (int)luaL_checknumber(L, 2);
	int b = (int)luaL_checknumber(L, 3);
	lua_pushnumber( L, (int)GetColor(r,g,b) );
	return 1;
}

//@`OtBbN̈̎w
static int Lua_SetDrawScreen(lua_State *L){
	int n = (int)luaL_checknumber(L, 1 );
	lua_pushnumber( L, (int)SetDrawScreen(n) );
	return 1;
}

//@tbv֐Aʂ̗y[W(i͕\ĂȂ)̓e\y[W(i\Ă)ɔf
static int Lua_ScreenFlip(lua_State *L){
	lua_pushnumber( L, (int)ScreenFlip() );
	return 1;
}

// obNOEhJ[ݒ
static int Lua_SetBackgroundColor(lua_State *L){
	int r = (int)luaL_checknumber(L, 1 );
	int g = (int)luaL_checknumber(L, 2 );
	int b = (int)luaL_checknumber(L, 3 );
	lua_pushnumber( L, (int)SetBackgroundColor( r, g, b ) );
	return 1;
}

//֌W֐

//@t@C̍Đ
static int Lua_PlayMovie(lua_State *L){
	const char * fn = luaL_checkstring(L, 1);
	int r  = (int)luaL_checknumber(L, 2);
	int t  = (int)luaL_checknumber(L, 3);
	lua_pushnumber( L, (int)PlayMovie(fn,r,t) );
	return 1;
}

//@[r[OtBbN̓̍ĐJn
static int Lua_PlayMovieToGraph(lua_State *L){
	int h  = (int)luaL_checknumber(L, 1);
	int pt = (int)luaL_optnumber(L, 2, 1);
	int sp = (int)luaL_optnumber(L, 3, 0);
	lua_pushnumber( L, (int)PlayMovieToGraph(h,pt,sp) );
	return 1;
}

//@[r[OtBbN̓Đꎞ~
static int Lua_PauseMovieToGraph(lua_State *L){
	int g = (int)luaL_checknumber(L, 1);
	int p = (int)luaL_optnumber(L, 2, 0);
	lua_pushnumber( L, (int)PauseMovieToGraph(g,p) );
	return 1;
}

//@[r[OtBbN̓̍ĐʒuύX
static int Lua_SeekMovieToGraph(lua_State *L){
	int h  = (int)luaL_checknumber(L, 1);
	int t  = (int)luaL_checknumber(L, 2);
	lua_pushnumber( L, (int)SeekMovieToGraph(h,t) );
	return 1;
}

//@[r[OtBbN̓̍Đʒu𓾂
static int Lua_TellMovieToGraph(lua_State *L){
	int h  = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)TellMovieToGraph(h) );
	return 1;
}

//@[r[OtBbN̓̍ĐԂ𓾂
static int Lua_GetMovieStateToGraph(lua_State *L){
	int h  = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)GetMovieStateToGraph(h) );
	return 1;
}

//}XN֌W֐
//@}XNʂ쐬
static int Lua_CreateMaskScreen(lua_State *L){
	lua_pushnumber( L, (int)CreateMaskScreen() );
	return 1;
}

//@}XNʂ폜
static int Lua_DeleteMaskScreen(lua_State *L){
	lua_pushnumber( L, (int)DeleteMaskScreen() );
	return 1;
}

//@}XNf[^摜t@C(BMP.JPEG.PNG)\z
static int Lua_LoadMask(lua_State *L){
	const char * fn = luaL_checkstring(L, 1);
	lua_pushnumber( L, (int)LoadMask(fn) );
	return 1;
}

//@}XNf[^摜t@C(BMP.JPEG.PNG)番\z
static int Lua_LoadDivMask(lua_State *L){
	const char * fn = luaL_checkstring(L, 1);
	int an  = (int)luaL_checknumber(L, 2);
	int xn  = (int)luaL_checknumber(L, 3);
	int yn  = (int)luaL_checknumber(L, 4);
	int xs  = (int)luaL_checknumber(L, 5);
	int ys  = (int)luaL_checknumber(L, 6);
	int *buf = (int*)malloc( sizeof(int) * an );
	int i;
	lua_pushnumber( L, (int)LoadDivMask(fn,an,xn,yn,xs,ys,buf) );

	// zԂ
    lua_createtable(L, an, 0);
    for( i=0;i<an;i++ ){
        lua_pushinteger(L, i); lua_pushinteger( L, buf[i] ); lua_settable (L,8);
    }
	free(buf);
	return 2;
}

//@}XNf[^}XNʂɕ`悷
static int Lua_DrawMask(lua_State *L){
	int x  = (int)luaL_checknumber(L, 1);
	int y  = (int)luaL_checknumber(L, 2);
	int h  = (int)luaL_checknumber(L, 3);
	int m  = (int)luaL_checknumber(L, 4);
    lua_pushnumber( L, (int)DrawMask(x,y,h,m) );
	return 1;
}

//@w̃}XNʗ̈w̃}XNf[^^CɕׂĖ߂
static int Lua_DrawFillMask(lua_State *L){
	int x1  = (int)luaL_checknumber(L, 1);
	int y1  = (int)luaL_checknumber(L, 2);
	int x2  = (int)luaL_checknumber(L, 3);
	int y2  = (int)luaL_checknumber(L, 4);
	int h   = (int)luaL_checknumber(L, 5);
	lua_pushnumber( L, (int)DrawFillMask(x1,y1,x2,y2,h) );
	return 1;
}

//@}XNf[^폜
static int Lua_DeleteMask(lua_State *L){
	int h   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)DeleteMask(h) );
	return 1;
}

//@}XNf[^
static int Lua_InitMask(lua_State *L){
	lua_pushnumber( L, (int)InitMask() );
	return 1;
}

//@}XNʂw̐FœhԂ
static int Lua_FillMaskScreen(lua_State *L){
	int f   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)FillMaskScreen(f) );
	return 1;
}

//@}XNʂ̗L̗LύX
static int Lua_SetUseMaskScreenFlag(lua_State *L){
	int f   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)SetUseMaskScreenFlag(f) );
	return 1;
}

//@̃}XNf[^̍쐬
static int Lua_MakeMask(lua_State *L){
	int w   = (int)luaL_checknumber(L, 1);
	int h   = (int)luaL_checknumber(L, 2);
	lua_pushnumber( L, (int)MakeMask(w,h) );
	return 1;
}

//@}XNf[^̑傫𓾂
static int Lua_GetMaskSize(lua_State *L){
	int mh   = (int)luaL_checknumber(L, 1);
	int w,h;
	lua_pushnumber( L, (int)GetMaskSize(&w,&h,mh) );
	lua_pushnumber( L, w );
	lua_pushnumber( L, h );
	return 3;
}

//@}XÑf[^}XNf[^̈ɓ]
static int Lua_SetDataToMask(lua_State *L){
	int w   = (int)luaL_checknumber(L, 1);
	int h   = (int)luaL_checknumber(L, 2);
	int mh  = (int)luaL_checknumber(L, 4);
	int * md = (int*)malloc(sizeof(int)*w*h);
	int i;
	for(i=0;i<w*h;i++){
		lua_gettable (L, 3);
		md[i] = lua_tointeger (L, 5);
		lua_pop(L,1);
	}
	lua_pushnumber( L, (int)SetDataToMask(w,h,md,mh) );
	free(md);
	return 1;
}

//@}XÑf[^}XNʂɒڕ`悷
static int Lua_DrawMaskToDirectData(lua_State *L){
	int x   = (int)luaL_checknumber(L, 1);
	int y   = (int)luaL_checknumber(L, 2);
	int w   = (int)luaL_checknumber(L, 3);
	int h   = (int)luaL_checknumber(L, 4);
	int * md = (int*)malloc(sizeof(int)*w*h);
	int i;
	for(i=0;i<w*h;i++){
		lua_gettable (L, 5);
		md[i] = lua_tointeger (L, 7);
		lua_pop(L,1);
	}
	int m   = (int)luaL_checknumber(L, 6);
	lua_pushnumber( L, (int)DrawMaskToDirectData(x,y,w,h,md,m) );
	free(md);
	return 1;
}

//@}XÑf[^^Cɕׂ`Œڃ}XNʑŜɕ`悷
static int Lua_DrawFillMaskToDirectData(lua_State *L){
	int x1   = (int)luaL_checknumber(L, 1);
	int y1   = (int)luaL_checknumber(L, 2);
	int x2   = (int)luaL_checknumber(L, 3);
	int y2   = (int)luaL_checknumber(L, 4);
	int w    = (int)luaL_checknumber(L, 5);
	int h    = (int)luaL_checknumber(L, 6);
	int * md = (int*)malloc(sizeof(int)*w*h);
	int i;
	for(i=0;i<w*h;i++){
		lua_gettable (L, 7);
		md[i] = (int)lua_tonumber (L, 9);
		lua_pop(L,1);
	}
	int m   = (int)luaL_checknumber(L, 8);
	lua_pushnumber( L, (int)DrawFillMaskToDirectData(x1,y1,x2,y2,w,h,md) );
	free(md);
	return 1;
}

//@}XNɎgߐF̃Zbg
static int Lua_SetMaskTransColor(lua_State *L){
	int c   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)SetMaskTransColor(c) );
	return 1;
}

//͊֌W̊֐
//@@WCpbh͊֘A֐
//@WCpbhڑĂ鐔擾
static int Lua_GetJoypadNum(lua_State *L){
	lua_pushnumber( L, (int)GetJoypadNum() );
	return 1;
}

static void pushkeydata(lua_State *L, int k ){
	lua_createtable(L, 0, 32);
	int tbl = lua_gettop(L);
	lua_pushstring(L, "DOWN"  ); lua_pushboolean( L, k&PAD_INPUT_DOWN	 ); lua_settable (L,tbl);
	lua_pushstring(L, "LEFT"  ); lua_pushboolean( L, k&PAD_INPUT_LEFT	 ); lua_settable (L,tbl);
	lua_pushstring(L, "RIGHT" ); lua_pushboolean( L, k&PAD_INPUT_RIGHT	 ); lua_settable (L,tbl);
	lua_pushstring(L, "UP"    ); lua_pushboolean( L, k&PAD_INPUT_UP		 ); lua_settable (L,tbl);
	lua_pushstring(L, "A"     ); lua_pushboolean( L, k&PAD_INPUT_A		 ); lua_settable (L,tbl);
	lua_pushstring(L, "B"     ); lua_pushboolean( L, k&PAD_INPUT_B		 ); lua_settable (L,tbl);
	lua_pushstring(L, "C"     ); lua_pushboolean( L, k&PAD_INPUT_C		 ); lua_settable (L,tbl);
	lua_pushstring(L, "X"     ); lua_pushboolean( L, k&PAD_INPUT_X		 ); lua_settable (L,tbl);
	lua_pushstring(L, "Y"     ); lua_pushboolean( L, k&PAD_INPUT_Y		 ); lua_settable (L,tbl);
	lua_pushstring(L, "Z"     ); lua_pushboolean( L, k&PAD_INPUT_Z		 ); lua_settable (L,tbl);
	lua_pushstring(L, "L"     ); lua_pushboolean( L, k&PAD_INPUT_L		 ); lua_settable (L,tbl);
	lua_pushstring(L, "R"     ); lua_pushboolean( L, k&PAD_INPUT_R		 ); lua_settable (L,tbl);
	lua_pushstring(L, "START" ); lua_pushboolean( L, k&PAD_INPUT_START	 ); lua_settable (L,tbl);
	lua_pushstring(L, "M"     ); lua_pushboolean( L, k&PAD_INPUT_M		 ); lua_settable (L,tbl);
	lua_pushstring(L, "D"     ); lua_pushboolean( L, k&PAD_INPUT_D		 ); lua_settable (L,tbl);
	lua_pushstring(L, "F"     ); lua_pushboolean( L, k&PAD_INPUT_F		 ); lua_settable (L,tbl);
	lua_pushstring(L, "G"     ); lua_pushboolean( L, k&PAD_INPUT_G		 ); lua_settable (L,tbl);
	lua_pushstring(L, "H"     ); lua_pushboolean( L, k&PAD_INPUT_H		 ); lua_settable (L,tbl);
	lua_pushstring(L, "I"     ); lua_pushboolean( L, k&PAD_INPUT_I		 ); lua_settable (L,tbl);
	lua_pushstring(L, "J"     ); lua_pushboolean( L, k&PAD_INPUT_J		 ); lua_settable (L,tbl);
	lua_pushstring(L, "K"     ); lua_pushboolean( L, k&PAD_INPUT_K		 ); lua_settable (L,tbl);
	lua_pushstring(L, "LL"    ); lua_pushboolean( L, k&PAD_INPUT_LL		 ); lua_settable (L,tbl);
	lua_pushstring(L, "N"     ); lua_pushboolean( L, k&PAD_INPUT_N		 ); lua_settable (L,tbl);
	lua_pushstring(L, "O"     ); lua_pushboolean( L, k&PAD_INPUT_O		 ); lua_settable (L,tbl);
	lua_pushstring(L, "P"     ); lua_pushboolean( L, k&PAD_INPUT_P		 ); lua_settable (L,tbl);
	lua_pushstring(L, "RR"    ); lua_pushboolean( L, k&PAD_INPUT_RR		 ); lua_settable (L,tbl);
	lua_pushstring(L, "S"     ); lua_pushboolean( L, k&PAD_INPUT_S		 ); lua_settable (L,tbl);
	lua_pushstring(L, "T"     ); lua_pushboolean( L, k&PAD_INPUT_T		 ); lua_settable (L,tbl);
	lua_pushstring(L, "U"     ); lua_pushboolean( L, k&PAD_INPUT_U		 ); lua_settable (L,tbl);
	lua_pushstring(L, "V"     ); lua_pushboolean( L, k&PAD_INPUT_V		 ); lua_settable (L,tbl);
	lua_pushstring(L, "W"     ); lua_pushboolean( L, k&PAD_INPUT_W		 ); lua_settable (L,tbl);
	lua_pushstring(L, "XX"    ); lua_pushboolean( L, k&PAD_INPUT_XX		 ); lua_settable (L,tbl);
}

//@WCpbh̓͏Ԃ𓾂
static int Lua_GetJoypadInputState(lua_State *L){
	int n = (int)luaL_checknumber( L, 1 );
	int k = GetJoypadInputState(n);
	pushkeydata( L, k );
	return 1;
}

//@WCpbh̓͏Ԃ𓾂 A
static int Lua_GetJoypadInputStateEX(lua_State *L){
	static int oldk = 0;
	int n = (int)luaL_checknumber( L, 1 );
	int k = GetJoypadInputState(n);
	int d = (~oldk) & k;
	int u = oldk & (~k);
	pushkeydata( L, k );
	pushkeydata( L, d );
	pushkeydata( L, u );
	oldk = k;
	return 3;
}

//@WCpbh̃AiOIȃo[͏𓾂
static int Lua_GetJoypadAnalogInput(lua_State *L){
	int t = (int)luaL_checknumber( L, 1 );
	int x,y;
	lua_pushnumber( L, (int)GetJoypadAnalogInput(&x,&y,t) );
	lua_pushnumber( L, x );
	lua_pushnumber( L, y );
	return 3;
}

//@WCpbh̃AiOIȃo[͏𓾂(orpbhEXeBbNp)
static int Lua_GetJoypadAnalogInputRight(lua_State *L){
	int t = (int)luaL_checknumber( L, 1 );
	int x,y;
	lua_pushnumber( L, (int)GetJoypadAnalogInputRight(&x,&y,t) );
	lua_pushnumber( L, x );
	lua_pushnumber( L, y );
	return 3;
}

//@WCpbh̓͂ɑΉL[{[h̓͂ݒ肷
static int Lua_SetJoypadInputToKeyInput(lua_State *L){
	int t  = (int)luaL_checknumber( L, 1 );
	int p  = (int)luaL_checknumber( L, 2 );
	int k1 = (int)luaL_checknumber( L, 3 );
	int k2 = (int)luaL_optnumber( L, 4, -1 );
	int k3 = (int)luaL_optnumber( L, 5, -1 );
	int k4 = (int)luaL_optnumber( L, 6, -1 );
	lua_pushnumber( L, (int)SetJoypadInputToKeyInput(t,p,k1,k2,k3,k4) );
	return 1;
}

//@WCpbh̐UJn
static int Lua_StartJoypadVibration(lua_State *L){
	int i  = (int)luaL_checknumber( L, 1 );
	int t  = (int)luaL_checknumber( L, 2 );
	int p  = (int)luaL_checknumber( L, 3 );
	lua_pushnumber( L, (int)StartJoypadVibration(i,p,t) );
	return 1;
}

//@WCpbh̐U~
static int Lua_StopJoypadVibration(lua_State *L){
	int i  = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)StopJoypadVibration(i) );
	return 1;
}

//@@}EX͊֘A֐
//@}EXJ[\̕\ݒtÕZbg
static int Lua_SetMouseDispFlag(lua_State *L){
	int d  = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)SetMouseDispFlag(d) );
	return 1;
}

//@}EXJ[\̈ʒu擾
static int Lua_GetMousePoint(lua_State *L){
	int x,y ;
	lua_pushnumber( L, (int)GetMousePoint(&x,&y) );
	lua_pushnumber( L, x );
	lua_pushnumber( L, y );
	return 3;
}

//@}EXJ[\̈ʒuZbg
static int Lua_SetMousePoint(lua_State *L){
	int x  = (int)luaL_checknumber( L, 1 );
	int y  = (int)luaL_checknumber( L, 2 );
	lua_pushnumber( L, (int)SetMousePoint(x,y) );
	return 1;
}

//@}EXJ[\̃{^̏Ԃ𓾂
static int Lua_GetMouseInput(lua_State *L){
	int b = GetMouseInput();
	lua_pushboolean( L, b&1 );
	lua_pushboolean( L, b&2 );
	lua_pushboolean( L, b&4 );
	return 3;
}

//@}EXzC[̉]ʂ𓾂
static int Lua_GetMouseWheelRotVol(lua_State *L){
	int r  = (int)luaL_optnumber( L, 1, 1);
	lua_pushnumber( L, (int)GetMouseWheelRotVol(r) );
	return 1;
}

//@@L[{[h͊֘A֐
//@ׂẴL[̉Ԃ擾
static int Lua_CheckHitKeyAll(lua_State *L){
	int t  = (int)luaL_optnumber( L, 1, 7 );
	lua_pushnumber( L, (int)CheckHitKeyAll(t) );
	return 1;
}

//@L[̓͏Ԃ𓾂
static int Lua_CheckHitKey(lua_State *L){
	int flg = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)CheckHitKey( flg ) );
	return 1;
}

//@L[{[ĥׂẴL[̉Ԃ擾
static int Lua_GetHitKeyStateAll(lua_State *L){
	char buf[256];
	int i,top;
	lua_pushnumber( L, (int)GetHitKeyStateAll(buf) );
	lua_createtable(L, 256, 0);
	top = lua_gettop(L);
	for(i=0;i<256;i++){
		lua_pushinteger(L, i); lua_pushinteger( L, buf[i] ); lua_settable(L,top);
	}
	return 1;
}

//@@p͊֘A֐
//@̓obt@ɗ܂f[^P擾
static int Lua_GetInputChar(lua_State *L){
	int f = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)GetInputChar(f) );
	return 1;
}

//@̓obt@ɗ܂f[^P擾Aobt@ɂȂɂR[hȂꍇ̓L[܂ő҂
static int Lua_GetInputCharWait(lua_State *L){
	int f = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)GetInputCharWait(f) );
	return 1;
}

//@̓obt@NA
static int Lua_ClearInputCharBuf(lua_State *L){
	lua_pushnumber( L, (int)ClearInputCharBuf() );
	return 1;
}

//@@{͊֘A֐
//@L[{[hɂ镶̓
static int Lua_KeyInputString(lua_State *L){
	int x = (int)luaL_checknumber( L, 1 );
	int y = (int)luaL_checknumber( L, 2 );
	int l = (int)luaL_checknumber( L, 3 );
	int f = (int)luaL_checknumber( L, 4 );
	char * buf = (char*)malloc(l+1);
	lua_pushnumber( L, (int)KeyInputString(x,y,l,buf,f) );
	lua_pushstring( L, buf );
	free(buf);
	return 1;
}

//@L[{[hɂ锼p݂̂̓
static int Lua_KeyInputSingleCharString(lua_State *L){
	int x = (int)luaL_checknumber( L, 1 );
	int y = (int)luaL_checknumber( L, 2 );
	int l = (int)luaL_checknumber( L, 3 );
	int f = (int)luaL_checknumber( L, 4 );
	char * buf = (char*)malloc(l+1);
	lua_pushnumber( L, (int)KeyInputSingleCharString(x,y,l,buf,f) );
	lua_pushstring( L, buf );
	free(buf);
	return 1;
}

//@L[{[hɂ鐔l̓
static int Lua_KeyInputNumber(lua_State *L){
	int x = (int)luaL_checknumber( L, 1 );
	int y = (int)luaL_checknumber( L, 2 );
	int maxnum = (int)luaL_checknumber( L, 3 );
	int minnum = (int)luaL_checknumber( L, 4 );
	int f = (int)luaL_checknumber( L, 5 );
	lua_pushnumber( L, (int)KeyInputNumber(x,y,maxnum,minnum,f) );
	return 1;
}

//@KeyInputStringn ֐gp̊̕eFύX
static int Lua_SetKeyInputStringColor(lua_State *L){
	int NmlStr        = (int)luaL_checknumber( L,1 );
	int NmlCur        = (int)luaL_checknumber( L,2 );
	int IMEStr        = (int)luaL_checknumber( L,3 );
	int IMECur        = (int)luaL_checknumber( L,4 );
	int IMELine		  = (int)luaL_checknumber( L,5 );
	int IMESelectStr  = (int)luaL_checknumber( L,6 );
	int IMEModeStr	  = (int)luaL_checknumber( L,7 );
	int NmlStrE       = (int)luaL_optnumber  ( L,8,0 ); 
	int IMESelectStrE = (int)luaL_optnumber  ( L,9,0 );
	int IMEModeStrE   = (int)luaL_optnumber  ( L,10,0 );
	int IMESelectWinE = (int)luaL_optnumber  ( L,11,-1 );
	int IMESelectWinF = (int)luaL_optnumber  ( L,12,-1 );
	int SelectStrBackColor = (int)luaL_optnumber( L,13,-1 );
	int SelectStrColor     = (int)luaL_optnumber( L,14,-1 );
	int SelectStrEdgeColor = (int)luaL_optnumber( L,15,-1 );
	lua_pushnumber( L,	(int)SetKeyInputStringColor( NmlStr, NmlCur, IMEStr, IMECur, IMELine, IMESelectStr, IMEModeStr , NmlStrE, 
		                    IMESelectStrE,IMEModeStrE,IMESelectWinE, IMESelectWinF,
							SelectStrBackColor,SelectStrColor,SelectStrEdgeColor) );
	return 1;
}
//@VL[̓f[^̍쐬
static int Lua_MakeKeyInput(lua_State *L){
	int l       = (int)luaL_checknumber( L,1 );
	int v       = (int)luaL_checknumber( L,2 );
	int s       = (int)luaL_checknumber( L,3 );
	int n       = (int)luaL_checknumber( L,4 );
	lua_pushnumber( L,	(int)MakeKeyInput(l,v,s,n) );
	return 1;
}

//@L[̓f[^̍폜
static int Lua_DeleteKeyInput(lua_State *L){
	int h       = (int)luaL_checknumber( L,1 );
	lua_pushnumber( L,	(int)DeleteKeyInput(h) );
	return 1;
}

//@ׂẴL[̓f[^̍폜
static int Lua_InitKeyInput(lua_State *L){
	lua_pushnumber( L,	(int)InitKeyInput() );
	return 1;
}

//@w̃L[͂ANeBuɂ
static int Lua_SetActiveKeyInput(lua_State *L){
	int h       = (int)luaL_checknumber( L,1 );
	lua_pushnumber( L,	(int)SetActiveKeyInput(h) );
	return 1;
}

//@͂IĂ邩擾
static int Lua_CheckKeyInput(lua_State *L){
	int h       = (int)luaL_checknumber( L,1 );
	lua_pushnumber( L,	(int)CheckKeyInput(h) );
	return 1;
}

//@L[͒f[^̕`
static int Lua_DrawKeyInputString(lua_State *L){
	int x       = (int)luaL_checknumber( L,1 );
	int y       = (int)luaL_checknumber( L,2 );
	int h       = (int)luaL_checknumber( L,3 );
	lua_pushnumber( L,	(int)DrawKeyInputString(x,y,h) );
	return 1;
}

//@̓[h`悷
static int Lua_DrawKeyInputModeString(lua_State *L){
	int x       = (int)luaL_checknumber( L,1 );
	int y       = (int)luaL_checknumber( L,2 );
	lua_pushnumber( L, (int)DrawKeyInputModeString(x,y) );
	return 1;
}

//@L[̓f[^Ɏw̕Zbg
static int Lua_SetKeyInputString(lua_State *L){
	char * s =(char *)luaL_checkstring(L, 1);
	int h = (int)luaL_checknumber( L,2 );
	lua_pushnumber( L, (int)SetKeyInputString(s,h) );
	return 1;
}

//@L[̓f[^Ɏw̐l𕶎ɒuăZbg
static int Lua_SetKeyInputNumber(lua_State *L){
	int n       = (int)luaL_checknumber( L,1 );
	int h       = (int)luaL_checknumber( L,2 );
	lua_pushnumber( L, (int)SetKeyInputNumber(n,h) );
	return 1;
}

//@̓f[^̕擾
static int Lua_GetKeyInputString(lua_State *L){
	char * s =(char *)luaL_checkstring(L, 1);
	int h    = (int)luaL_checknumber( L,2 );
	lua_pushnumber( L, (int)GetKeyInputString(s,h) );
	return 1;
}

//@̓f[^̕𐔒lƂĎ擾
static int Lua_GetKeyInputNumber(lua_State *L){
	int h    = (int)luaL_checknumber( L,2 );
	lua_pushnumber( L, (int)GetKeyInputNumber(h) );
	return 1;
}

//p֐
//@t@C(WAV.MP3.Ogg)Đ
static int Lua_PlaySoundFile(lua_State *L){
	const char * f = luaL_checkstring(L, 1);
	int typ = (int)luaL_checknumber(L, 2);
	lua_pushnumber( L, (int)PlaySoundFile( f, typ ) );
	return 1;
}

//@t@CĐׂ
static int Lua_CheckSoundFile(lua_State *L){
	lua_pushnumber( L, (int)CheckSoundFile() );
	return 1;
}

//@t@C̍Đ~߂
static int Lua_StopSoundFile(lua_State *L){
	lua_pushnumber( L, (int)StopSoundFile() );
	return 1;
}

//@t@C(WAV.MP3.Ogg)ɓǂ݂
static int Lua_LoadSoundMem(lua_State *L){
	const char * f = luaL_checkstring(L, 1);
	lua_pushnumber( L, (int)LoadSoundMem( f ) );
	return 1;
}

//@ɓǂ݂񂾉f[^Đ
static int Lua_PlaySoundMem(lua_State *L){
	int h   = (int)luaL_checknumber(L, 1);
	int typ = (int)luaL_checknumber(L, 2);
	int flg = (int)luaL_checknumber(L, 3);
	lua_pushnumber( L, (int)PlaySoundMem( h, typ, flg ) );
	return 1;
}

//@ɓǂ݂񂾉f[^Đׂ
static int Lua_CheckSoundMem(lua_State *L){
	int h   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)CheckSoundMem( h ) );
	return 1;
}

//@ɓǂݍ񂾉f[^̍Đ~߂
static int Lua_StopSoundMem(lua_State *L){
	int h   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)StopSoundMem( h ) );
	return 1;
}

//@ɓǂ݂񂾃TEhf[^폜
static int Lua_DeleteSoundMem(lua_State *L){
	int h   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)DeleteSoundMem( h ) );
	return 1;
}

//@ɓǂ݂񂾉f[^ׂď
static int Lua_InitSoundMem(lua_State *L){
	lua_pushnumber( L, (int)InitSoundMem() );
	return 1;
}

//@ɓǂ݂񂾉f[^̍ĐɃpݒ肷
static int Lua_SetPanSoundMem(lua_State *L){
	int p   = (int)luaL_checknumber(L, 1);
	int h   = (int)luaL_checknumber(L, 2);
	lua_pushnumber( L, (int)SetPanSoundMem( p, h ) );
	return 1;
}

//@ɓǂ݂񂾉f[^̍ĐɃ{[ݒ肷
static int Lua_ChangeVolumeSoundMem(lua_State *L){
	int v   = (int)luaL_checknumber(L, 1);
	int h   = (int)luaL_checknumber(L, 2);
	lua_pushnumber( L, (int)ChangeVolumeSoundMem( v, h ) );
	return 1;
}

//@ɓǂݍ񂾉f[^̍Đgݒ肷
static int Lua_SetFrequencySoundMem(lua_State *L){
	int v   = (int)luaL_checknumber(L, 1);
	int h   = (int)luaL_checknumber(L, 2);
	lua_pushnumber( L, (int)SetFrequencySoundMem( v, h ) );
	return 1;
}

//@ɓǂݍ񂾉f[^̃[vʒuݒ肷
static int Lua_SetLoopPosSoundMem(lua_State *L){
	int l   = (int)luaL_checknumber(L, 1);
	int h   = (int)luaL_checknumber(L, 2);
	lua_pushnumber( L, (int)SetLoopPosSoundMem( l, h ) );
	return 1;
}

//@ɓǂݍ񂾉f[^̃[vʒuݒ肷(Tvʒuw)
static int Lua_SetLoopSamplePosSoundMem(lua_State *L){
	int l   = (int)luaL_checknumber(L, 1);
	int h   = (int)luaL_checknumber(L, 2);
	lua_pushnumber( L, (int)SetLoopSamplePosSoundMem( l, h ) );
	return 1;
}

//@ɓǂݍ񂾉f[^̍ĐʒuTvPʂŕύX
static int Lua_SetCurrentPositionSoundMem(lua_State *L){
	int p   = (int)luaL_checknumber(L, 1);
	int h   = (int)luaL_checknumber(L, 2);
	lua_pushnumber( L, (int)SetCurrentPositionSoundMem( p, h ) );
	return 1;
}

//@Ƀɓǂݍł鉹f[^gpTEhnhVɍ쐬( Xg[TEĥ )
static int Lua_DuplicateSoundMem(lua_State *L){
	int h   = (int)luaL_checknumber(L,1);
	lua_pushnumber( L, (int)DuplicateSoundMem( h ) );
	return 1;
}

//yĐ֐
//@lhch͂loRt@Ct(Đ)
static int Lua_PlayMusic(lua_State *L){
	const char * f = luaL_checkstring(L, 1);
	int t   = (int)luaL_checknumber(L, 2);
	lua_pushnumber( L, (int)PlayMusic( f, t ) );
	return 1;
}

//@lhch͂loRt@Ct(Đ)̏擾
static int Lua_CheckMusic(lua_State *L){
	lua_pushnumber( L, (int)CheckMusic() );
	return 1;
}

//@lhch͂loRt@C̉t(Đ)~
static int Lua_StopMusic(lua_State *L){
	lua_pushnumber( L, (int)StopMusic() );
	return 1;
}

//@lhch͂loRt@C̉t(Đ)̉ʂݒ肷
static int Lua_SetVolumeMusic(lua_State *L){
	int v   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)SetVolumeMusic( v ) );
	return 1;
}

//EGCg֌W̊֐
//@w̎ԂƂ߂
static int Lua_WaitTimer(lua_State *L){
	int t   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)WaitTimer( t ) );
	return 1;
}

//@bqs̐Mw񐔑҂
static int Lua_WaitVSync(lua_State *L){
	int n   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)WaitVSync( n ) );
	return 1;
}

//@L[̓͑҂
static int Lua_WaitKey(lua_State *L){
	lua_pushnumber( L, (int)WaitKey() );
	return 1;
}

//Ԋ֌W̊֐
//@~bPʂ̐xJE^̌ݒl𓾂
static int Lua_GetNowCount(lua_State *L){
	lua_pushnumber( L, (int)GetNowCount() );
	return 1;
}

//@GetNowCount̍xo[W
static int Lua_GetNowHiPerformanceCount(lua_State *L){
//	int f   = luaL_optnumber(L, 1, 0);
//	lua_pushnumber( L, GetNowHiPerformanceCount(f) );
//	return 1;
	printf("not implemented! [GetNowHiPerformanceCount]\n");
	return 0;
}

//@ݎ擾
static int Lua_GetDateTime(lua_State *L){
	DATEDATA buf;
	lua_pushnumber( L, (int)GetDateTime(&buf) );
	lua_createtable(L, 0, 6);
	lua_pushstring(L, "Year" ); lua_pushinteger( L, buf.Year ); lua_settable (L,2);
	lua_pushstring(L, "Mon"  ); lua_pushinteger( L, buf.Mon	 ); lua_settable (L,2);
	lua_pushstring(L, "Day"  ); lua_pushinteger( L, buf.Day	 ); lua_settable (L,2);
	lua_pushstring(L, "Hour" ); lua_pushinteger( L, buf.Hour ); lua_settable (L,2);
	lua_pushstring(L, "min"  ); lua_pushinteger( L, buf.Min  ); lua_settable (L,2);
	lua_pushstring(L, "sec"  ); lua_pushinteger( L, buf.Sec  ); lua_settable (L,2);
	return 1;
}

//擾֐
//
//@擾
static int Lua_GetRand(lua_State *L){
	int m   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)GetRand(m) );
	return 1;
}

//@̏lݒ肷
static int Lua_SRand(lua_State *L){
	int s  = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)SRand(s) );
	return 1;
}

//EChE[h֌W
//@EChE[hEtXN[[h̕ύXs
static int Lua_ChangeWindowMode(lua_State *L){
	int flg = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)ChangeWindowMode( flg ) );
	return 1;
}
//@EChẼ^CgύX
static int Lua_SetMainWindowText(lua_State *L){
	const char * t = luaL_checkstring(L, 1);
	lua_pushnumber( L, (int)SetMainWindowText( t ) );
	return 1;
}

//@EChẼACRύX
static int Lua_SetWindowIconID(lua_State *L){
	printf("not implemented! [SetWindowIconID]\n");
	return 0;
}

//@EChE[h̎ɃEChẼTCYRɕύXo悤ɂ邩ǂݒ肷
static int Lua_SetWindowSizeChangeEnableFlag(lua_State *L){
	int flg = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)SetWindowSizeChangeEnableFlag( flg ) );
	return 1;
}

//@EChE[h̎̃EChȆ傫ƕ`ʂ̑傫̔䗦ݒ肷
static int Lua_SetWindowSizeExtendRate(lua_State *L){
	double rt = luaL_checknumber(L, 1);
	lua_pushnumber( L, (int)SetWindowSizeExtendRate( rt ) );
	return 1;
}

//ʐM֌W
//@̃}Vɐڑ
static int Lua_ConnectNetWork(lua_State *L){
	IPDATA d;
	d.d1 = (int)luaL_checknumber( L, 1 );
	d.d2 = (int)luaL_checknumber( L, 2 );
	d.d3 = (int)luaL_checknumber( L, 3 );
	d.d4 = (int)luaL_checknumber( L, 4 );
	int p = (int)luaL_optnumber( L, 5, -1 );
	lua_pushnumber( L, (int)ConnectNetWork(d,p) );
	return 1;
}

//@ڑI
static int Lua_CloseNetWork(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)CloseNetWork(h) );
	return 1;
}

//@ڑ󂯕tԂɂ
static int Lua_PreparationListenNetWork(lua_State *L){
	int p = (int)luaL_optnumber( L, 1, -1 );
	lua_pushnumber( L, (int)PreparationListenNetWork(p) );
	return 1;
}

//@ڑ󂯕tĂԂ
static int Lua_StopListenNetWork(lua_State *L){
	lua_pushnumber( L, (int)StopListenNetWork() );
	return 1;
}

//@f[^𑗐M
static int Lua_NetWorkSend(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	int l = (int)luaL_checknumber( L, 3 );
	char * buf = (char*)malloc(l);
	int i;
	for(i=0;i<l;i++){
		lua_gettable (L, 2);
		buf[l] = lua_tointeger(L, 4);
		lua_pop(L,1);
	}
	lua_pushnumber( L, (int)NetWorkSend(h,buf,l) );
	free(buf);
	return 1;
}

//@Mf[^ꎞLobt@ɗ܂Ăf[^̗ʂ𓾂
static int Lua_GetNetWorkDataLength(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)GetNetWorkDataLength(h) );
	return 1;
}

//@M̃f[^̗ʂ𓾂
static int Lua_GetNetWorkSendDataLength(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)GetNetWorkSendDataLength(h) );
	return 1;
}

//@Mf[^ꎞLobt@ɗ܂Ăf[^擾
static int Lua_NetWorkRecv(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	int l = (int)luaL_checknumber( L, 2 );
	char * buf = (char*)malloc( l );
	int i;
	lua_pushnumber( L,(int)NetWorkRecv(h,buf,l) );
	lua_createtable(L, l, 0);
	for(i=0;i<l;i++ ){
        lua_pushinteger(L, i); lua_pushinteger( L, buf[i] ); lua_settable(L,3);
	}
	free(buf);	
	return 2;
}

//@Mf[^ǂݍށAǂݍ񂾃f[^̓obt@폜Ȃ
static int Lua_NetWorkRecvToPeek(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	int l = (int)luaL_checknumber( L, 2 );
	char * buf = (char*)malloc( l );
	int i;
	lua_pushnumber( L,(int)NetWorkRecvToPeek(h,buf,l) );
	lua_createtable(L, l, 0);
	for(i=0;i<l;i++ ){
        lua_pushinteger(L, i); lua_pushinteger( L, buf[i] ); lua_settable(L,3);
	}
	free(buf);	
	return 2;
}

//@VɊmڑlbg[Nnh𓾂
static int Lua_GetNewAcceptNetWork(lua_State *L){
	lua_pushnumber( L,(int)GetNewAcceptNetWork() );
	return 1;
}

//@Vɔjꂽڑlbg[Nnh𓾂
static int Lua_GetLostNetWork(lua_State *L){
	lua_pushnumber( L, (int)GetLostNetWork() );
	return 1;
}

//@ڑԂ擾
static int Lua_GetNetWorkAcceptState(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)GetNetWorkAcceptState(h) );
	return 1;
}

//@ڑ̂hoAhX𓾂
static int Lua_GetNetWorkIP(lua_State *L){
	IPDATA buf;
	int h = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)GetNetWorkIP(h,&buf) );
	lua_pushnumber( L, buf.d1 );
	lua_pushnumber( L, buf.d2 );
	lua_pushnumber( L, buf.d3 );
	lua_pushnumber( L, buf.d4 );
	return 5;
}

//
//@tcogpĒʐM邽߂̃\Pbg쐬
static int Lua_MakeUDPSocket(lua_State *L){
	int p = (int)luaL_optnumber( L, 1, -1 );
	lua_pushnumber( L, (int)MakeUDPSocket(p) );
	return 1;
}

//
//@tcogpĒʐM邽߂̃\Pbg폜
static int Lua_DeleteUDPSocket(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, 	(int)DeleteUDPSocket(h) );
	return 1;
}

//
//@tcogpđ̃}VɃf[^𑗐M
static int Lua_NetWorkSendUDP(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	IPDATA ip;
	ip.d1 = (int)luaL_checknumber( L, 2 );
	ip.d2 = (int)luaL_checknumber( L, 3 );
	ip.d3 = (int)luaL_checknumber( L, 4 );
	ip.d4 = (int)luaL_checknumber( L, 5 );
	int port = (int)luaL_checknumber( L, 6 );
	int l = (int)luaL_checknumber( L, 8 );

	char * buf = (char*)malloc(l);
	int i;
	for(i=0;i<l;i++){
		lua_gettable (L, 7);
		buf[i] = lua_tointeger (L, 9);
		lua_pop(L,1);
	}
	lua_pushnumber( L, (int)NetWorkSendUDP(h,ip,port,buf,l) );
	free(buf);
	return 1;
}

//
//@tcogpđ̃}Ṽf[^M
static int Lua_NetWorkRecvUDP(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	IPDATA ip;
	int port;
	int l = (int)luaL_checknumber( L, 2 );
	int p = (int)luaL_checknumber( L, 3 );
	char * buf = (char*)malloc(l);
	int i;
	lua_pushnumber( L, (int)NetWorkRecvUDP(h,&ip,&port,buf,l,p ) );
	lua_pushnumber( L, ip.d1 );
	lua_pushnumber( L, ip.d2 );
	lua_pushnumber( L, ip.d3 );
	lua_pushnumber( L, ip.d4 );
	lua_pushnumber( L, port );
	lua_createtable(L, l, 0);
	int t = lua_gettop(L);
	for(i=0;i<l;i++ ){
        lua_pushinteger(L, i); lua_pushinteger( L, buf[i] ); lua_settable(L,t);
	}
	free(buf);	
	return 7;
}

//
//@tcogp̃}VMf[^邩ǂ擾
static int Lua_CheckNetWorkRecvUDP(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)CheckNetWorkRecvUDP(h) );
	return 1;
}

//t@Cǂݍ݊֌W
//@t@CJ
static int Lua_FileRead_open(lua_State *L){
	const char * p = luaL_checkstring( L, 1 );
	int s = (int)luaL_optnumber( L, 2, 0 );
	lua_pushnumber( L, (int)FileRead_open(p,s) );
	return 1;
}

//@t@C̃TCY𓾂
static int Lua_FileRead_size(lua_State *L){
	const char * p = luaL_checkstring( L, 1 );
	lua_pushnumber( L, (int)FileRead_size(p) );
	return 1;
}

//@t@C
static int Lua_FileRead_close(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)FileRead_close(h) );
	return 1;
}

//@t@C|C^̈ʒu𓾂
static int Lua_FileRead_tell(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)FileRead_tell(h) );
	return 1;
}

//@t@C|C^̈ʒuύX
static int Lua_FileRead_seek(lua_State *L){
	int h = (int)luaL_checknumber( L, 1 );
	int s = (int)luaL_checknumber( L, 2 );
	int o = (int)luaL_checknumber( L, 3 );
	lua_pushnumber( L, (int)FileRead_seek(h,s,o) );
	return 1;
}

//@t@Cf[^ǂݍ
static int Lua_FileRead_read(lua_State *L){
	int siz = (int)luaL_checknumber( L, 1 );
	int h   = (int)luaL_checknumber( L, 2 );
	char * buf = (char*)malloc( siz );
	int i;
	lua_pushnumber( L,(int)FileRead_read(buf,siz,h) );
	lua_createtable(L, siz, 0);
	for(i=0;i<siz;i++ ){
        lua_pushinteger(L, i); lua_pushinteger( L, buf[i] ); lua_settable(L,4);
	}
	free(buf);	
	return 2;
}

//@t@C̏I[ǂ𒲂ׂ
static int Lua_FileRead_eof(lua_State *L){
	int h   = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L,(int)FileRead_eof(h) );
	return 1;
}

//@t@Csǂݏo
static int Lua_FileRead_gets(lua_State *L){
	int siz  = (int)luaL_checknumber( L, 1 );
	int h    = (int)luaL_checknumber( L, 2 );
	char * buf = (char*)malloc( siz );
	lua_pushnumber( L,(int)FileRead_gets(buf,siz, h) );
	lua_pushstring( L, buf );
	return 2;
}

//@t@Cꕶǂݏo
static int Lua_FileRead_getc(lua_State *L){
	int h    = (int)luaL_checknumber( L, 1 );
	TCHAR c = FileRead_getc(h);
	lua_pushnumber( L, c );
	return 1;
}

//@t@C珑tf[^ǂݏo
static int Lua_FileRead_scanf(lua_State *L){
	printf("not implemented! [FileRead_scanf]\n");
	return 0;
}

//hbgPʂŉ摜ɃANZX֌W
//@botňC[W̓ǂݍ
static int Lua_LoadSoftImage(lua_State *L){
//	const char * fn = luaL_checkstring( L, 1 );
//	lua_pushnumber( L, LoadSoftImage(fn) );
	printf("not implemented! [LoadSoftImage]\n");
	return 0;
}

//@botňC[W̃̓ǂݍ
static int Lua_LoadSoftImageToMem(lua_State *L){
//	LoadSoftImageToMem(buf, siz);
	printf("not implemented! [LoadSoftImageToMem]\n");
	return 0;
}

//@botňC[W̍쐬( RGBA8 J[ )
static int Lua_MakeARGB8ColorSoftImage(lua_State *L){
	printf("not implemented! [MakeARGB8ColorSoftImage]\n");
	return 0;
}

//@botňC[W̍쐬( XRGB8 J[ )
static int Lua_MakeXRGB8ColorSoftImage(lua_State *L){
	printf("not implemented! [MakeXRGB8ColorSoftImage]\n");
	return 0;
}

//@botňC[W̍쐬( pbgQTUF J[ )
static int Lua_MakePAL8ColorSoftImage(lua_State *L){
	printf("not implemented! [MakePAL8ColorSoftImage]\n");
	return 0;
}

//@botňC[W̉
static int Lua_DeleteSoftImage(lua_State *L){
	printf("not implemented! [DeleteSoftImage]\n");
	return 0;
}

//@botňC[WSĉ
static int Lua_InitSoftImage(lua_State *L){
	printf("not implemented! [InitSoftImage]\n");
	return 0;
}

//@botňC[W̃TCY擾
static int Lua_GetSoftImageSize(lua_State *L){
	printf("not implemented! [GetSoftImageSize]\n");
	return 0;
}

//@botňC[WwFœhԂ(eFvf͂O`QTT)
static int Lua_FillSoftImage(lua_State *L){
	printf("not implemented! [FillSoftImage]\n");
	return 0;
}

//@botňC[W̃pbgZbg(eFvf͂O`QTT)
static int Lua_SetPaletteSoftImage(lua_State *L){
	printf("not implemented! [SetPaletteSoftImage]\n");
	return 0;
}

//@botňC[W̃pbg擾(eFvf͂O`QTT)
static int Lua_GetPaletteSoftImage(lua_State *L){
	printf("not implemented! [GetPaletteSoftImage]\n");
	return 0;
}

//@botňC[W̎wWɃhbg`悷(pbg摜pALl͂O`QTT)
static int Lua_DrawPixelPalCodeSoftImage(lua_State *L){
	printf("not implemented! [DrawPixelPalCodeSoftImage]\n");
	return 0;
}

//@botňC[W̎wW̐FR[h擾(pbg摜pA߂l͂O`QTT)
static int Lua_GetPixelPalCodeSoftImage(lua_State *L){
	printf("not implemented! [GetPixelPalCodeSoftImage]\n");
	return 0;
}

//@botňC[W̎wWɃhbg`悷(eFvf͂O`QTT)
static int Lua_DrawPixelSoftImage(lua_State *L){
	printf("not implemented! [DrawPixelSoftImage]\n");
	return 0;
}

//@botňC[W̎wW̐F擾(eFvf͂O`QTT)
static int Lua_GetPixelSoftImage(lua_State *L){
	printf("not implemented! [GetPixelSoftImage]\n");
	return 0;
}

//@botňC[Wʂ̃C[Wɓ]
static int Lua_BltSoftImage(lua_State *L){
	printf("not implemented! [BltSoftImage]\n");
	return 0;
}

//@botňC[Wʂɕ`悷
static int Lua_DrawSoftImage(lua_State *L){
	printf("not implemented! [DrawSoftImage]\n");
	return 0;
}

//@botňC[WOtBbNnh쐬
static int Lua_CreateGraphFromSoftImage(lua_State *L){
	printf("not implemented! [CreateGraphFromSoftImage]\n");
	return 0;
}

//@botňC[W番OtBbNnh쐬
static int Lua_CreateDivGraphFromSoftImage(lua_State *L){
	printf("not implemented! [CreateDivGraphFromSoftImage]\n");
	return 0;
}

//}Ci[֐
//@Rc@\gÃtOZbg
static int Lua_SetUse3DFlag(lua_State *L){
	int h    = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)SetUse3DFlag(h) );
	return 1;
}

//@ʂ̕`ɂRcANZ[^gĂ邩Ȁ𓾂
static int Lua_GetUse3DFlag(lua_State *L){
	lua_pushnumber( L, (int)GetUse3DFlag() );
	return 1;
}

//@ScreenFlip֐sɂbqs̐M҂邩̃tOZbg
static int Lua_SetWaitVSyncFlag(lua_State *L){
	int f    = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)SetWaitVSyncFlag(f) );
	return 1;
}

//@ʂ̐Frbg𓾂
static int Lua_GetColorBitDepth(lua_State *L){
	lua_pushnumber( L, (int)GetColorBitDepth() );
	return 1;
}

//@cɕ`悷
static int Lua_DrawVString(lua_State *L){
	int x    = (int)luaL_checknumber( L, 1 );
	int y    = (int)luaL_checknumber( L, 2 );
	const char * s = luaL_checkstring( L, 3 );
	int c    = (int)luaL_checknumber( L, 4 );
	int e    = (int)luaL_optnumber( L, 5, 0 );
	lua_pushnumber( L, (int)DrawVString(x,y,s,c,e) );
	return 1;
}

//@tHgnhgpĕcɕ`悷
static int Lua_DrawVStringToHandle(lua_State *L){
	int x    = (int)luaL_checknumber( L, 1 );
	int y    = (int)luaL_checknumber( L, 2 );
	const char * s = luaL_checkstring( L, 3 );
	int c    = (int)luaL_checknumber( L, 4 );
	int h    = (int)luaL_checknumber( L, 5 );
	int e    = (int)luaL_optnumber( L, 6, 0 );
	lua_pushnumber( L, (int)DrawVStringToHandle(x,y,s,c,h,e) );
	return 1;
}

//@OtBbNF̉摜򉻊ɘa[h̕ύX
static int Lua_SetGraphDataShavedMode(lua_State *L){
	int m    = (int)luaL_checknumber( L, 1 );
	lua_pushnumber( L, (int)SetGraphDataShavedMode(m) );
	return 1;
}

//@ݕ`ΏۂɂȂĂʂalo`ŕۑ
static int Lua_SaveDrawScreen(lua_State *L){
	int x1    = (int)luaL_checknumber( L, 1 );
	int y1    = (int)luaL_checknumber( L, 2 );
	int x2    = (int)luaL_checknumber( L, 3 );
	int y2    = (int)luaL_checknumber( L, 4 );
	const char * fn = luaL_checkstring(L, 5);
	int typ   = (int)luaL_optnumber(L, 6,  0);
	int jq    = (int)luaL_optnumber(L, 7, 80);
	int js    = (int)luaL_optnumber(L, 8,  1);
	int pcmp  = (int)luaL_optnumber(L, 9, -1);
	lua_pushnumber( L,	(int)SaveDrawScreen(x1,y1,x2,y2,fn,typ,jq,js,pcmp) );
	return 1;
}

//@tH[JX̃\tgɈڂĂƂɃobNOEhɕ\OtBbÑ[hAo^(NULL ŉ)
static int Lua_LoadPauseGraph(lua_State *L){
	const char * fn = luaL_checkstring(L, 1);
	lua_pushnumber( L,	(int)LoadPauseGraph( fn ) );
	return 1;
}

//@Oo͂sۂ̃Zbg
static int Lua_SetOutApplicationLogValidFlag(lua_State *L){
	int flg   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L,(int)SetOutApplicationLogValidFlag(flg) );
	return 1;
}

//@RcANZ[^gȂ`揈Ȋȗꂽgp邩ۂύX
static int Lua_SetBasicBlendFlag(lua_State *L){
	int flg   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L,(int)SetBasicBlendFlag(flg));
	return 1;
}

//@ʂ̉摜f[^uq`lɔzu邩ǂύX
static int Lua_SetScreenMemToVramFlag(lua_State *L){
	int flg   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L,(int)SetScreenMemToVramFlag(flg) );
	return 1;
}

//@ʃRs[֐Aʂ̗y[Wii͕\ĂȂj\y[Wii\ĂjɃRs[
static int Lua_ScreenCopy(lua_State *L){
	lua_pushnumber( L,(int)ScreenCopy() );
	return 1;
}

//@gp\ȃtHg̖O񋓂
static int Lua_EnumFontName(lua_State *L){
	int flg = (int)luaL_checknumber(L, 1);
	int cnt = EnumFontName(NULL,0,flg );
	int i;
	char * buf =(char*) malloc( 64 * cnt );
	lua_pushnumber( L,(int)EnumFontName( buf,cnt,flg ) );
    lua_createtable(L, cnt, 0);
    for( i=0;i<cnt;i++ ){
        lua_pushinteger(L, i); lua_pushstring( L, buf+i*64 ); lua_settable (L,3);
    }
	free(buf);
	return 2;
}	

//@lhch̉t`ԂZbg
static int Lua_SelectMidiMode(lua_State *L){
	int mode  = (int)luaL_checknumber(L,1);
	lua_pushnumber( L,(int)SelectMidiMode(mode) );
	return 1;
}

//@EChEANeBuł͂ȂԂł𑱍s邩AtOZbg
static int Lua_SetAlwaysRunFlag(lua_State *L){
	int f  = (int)luaL_checknumber(L,1);
	lua_pushnumber( L,(int)SetAlwaysRunFlag(f) );
	return 1;
}

//@rfI̗eʂ𓾂
static int Lua_GetVideoMemorySize(lua_State *L){
	int a, f;
	lua_pushnumber( L,(int)GetVideoMemorySize(&a,&f) );
	lua_pushnumber( L, a );
	lua_pushnumber( L, f );
	return 3;
}

//@KvȂOtBbN̕sۂݒ肷
static int Lua_SetUseDivGraphFlag(lua_State *L){
	int f  = (int)luaL_checknumber(L,1);
	lua_pushnumber( L,(int)SetUseDivGraphFlag(f) );
	return 1;
}

//@쐬鉹f[^̍Đ`ݒ肷
static int Lua_SetCreateSoundDataType(lua_State *L){
	int t  = (int)luaL_checknumber(L,1);
	lua_pushnumber( L,(int)SetCreateSoundDataType(t) );
	return 1;
}

//@̉摜t@CC[WOtBbNnh쐬
static int Lua_CreateGraphFromMem(lua_State *L){
	printf("not implemented! [CreateGraphFromMem]\n");
	return 0;
}

//@̉摜t@CC[W̃OtBbNnhɃf[^]
static int Lua_ReCreateGraphFromMem(lua_State *L){
	printf("not implemented! [ReCreateGraphFromMem]\n");
	return 0;
}

//@摜t@C쐬OtBbNnhɍēx摜t@C摜ǂݍ
static int Lua_ReloadFileGraphAll(lua_State *L){
	printf("not implemented! [ReloadFileGraphAll]\n");
	return 0;
}

//@OtBbNnh֐o^
static int Lua_SetRestoreGraphCallback(lua_State *L){
	printf("not implemented! [SetRestoreGraphCallback]\n");
	return 0;
}

//@̉t@CC[WTEhnh쐬
static int Lua_LoadSoundMemByMemImage(lua_State *L){
	printf("not implemented! [LoadSoundMemByMemImage]\n");
	return 0;
}

//@}XN̐lɑ΂ʂt]邩ǂݒ肷
static int Lua_SetMaskReverseEffectFlag(lua_State *L){
	int f  = (int)luaL_checknumber(L, 1);
    lua_pushnumber( L,(int)SetMaskReverseEffectFlag(f) );
	return 1;
}

//@cwA[JCut@C̓ǂݍ݋@\gǂݒ肷
static int Lua_SetUseDXArchiveFlag(lua_State *L){
	int f  = (int)luaL_checknumber(L, 1);
    lua_pushnumber( L,(int)SetUseDXArchiveFlag( f ) );
	return 1;
}

//@cwA[JCut@C̊gqύX
static int Lua_SetDXArchiveExtension(lua_State *L){
	const char * buf  = luaL_checkstring(L, 1);
    lua_pushnumber( L,(int)SetDXArchiveExtension( buf ) );
	return 1;
}

//@cwA[JCut@Čݒ肷
static int Lua_SetDXArchiveKeyString(lua_State *L){
	const char * buf  = luaL_checkstring(L, 1);
    lua_pushnumber( L,(int)SetDXArchiveKeyString( buf ) );
	return 1;
}

//@USOSWỎʂłRQOQSỎʉ𑜓xɂ邩ǂ̃tOZbgAUSOSWOȊỎ𑜓xł͖
static int Lua_SetEmulation320x240(lua_State *L){
	int f   = (int)luaL_checknumber(L, 1);
	lua_pushnumber( L,(int)SetEmulation320x240(f) );
	return 1;
}

static const luaL_Reg Lua_DxLib[] = {
	//
	{ "DxLib_Init"              , Lua_DxLib_Init        },
	{ "DxLib_End"               , Lua_DxLib_End         },
	{ "ProcessMessage"         , Lua_ProcessMessage     },
	{ "SetUseFPUPreserveFlag"   , Lua_SetUseFPUPreserveFlag },
	//}``֐
	{ "DrawLine"				, Lua_DrawLine			},
	{ "DrawBox"					, Lua_DrawBox			},
	{ "DrawCircle"				, Lua_DrawCircle		},
	{ "DrawOval"				, Lua_DrawOval			},
	{ "DrawTriangle"			, Lua_DrawTriangle		},
	{ "DrawPixel"				, Lua_DrawPixel			},
	{ "GetPixel"				, Lua_GetPixel			},
	//OtBbNf[^֐
	{ "LoadGraphScreen"         , Lua_LoadGraphScreen      },
	{ "LoadGraph"               , Lua_LoadGraph            },
	{ "LoadDivGraph"            , Lua_LoadDivGraph         },
	{ "MakeGraph"               , Lua_MakeGraph            },
	{ "DrawGraph"               , Lua_DrawGraph            },
	{ "DrawTurnGraph"			, Lua_DrawTurnGraph			},
	{ "DrawExtendGraph"			, Lua_DrawExtendGraph		},
	{ "DrawRotaGraph"			, Lua_DrawRotaGraph			},
	{ "DrawRotaGraph2"			, Lua_DrawRotaGraph2		},
	{ "DrawModiGraph"			, Lua_DrawModiGraph			},
	{ "DrawRectGraph"			, Lua_DrawRectGraph			},
	{ "DerivationGraph"			, Lua_DerivationGraph		},
	{ "GetDrawScreenGraph"		, Lua_GetDrawScreenGraph	},
	{ "GetGraphSize"			, Lua_GetGraphSize			},
	{ "InitGraph"				, Lua_InitGraph				},
	{ "DeleteGraph"				, Lua_DeleteGraph			},
	{ "SetDrawMode"				, Lua_SetDrawMode			},
	{ "SetDrawBlendMode"		, Lua_SetDrawBlendMode		},
	{ "SetDrawBright"			, Lua_SetDrawBright			},
	{ "SetTransColor"			, Lua_SetTransColor			},
	{ "LoadBlendGraph"			, Lua_LoadBlendGraph		},
	{ "DrawBlendGraph"			, Lua_DrawBlendGraph		},
	//`֌W֐
	{ "DrawString"							, Lua_DrawString				},
	{ "DrawFormatString"					, Lua_DrawFormatString			},
	{ "GetDrawStringWidth"					, Lua_GetDrawStringWidth		},
	{ "GetDrawFormatStringWidth"			, Lua_GetDrawFormatStringWidth	},
	{ "SetFontSize"							, Lua_SetFontSize				},
	{ "SetFontThickness"					, Lua_SetFontThickness			},
	{ "ChangeFont"							, Lua_ChangeFont				},
	{ "ChangeFontType"						, Lua_ChangeFontType			},
	{ "CreateFontToHandle"					, Lua_CreateFontToHandle		},
	{ "DeleteFontToHandle"					, Lua_DeleteFontToHandle		},
	{ "DrawStringToHandle"					, Lua_DrawStringToHandle		},
	{ "DrawFormatStringToHandle"			, Lua_DrawFormatStringToHandle	},
	{ "GetDrawStringWidthToHandle"			, Lua_GetDrawStringWidthToHandle	},
	{ "GetDrawFormatStringWidthToHandle"	, Lua_GetDrawFormatStringWidthToHandle	},
	{ "GetFontStateToHandle"				, Lua_GetFontStateToHandle	},
	{ "InitFontToHandle"					, Lua_InitFontToHandle	},
	//ȈՉʏo͊֐
	{ "printfDx"               , Lua_printfDx             },
	{ "clsDx"                  , Lua_clsDx                },
	//̑ʑn֐
	{ "SetGraphMode"           , Lua_SetGraphMode		},
	{ "GetScreenState"         , Lua_GetScreenState		},
	{ "SetDrawArea"            , Lua_SetDrawArea		},
	{ "ClearDrawScreen"        , Lua_ClearDrawScreen      },
	{ "GetColor"               , Lua_GetColor             },
	{ "SetDrawScreen"          , Lua_SetDrawScreen        },
	{ "ScreenFlip"             , Lua_ScreenFlip           },
	{ "SetBackgroundColor"     , Lua_SetBackgroundColor   },
	//֌W֐
	{ "PlayMovie"                   , Lua_PlayMovie	},
	{ "PlayMovieToGraph"            , Lua_PlayMovieToGraph	},
	{ "PauseMovieToGraph"           , Lua_PauseMovieToGraph	},
	{ "SeekMovieToGraph"            , Lua_SeekMovieToGraph	},
	{ "TellMovieToGraph"            , Lua_TellMovieToGraph	},
	{ "GetMovieStateToGraph"        , Lua_GetMovieStateToGraph	},
	//}XN֌W֐
	{ "CreateMaskScreen"		, Lua_CreateMaskScreen	},
	{ "DeleteMaskScreen"		, Lua_DeleteMaskScreen	},
	{ "LoadMask"				, Lua_LoadMask	},
	{ "LoadDivMask"				, Lua_LoadDivMask	},
	{ "DrawMask"				, Lua_DrawMask	},
	{ "DrawFillMask"			, Lua_DrawFillMask	},
	{ "DeleteMask"				, Lua_DeleteMask	},
	{ "InitMask"				, Lua_InitMask	},
	{ "FillMaskScreen"			, Lua_FillMaskScreen	},
	{ "SetUseMaskScreenFlag"	, Lua_SetUseMaskScreenFlag	},
	{ "MakeMask"				, Lua_MakeMask	},
	{ "GetMaskSize"				, Lua_GetMaskSize	},
	{ "SetDataToMask"			, Lua_SetDataToMask	},
	{ "DrawMaskToDirectData"	, Lua_DrawMaskToDirectData	},
	{ "DrawFillMaskToDirectData", Lua_DrawFillMaskToDirectData	},
	{ "SetMaskTransColor"		, Lua_SetMaskTransColor	},
	//͊֌W̊֐
	{ "GetJoypadNum"			, Lua_GetJoypadNum	},
	{ "GetJoypadInputState"		, Lua_GetJoypadInputState	},
	{ "GetJoypadInputStateEX"	, Lua_GetJoypadInputStateEX	},
	{ "GetJoypadAnalogInput"	, Lua_GetJoypadAnalogInput	},
	{ "GetJoypadAnalogInputRight", Lua_GetJoypadAnalogInputRight	},
	{ "SetJoypadInputToKeyInput", Lua_SetJoypadInputToKeyInput	},
	{ "StartJoypadVibration"	, Lua_StartJoypadVibration	},
	{ "StopJoypadVibration"		, Lua_StopJoypadVibration	},
	//}EX͊֘A֐
	{ "SetMouseDispFlag"		, Lua_SetMouseDispFlag	},
	{ "GetMousePoint"			, Lua_GetMousePoint	},
	{ "SetMousePoint"			, Lua_SetMousePoint	},
	{ "GetMouseInput"			, Lua_GetMouseInput	},
	{ "GetMouseWheelRotVol"		, Lua_GetMouseWheelRotVol	},
	//L[{[h͊֘A֐
	{ "CheckHitKeyAll"			, Lua_CheckHitKeyAll	},
	{ "CheckHitKey"				, Lua_CheckHitKey          },
	{ "GetHitKeyStateAll"		, Lua_GetHitKeyStateAll	},
	//p͊֘A֐
	{ "GetInputChar"			, Lua_GetInputChar	},
	{ "GetInputCharWait"		, Lua_GetInputCharWait	},
	{ "ClearInputCharBuf"		, Lua_ClearInputCharBuf	},
	//{͊֘A֐
	{ "KeyInputString"			, Lua_KeyInputString	},
	{ "KeyInputSingleCharString", Lua_KeyInputSingleCharString	},
	{ "KeyInputNumber"			, Lua_KeyInputNumber	},
	{ "SetKeyInputStringColor"	, Lua_SetKeyInputStringColor	},
	{ "MakeKeyInput"			, Lua_MakeKeyInput	},
	{ "DeleteKeyInput"			, Lua_DeleteKeyInput	},
	{ "InitKeyInput"			, Lua_InitKeyInput	},
	{ "SetActiveKeyInput"		, Lua_SetActiveKeyInput	},
	{ "CheckKeyInput"			, Lua_CheckKeyInput	},
	{ "DrawKeyInputString"		, Lua_DrawKeyInputString	},
	{ "DrawKeyInputModeString"	, Lua_DrawKeyInputModeString	},
	{ "SetKeyInputString"		, Lua_SetKeyInputString	},
	{ "SetKeyInputNumber"		, Lua_SetKeyInputNumber	},
	{ "GetKeyInputString"		, Lua_GetKeyInputString	},
	{ "GetKeyInputNumber"		, Lua_GetKeyInputNumber	},
	//p֐
	{ "PlaySoundFile"			, Lua_PlaySoundFile	},
	{ "CheckSoundFile"			, Lua_CheckSoundFile	},
	{ "StopSoundFile"			, Lua_StopSoundFile	},
	{ "LoadSoundMem"			, Lua_LoadSoundMem	},
	{ "PlaySoundMem"			, Lua_PlaySoundMem	},
	{ "CheckSoundMem"			, Lua_CheckSoundMem	},
	{ "StopSoundMem"			, Lua_StopSoundMem	},
	{ "DeleteSoundMem"			, Lua_DeleteSoundMem	},
	{ "InitSoundMem"			, Lua_InitSoundMem	},
	{ "SetPanSoundMem"			, Lua_SetPanSoundMem	},
	{ "ChangeVolumeSoundMem"	, Lua_ChangeVolumeSoundMem	},
	{ "SetFrequencySoundMem"	, Lua_SetFrequencySoundMem	},
	{ "SetLoopPosSoundMem"		, Lua_SetLoopPosSoundMem	},
	{ "SetLoopSamplePosSoundMem", Lua_SetLoopSamplePosSoundMem	},
	{ "SetCurrentPositionSoundMem", Lua_SetCurrentPositionSoundMem	},
	{ "DuplicateSoundMem"		, Lua_DuplicateSoundMem	},
	//yĐ֐
	{ "PlayMusic"				, Lua_PlayMusic	},
	{ "CheckMusic"				, Lua_CheckMusic	},
	{ "StopMusic"				, Lua_StopMusic	},
	{ "SetVolumeMusic"			, Lua_SetVolumeMusic	},
	//EGCg֌W̊֐
	{ "WaitTimer"				, Lua_WaitTimer	},
	{ "WaitVSync"				, Lua_WaitVSync	},
	{ "WaitKey"					, Lua_WaitKey	},
	//Ԋ֌W̊֐
	{ "GetNowCount"				, Lua_GetNowCount	},
	{ "GetNowHiPerformanceCount", Lua_GetNowHiPerformanceCount	},
	{ "GetDateTime"				, Lua_GetDateTime	},
	//擾֐
	{ "GetRand"		, Lua_GetRand	},
	{ "SRand"		, Lua_SRand	},
	//EChE[h֌W
	{ "ChangeWindowMode"       , Lua_ChangeWindowMode     },
	{ "SetMainWindowText"		, Lua_SetMainWindowText	},
	{ "SetWindowIconID"		, Lua_SetWindowIconID	},
	{ "SetWindowSizeChangeEnableFlag"		, Lua_SetWindowSizeChangeEnableFlag	},
	{ "SetWindowSizeExtendRate"		, Lua_SetWindowSizeExtendRate	},
	//ʐM֌W
	{ "ConnectNetWork"		, Lua_ConnectNetWork	},
	{ "CloseNetWork"		, Lua_CloseNetWork	},
	{ "PreparationListenNetWork"		, Lua_PreparationListenNetWork	},
	{ "StopListenNetWork"		, Lua_StopListenNetWork	},
	{ "NetWorkSend"		, Lua_NetWorkSend	},
	{ "GetNetWorkDataLength"		, Lua_GetNetWorkDataLength	},
	{ "GetNetWorkSendDataLength"		, Lua_GetNetWorkSendDataLength	},
	{ "NetWorkRecv"		, Lua_NetWorkRecv	},
	{ "NetWorkRecvToPeek"		, Lua_NetWorkRecvToPeek	},
	{ "GetNewAcceptNetWork"		, Lua_GetNewAcceptNetWork	},
	{ "GetLostNetWork"		, Lua_GetLostNetWork	},
	{ "GetNetWorkAcceptState"		, Lua_GetNetWorkAcceptState	},
	{ "GetNetWorkIP"		, Lua_GetNetWorkIP	},
	{ "MakeUDPSocket"		, Lua_MakeUDPSocket	},
	{ "DeleteUDPSocket"		, Lua_DeleteUDPSocket	},
	{ "NetWorkSendUDP"		, Lua_NetWorkSendUDP	},
	{ "NetWorkRecvUDP"		, Lua_NetWorkRecvUDP	},
	{ "CheckNetWorkRecvUDP"		, Lua_CheckNetWorkRecvUDP	},
	//t@Cǂݍ݊֌W
	{ "FileRead_open"		, Lua_FileRead_open	},
	{ "FileRead_size"		, Lua_FileRead_size	},
	{ "FileRead_close"		, Lua_FileRead_close	},
	{ "FileRead_tell"		, Lua_FileRead_tell	},
	{ "FileRead_seek"		, Lua_FileRead_seek	},
	{ "FileRead_read"		, Lua_FileRead_read	},
	{ "FileRead_eof"		, Lua_FileRead_eof	},
	{ "FileRead_gets"		, Lua_FileRead_gets	},
	{ "FileRead_getc"		, Lua_FileRead_getc	},
	{ "FileRead_scanf"		, Lua_FileRead_scanf	},
	//hbgPʂŉ摜ɃANZX֌W
	{ "LoadSoftImage"		, Lua_LoadSoftImage	},
	{ "LoadSoftImageToMem"		, Lua_LoadSoftImageToMem	},
	{ "MakeARGB8ColorSoftImage"		, Lua_MakeARGB8ColorSoftImage	},
	{ "MakeXRGB8ColorSoftImage"		, Lua_MakeXRGB8ColorSoftImage	},
	{ "MakePAL8ColorSoftImage"		, Lua_MakePAL8ColorSoftImage	},
	{ "DeleteSoftImage"		, Lua_DeleteSoftImage	},
	{ "InitSoftImage"		, Lua_InitSoftImage	},
	{ "GetSoftImageSize"		, Lua_GetSoftImageSize	},
	{ "FillSoftImage"		, Lua_FillSoftImage	},
	{ "SetPaletteSoftImage"		, Lua_SetPaletteSoftImage	},
	{ "GetPaletteSoftImage"		, Lua_GetPaletteSoftImage	},
	{ "DrawPixelPalCodeSoftImage"		, Lua_DrawPixelPalCodeSoftImage	},
	{ "GetPixelPalCodeSoftImage"		, Lua_GetPixelPalCodeSoftImage	},
	{ "DrawPixelSoftImage"		, Lua_DrawPixelSoftImage	},
	{ "GetPixelSoftImage"		, Lua_GetPixelSoftImage	},
	{ "BltSoftImage"		, Lua_BltSoftImage	},
	{ "DrawSoftImage"		, Lua_DrawSoftImage	},
	{ "CreateGraphFromSoftImage"		, Lua_CreateGraphFromSoftImage	},
	{ "CreateDivGraphFromSoftImage"		, Lua_CreateDivGraphFromSoftImage	},
	//}Ci[֐
	{ "SetUse3DFlag"		, Lua_SetUse3DFlag	},
	{ "GetUse3DFlag"		, Lua_GetUse3DFlag	},
	{ "SetWaitVSyncFlag"		, Lua_SetWaitVSyncFlag	},
	{ "GetColorBitDepth"		, Lua_GetColorBitDepth	},
	{ "DrawVString"		, Lua_DrawVString	},
	{ "DrawVStringToHandle"		, Lua_DrawVStringToHandle	},
	{ "SetGraphDataShavedMode"		, Lua_SetGraphDataShavedMode	},
	{ "SaveDrawScreen"		, Lua_SaveDrawScreen	},
	{ "LoadPauseGraph"		, Lua_LoadPauseGraph	},
	{ "SetOutApplicationLogValidFlag"		, Lua_SetOutApplicationLogValidFlag	},
	{ "SetBasicBlendFlag"		, Lua_SetBasicBlendFlag	},
	{ "SetScreenMemToVramFlag"		, Lua_SetScreenMemToVramFlag	},
	{ "ScreenCopy"		, Lua_ScreenCopy	},
	{ "EnumFontName"		, Lua_EnumFontName	},
	{ "SelectMidiMode"		, Lua_SelectMidiMode	},
	{ "SetAlwaysRunFlag"		, Lua_SetAlwaysRunFlag	},
	{ "GetVideoMemorySize"		, Lua_GetVideoMemorySize	},
	{ "SetUseDivGraphFlag"		, Lua_SetUseDivGraphFlag	},
	{ "SetCreateSoundDataType"		, Lua_SetCreateSoundDataType	},
	{ "CreateGraphFromMem"		, Lua_CreateGraphFromMem	},
	{ "ReCreateGraphFromMem"		, Lua_ReCreateGraphFromMem	},
	{ "ReloadFileGraphAll"		, Lua_ReloadFileGraphAll	},
	{ "SetRestoreGraphCallback"		, Lua_SetRestoreGraphCallback	},
	{ "LoadSoundMemByMemImage"		, Lua_LoadSoundMemByMemImage	},
	{ "SetMaskReverseEffectFlag"		, Lua_SetMaskReverseEffectFlag	},
	{ "SetUseDXArchiveFlag"		, Lua_SetUseDXArchiveFlag	},
	{ "SetDXArchiveExtension"		, Lua_SetDXArchiveExtension	},
	{ "SetDXArchiveKeyString"		, Lua_SetDXArchiveKeyString	},
	{ "SetEmulation320x240"		, Lua_SetEmulation320x240	},
	{NULL, NULL}
};

LUALIB_API int luaopen_DxLib (lua_State *L) {
	luaL_register(L, "_G", Lua_DxLib );
	return 1;
}

} // extern "C"
