#
# Copyright (c) 2023 supercell
#
# SPDX-License-Identifier: BSD-3-Clause
#

module Luce
  # Parses unordered lists
  class UnorderedListSyntax < ListSyntax
    getter pattern : Regex = Luce.ul_pattern

    getter list_tag : String = "ul"

    def can_parse?(parser : BlockParser) : Bool
      # Check if it matches `hrPattern`, otherwise it will produce an infinite
      # loop if put `UnorderedListSyntax` or `UnorderedListWithCheckboxSyntax`
      # bofore `HorizontalRuleSyntax` and parse:
      # ```
      # * * *
      # ```
      return false if Luce.hr_pattern.matches?(parser.current)

      pattern.matches?(parser.current)
    end
  end
end
