package myapp.oap4pmahjong.test;

import java.util.Enumeration;
import java.util.Vector;

public class Sutehai {

	public static final int POS_UNDER = 0;
	public static final int POS_RIGHT = 1;
	public static final int POS_LEFT  = 2;
	public static final int POS_UPPER = 3;
	
	public static final int STAY_HOLD = 0;
	public static final int STAY_STAY = 1;
	public static final int STAY_AWAY = 2;
	
	private static Sutehai[] sutehai = null;
	
	public static Sutehai getInstance(int position) {
		if (sutehai == null) {
			sutehai = new Sutehai[4];
			for (int i = 0; i < 4; i++) {
				sutehai[i] = new Sutehai(i);
			}
		}
		return sutehai[position % 4];
	}
	
	public static class Hai {
		private final int 		haiId;
		private final boolean 	riichi;
		private final boolean	pass;
		private int   			stay;
		
		private Hai(int haiId, boolean pass, boolean riichi, int stay) {
			this.haiId  = haiId;
			this.pass	= pass;
			this.riichi = riichi;
			if ((stay == Sutehai.STAY_HOLD) || (stay == Sutehai.STAY_STAY)) { 
				this.stay   = stay;
			} else {
				this.stay 	= Sutehai.STAY_AWAY;
			}
		}

		public int getHaiId() {
			return this.haiId;
		}
		
		public boolean isRiichi() {
			return this.riichi;
		}
		
		public boolean isPass() {
			return this.pass;
		}
		
		public int getStay() {
			return this.stay;
		}

		private boolean setStay(int stay) {
			if ((this.stay == Sutehai.STAY_HOLD) || (stay != Sutehai.STAY_HOLD)) { 
				this.stay = stay;
				return true;
			} else {
				return false;
			}
		}
	}
	
	private final Vector 	hailist;
	private final int 		position;
	
	private Sutehai(int position) {
		this.position = position;
		this.hailist  = new Vector();
	}
	
	public int getPosition() {
		return this.position;
	}
	
	public boolean add(int haiId, boolean pass, boolean riichi) {
		if (this.hailist.size() > 0) {
			Sutehai.Hai last = (Sutehai.Hai)this.hailist.lastElement();
			if (last.getStay() == Sutehai.STAY_HOLD) {
				return false;
			}
		}
		this.hailist.addElement(new Sutehai.Hai(haiId, pass, riichi, Sutehai.STAY_HOLD));
		return true;
	}
	
	public boolean settle(int stay) {
		if (this.hailist.size() == 0) {
			return false;
		}
		Sutehai.Hai hold = (Sutehai.Hai)this.hailist.lastElement();
		return hold.setStay(stay);
	}
	
	public Enumeration getHais() {
		return this.hailist.elements();
	}
	
	public void clear() {
		this.hailist.removeAllElements();
	}
	
	public boolean existHaiNum(int hainum) {
		for (Enumeration e = this.hailist.elements(); e.hasMoreElements(); ) {
			Sutehai.Hai hai = (Sutehai.Hai)e.nextElement();
			if (hainum == (hai.getHaiId() / 4)) {
				return true;
			}
		}
		return false;
	}
	
}
