package myapp.oap4pmahjong.test;

public class Setting {

	public static final int AKA_0 = 0;
	public static final int AKA_2 = 2;
	public static final int AKA_3 = 3;
	public static final int AKA_4 = 4;
	public static final int AKA_6 = 6;
	
	private static Setting setting = null;

	public static final Setting getInstance() {
		if (Setting.setting == null) {
			Setting.setting = new Setting();
		}
		return Setting.setting;
	}

	private int aka = Setting.AKA_3;
	
	private Setting() {
	}
	
	public int getAka() {
		return this.aka;
	}
	
	public boolean isAka(int haiId) {
		switch (this.aka) {
		case Setting.AKA_2:
			return (haiId == 52) || (haiId == 53);
		case Setting.AKA_3:
			return (haiId == 16) || (haiId == 52) || (haiId == 88);
		case Setting.AKA_4:
			return (haiId == 16) || (haiId == 52) || (haiId == 53) || (haiId == 88);
		case Setting.AKA_6:
			return (haiId == 16) || (haiId == 17) 
					|| (haiId == 52) || (haiId == 53)
					|| (haiId == 88) || (haiId == 89);
		default:
			return false;
		}
	}
	
	public void setAka(int aka) {
		switch (aka) {
		case Setting.AKA_2:
		case Setting.AKA_3:
		case Setting.AKA_4:
		case Setting.AKA_6:
			this.aka = aka;
			break;
		default:
			this.aka = Setting.AKA_0;
			break;
		}
	}
}
