package myapp.oap4pmahjong.test;

import java.io.IOException;
import java.util.Enumeration;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

import myapp.oap4pmahjong.MainMIDlet;

public class HaiDrawer {
	
	public static final int HAI_WIDTH 	= 10;
	public static final int HAI_HEIGHT 	= 13;
	
	public static final int HAIID_URA	= -1;
	
	public static final int ROT_UNDER_UNDER_EDGE = Sprite.TRANS_NONE;
	public static final int ROT_UNDER_RIGHT_EDGE = Sprite.TRANS_ROT90;
	public static final int ROT_UNDER_UPPER_EDGE = Sprite.TRANS_ROT180;
	public static final int ROT_UNDER_LEFT_EDGE  = Sprite.TRANS_ROT270;
	
	public static final int SUF_DEFAULT 	= 39;
	public static final int SUF_SELECTED 	= 48;
	public static final int SUF_DARK		= 49;
		
	private static final int HAI_HANA 	= 40;
	private static final int HAI_AKA	= -5;
	private static final int HAI_URA  	= 37;
	
	private static final int EDGE_NORMAL = Sprite.TRANS_NONE;
	private static final int EDGE_TURNED = Sprite.TRANS_MIRROR_ROT270;
		private static HaiDrawer haidrawer = null; 
	
	public static HaiDrawer getInstance() throws IOException {
		if (HaiDrawer.haidrawer == null) {
			HaiDrawer.haidrawer = new HaiDrawer();
		}
		return HaiDrawer.haidrawer;
	}
	
	private final Setting   setting;
	private final Sprite 	sprite;
	private int hai 			= 0;
	private int rotation 		= HaiDrawer.ROT_UNDER_UNDER_EDGE;
	private int surface  		= HaiDrawer.SUF_DEFAULT;
	private int edge			= HaiDrawer.EDGE_NORMAL;
	private int offsetX			= 0;
	private int offsetY			= 0;
	
	private HaiDrawer() throws IOException {
		this.sprite = new Sprite(Image.createImage("/pai.png"), HaiDrawer.HAI_WIDTH, HaiDrawer.HAI_HEIGHT);
		this.setting = Setting.getInstance();
	}
	
	public void setSurface(int surface) {
		if ((surface == HaiDrawer.SUF_DEFAULT) || (surface == HaiDrawer.SUF_DARK)) {
			this.surface = surface;
		} else {
			this.surface = HaiDrawer.SUF_SELECTED;
		}
	}
	
	public void setHai(int haiId) {
		if (haiId < 0) {
			this.hai = HaiDrawer.HAI_URA; // 
		} else if (haiId < 108) {
			this.hai = haiId / 4;
			this.hai += (this.hai / 9) + 1  
					+ (this.setting.isAka(haiId) ? HaiDrawer.HAI_AKA : 0);
		} else if (haiId < 136) {
			this.hai = (haiId / 4) + 3; // +3 ͐Ԕv̕炵Ă
		} else {
			this.hai = HaiDrawer.HAI_HANA + (haiId % 8); // Ԕv
		}
	}
	
	public void setRotation(int rotation) {
		this.rotation 	= rotation;
		this.edge 		= HaiDrawer.EDGE_NORMAL;
		this.offsetX 	= 0;
		this.offsetY 	= 0;
		switch (rotation) {
		case HaiDrawer.ROT_UNDER_LEFT_EDGE:
			this.edge 		= HaiDrawer.EDGE_TURNED;
			this.offsetY	= -1;
			break;
		case HaiDrawer.ROT_UNDER_RIGHT_EDGE:
			this.edge 		= HaiDrawer.EDGE_TURNED;
			this.offsetX	= -1;
			break;
		case HaiDrawer.ROT_UNDER_UPPER_EDGE:
			this.offsetX	= -1;
			this.offsetY	= -1;
			break;
		default:
			this.rotation 	= HaiDrawer.ROT_UNDER_UNDER_EDGE;
			break;
		}
	}
	
	public void paintHai(Graphics g, int x, int y) {
		this.sprite.setFrame(this.surface);
		this.sprite.setTransform(this.edge);
		this.sprite.setPosition(x, y);
		this.sprite.paint(g);
		
		this.sprite.setFrame(this.hai);
		this.sprite.setTransform(this.rotation);
		this.sprite.setPosition(x + this.offsetX, y + this.offsetY);
		this.sprite.paint(g);
	}
	
	public void paintHai(Graphics g, int x, int y, int haiId, int surface, int rotation) {
		if (this.surface != surface) {
			this.setSurface(surface);
		}
		if (this.rotation != rotation) {
			this.setRotation(rotation);
		}
		this.setHai(haiId);
		this.paintHai(g, x, y);
	}
	
	public void paintSutehai(Graphics g, Sutehai sutehai) {
		int rotation;
		int riichirotation;
		int riichioffsetX = 0;
		int riichioffsetY = 0;
		int riichiaddX    = 0;
		int riichiaddY    = 0;
		int addColumnX	  = 0;
		int addColumnY 	  = 0;
		int addRowX		  = 0;
		int addRowY		  = 0;
		int	holdaddX	  = 2;
		int holdaddY	  = 2;
		int count 		  = 0;
		int x0            = g.getClipX();
		int	y0            = g.getClipY();
		int	w			  = g.getClipWidth();
		int h			  = g.getClipHeight();
		int x;
		int y;
		int diff		  = Math.abs(HaiDrawer.HAI_HEIGHT - HaiDrawer.HAI_WIDTH);
		
		switch (sutehai.getPosition()) {
		case Sutehai.POS_LEFT:
			rotation = HaiDrawer.ROT_UNDER_RIGHT_EDGE;
			riichirotation = HaiDrawer.ROT_UNDER_UPPER_EDGE;
			x0 += ((w - (HaiDrawer.HAI_WIDTH * 6)) / 2) - HaiDrawer.HAI_HEIGHT;
			y0 += (h - (HaiDrawer.HAI_WIDTH * 6)) / 2;
			addColumnY = HaiDrawer.HAI_WIDTH;
			addRowX = -HaiDrawer.HAI_HEIGHT;
			riichiaddY = diff;
			holdaddX = -2;
			break;
			
		case Sutehai.POS_RIGHT:
			rotation = HaiDrawer.ROT_UNDER_LEFT_EDGE;
			riichirotation = HaiDrawer.ROT_UNDER_UNDER_EDGE;
			x0 += (w + (HaiDrawer.HAI_WIDTH * 6)) / 2;
			y0 += ((h + (HaiDrawer.HAI_WIDTH * 6)) / 2) - HaiDrawer.HAI_WIDTH;
			addColumnY = -HaiDrawer.HAI_WIDTH;
			addRowX = HaiDrawer.HAI_HEIGHT;
			riichioffsetX = diff;
			riichioffsetY = -diff;
			riichiaddY = -diff;
			holdaddY = -2;
			break;
			
		case Sutehai.POS_UPPER:
			rotation = HaiDrawer.ROT_UNDER_UPPER_EDGE;
			riichirotation = HaiDrawer.ROT_UNDER_LEFT_EDGE;
			x0 += ((w + (HaiDrawer.HAI_WIDTH * 6)) / 2) - HaiDrawer.HAI_WIDTH;
			y0 += ((h - (HaiDrawer.HAI_WIDTH * 6)) / 2) - HaiDrawer.HAI_HEIGHT;
			addColumnX = -HaiDrawer.HAI_WIDTH;
			addRowY = -HaiDrawer.HAI_HEIGHT;
			riichioffsetX = -diff;
			riichiaddX = -diff;
			holdaddX = -2;
			holdaddY = -2;
			break;
			
		default:
			rotation = HaiDrawer.ROT_UNDER_UNDER_EDGE;
			riichirotation = HaiDrawer.ROT_UNDER_RIGHT_EDGE;
			x0 += (w - (HaiDrawer.HAI_WIDTH * 6)) / 2;
			y0 += (h + (HaiDrawer.HAI_WIDTH * 6)) / 2;
			addColumnX = HaiDrawer.HAI_WIDTH;
			addRowY = HaiDrawer.HAI_HEIGHT;
			riichioffsetY = diff;
			riichiaddX = diff;
			break;
		}
		
		x = x0;
		y = y0;
		this.setRotation(rotation);
		for (Enumeration e = sutehai.getHais(); e.hasMoreElements(); ) {
			Sutehai.Hai hai = (Sutehai.Hai)e.nextElement();
			if (hai.getStay() == Sutehai.STAY_AWAY) {
				continue;
			} else if (hai.getStay() == Sutehai.STAY_HOLD) {
				x += holdaddX;
				y += holdaddY;
			}
			if (hai.isPass()) {
				this.setSurface(HaiDrawer.SUF_DARK);
			} else {
				this.setSurface(HaiDrawer.SUF_DEFAULT);
			}
			this.setHai(hai.getHaiId());
			if (hai.isRiichi()) {
				this.setRotation(riichirotation);
				this.paintHai(g, x + riichioffsetX, y + riichioffsetY);
				this.setRotation(rotation);
				x += riichiaddX;
				y += riichiaddY;
			} else {
				this.paintHai(g, x, y);
			}
			count++;
			if ((count % 6) == 0) {
				int n = count / 6;
				x = x0 + addRowX * n;
				y = y0 + addRowY * n;
			} else {
				x += addColumnX;
				y += addColumnY;
			}
		}
			
	}
	
}
