package myapp.oap4pmahjong;

import java.io.IOException;
import java.util.Random;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

import myapp.oap4pmahjong.test.HaiDrawer;
import myapp.oap4pmahjong.test.Setting;
import myapp.oap4pmahjong.test.Sutehai;

class MainCanvas extends GameCanvas {

	private boolean 	finished_init 	= false;
	
	private HaiDrawer haidrawer = null;
	
	public MainCanvas() {
		super(false);
		// TODO ꂽRXgN^[EX^u
	}
	
	private void init() {
		if (this.haidrawer == null) {
			try {
				this.haidrawer = HaiDrawer.getInstance();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		
		this.finished_init = true;
	}
	
	/* ( Javadoc)
	 * @see javax.microedition.lcdui.Canvas#keyReleased(int)
	 */
	protected void keyReleased(int keyCode) {
		// TODO ꂽ\bhEX^u
		super.keyReleased(keyCode);
		
		this.draw();
		
	}

	public void draw() {
		if (!this.finished_init) {
			this.init();
		}
		
		Graphics g = this.getGraphics();
		
		g.setClip(0, 0, MainMIDlet.DISPLAY_WIDTH, MainMIDlet.DISPLAY_HEIGHT);
		g.setColor(0x007700);
		g.fillRect(0, 0, g.getClipWidth(), g.getClipHeight());
		
		
		Random rand = new Random(System.currentTimeMillis());
		
		for (int i = 0; i < 4; i++) {
			Sutehai sutehai = Sutehai.getInstance(i);
			sutehai.clear();
			for (int j = 0; j < 28; j++) {
				sutehai.add(rand.nextInt(134), (j > i * 4) || (rand.nextInt(3) == 0), (j == i * 4)); sutehai.settle(Sutehai.STAY_STAY);
			}
			sutehai.add(rand.nextInt(134), true, true);
			this.haidrawer.paintSutehai(g, sutehai);
		}
		
		this.flushGraphics();
	}

}
