//Reversi Project
//Thanks to : Masanori Ueno & Hiroshi Ibaraki
//copyright(c)2014 NANDENJIN Laboratory / Kazumi Inada
if(!reversi){
	var reversi={};
}

//コントローラー
reversi.Controller=function(){
	var obj={};
	var dom=document.createElement('div');
	obj.dom=dom;
	var writeLog=function(t){
		dom.innerHTML=t;
	};
	writeLog('Waiting start...');
	
	var board,role=1,players=[],playerNames=['Black','White'],waitTime=0;
	var start=function(b,p){
		board=b;
		players=p;
		if(players.length!=2){
			writeLog('Player set Error');
			return false;
		}
		players.forEach(function(l,i){
			l.setRole(i+1);
		});
		requestPut();
	};
	obj.start=start;
	
	var setPlayerName=function(r,n){
		playerNames[r]=n;
	};
	obj.setPlayerName=setPlayerName;
	
	var requestPut=function(){
		writeLog('Waiting player '+role+' ('+playerNames[role-1]+')');
		players[role-1].request(board,catchCallback);
	};
	
	var catchCallback=function(){
		if(role==2){
			role=1;
		}else{
			role=2;
		}
		writeLog('Player '+role+' ('+playerNames[role-1]+') sent a response.');
		var ableB=board.getAbleToPut(1);
		var ableW=board.getAbleToPut(2);
		if(ableB.length!=0||ableW.length!=0){
			setTimeout(requestPut,waitTime);
		}else{
			//ゲームセット
			players.forEach(function(t){
				t.gameSet();
			});
			var scr=board.countPlayerScore();
			writeLog('Game set! B:W = '+scr[1]+':'+scr[2]);
			callApiEventListeners("gameset");
		}
	};
	
	//外部APIイベントリスナーを登録
	var addEvent=function(type,fnc){
		if(!obj.apiEventListeners){
			obj.apiEventListeners={};
		}
		if(!obj.apiEventListeners[type]){
			obj.apiEventListeners[type]=[];
		}
		obj.apiEventListeners[type].push(fnc);
	};
	obj.addEvent=addEvent;
	
	//外部APIイベントリスナーを起動：イベントリスナー関数に引数が渡せないので改造するかそれぞれの呼び出し元からコールするようにすべきか
	var callApiEventListeners=function(type){
		if(obj.apiEventListeners&&obj.apiEventListeners[type]){
			obj.apiEventListeners[type].forEach(function(f){
				f(type,obj);
			});
		}
	};
	
	return obj;
};



//プレーヤ
if(!reversi.player){
	reversi.player={};
}
if(!reversi.style){
	reversi.style={};
}

reversi.style.pRoleDom='display:inline-block;font:normal 30px sans-serif;width:40px;height:40px;line-height:50px;text-align:center;border:1px solid #000;';
reversi.style.pInd='display:inline-block;font:normal 15px sans-serif;width:500px;margin-left:5px;';



reversi.player.Manual=function(v){
	var obj={};
	obj.name="manual";
	var role,waiting=false,board,callback;
	var setRole=function(r){
		role=r;
		roleDom.innerHTML=r;
		roleDom.style.background=['#000','#FFF'][r-1];
		roleDom.style.color=['#FFF','#000'][r-1];
		v.addEvent((function(rl){
			return function(x,y){
				userTouch(rl,x,y);
			};
		})(r));
		return 'Manual';
	};
	obj.setRole=setRole;
	
	var request=function(b,c){
		//パス
		if(b.getAbleToPut(role).length<=0){
			writeLog("Nothing to put");
			c();
			return false;
		}
		
		//ユーザー入力待機
		waiting=true;
		board=b,callback=c;
		writeLog('Waiting you...');
	};
	obj.request=request;
	
	var userTouch=function(r,x,y){
		if(r!=role||!waiting){
			return false;
		}
		if(board.putDataByCursor(new reversi.Cursor(x,y),role)){
			waiting=false;
			writeLog('Action : put '+x+' , '+y+' / Waiting other...');
			callback();
		}
	};
	
	//ゲームセット
	var gameSet=function(){
		writeLog('Game finished.');
	};
	obj.gameSet=gameSet;
	
	var dom=document.createElement('div');
	var roleDom=document.createElement('span');
	roleDom.style.cssText=reversi.style.pRoleDom;
	var ind=document.createElement('span');
	ind.style.cssText=reversi.style.pInd;
	ind.innerHTML='Player on Manual';
	dom.appendChild(roleDom);
	dom.appendChild(ind);
	obj.dom=dom;
	
	var writeLog=function(t,c){
		ind.innerHTML=t;
		ind.style.color=c||'#000';
	};
	
	return obj;
};

reversi.player.Counter=function(){
	var obj={};
	obj.name="counter";
	var role,board,callback;
	
	var setRole=function(r){
		role=r;
		roleDom.innerHTML=r;
		roleDom.style.background=['#000','#FFF'][r-1];
		roleDom.style.color=['#FFF','#000'][r-1];
		console.log('Player Counter:Role'+role);
	};
	obj.setRole=setRole;
	
	var request=function(b,c){
		writeLog('My turn : analysing board...');
		board=b,callback=c;
		var sar=board.getAbleToPut(role);
		
		//パス
		if(sar.length<=0){
			writeLog('Player Counter on '+role+' : Nothing to put');
			callback();
			return false;
		}
		
		var maxIndex=0;
		for(var i=0;i<sar.length;i++){
			if(sar[i]>sar[maxIndex]){
				maxIndex=i;
			}
		}
		var targetCursor=board.result[maxIndex];
		targetCursor.putDataByBoard(board,role);
		console.log('Player Counter on '+role+' : Put on '+targetCursor.x+','+targetCursor.y);
		writeLog('Action : put '+targetCursor.x+' , '+targetCursor.y+' / Waiting other...');
		callback();
	};
	obj.request=request;
	
	var gameSet=function(){
		writeLog('Game finished.');
	};
	obj.gameSet=gameSet;
	
	var dom=document.createElement('div');
	var roleDom=document.createElement('span');
	roleDom.style.cssText=reversi.style.pRoleDom;
	var ind=document.createElement('span');
	ind.style.cssText=reversi.style.pInd;
	ind.innerHTML='Player "Counter"';
	dom.appendChild(roleDom);
	dom.appendChild(ind);
	obj.dom=dom;
	
	var writeLog=function(t,c){
		ind.innerHTML=t;
		ind.style.color=c||'#000';
	};
	
	return obj;
};

//スペースカウンター(Double)
reversi.player.DoubleSpacer=function(){
	var worker;
	var obj={},role,board,callback;
	obj.name="double_spacer";
	
	var setRole=function(r){
		role=r;
		roleDom.innerHTML=r;
		roleDom.style.background=['#000','#FFF'][r-1];
		roleDom.style.color=['#FFF','#000'][r-1];
		console.log('Player DoubleSpacer:Role'+role);
	};
	obj.setRole=setRole;
	
	var request=function(b,c){
		worker=new Worker('spacer_worker.js');
		worker.addEventListener('message',catchWorker);
		writeLog('My turn : Analysing board...');
		board=b,callback=c;
		worker.postMessage({
			board:board.board,
			role:role
		});
	};
	obj.request=request;
	
	var catchWorker=function(e){
		if(e.data.status=='analysing'){
			writeLog('My turn : Analysing board : '+e.data.msg);
		}else if(e.data.status=='complete'){
			worker.removeEventListener('message',arguments.callee);
			var list=e.data.list,rtnCrs=e.data.rtnCrs;
			
			//置けなかったらパス
			if(list.length<=0){
				writeLog('Action : Nothing to put');
				callback();
				return false;
			}
			
			var maxIndex=0;
			for(var k=0;k<list.length;k++){
				if(list[k]>list[maxIndex]){
					maxIndex=k;
				}
			}
			board.putDataByCursor(new reversi.Cursor(rtnCrs[maxIndex].x,rtnCrs[maxIndex].y),role);
			writeLog('Action : put on '+rtnCrs[maxIndex].x+','+rtnCrs[maxIndex].y);
			console.log('Player '+role+' : put on '+rtnCrs[maxIndex].x+','+rtnCrs[maxIndex].y);
			console.log('===');
			callback();
		}
	};
	obj.catchWorker=catchWorker;
	
	var gameSet=function(){
		writeLog('Game set!');
	};
	obj.gameSet=gameSet;
	
	var dom=document.createElement('div');
	var roleDom=document.createElement('span');
	roleDom.style.cssText=reversi.style.pRoleDom;
	var ind=document.createElement('span');
	ind.style.cssText=reversi.style.pInd;
	ind.innerHTML='Player "DoubleSpacer"';
	dom.appendChild(roleDom);
	dom.appendChild(ind);
	obj.dom=dom;
	
	var writeLog=function(t,c){
		ind.innerHTML=t;
		ind.style.color=c||'#000';
	};
	
	return obj;
};

reversi.player.NSeer=function(n){
	var obj={},worker,role,board,callback;
	obj.name="n_seer_"+n;
	
	var setRole=function(r){
		role=r;
		roleDom.innerHTML=r;
		roleDom.style.background=['#000','#FFF'][r-1];
		roleDom.style.color=['#FFF','#000'][r-1];
		console.log('Player NSeer:Role'+role);
	};
	obj.setRole=setRole;
	
	var request=function(b,c){
		worker=new Worker('nseer_worker.js');
		worker.addEventListener('message',catchWorker);
		writeLog('My turn : Analysing board...');
		board=b,callback=c;
		worker.postMessage({
			board:board.board,
			role:role,
			n:n
		});
	};
	obj.request=request;
	
	var catchWorker=function(e){
		if(e.data.status=='analysing'){
			writeLog('My turn : Analysing board : '+e.data.msg);
		}else if(e.data.status=='complete'){
			worker.removeEventListener('message',arguments.callee);
			
			if(!e.data.action){
				writeLog('Action : Nothing to put');
				callback();
				return false;
			}
			
			var action=new reversi.Cursor(e.data.action.x,e.data.action.y);
			
			
			board.putDataByCursor(action,role);
			writeLog('Action : put on '+action.x+','+action.y);
			console.log('===');
			callback();
		}
	};
	obj.catchWorker=catchWorker;
	
	var gameSet=function(){
		writeLog('Game set!');
	};
	obj.gameSet=gameSet;
	
	
	//DOM生成
	if(document){
		var dom=document.createElement('div');
		var roleDom=document.createElement('span');
		roleDom.style.cssText=reversi.style.pRoleDom;
		var ind=document.createElement('span');
		ind.style.cssText=reversi.style.pInd;
		ind.innerHTML='Player "NSeer"';
		dom.appendChild(roleDom);
		dom.appendChild(ind);
		obj.dom=dom;
	}
	
	var writeLog=function(t,c){
		if(!ind){
			return false;
		}
		ind.innerHTML=t;
		ind.style.color=c||'#000';
	};
	
	return obj;
};