//Reversi Project - Player NSeer
//Thanks to : Masanori Ueno & Hiroshi Ibaraki
//Copyright(c)2015 NANDENJIN Laboratory / Kazimi Inada

var n,role,enemy,w=0,h=0;
var loopCnt=0,allSlc=0,nowSlc=0;

importScripts('reversi.js');

//再帰処理で先読み
function calcScoreByBoard(cnt,b){
	var nr=[role,enemy][(n-cnt)%2],ne=[enemy,role][(n-cnt)%2];;
	b.getAbleToPut(nr);
	var gs=0;
	cnt--;
	
	for(var i=0;i<b.result.length;i++){
		self.postMessage({
			status:'analysing',
			msg:'Caliculating cells... : ( '+nowSlc+' / '+allSlc+' ) '+loopCnt
		});
		loopCnt++;
		
		cgs=b.countScoreByCursor(b.result[i],nr)/b.result.length;
		if(nr==role){
			gs+=cgs;
		}else if(nr==enemy){
			gs-=cgs;
		}
		if(cnt>0){
			var nbc=b.clone();
			nbc.putDataByCursor(b.result[i],nr);
			gs+=arguments.callee(cnt,nbc);
		}
	}
	if(b.result.length<=0&&cnt>0){
			var nbc=b.clone();
			gs+=arguments.callee(cnt,nbc);
	}
	return gs;
}

self.addEventListener('message',function(e){
	var board=new reversi.Board(e.data.board.length,e.data.board[0].length);
	role=e.data.role;
	n=e.data.n,w=board.width,h=board.height;
	if(role==1){
		enemy=2;
	}else{
		enemy=1;
	}
	board.board=e.data.board;
	
	self.postMessage({
		status:'analysing',
		msg:'Getting cells which can be put...'
	});
	var list=board.getAbleToPut(role);
	var sls=[];
	
	//パス
	if(list.length<=0){
		self.postMessage({
			status:'complete'
		});
		self.close();
	}
	
	//解析
	allSlc=board.result.length;
	for(var i=0;i<board.result.length;i++){
		//二手以上先読みの場合は解析ループへ
		if(n>=2){
			nowSlc=i;
			var cb=board.clone();
			cb.putDataByCursor(board.result[i].clone(),role);
			sls[i]=calcScoreByBoard(n-1,cb);
		
		//一手先読みの場合は取れる個数を数えて終わり
		}else{
			sls[i]=board.countScoreByCursor(board.result[i].clone(),role);
		}
	}
	console.log(sls);
	self.postMessage({
		status:'analysing',
		msg:'Preparing data...'
	});
	
	var maxIndex=0,maxScore=-Infinity;
	var cFlag=false,lFlag=false;
	var cps=[],lps=[];
	
	//角と端がないか検査
	for(var k=0;k<sls.length;k++){
		cps[k]=-Infinity,lps[k]=-Infinity;
		var cta=board.result[k];
		//角
		if((cta.x==0||cta.x==w-1)&&(cta.y==0||cta.y==h-1)){
			cFlag=true;
			cps[k]=sls[k];
		}
		//端
		if((cta.x==0||cta.x==w-1)||(cta.y==0||cta.y==h-1)){
			lFlag=true;
			lps[j]=sls[k];
		}
	}
	
	//角>端>Allの順位でソート範囲決定
	var ats;
	if(cFlag){
		ats=cps;
	}else if(lFlag){
		ats=lps;
	}else{
		ats=sls;
	}
	
	for(var j=0;j<ats.length;j++){
		if(ats[j]>maxScore){
			maxScore=ats[j];
			maxIndex=j;
		}
	}
	
	self.postMessage({
		status:'complete',
		action:{
			x:board.result[maxIndex].x,
			y:board.result[maxIndex].y
		}
	});
	self.close();
});