/**
 * 
 */
package tm.tmdiagram.tmdeditor.model;


/**
 * @author hnakajima
 *
 */
public class Entity extends AbstractEntityModel {
	public static final String P_PHYSICAL_NAME = "p_physical_name";
	private String physicalName = "";
	private String description = "";
	private Identifier identifier = null;
	private EntityType entityType = EntityType.R;

	/**
	 * @return the physicalName
	 */
	public String getPhysicalName() {
		return physicalName;
	}
	/**
	 * @param physicalName the physicalName to set
	 */
	public void setPhysicalName(String physicalName) {
		this.physicalName = physicalName;
		firePropertyChange(P_PHYSICAL_NAME, null, physicalName);
	}
	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * @return the identifier
	 */
	public Identifier getIdentifier() {
		return identifier;
	}
	/**
	 * @param identifier the identifier to set
	 */
	public void setIdentifier(Identifier identifier) {
		this.identifier = identifier;
	}
	/**
	 * @return the entityType
	 */
	public EntityType getEntityType() {
		return entityType;
	}
	/**
	 * @param entityType the entityType to set
	 */
	public void setEntityType(EntityType entityType) {
		this.entityType = entityType;
	}
	public void removeReuseKey(Identifier reuseKey) {
		this.reuseKeys.remove(reuseKey);
		firePropertyChange(P_ATTRIBUTE, reuseKey, null);
	}
}
