package tm.tmdiagram.tmdeditor.editpart;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

import tm.tmdiagram.tmdeditor.model.CombinationTable;
import tm.tmdiagram.tmdeditor.model.Diagram;
import tm.tmdiagram.tmdeditor.model.Entity;
import tm.tmdiagram.tmdeditor.model.MappingList;
import tm.tmdiagram.tmdeditor.model.RecursiveConnection;
import tm.tmdiagram.tmdeditor.model.RecursiveTable;
import tm.tmdiagram.tmdeditor.model.RelatedRelationship;
import tm.tmdiagram.tmdeditor.model.Relationship;

public class TMDEditPartFactory implements EditPartFactory {

	public EditPart createEditPart(EditPart context, Object model) {
		EditPart part = null;
		if (model instanceof Diagram) {
			part = new DiagramEditPart();
		} else if (model instanceof Relationship) {
			part = new RelationshipEditPart();
		} else if (model instanceof RelatedRelationship) {
			part = new RelatedRelationshipEditPart();
		} else if (model instanceof RecursiveConnection) {
			part = new RecursiveConnectionEditPart();
		} else if (model instanceof CombinationTable) {
			part = new CombinationTableEditPart();
		} else if (model instanceof MappingList) {
			part = new MappingListEditPart();
		} else if (model instanceof RecursiveTable) {
			part = new RecursiveTableEditPart();
		} else if (model instanceof Entity) {
			part = new EntityEditPart();
		}
		if (part != null) {
			part.setModel(model);
		}
		return part;
	}

}
