package ter.diagram.editor.model.command;

import org.eclipse.gef.commands.Command;

import ter.diagram.editor.model.RelationshipConnection;
import ter.diagram.editor.model.EntityBase;

public class RelationshipReconnectCommand extends Command {
	private EntityBase oldSource, oldTarget;
	private EntityBase newSource, newTarget;
	private RelationshipConnection relationship;
	
	@Override
	public void execute() {
		if (newSource != null) {
			oldSource = relationship.getSource();
			reconnectSource(newSource);
		}
		if (newTarget != null) {
			oldTarget = relationship.getTarget();
			reconnectTarget(newTarget);
		}
	}

	@Override
	public void undo() {
		if (oldSource != null) {
			reconnectSource(oldSource);
		}
		if (oldTarget != null) {
			reconnectTarget(oldTarget);
		}
		oldSource = null;
		oldTarget = null;
	}

	private void reconnectSource(EntityBase source) {
		relationship.detachSource();
		relationship.setSource(source);
		relationship.attachSource();
	}
	private void reconnectTarget(EntityBase target) {
		relationship.detachTarget();
		relationship.setTarget(target);
		relationship.attachTarget();
	}
	public void setNewSource(EntityBase newSource) {
		this.newSource = newSource;
	}

	public void setNewTarget(EntityBase newTarget) {
		this.newTarget = newTarget;
	}

	public void setRelationship(RelationshipConnection relationship) {
		this.relationship = relationship;
	}

}
