/**
 * 
 */
package ter.diagram.editor.model.command;

import org.eclipse.gef.commands.Command;

import ter.diagram.editor.model.EntityBase;

/**
 * @author nakaG
 *
 */
public class EntityBaseTypeDirectEditCommand extends Command {
	private int oldEntityType;
	private int newEntityType;
	private EntityBase entity;
	
	
	/**
	 * @param entity 設定する entity
	 */
	public void setEntity(EntityBase entity) {
		this.entity = entity;
	}
	/**
	 * @param newEntityType 設定する newEntityType
	 */
	public void setNewEntityType(int newEntityType) {
		this.newEntityType = newEntityType;
	}
	/**
	 * @param oldEntityType 設定する oldEntityType
	 */
	public void setOldEntityType(int oldEntityType) {
		this.oldEntityType = oldEntityType;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#execute()
	 */
	@Override
	public void execute() {
		entity.setEntityType(newEntityType);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	@Override
	public void undo() {
		entity.setEntityType(oldEntityType);
	}
	
	
}
