/**
 * 
 */
package ter.diagram.editor.model.command;

import org.eclipse.gef.commands.Command;

import ter.diagram.editor.model.EntityBase;

/**
 * @author ctc
 *
 */
public class EntityBaseNameDirectEditCommand extends Command {
	private String oldName;
	private String newName;
	private EntityBase entity;
	
	
	/**
	 * @param entity 設定する entity
	 */
	public void setEntity(EntityBase entity) {
		this.entity = entity;
	}

	/**
	 * @param newName 設定する newName
	 */
	public void setNewName(String newName) {
		this.newName = newName;
	}

	/**
	 * @param oldName 設定する oldName
	 */
	public void setOldName(String oldName) {
		this.oldName = oldName;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#execute()
	 */
	@Override
	public void execute() {
		entity.setName(newName);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	@Override
	public void undo() {
		entity.setName(oldName);
	}

}
