package ter.diagram.editor.model.command;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.gef.commands.Command;

import ter.diagram.editor.model.RelationshipConnection;
import ter.diagram.editor.model.EntityBase;
import ter.diagram.editor.model.TMDiagram;

public class EntityBaseDeleteCommand extends Command {
	private TMDiagram tmdiagram;
	private EntityBase entityBase;
	private List sourceRelationships = new ArrayList();
	private List targetRelationships = new ArrayList();
	
	public EntityBaseDeleteCommand() {
		super();
		// TODO Auto-generated constructor stub
	}

	public EntityBaseDeleteCommand(String label) {
		super(label);
		// TODO Auto-generated constructor stub
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#execute()
	 */
	public void execute() {
		sourceRelationships.addAll(entityBase.getSourceRelationships());
		targetRelationships.addAll(entityBase.getTargetRelationships());
		
		detachRelationships(sourceRelationships);
		detachRelationships(targetRelationships);
		tmdiagram.removeEntity(entityBase);
	}

	private void detachRelationships(List relationships) {
		for (int i = 0; i < relationships.size(); i++) {
			RelationshipConnection model =
				(RelationshipConnection) relationships.get(i);
			model.detachSource();
			model.detachTarget();
		}
	}
	/**
	 * @param entityBase The entityBase to set.
	 */
	public void setEntityBase(EntityBase entityBase) {
		this.entityBase = entityBase;
	}

	/**
	 * @param tmdiagram The tmdiagram to set.
	 */
	public void setTmdiagram(TMDiagram tmdiagram) {
		this.tmdiagram = tmdiagram;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	public void undo() {
		this.tmdiagram.addEntity(entityBase);
		attathRelationships(sourceRelationships);
		attathRelationships(targetRelationships);
		
		sourceRelationships.clear();
		targetRelationships.clear();
	}

	private void attathRelationships(List relationships) {
		for (int i = 0; i < relationships.size(); i++) {
			RelationshipConnection model =
				(RelationshipConnection) relationships.get(i);
			model.attachSource();
			model.attachTarget();
		}
		
	}

	
	
}
