package ter.diagram.editor.model.command;

import org.eclipse.gef.commands.Command;

import ter.diagram.editor.model.EntityBase;
import ter.diagram.editor.model.Identifier;
import ter.diagram.editor.model.TMDiagram;

public class EntityBaseCreateCommand extends Command {
	private TMDiagram diagram;
	private EntityBase entity;
	
	public EntityBaseCreateCommand() {
		super();
		// TODO Auto-generated constructor stub
	}

	public EntityBaseCreateCommand(String label) {
		super(label);
		// TODO Auto-generated constructor stub
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#execute()
	 */
	public void execute() {
		int count = diagram.getEntities().size();
		entity.setName("entity"+ (count+1));
		Identifier identifier = new Identifier(entity);
		identifier.setName(entity.getName() + "No");
//		entity.addIdentifier(identifier);
		entity.setIdentifier(identifier);
		diagram.addEntity(entity);
	}

	public void setDiagram(Object diagram) {
		this.diagram = (TMDiagram) diagram;
	}
	
	public void setEntity(Object entity) {
		this.entity = (EntityBase) entity;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	public void undo() {
		this.diagram.removeEntity(entity);
	}

}
