package ter.diagram.editor.model.command;

import org.eclipse.gef.commands.Command;

import sun.rmi.runtime.NewThreadAction;
import ter.diagram.editor.model.Attribute;
import ter.diagram.editor.model.EntityBase;

public class AttributeTransferCommand extends Command
{

    private Attribute attributeToMove;
    private Attribute attributeAfter;
    private EntityBase originalEntity;
    private EntityBase newEntity;
    private int oldIndex;
    private int newIndex;
    
    public AttributeTransferCommand()
    {
        super();
        // TODO Auto-generated constructor stub
    }

    public AttributeTransferCommand(String label)
    {
        super(label);
        // TODO Auto-generated constructor stub
    }

    /**
     * @param attributeAfter The attributeAfter to set.
     */
    public void setAttributeAfter(Attribute attributeAfter)
    {
        this.attributeAfter = attributeAfter;
    }

    /**
     * @param attributeToMove The attributeToMove to set.
     */
    public void setAttributeToMove(Attribute attributeToMove)
    {
        this.attributeToMove = attributeToMove;
    }

    /**
     * @param newEntity The newEntity to set.
     */
    public void setNewEntity(EntityBase newEntity)
    {
        this.newEntity = newEntity;
    }

    /**
     * @param newIndex The newIndex to set.
     */
    public void setNewIndex(int newIndex)
    {
        this.newIndex = newIndex;
    }

    /**
     * @param oldIndex The oldIndex to set.
     */
    public void setOldIndex(int oldIndex)
    {
        this.oldIndex = oldIndex;
    }

    /**
     * @param originalEntity The originalEntity to set.
     */
    public void setOriginalEntity(EntityBase originalEntity)
    {
        this.originalEntity = originalEntity;
    }

    /* (non-Javadoc)
     * @see org.eclipse.gef.commands.Command#execute()
     */
    @Override
    public void execute()
    {
        originalEntity.removeAttribute(attributeToMove);
        newEntity.addAttribute(attributeToMove, newIndex);
    }

    /* (non-Javadoc)
     * @see org.eclipse.gef.commands.Command#undo()
     */
    @Override
    public void undo()
    {
        newEntity.removeAttribute(attributeToMove);
        originalEntity.addAttribute(attributeToMove, oldIndex);
    }

    /* (non-Javadoc)
     * @see org.eclipse.gef.commands.Command#canExecute()
     */
    @Override
    public boolean canExecute()
    {
        if (originalEntity.getChildren().size() > 1)
            return true;
        else
            return false;
    }

    
}
