package ter.diagram.editor.model;

import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRelationshipModel {
	private EntityBase source, target;
	private Identifier reuseSourceId, reuseTargetId;
	private List<Identifier> reuseSources, reuseTargets;
	
	public AbstractRelationshipModel() {
		super();
		// TODO Auto-generated constructor stub
	}

	public void attachSource() {
		if (!source.getSourceRelationships().contains(this)) {
			source.addSourceRelationship(this);
//			reuseSourceId = createReUseKey(source, target);
//			reuseSources = createReuseKeys(source, target);
		}
	}

	private Identifier createReUseKey(EntityBase org, EntityBase dest) {
		
		Identifier identifier = new Identifier(dest);
		identifier.setName(((Identifier)org.getIdentifieres().get(0)).getName());
		return identifier;
	}
	public void attachTarget() {
		if (!target.getTargetRelationships().contains(this)) {
			target.addTargetRelationship(this);
			reuseTargetId = createReUseKey(target, source);
		}
	}
	
	public void detachSource() {
		source.removeSourceRelationship(this);
		source.removeIdentifier(reuseTargetId);
	}
	
	public void detachTarget() {
		target.removeTargetRelationship(this);
		target.removeIdentifier(reuseSourceId);
	}

	/**
	 * @return Returns the source.
	 */
	public EntityBase getSource() {
		return source;
	}

	/**
	 * @param source The source to set.
	 */
	public void setSource(EntityBase source) {
		this.source = source;
	}

	/**
	 * @return Returns the target.
	 */
	public EntityBase getTarget() {
		return target;
	}

	/**
	 * @param target The target to set.
	 */
	public void setTarget(EntityBase target) {
		this.target = target;
	}

	/**
	 * @return reuseSourceId
	 */
	public Identifier getReuseSourceId() {
		return reuseSourceId;
	}

	/**
	 * @return reuseTargetId
	 */
	public Identifier getReuseTargetId() {
		return reuseTargetId;
	}
	
}
