package ter.diagram.editor.figure;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;

public class EntityBaseTitleFigure extends Figure {

	public EntityBaseTitleFigure() {
		BorderLayout layout = new BorderLayout();
//		setBackgroundColor(ColorConstants.lightBlue);
//		setOpaque(true);
		setLayoutManager(layout);
		setBorder(new CompoundBorder(new EntityBaseTitleFigureBorder(), new MarginBorder(3)));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.draw2d.Figure#add(org.eclipse.draw2d.IFigure, java.lang.Object, int)
	 */
	public void add(IFigure figure, Object constraint, int index) {
		super.add(figure, constraint, index);
		if (figure instanceof TitleLabel) {
			getLayoutManager().setConstraint(figure, BorderLayout.CENTER);
		} else if (figure instanceof EntityTypeLabel) {
			getLayoutManager().setConstraint(figure, BorderLayout.RIGHT);
		}
	}
	
	public class EntityBaseTitleFigureBorder extends AbstractBorder {

		/* (non-Javadoc)
		 * @see org.eclipse.draw2d.Border#getInsets(org.eclipse.draw2d.IFigure)
		 */
		public Insets getInsets(IFigure figure) {
			return new Insets(0, 0, 1, 0);
		}

		/* (non-Javadoc)
		 * @see org.eclipse.draw2d.Border#paint(org.eclipse.draw2d.IFigure, org.eclipse.draw2d.Graphics, org.eclipse.draw2d.geometry.Insets)
		 */
		public void paint(IFigure figure, Graphics graphics, Insets insets) {
			graphics.setLineWidth(2);
			graphics.drawLine(getPaintRectangle(figure, insets).getBottomLeft(), tempRect.getBottomRight());

		}
	}
	
}
