package ter.diagram.editor.editpolicy;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

import ter.diagram.editor.editpart.AttributeEditPart;
import ter.diagram.editor.editpart.EntityBaseEditPart;
import ter.diagram.editor.model.Attribute;
import ter.diagram.editor.model.EntityBase;
import ter.diagram.editor.model.Identifier;
import ter.diagram.editor.model.command.AttributeMoveCommand;
import ter.diagram.editor.model.command.AttributeTransferCommand;
import ter.diagram.editor.model.command.AttributeCreateCommand;
import ter.diagram.editor.model.command.CreateIdentifierCommand;

public class EntityLayoutEditPolicy extends FlowLayoutEditPolicy {

	public EntityLayoutEditPolicy() {
		super();
		// TODO Auto-generated constructor stub
	}

	protected Command createAddCommand(EditPart child, EditPart after) {
		System.out.println("EntityLayoutEditPolicy.createAddCommand");
		if (!(child instanceof AttributeEditPart))
            return null;
        if (!(after instanceof AttributeEditPart))
            return null;
        
        Attribute toMove = (Attribute) child.getModel();
        Attribute afterModel = (Attribute) after.getModel();
        
        EntityBaseEditPart originalEntityEditPart = (EntityBaseEditPart)child.getParent();
        EntityBase originalEntity = (EntityBase)originalEntityEditPart.getModel();
        EntityBaseEditPart newEntityEditPart = (EntityBaseEditPart)after.getParent();
        EntityBase newEntity = (EntityBase)newEntityEditPart.getModel();
        
        int oldIndex = originalEntityEditPart.getChildren().indexOf(child);
        int newIndex = newEntityEditPart.getChildren().indexOf(after);
        
        AttributeTransferCommand command = new AttributeTransferCommand();
        command.setAttributeToMove(toMove);
        command.setAttributeAfter(afterModel);
        command.setOriginalEntity(originalEntity);
        command.setNewEntity(newEntity);
        command.setOldIndex(oldIndex);
        command.setNewIndex(newIndex);
        
		return command;
	}

	protected Command createMoveChildCommand(EditPart child, EditPart after) {
		System.out.println("EntityLayoutEditPolicy.createMoveChildCommand");
        
        if (after != null) {
            Attribute childModel = (Attribute) child.getModel();
            
            EntityBase parentEntity = (EntityBase) getHost().getModel();
            int oldIndex = getHost().getChildren().indexOf(child);
            int newIndex = getHost().getChildren().indexOf(after);
            
            AttributeMoveCommand command = new AttributeMoveCommand();
            command.setChildAttribute(childModel);
            command.setOldIndex(oldIndex);
            command.setNewIndex(newIndex);
            command.setParentEntity(parentEntity);
            return command;
        }
		return null;
	}

	protected Command getCreateCommand(CreateRequest request) {
		System.out.println("EntityLayoutEditPolicy.getCreateCommand");
//		Object newObject = request.getNewObject();
//		
//		if (!(newObject instanceof Attribute)) {
//			return null;
//		}
//		EntityBase entity = (EntityBase) getHost().getModel();
//		if (newObject instanceof Identifier) {
//			CreateIdentifierCommand command = new CreateIdentifierCommand();
//			command.setEntity(entity);
//			Identifier identifier = (Identifier) newObject;
//			identifier.setName(entity.getName() + "No");
//			command.setIdentifier(identifier);
//			return command;
//		} else {
//			AttributeCreateCommand command = new AttributeCreateCommand();
//			command.setEntity(entity);
//			Attribute attr = (Attribute) newObject;
//			attr.setName("attribute"+ (entity.getAttributes().size() + 1));
//			command.setAttribute(attr);
//			return command;
//		}
        return null;
	}

	protected Command getDeleteDependantCommand(Request request) {
		System.out.println("EntityLayoutEditPolicy.getDeleteDependantCommand");
		return null;
	}

}
