package ter.diagram.editor.editpart;

import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import ter.diagram.editor.editpolicy.TMDiagramEditPolicy;
import ter.diagram.editor.model.AbstractTMModel;
import ter.diagram.editor.model.TMDiagram;

public class TMDiagramEditPart extends EditPartWithListener {

	public TMDiagramEditPart() {
		super();
		// TODO Auto-generated constructor stub
	}

	protected IFigure createFigure() {
		Layer figure = new Layer();
		figure.setLayoutManager(new XYLayout());
		return figure;
	}

	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new TMDiagramEditPolicy());
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editparts.AbstractEditPart#getModelChildren()
	 */
	protected List getModelChildren() {
		return ((TMDiagram)getModel()).getEntities();
	}

	/* (non-Javadoc)
	 * @see java.beans.PropertyChangeListener#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		Object oldValue = evt.getOldValue();
		Object newValue = evt.getNewValue();
		if (evt.getPropertyName().equals(AbstractTMModel.P_CHILDREN)) {
			if (newValue != null) {
				EditPart editPart = createChild(newValue);
				int modelIndex = getModelChildren().indexOf(newValue);
				addChild(editPart, modelIndex);
			} else {
				List children = getChildren();
				EditPart partToRemove = null;
				for (Iterator iter = children.iterator(); iter.hasNext();)
				{
					EditPart part = (EditPart) iter.next();
					if (part.getModel() == oldValue)
					{
						partToRemove = part;
						break;
					}
				}

				if (partToRemove != null)
					removeChild(partToRemove);
			}
			refreshChildren();
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editparts.AbstractEditPart#isSelectable()
	 */
	@Override
	public boolean isSelectable() {
		return false;
	}
	
}
