package ter.diagram.editor.editpart;

import java.beans.PropertyChangeEvent;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;

import ter.diagram.editor.directedit.AttributeCellEditorLocator;
import ter.diagram.editor.directedit.AttributeDirectEditManager;
import ter.diagram.editor.editpolicy.AttributeComponentEditPolicy;
import ter.diagram.editor.editpolicy.AttributeDirectEditPolicy;
import ter.diagram.editor.figure.AttributeLabel;
import ter.diagram.editor.model.Attribute;
import ter.diagram.editor.model.EntityBase;

public class AttributeEditPart extends EditPartWithListener {

	protected DirectEditManager manager;
	
	public AttributeEditPart() {
		super();
        System.out.println("AttributeEditPart instanciate.");

		// TODO Auto-generated constructor stub
	}

	protected IFigure createFigure() {
		Attribute model = (Attribute)getModel();
		AttributeLabel label = new AttributeLabel();
		label.setText(model.getName());
//		label.setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(3)));
//		label.setBackgroundColor(ColorConstants.lightBlue);
		label.setOpaque(true);

		return label;
	}

	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new AttributeComponentEditPolicy());
        installEditPolicy(EditPolicy.LAYOUT_ROLE, null);
        installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new AttributeDirectEditPolicy());
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editparts.AbstractEditPart#refreshVisuals()
	 */
	protected void refreshVisuals() {
        Attribute attribute = (Attribute)getModel();
        AttributeLabel attributeLabel = (AttributeLabel)getFigure();
        attributeLabel.setText(attribute.getName());
        
	}

	/* (non-Javadoc)
	 * @see java.beans.PropertyChangeListener#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		if (evt.getPropertyName().equals(EntityBase.P_NAME_ATTRIBUTE)) {
			AttributeLabel label = (AttributeLabel) getFigure();
			label.setText((String)evt.getNewValue());
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editparts.AbstractEditPart#performRequest(org.eclipse.gef.Request)
	 */
	@Override
	public void performRequest(Request req) {
		if (req.getType() == RequestConstants.REQ_DIRECT_EDIT) {
			performDirectEdit();
		}
	}

	private void performDirectEdit() {
		if (manager == null) {
			manager = new AttributeDirectEditManager(this, TextCellEditor.class, new AttributeCellEditorLocator(getFigure()));
		}
		manager.show();
	}

	
}
