/**
 * 
 */
package ter.diagram.editor.directedit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.swt.widgets.Text;

import ter.diagram.editor.figure.IdentifierLabel;
import ter.diagram.editor.model.EntityBase;
import ter.diagram.editor.model.Identifier;

/**
 * @author ctc
 *
 */
public class EntityBaseIdentifierDirectEditManager extends DirectEditManager {

	private EntityBase entity;
	private String identifierName;
	public EntityBaseIdentifierDirectEditManager(GraphicalEditPart part, Class arg1, CellEditorLocator arg2) {
		super(part, arg1, arg2);
		entity = (EntityBase)part.getModel();
	}
	public EntityBaseIdentifierDirectEditManager(GraphicalEditPart part, Class arg1, CellEditorLocator arg2, IFigure figure) {
		super(part, arg1, arg2);
		entity = (EntityBase)part.getModel();
		identifierName = ((IdentifierLabel)figure).getText();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.tools.DirectEditManager#initCellEditor()
	 */
	@Override
	protected void initCellEditor() {
		System.out.println("EntityBaseIdentifierDirectEditManager.initCellEditor() start");

		getCellEditor().setValue(identifierName);
//		getCellEditor().setValue(entity.getIdentifier().getName());
		
		Text text = (Text) getCellEditor().getControl();
		text.selectAll();
		System.out.println("EntityBaseIdentifierDirectEditManager.initCellEditor() end");
	}

}
