/**
 * 
 */
package ter.diagram.editor.directedit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

/**
 * @author nakaG
 *
 */
public class AttributeCellEditorLocator implements CellEditorLocator {

	private IFigure figure;
	
	public AttributeCellEditorLocator(IFigure figure) {
		this.figure = figure;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.gef.tools.CellEditorLocator#relocate(org.eclipse.jface.viewers.CellEditor)
	 */
	public void relocate(CellEditor cellEditor) {
		Text text = (Text) cellEditor.getControl();
		Point pref = text.computeSize(-1, -1);

		Rectangle rect = figure.getBounds().getCopy();
		Rectangle prect = figure.getParent().getBounds().getCopy();
		figure.translateToAbsolute(rect);
		text.setBounds(rect.x, rect.y, prect.width, rect.height);
	}

}
