package ter.diagram.editor;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

import ter.diagram.editor.editpart.TMEditPartFactory;
import ter.diagram.editor.model.Attribute;
import ter.diagram.editor.model.EntityBase;
import ter.diagram.editor.model.Identifier;
import ter.diagram.editor.model.RelationshipConnection;
import ter.diagram.editor.model.TMDiagram;

public class TERDiagramEditor extends GraphicalEditorWithPalette {

	public TERDiagramEditor() {
		super();
		setEditDomain(new DefaultEditDomain(this));
	}

	public void doSave(IProgressMonitor monitor) {
		// TODO Auto-generated method stub

	}

	public void doSaveAs() {
		// TODO Auto-generated method stub

	}

//	public void init(IEditorSite site, IEditorInput input)
//			throws PartInitException {
//		// TODO Auto-generated method stub
//
//	}

	public boolean isDirty() {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean isSaveAsAllowed() {
		// TODO Auto-generated method stub
		return false;
	}

//	public void createPartControl(Composite parent) {
//		// TODO Auto-generated method stub
//
//	}

//	public void setFocus() {
//		// TODO Auto-generated method stub
//
//	}

	protected void initializeGraphicalViewer() {
		GraphicalViewer viewer = getGraphicalViewer();
		TMDiagram root = new TMDiagram();
//		EntityBase entity = new EntityBase();
//		Identifier identifier = new Identifier();
//		identifier.setConstraint(new Rectangle(0,0,-1,-1));
//		identifier.setName("identifier1");
//		List idr = new ArrayList();
//		idr.add(identifier);
//		
//		Attribute attribute = new Attribute();
//		attribute.setConstraint(new Rectangle(0,0,-1,-1));
//		attribute.setName("attribute1");
//		List attr = new ArrayList();
//		attr.add(attribute);
//
//		Attribute attribute2 = new Attribute();
//		attribute2.setConstraint(new Rectangle(0,0,-1,-1));
//		attribute2.setName("attribute2");
//		attr.add(attribute2);
//		
//		entity.setIdentifieres(idr);
//		entity.setAttributes(attr);
//		entity.setConstraint(new Rectangle(0,0, -1, -1));
//		root.addEntity(entity);
//
//		EntityBase entity2 = new EntityBase();
//		Identifier identifier2 = new Identifier();
//		identifier2.setConstraint(new Rectangle(0,0,-1,-1));
//		identifier2.setName("identifier1");
//		List idr2 = new ArrayList();
//		idr2.add(identifier2);
//		
//		List attr2 = new ArrayList();
//
//		entity2.setIdentifieres(idr2);
//		entity2.setAttributes(attr2);
//		entity2.setConstraint(new Rectangle(0,0, -1, -1));
//		root.addEntity(entity2);
//		
		viewer.setContents(root);
//		viewer.setContents(entity);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.ui.parts.GraphicalEditor#configureGraphicalViewer()
	 */
	protected void configureGraphicalViewer() {
		super.configureGraphicalViewer();
		GraphicalViewer viewer = getGraphicalViewer();
		viewer.setEditPartFactory(new TMEditPartFactory());
		
		KeyHandler handler = new KeyHandler();
		
		handler.put(
				KeyStroke.getPressed(SWT.DEL, 127, 0),
				getActionRegistry().getAction(ActionFactory.DELETE.getId()));
		handler.put(
	    	      KeyStroke.getPressed(SWT.F2, 0),
	    	      getActionRegistry().getAction(GEFActionConstants.DIRECT_EDIT));

		viewer.setKeyHandler(new GraphicalViewerKeyHandler(viewer)
		  .setParent(handler));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.ui.parts.GraphicalEditorWithPalette#getPaletteRoot()
	 */
	protected PaletteRoot getPaletteRoot() {
		PaletteRoot root = new PaletteRoot();
		
		PaletteGroup toolGroup = new PaletteGroup("ツール");
		
		ToolEntry tool = new SelectionToolEntry();
		toolGroup.add(tool);
		root.setDefaultEntry(tool);
		
		tool = new MarqueeToolEntry();
		toolGroup.add(tool);
		
		PaletteDrawer drawer = new PaletteDrawer("作成");
		
		ImageDescriptor descriptor =
			EditorPlugin.getImageDescriptor("icons/newModel.gif");

		CreationToolEntry creationEntry =
		new CreationToolEntry(
				"Entity作成",
                "作成",
				new SimpleFactory(EntityBase.class),
				descriptor,
				descriptor);
		drawer.add(creationEntry);

		descriptor =
			EditorPlugin.getImageDescriptor("icons/newConnection.gif");

		ConnectionCreationToolEntry connxCCreationEntry =
			new ConnectionCreationToolEntry(
					"Relationship作成",
					"リレーションシップ作成",
					new SimpleFactory(RelationshipConnection.class),
					descriptor,
					descriptor);
		drawer.add(connxCCreationEntry);

		descriptor =
			EditorPlugin.getImageDescriptor("icons/newModel.gif");

		CreationToolEntry creationAttribute =
		new CreationToolEntry(
				"Attribute作成",
                "作成",
				new SimpleFactory(Attribute.class),
				descriptor,
				descriptor);
		drawer.add(creationAttribute);
		
		root.add(toolGroup);
		root.add(drawer);
		
		return root;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.ui.parts.GraphicalEditor#createActions()
	 */
	@Override
	protected void createActions() {
		super.createActions();
		
		ActionRegistry registry = getActionRegistry();
		IAction action = new DirectEditAction((IWorkbenchPart)this);
		registry.registerAction(action);
		
		getSelectionActions().add(action.getId());
	}

	
}
