package com.nwalsh.xalan;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.w3c.dom.*;
import org.apache.xml.utils.DOMBuilder;
import com.nwalsh.xalan.Callout;

/**
 * <p>Utility class for the Verbatim extension (ignore this).</p>
 *
 * <p>$Id: FormatCallout.java 7007 2007-07-11 07:09:12Z mzjn $</p>
 *
 * <p>Copyright (C) 2000, 2001 Norman Walsh.</p>
 *
 * <p><b>Change Log:</b></p>
 * <dl>
 * <dt>1.0</dt>
 * <dd><p>Initial release.</p></dd>
 * </dl>
 *
 * @author Norman Walsh
 * <a href="mailto:ndw@nwalsh.com">ndw@nwalsh.com</a>
 *
 * @see Verbatim
 *
 * @version $Id: FormatCallout.java 7007 2007-07-11 07:09:12Z mzjn $
 **/

public abstract class FormatCallout {
  protected static final String foURI = "http://www.w3.org/1999/XSL/Format";
  protected static final String xhURI = "http://www.w3.org/1999/xhtml";
  protected boolean stylesheetFO = false;

  public FormatCallout() {
    //nop;
  }

  public String areaLabel(Element area) {
    String label = null;

    if (!"".equals(area.getAttribute("label"))) {
      // If this area has a label, use it
      label = area.getAttribute("label");
    } else {
      // Otherwise, if its parent is an areaset and it has a label, use that
      Element parent = (Element) area.getParentNode();
      if (parent != null
	  && parent.getNodeName().equals("areaset")
	  && !"".equals(parent.getAttribute("label"))) {
	label = parent.getAttribute("label");
      }
    }

    return label;
  }


// Get area ID (used for xrefs to callouts)
  public String areaID(Element area) {
    String id = null;
    
    if (area.hasAttribute("id")) {
      id = area.getAttribute("id");
    }

    else {
      if (area.hasAttribute("xml:id")) {
	id = area.getAttribute("xml:id");
      } 
    
      else {
	id = "";
      }
    }
    //System.out.println(id);
    return id;
  }


  public void startSpan(DOMBuilder rtf, String id)
    throws SAXException {
  
    if (!stylesheetFO) {
      AttributesImpl spanAttr = new AttributesImpl();
      spanAttr.addAttribute("", "class", "class", "CDATA", "co");
      spanAttr.addAttribute("", "id", "id", "ID", id);
      rtf.startElement("", "span", "span", spanAttr);
    }
  }
  
  public void endSpan(DOMBuilder rtf) 
    throws SAXException {
  
    if (!stylesheetFO) {
      rtf.endElement("", "span", "span");
    }
  }

  public void formatTextCallout(DOMBuilder rtf,
				Callout callout) {
    Element area = callout.getArea();
    int num = callout.getCallout();
    String userLabel = areaLabel(area);
    String label = "(" + num + ")";

    if (userLabel != null) {
      label = userLabel;
    }

    String id = areaID(area);
    char chars[] = label.toCharArray();

    try {
      startSpan(rtf, id);
      if (stylesheetFO) {
	AttributesImpl spanAttr = new AttributesImpl();
	spanAttr.addAttribute("", "id", "id", "ID", id);
	rtf.startElement(foURI, "inline", "fo:inline", spanAttr);
      }

      rtf.characters(chars, 0, label.length());
      if (stylesheetFO) {
	rtf.endElement(foURI, "inline", "fo:inline");
      }
      endSpan(rtf);
    } catch (SAXException e) {
      System.out.println("SAX Exception in text formatCallout");
    }
  }

  public abstract void formatCallout(DOMBuilder rtf,
				     Callout callout);
}

