//
//  ECSceneView.h
//  SceneRenderProto
//
//  Created by 二鏡 on 11/11/14.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "ECScene.h"
#import "ECRegularLayer.h"
#import "ECSceneComposition.h"

typedef enum {
    eLayerNone = 0,
    eLayerMove,
    eLayerResizeTopLeft,
    eLayerResizeTop,
    eLayerResizeTopRight,
    eLayerResizeLeft,
    eLayerResizeRight,
    eLayerResizeBottomLeft,
    eLayerResizeBottom,
    eLayerResizeBottomRight,
} eLayerEditMode;

typedef enum {
    eDragOptionUndefined = 0,
    eDragOptionNone,
    eDragOptionHorizontal,
    eDragOptionVertical,
} eDragOption;

typedef enum {
    eDropTypeNone,
    eDropTypeImage,
    eDropTypeTemplate,
} eDropType;

@interface ECSceneView : NSView
{
    BOOL editable;
    BOOL keepAspect;
    IBOutlet id delegate;
    ECSceneComposition *composition;
    ECScene *scene;
    // 直接描画モード用のScene
    // compositionを代入するとそちらへのショートカットとして機能する
    
    // key state
    struct {
        BOOL moved;
        CGPoint original;
    } key_state;
    
    // dragging state
    NSPoint clickPoint;
    CGRect layerOldBounds;
    CGRect layerOldTextFrame;
    eLayerEditMode draggingMode;
    eDragOption draggingOption;
    BOOL dragged;
    
    // drop state
    BOOL dropping;
    BOOL insideScene;
    eDropType dropType;
    ECRegularLayer *dropTarget;
    BOOL isAcceptableDropType;
}
@property (readwrite,assign) ECSceneComposition *composition;
@property (nonatomic,retain) ECScene *scene;
@property (readwrite) BOOL editable;

- (IBAction)deselect:(id)sender;
- (IBAction)hideSelection:(id)sender;
- (IBAction)showAllLayers:(id)sender;
- (IBAction)toggleLock:(id)sender;
@end
