//
//  ECLongOperationPanelController.m
//  Etokicho
//
//  Created by 二鏡 on 11/12/04.
//  Copyright (c) 2011年 二鏡庵. All rights reserved.
//

#import "ECLongOperationPanelController.h"

static id _si = nil;

@interface ECLongOperationPanelController ()
@property (readwrite) BOOL canceling;
@end

@implementation ECLongOperationPanelController
@synthesize progress, canStop, durationString, title, canceling;
+ (id)sharedPanel
{
    if(_si == nil)
        _si = [[self alloc] initWithWindowNibName: @"LongOperationPanel"];
    return _si;
}

- (void)awakeFromNib
{
    [progress setUsesThreadedAnimation: YES];
}

- (IBAction)cancel:(id)sender
{
    self.canceling = YES;
    cancelHandler();
}

- (void)beginWithCancelHandler:(void (^)())handler
{
    cancelHandler = handler;
    self.canceling = NO;
    id window = [self window];
    [window center];
    [window orderFront: self];
    [progress startAnimation: self];
    [NSApp runModalForWindow: window];
    
    [progress stopAnimation: self];
    [window close];
    cancelHandler = nil;
}
@end
