//
//  ECDTransitionSegment+CurrentTransition.m
//  Etokicho
//
//  Created by 二鏡 on 11/12/07.
//  Copyright (c) 2011年 二鏡庵. All rights reserved.
//

#import "ECDTransitionSegment.h"
#import "MainController.h"

@implementation ECDTransitionSegment (CurrentTransition)
+ (id)attachNewTransitionInContext:(NSManagedObjectContext*)context
{
    ConfigurationManager *cm = [[NSApp delegate] configurationManager];
    id obj = [cm currentTransition];
    if(obj == nil)
        return nil;
    
    ECQCCompositionItem *item = [[ECQCCompositionItem alloc] init];
    item.identifier = [obj valueForKey: @"identifier"];
    item.parameters = [obj valueForKey: @"parameters"];
    
    id entity = [NSEntityDescription entityForName: @"TransitionSegment"
                            inManagedObjectContext: context];
    ECDTransitionSegment *ret = [[self alloc] initWithEntity: entity
                              insertIntoManagedObjectContext: context];

    ret.templateName = [obj valueForKey: @"name"];
    ret.item = item;
    ret.flipHorizontal = [[obj valueForKey: @"flipHorizontal"] boolValue];
    ret.msec = [[obj valueForKey: @"duration"] integerValue];
    [item release];
    
    return [ret autorelease];
}
@end
