/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import iterator.AbstractIterator;
import java.util.ListIterator;

/**
 *
 * @author mtomono
 */
public class PointRemoveIterator<T extends Comparable<T>> extends AbstractIterator<Range<T>> {
    ListIterator<Range<T>> iter;
    
    public PointRemoveIterator(ListIterator<Range<T>> iter) {
        this.iter = iter;
    }
    
    @Override
    protected void findNext() {
        if (!iter.hasNext())
            return;
        Range<T> retval = iter.next();
        while (iter.hasNext()) {
            Range<T> nextRange = iter.next();
            if (retval.adjoinsAtEndWith(nextRange))
                retval = retval.cover(nextRange);
            else {
                iter.previous();
                break;
            }
        } 
        nextFound(retval);
    }
    
}
