/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package grammar;

import context.IContext;
import java.util.Optional;
import java.util.function.Predicate;
import static debug.Trace.*;

/**
 * Context Node detraceegates matching of context to Intension<Context<T>>
 * @author mtomono
 * @param <T>
 */
public class Nod<T> extends Grammar<T>{
    Predicate<IContext<T>> body;
    static public Action ReduceNod = NowTree;

    public static <T extends Comparable<T>> Nod<T> c(T body) {
        return new Nod<>(n->n.now().orElse(null)==body);
    }
    
    public static <T> Nod<T> c(Predicate<Optional<T>> body) {
        return new Nod<>(n->body.test(n.now()));
    }
    
    public Nod(Predicate<IContext<T>> body) {
        this.body = body;
        this.action = ReduceNod;
    }
    
    @Override
    public int minLength() {
        return 1;
    }

    @Override
    public boolean match(IContext<T> target) {
        if (!target.hasNext())
            return false;
        target.next();
        assert target.trace.l(s("  ", target.get(0)));
        return this.body.test(target);
    }

    @Override
    public String bodyToString() {
        return this.body.toString();
    }
}
